(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7376,        244]
NotebookOptionsPosition[      5656,        190]
NotebookOutlinePosition[      6761,        220]
CellTagsIndexPosition[      6718,        217]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMPUTER ARITHMETIC PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Computer Arithmetic Package" :> 
          Documentation`HelpLookup[
           "paclet:ComputerArithmetic/tutorial/ComputerArithmetic"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Computer Arithmetic Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SetArithmetic" :> 
          Documentation`HelpLookup[
           "paclet:ComputerArithmetic/ref/SetArithmetic"], "Divide" :> 
          Documentation`HelpLookup["paclet:ref/Divide"], "IdealDivision" :> 
          Documentation`HelpLookup[
           "paclet:ComputerArithmetic/ref/IdealDivision"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"SetArithmetic\"\>", 
       2->"\<\"Divide\"\>", 3->"\<\"IdealDivision\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Computer Arithmetic Package" :> 
          Documentation`HelpLookup[
           "paclet:ComputerArithmetic/guide/ComputerArithmeticPackage"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Computer Arithmetic Package\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["IdealDivide", "ObjectName",
 CellID->27918],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"IdealDivide", "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["y", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the correctly rounded result of ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " divided by ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     " involving a single rounding error."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->9625]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->17014],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SetArithmetic",
    BaseStyle->"Link",
    ButtonData->"paclet:ComputerArithmetic/ref/SetArithmetic"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Divide",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Divide"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["IdealDivision",
    BaseStyle->"Link",
    ButtonData->"paclet:ComputerArithmetic/ref/IdealDivision"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->5695]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->18174],

Cell[TextData[ButtonBox["Computer Arithmetic Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:ComputerArithmetic/tutorial/ComputerArithmetic"]], "Tutorials",
 CellID->10984]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->4535552],

Cell[TextData[ButtonBox["Computer Arithmetic Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:ComputerArithmetic/guide/ComputerArithmeticPackage"]], "MoreAbout",
 CellID->85652738]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"IdealDivide - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 56, 50.5349870}", "context" -> 
    "ComputerArithmetic`", "keywords" -> {}, "index" -> True, "label" -> 
    "Computer Arithmetic Package Symbol", "language" -> "en", "paclet" -> 
    "ComputerArithmetic Package", "status" -> "None", "summary" -> 
    "IdealDivide[x, y] gives the correctly rounded result of x divided by y \
involving a single rounding error.", "synonyms" -> {}, "title" -> 
    "IdealDivide", "type" -> "Symbol", "uri" -> 
    "ComputerArithmetic/ref/IdealDivide"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2122, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2745, 80, 49, 1, 70, "ObjectName",
 CellID->27918],
Cell[2797, 83, 643, 20, 70, "Usage",
 CellID->9625]
}, Open  ]],
Cell[CellGroupData[{
Cell[3477, 108, 311, 9, 70, "SeeAlsoSection",
 CellID->17014],
Cell[3791, 119, 749, 26, 70, "SeeAlso",
 CellID->5695]
}, Open  ]],
Cell[CellGroupData[{
Cell[4577, 150, 314, 9, 70, "TutorialsSection",
 CellID->18174],
Cell[4894, 161, 178, 4, 70, "Tutorials",
 CellID->10984]
}, Open  ]],
Cell[CellGroupData[{
Cell[5109, 170, 317, 9, 70, "MoreAboutSection",
 CellID->4535552],
Cell[5429, 181, 185, 4, 70, "MoreAbout",
 CellID->85652738]
}, Open  ]],
Cell[5629, 188, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

