(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8976,        301]
NotebookOptionsPosition[      6985,        240]
NotebookOutlinePosition[      8145,        270]
CellTagsIndexPosition[      8102,        267]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMPUTER ARITHMETIC PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Computer Arithmetic Package" :> 
          Documentation`HelpLookup[
           "paclet:ComputerArithmetic/tutorial/ComputerArithmetic"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Computer Arithmetic Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SetArithmetic" :> 
          Documentation`HelpLookup[
           "paclet:ComputerArithmetic/ref/SetArithmetic"], "Divide" :> 
          Documentation`HelpLookup["paclet:ref/Divide"], "IdealDivide" :> 
          Documentation`HelpLookup[
           "paclet:ComputerArithmetic/ref/IdealDivide"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"SetArithmetic\"\>", 2->"\<\"Divide\"\>", 
       3->"\<\"IdealDivide\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Computer Arithmetic Package" :> 
          Documentation`HelpLookup[
           "paclet:ComputerArithmetic/guide/ComputerArithmeticPackage"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Computer Arithmetic Package\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["IdealDivision", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["IdealDivision"], "InlineFormula"],
     " \[LineSeparator]is an option to ",
     Cell[BoxData[
      ButtonBox["SetArithmetic",
       BaseStyle->"Link",
       ButtonData->"paclet:ComputerArithmetic/ref/SetArithmetic"]], 
      "InlineFormula"],
     " that specifies whether ",
     Cell[BoxData[
      ButtonBox["$PreRead",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$PreRead"]], "InlineFormula"],
     " should be used to translate the default '/' division operator to use ",
     
     Cell[BoxData[
      ButtonBox["IdealDivide",
       BaseStyle->"Link",
       ButtonData->"paclet:ComputerArithmetic/ref/IdealDivide"]], 
      "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Valid settings for the option ",
 Cell[BoxData["IdealDivision"], "InlineFormula"],
 " are ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ". The default setting is ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->1067943069]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SetArithmetic",
    BaseStyle->"Link",
    ButtonData->"paclet:ComputerArithmetic/ref/SetArithmetic"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Divide",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Divide"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["IdealDivide",
    BaseStyle->"Link",
    ButtonData->"paclet:ComputerArithmetic/ref/IdealDivide"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->5695]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Computer Arithmetic Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:ComputerArithmetic/tutorial/ComputerArithmetic"]], "Tutorials",
 CellID->10984]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->38303248],

Cell[TextData[ButtonBox["Computer Arithmetic Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:ComputerArithmetic/guide/ComputerArithmeticPackage"]], "MoreAbout",
 CellID->85652738]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"IdealDivision - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 56, 50.7224918}", "context" -> 
    "ComputerArithmetic`", "keywords" -> {}, "index" -> True, "label" -> 
    "Computer Arithmetic Package Symbol", "language" -> "en", "paclet" -> 
    "ComputerArithmetic Package", "status" -> "None", "summary" -> 
    "IdealDivision is an option to SetArithmetic that specifies whether \
$PreRead should be used to translate the default '/' division operator to use \
IdealDivide.", "synonyms" -> {}, "title" -> "IdealDivision", "type" -> 
    "Symbol", "uri" -> "ComputerArithmetic/ref/IdealDivision"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2116, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2739, 80, 56, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[2798, 83, 924, 28, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[3759, 116, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4237, 133, 526, 20, 70, "Notes",
 CellID->1067943069]
}, Closed]],
Cell[CellGroupData[{
Cell[4800, 158, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[5119, 169, 745, 26, 70, "SeeAlso",
 CellID->5695]
}, Open  ]],
Cell[CellGroupData[{
Cell[5901, 200, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[6222, 211, 178, 4, 70, "Tutorials",
 CellID->10984]
}, Open  ]],
Cell[CellGroupData[{
Cell[6437, 220, 318, 9, 70, "MoreAboutSection",
 CellID->38303248],
Cell[6758, 231, 185, 4, 70, "MoreAbout",
 CellID->85652738]
}, Open  ]],
Cell[6958, 238, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

