(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10578,        360]
NotebookOptionsPosition[      8423,        293]
NotebookOutlinePosition[      9600,        323]
CellTagsIndexPosition[      9557,        320]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMPUTER ARITHMETIC PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Computer Arithmetic Package" :> 
          Documentation`HelpLookup[
           "paclet:ComputerArithmetic/tutorial/ComputerArithmetic"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Computer Arithmetic Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MicroscopicErrorPlot" :> 
          Documentation`HelpLookup[
           "paclet:ComputerArithmetic/ref/MicroscopicErrorPlot"], 
          "MachineError" :> 
          Documentation`HelpLookup[
           "paclet:ComputerArithmetic/ref/MachineError"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"MicroscopicErrorPlot\"\>", 
       2->"\<\"MachineError\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Computer Arithmetic Package" :> 
          Documentation`HelpLookup[
           "paclet:ComputerArithmetic/guide/ComputerArithmeticPackage"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Computer Arithmetic Package\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MicroscopePlot", "ObjectName", "Microscope",
 CellID->23370],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"MicroscopePlot", "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          StyleBox["a", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]plots the expression ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " in a small neighborhood of ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"],
     " using machine arithmetic."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"MicroscopePlot", "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          StyleBox["a", "TI"], ",", 
          StyleBox["n", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]plots ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " from ",
     Cell[BoxData[
      RowBox[{
       StyleBox["a", "TI"], "-", 
       StyleBox["n", "TI"]}]], "InlineFormula"],
     " ulps to ",
     Cell[BoxData[
      RowBox[{
       StyleBox["a", "TI"], "+", 
       StyleBox["n", "TI"]}]], "InlineFormula"],
     " ulps."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->6549]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following option can be given:", "Notes",
 CellID->1348],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Joined",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Joined",
     ButtonNote->"ObsLink: PlotJoined -> Joined (ListLinePlot)"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to join points", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->9077],

Cell[TextData[{
 "Valid settings for ",
 Cell[BoxData[
  ButtonBox["Joined",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Joined",
   ButtonNote->"ObsLink: PlotJoined -> Joined (ListLinePlot)"]], 
  "InlineFormula"],
 " are ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Real",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Real"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->26199],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Joined",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Joined",
    ButtonNote->"ObsLink: PlotJoined -> Joined (ListLinePlot)"], "->", 
   ButtonBox["Real",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Real"]}]], "InlineFormula"],
 ", the line joining the plot points represents the mapping from the set of \
real numbers to the set of machine number outputs."
}], "Notes",
 CellID->16835]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->27617],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["MicroscopicErrorPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ComputerArithmetic/ref/MicroscopicErrorPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MachineError",
    BaseStyle->"Link",
    ButtonData->"paclet:ComputerArithmetic/ref/MachineError"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->5233]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->3573],

Cell[TextData[ButtonBox["Computer Arithmetic Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:ComputerArithmetic/tutorial/ComputerArithmetic"]], "Tutorials",
 CellID->28137]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->244178713],

Cell[TextData[ButtonBox["Computer Arithmetic Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:ComputerArithmetic/guide/ComputerArithmeticPackage"]], "MoreAbout",
 CellID->3139139]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MicroscopePlot - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 56, 51.0662506}", "context" -> 
    "ComputerArithmetic`", "keywords" -> {}, "index" -> True, "label" -> 
    "Computer Arithmetic Package Symbol", "language" -> "en", "paclet" -> 
    "ComputerArithmetic Package", "status" -> "None", "summary" -> 
    "MicroscopePlot[f, {x, a}] plots the expression f in a small neighborhood \
of a using machine arithmetic. MicroscopePlot[f, {x, a, n}] plots f from a - \
n ulps to a + n ulps.", "synonyms" -> {}, "title" -> "MicroscopePlot", "type" -> 
    "Symbol", "uri" -> "ComputerArithmetic/ref/MicroscopePlot"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2060, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2683, 80, 66, 1, 70, "ObjectName",
 CellID->23370],
Cell[2752, 83, 1431, 48, 70, "Usage",
 CellID->6549]
}, Open  ]],
Cell[CellGroupData[{
Cell[4220, 136, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4698, 153, 66, 1, 70, "Notes",
 CellID->1348],
Cell[4767, 156, 569, 16, 70, "3ColumnTableMod",
 CellID->9077],
Cell[5339, 174, 616, 25, 70, "Notes",
 CellID->26199],
Cell[5958, 201, 478, 14, 70, "Notes",
 CellID->16835]
}, Closed]],
Cell[CellGroupData[{
Cell[6473, 220, 311, 9, 70, "SeeAlsoSection",
 CellID->27617],
Cell[6787, 231, 520, 17, 70, "SeeAlso",
 CellID->5233]
}, Open  ]],
Cell[CellGroupData[{
Cell[7344, 253, 313, 9, 70, "TutorialsSection",
 CellID->3573],
Cell[7660, 264, 178, 4, 70, "Tutorials",
 CellID->28137]
}, Open  ]],
Cell[CellGroupData[{
Cell[7875, 273, 319, 9, 70, "MoreAboutSection",
 CellID->244178713],
Cell[8197, 284, 184, 4, 70, "MoreAbout",
 CellID->3139139]
}, Open  ]],
Cell[8396, 291, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

