(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6121,        215]
NotebookOptionsPosition[      4390,        161]
NotebookOutlinePosition[      5475,        190]
CellTagsIndexPosition[      5432,        187]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMPUTER ARITHMETIC PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Computer Arithmetic Package" :> 
          Documentation`HelpLookup[
           "paclet:ComputerArithmetic/tutorial/ComputerArithmetic"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Computer Arithmetic Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ComputerNumber" :> 
          Documentation`HelpLookup[
           "paclet:ComputerArithmetic/ref/ComputerNumber"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"ComputerNumber\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NaN", "ObjectName",
 CellID->7741],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["NaN"], "InlineFormula"],
     " \[LineSeparator]is the symbol used by the functions in the ",
     ButtonBox["Computer Arithmetic Package",
      BaseStyle->"Link",
      ButtonData->
       "paclet:ComputerArithmetic/guide/ComputerArithmeticPackage"],
     " to represent a nonrepresentable number."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->11245]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["NaN"], "InlineFormula"],
 " is an acronym for ",
 StyleBox["N",
  FontWeight->"Bold"],
 "ot ",
 StyleBox["A",
  FontWeight->"Bold"],
 " ",
 StyleBox["N",
  FontWeight->"Bold"],
 "umber."
}], "Notes",
 CellID->14578]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->9227],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["ComputerNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ComputerArithmetic/ref/ComputerNumber"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->309355830]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->4949],

Cell[TextData[ButtonBox["Computer Arithmetic Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:ComputerArithmetic/tutorial/ComputerArithmetic"]], "Tutorials",
 CellID->21705]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NaN - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 56, 51.5975142}", "context" -> 
    "ComputerArithmetic`", "keywords" -> {}, "index" -> True, "label" -> 
    "Computer Arithmetic Package Symbol", "language" -> "en", "paclet" -> 
    "ComputerArithmetic Package", "status" -> "None", "summary" -> 
    "NaN is the symbol used by the functions in the Computer Arithmetic \
Package to represent a nonrepresentable number.", "synonyms" -> {}, "title" -> 
    "NaN", "type" -> "Symbol", "uri" -> "ComputerArithmetic/ref/NaN"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1265, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1888, 61, 40, 1, 70, "ObjectName",
 CellID->7741],
Cell[1931, 64, 544, 15, 70, "Usage",
 CellID->11245]
}, Open  ]],
Cell[CellGroupData[{
Cell[2512, 84, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2990, 101, 246, 13, 70, "Notes",
 CellID->14578]
}, Closed]],
Cell[CellGroupData[{
Cell[3273, 119, 310, 9, 70, "SeeAlsoSection",
 CellID->9227],
Cell[3586, 130, 231, 6, 70, "SeeAlso",
 CellID->309355830]
}, Open  ]],
Cell[CellGroupData[{
Cell[3854, 141, 313, 9, 70, "TutorialsSection",
 CellID->4949],
Cell[4170, 152, 178, 4, 70, "Tutorials",
 CellID->21705]
}, Open  ]],
Cell[4363, 159, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

