(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6704,        218]
NotebookOptionsPosition[      5054,        169]
NotebookOutlinePosition[      6250,        200]
CellTagsIndexPosition[      6207,        197]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMPUTER ARITHMETIC PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Computer Arithmetic Package" :> 
          Documentation`HelpLookup[
           "paclet:ComputerArithmetic/tutorial/ComputerArithmetic"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Computer Arithmetic Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"RoundingRule" :> 
          Documentation`HelpLookup[
           "paclet:ComputerArithmetic/ref/RoundingRule"], "Ceiling" :> 
          Documentation`HelpLookup["paclet:ref/Ceiling"], "Truncation" :> 
          Documentation`HelpLookup[
           "paclet:ComputerArithmetic/ref/Truncation"], "RoundToEven" :> 
          Documentation`HelpLookup[
           "paclet:ComputerArithmetic/ref/RoundToEven"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"RoundingRule\"\>", 2->"\<\"Ceiling\"\>", 
       3->"\<\"Truncation\"\>", 4->"\<\"RoundToEven\"\>"}, "\<\"see also\"\>",
        
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["RoundToInfinity", "ObjectName",
 CellID->7640],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["RoundToInfinity"], "InlineFormula"],
     " \[LineSeparator]is a setting for the option ",
     Cell[BoxData[
      ButtonBox["RoundingRule",
       BaseStyle->"Link",
       ButtonData->"paclet:ComputerArithmetic/ref/RoundingRule"]], 
      "InlineFormula"],
     " of ",
     Cell[BoxData[
      ButtonBox["SetArithmetic",
       BaseStyle->"Link",
       ButtonData->"paclet:ComputerArithmetic/ref/SetArithmetic"]], 
      "InlineFormula"],
     " that specifies rounding to the nearest representable number and, in \
the case of a tie, rounding away from 0."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->12087]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1663],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["RoundingRule",
    BaseStyle->"Link",
    ButtonData->"paclet:ComputerArithmetic/ref/RoundingRule"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Ceiling",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Ceiling"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Truncation",
    BaseStyle->"Link",
    ButtonData->"paclet:ComputerArithmetic/ref/Truncation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RoundToEven",
    BaseStyle->"Link",
    ButtonData->"paclet:ComputerArithmetic/ref/RoundToEven"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->10615]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->15012],

Cell[TextData[ButtonBox["Computer Arithmetic Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:ComputerArithmetic/tutorial/ComputerArithmetic"]], "Tutorials",
 CellID->13810]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"RoundToInfinity - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 56, 58.5195664}", "context" -> 
    "ComputerArithmetic`", "keywords" -> {}, "index" -> True, "label" -> 
    "Computer Arithmetic Package Symbol", "language" -> "en", "paclet" -> 
    "ComputerArithmetic Package", "status" -> "None", "summary" -> 
    "RoundToInfinity is a setting for the option RoundingRule of \
SetArithmetic that specifies rounding to the nearest representable number \
and, in the case of a tie, rounding away from 0.", "synonyms" -> {}, "title" -> 
    "RoundToInfinity", "type" -> "Symbol", "uri" -> 
    "ComputerArithmetic/ref/RoundToInfinity"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1632, 40, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2255, 67, 52, 1, 70, "ObjectName",
 CellID->7640],
Cell[2310, 70, 806, 23, 70, "Usage",
 CellID->12087]
}, Open  ]],
Cell[CellGroupData[{
Cell[3153, 98, 310, 9, 70, "SeeAlsoSection",
 CellID->1663],
Cell[3466, 109, 1014, 35, 70, "SeeAlso",
 CellID->10615]
}, Open  ]],
Cell[CellGroupData[{
Cell[4517, 149, 314, 9, 70, "TutorialsSection",
 CellID->15012],
Cell[4834, 160, 178, 4, 70, "Tutorials",
 CellID->13810]
}, Open  ]],
Cell[5027, 167, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

