(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8931,        304]
NotebookOptionsPosition[      7034,        244]
NotebookOutlinePosition[      8117,        273]
CellTagsIndexPosition[      8074,        270]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMPUTER ARITHMETIC PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Computer Arithmetic Package" :> 
          Documentation`HelpLookup[
           "paclet:ComputerArithmetic/tutorial/ComputerArithmetic"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Computer Arithmetic Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SetArithmetic" :> 
          Documentation`HelpLookup[
           "paclet:ComputerArithmetic/ref/SetArithmetic"], "Round" :> 
          Documentation`HelpLookup["paclet:ref/Round"], "Ceiling" :> 
          Documentation`HelpLookup["paclet:ref/Ceiling"], "Floor" :> 
          Documentation`HelpLookup["paclet:ref/Floor"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"SetArithmetic\"\>", 2->"\<\"Round\"\>", 
       3->"\<\"Ceiling\"\>", 4->"\<\"Floor\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Computer Arithmetic Package" :> 
          Documentation`HelpLookup[
           "paclet:ComputerArithmetic/guide/ComputerArithmeticPackage"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Computer Arithmetic Package\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["RoundingRule", "ObjectName",
 CellID->1511],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["RoundingRule"], "InlineFormula"],
     " \[LineSeparator]is an option to ",
     Cell[BoxData[
      ButtonBox["SetArithmetic",
       BaseStyle->"Link",
       ButtonData->"paclet:ComputerArithmetic/ref/SetArithmetic"]], 
      "InlineFormula"],
     " that specifies the rounding scheme to use."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->32125]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Valid settings are ",
 Cell[BoxData[
  ButtonBox["RoundToEven",
   BaseStyle->"Link",
   ButtonData->"paclet:ComputerArithmetic/ref/RoundToEven"]], 
  "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["RoundToInfinity",
   BaseStyle->"Link",
   ButtonData->"paclet:ComputerArithmetic/ref/RoundToInfinity"]], 
  "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["Truncation",
   BaseStyle->"Link",
   ButtonData->"paclet:ComputerArithmetic/ref/Truncation"]], 
  "InlineFormula"],
 ". The default setting is ",
 Cell[BoxData[
  ButtonBox["RoundToEven",
   BaseStyle->"Link",
   ButtonData->"paclet:ComputerArithmetic/ref/RoundToEven"]], 
  "InlineFormula"],
 "."
}], "Notes",
 CellID->11838]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->12902],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SetArithmetic",
    BaseStyle->"Link",
    ButtonData->"paclet:ComputerArithmetic/ref/SetArithmetic"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Round",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Round"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Ceiling",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Ceiling"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Floor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Floor"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->230095101]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->18939],

Cell[TextData[ButtonBox["Computer Arithmetic Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:ComputerArithmetic/tutorial/ComputerArithmetic"]], "Tutorials",
 CellID->11544]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->108714000],

Cell[TextData[ButtonBox["Computer Arithmetic Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:ComputerArithmetic/guide/ComputerArithmeticPackage"]], "MoreAbout",
 CellID->174869076]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"RoundingRule - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 56, 51.7537682}", "context" -> 
    "ComputerArithmetic`", "keywords" -> {}, "index" -> True, "label" -> 
    "Computer Arithmetic Package Symbol", "language" -> "en", "paclet" -> 
    "ComputerArithmetic Package", "status" -> "None", "summary" -> 
    "RoundingRule is an option to SetArithmetic that specifies the rounding \
scheme to use.", "synonyms" -> {}, "title" -> "RoundingRule", "type" -> 
    "Symbol", "uri" -> "ComputerArithmetic/ref/RoundingRule"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2158, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2781, 80, 49, 1, 70, "ObjectName",
 CellID->1511],
Cell[2833, 83, 541, 16, 70, "Usage",
 CellID->32125]
}, Open  ]],
Cell[CellGroupData[{
Cell[3411, 104, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3889, 121, 715, 27, 70, "Notes",
 CellID->11838]
}, Closed]],
Cell[CellGroupData[{
Cell[4641, 153, 311, 9, 70, "SeeAlsoSection",
 CellID->12902],
Cell[4955, 164, 960, 35, 70, "SeeAlso",
 CellID->230095101]
}, Open  ]],
Cell[CellGroupData[{
Cell[5952, 204, 314, 9, 70, "TutorialsSection",
 CellID->18939],
Cell[6269, 215, 178, 4, 70, "Tutorials",
 CellID->11544]
}, Open  ]],
Cell[CellGroupData[{
Cell[6484, 224, 319, 9, 70, "MoreAboutSection",
 CellID->108714000],
Cell[6806, 235, 186, 4, 70, "MoreAbout",
 CellID->174869076]
}, Open  ]],
Cell[7007, 242, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

