(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11461,        374]
NotebookOptionsPosition[      9204,        304]
NotebookOutlinePosition[     10421,        335]
CellTagsIndexPosition[     10378,        332]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMPUTER ARITHMETIC PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Computer Arithmetic Package" :> 
          Documentation`HelpLookup[
           "paclet:ComputerArithmetic/tutorial/ComputerArithmetic"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Computer Arithmetic Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ComputerNumber" :> 
          Documentation`HelpLookup[
           "paclet:ComputerArithmetic/ref/ComputerNumber"], "Arithmetic" :> 
          Documentation`HelpLookup[
           "paclet:ComputerArithmetic/ref/Arithmetic"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"ComputerNumber\"\>", 
       2->"\<\"Arithmetic\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Computer Arithmetic Package" :> 
          Documentation`HelpLookup[
           "paclet:ComputerArithmetic/guide/ComputerArithmeticPackage"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Computer Arithmetic Package\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SetArithmetic", "ObjectName",
 CellID->21447],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SetArithmetic", "[", 
       StyleBox["d", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]sets the number of digits of precision ",
     Cell[BoxData[
      StyleBox["d", "TI"]], "InlineFormula"],
     " to be used in ",
     Cell[BoxData[
      ButtonBox["ComputerNumber",
       BaseStyle->"Link",
       ButtonData->"paclet:ComputerArithmetic/ref/ComputerNumber"]], 
      "InlineFormula"],
     " objects."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SetArithmetic", "[", 
       RowBox[{
        StyleBox["d", "TI"], ",", 
        StyleBox["b", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]sets the number of digits of precision ",
     Cell[BoxData[
      StyleBox["d", "TI"]], "InlineFormula"],
     " and the base ",
     Cell[BoxData[
      StyleBox["b", "TI"]], "InlineFormula"],
     " to be used in ",
     Cell[BoxData[
      ButtonBox["ComputerNumber",
       BaseStyle->"Link",
       ButtonData->"paclet:ComputerArithmetic/ref/ComputerNumber"]], 
      "InlineFormula"],
     " objects."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->1084]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Allowable settings for the precision ",
 Cell[BoxData[
  StyleBox["d", "TI"]], "InlineFormula"],
 " are the integers between 1 and 10 inclusive. The default value is 4."
}], "Notes",
 CellID->592],

Cell[TextData[{
 "Allowable settings for the base ",
 Cell[BoxData[
  StyleBox["b", "TI"]], "InlineFormula"],
 " are the integers between 2 and 16 inclusive. The default value is 10."
}], "Notes",
 CellID->18725],

Cell[TextData[{
 "Changing the default settings to be used in ",
 Cell[BoxData[
  ButtonBox["ComputerNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ComputerArithmetic/ref/ComputerNumber"]], 
  "InlineFormula"],
 " objects and then referring to ",
 Cell[BoxData[
  ButtonBox["ComputerNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ComputerArithmetic/ref/ComputerNumber"]], 
  "InlineFormula"],
 " objects defined prior to the change can lead to unpredictable results."
}], "Notes",
 CellID->8996],

Cell["The following options can be given:", "Notes",
 CellID->29855],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["RoundingRule",
     BaseStyle->"Link",
     ButtonData->"paclet:ComputerArithmetic/ref/RoundingRule"], 
    ButtonBox["RoundToEven",
     BaseStyle->"Link",
     ButtonData->"paclet:ComputerArithmetic/ref/RoundToEven"], Cell[
    "rule used to round numbers", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ExponentRange",
     BaseStyle->"Link",
     ButtonData->"paclet:ComputerArithmetic/ref/ExponentRange"], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "50"}], ",", "50"}], "}"}], Cell[
    "range of allowed exponents", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["MixedMode",
     BaseStyle->"Link",
     ButtonData->"paclet:ComputerArithmetic/ref/MixedMode"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to allow mixed-mode arithmetic", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["IdealDivision",
     BaseStyle->"Link",
     ButtonData->"paclet:ComputerArithmetic/ref/IdealDivision"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[TextData[{
     "whether to convert '/' to ~",
     StyleBox[ButtonBox["IdealDivide",
      BaseStyle->"Link",
      ButtonData->"paclet:ComputerArithmetic/ref/IdealDivide"], "InlineCode"],
     
     "~"
    }], "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->24828]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->30742],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ComputerNumber",
    BaseStyle->"Link",
    ButtonData->"paclet:ComputerArithmetic/ref/ComputerNumber"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Arithmetic",
    BaseStyle->"Link",
    ButtonData->"paclet:ComputerArithmetic/ref/Arithmetic"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->2014245271]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->15338],

Cell[TextData[ButtonBox["Computer Arithmetic Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:ComputerArithmetic/tutorial/ComputerArithmetic"]], "Tutorials",
 CellID->17342]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->189902188],

Cell[TextData[ButtonBox["Computer Arithmetic Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:ComputerArithmetic/guide/ComputerArithmeticPackage"]], "MoreAbout",
 CellID->123877888]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SetArithmetic - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 56, 58.6914458}", "context" -> 
    "ComputerArithmetic`", "keywords" -> {}, "index" -> True, "label" -> 
    "Computer Arithmetic Package Symbol", "language" -> "en", "paclet" -> 
    "ComputerArithmetic Package", "status" -> "None", "summary" -> 
    "SetArithmetic[d] sets the number of digits of precision d to be used in \
ComputerNumber objects. SetArithmetic[d, b] sets the number of digits of \
precision d and the base b to be used in ComputerNumber objects.", 
    "synonyms" -> {}, "title" -> "SetArithmetic", "type" -> "Symbol", "uri" -> 
    "ComputerArithmetic/ref/SetArithmetic"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2025, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2648, 79, 51, 1, 70, "ObjectName",
 CellID->21447],
Cell[2702, 82, 1313, 41, 70, "Usage",
 CellID->1084]
}, Open  ]],
Cell[CellGroupData[{
Cell[4052, 128, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4530, 145, 214, 6, 70, "Notes",
 CellID->592],
Cell[4747, 153, 212, 6, 70, "Notes",
 CellID->18725],
Cell[4962, 161, 509, 15, 70, "Notes",
 CellID->8996],
Cell[5474, 178, 68, 1, 70, "Notes",
 CellID->29855],
Cell[5545, 181, 1679, 45, 70, "3ColumnTableMod",
 CellID->24828]
}, Closed]],
Cell[CellGroupData[{
Cell[7261, 231, 311, 9, 70, "SeeAlsoSection",
 CellID->30742],
Cell[7575, 242, 510, 17, 70, "SeeAlso",
 CellID->2014245271]
}, Open  ]],
Cell[CellGroupData[{
Cell[8122, 264, 314, 9, 70, "TutorialsSection",
 CellID->15338],
Cell[8439, 275, 178, 4, 70, "Tutorials",
 CellID->17342]
}, Open  ]],
Cell[CellGroupData[{
Cell[8654, 284, 319, 9, 70, "MoreAboutSection",
 CellID->189902188],
Cell[8976, 295, 186, 4, 70, "MoreAbout",
 CellID->123877888]
}, Open  ]],
Cell[9177, 302, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

