(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6577,        216]
NotebookOptionsPosition[      5003,        168]
NotebookOutlinePosition[      6121,        198]
CellTagsIndexPosition[      6078,        195]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMPUTER ARITHMETIC PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Computer Arithmetic Package" :> 
          Documentation`HelpLookup[
           "paclet:ComputerArithmetic/tutorial/ComputerArithmetic"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Computer Arithmetic Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"RoundingRule" :> 
          Documentation`HelpLookup[
           "paclet:ComputerArithmetic/ref/RoundingRule"], "Floor" :> 
          Documentation`HelpLookup["paclet:ref/Floor"], "RoundToEven" :> 
          Documentation`HelpLookup[
           "paclet:ComputerArithmetic/ref/RoundToEven"], "RoundToInfinity" :> 
          Documentation`HelpLookup[
           "paclet:ComputerArithmetic/ref/RoundToInfinity"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"RoundingRule\"\>", 
       2->"\<\"Floor\"\>", 3->"\<\"RoundToEven\"\>", 
       4->"\<\"RoundToInfinity\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Truncation", "ObjectName",
 CellID->22777],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Truncation"], "InlineFormula"],
     " \[LineSeparator]is a setting for the option ",
     Cell[BoxData[
      ButtonBox["RoundingRule",
       BaseStyle->"Link",
       ButtonData->"paclet:ComputerArithmetic/ref/RoundingRule"]], 
      "InlineFormula"],
     " of ",
     Cell[BoxData[
      ButtonBox["SetArithmetic",
       BaseStyle->"Link",
       ButtonData->"paclet:ComputerArithmetic/ref/SetArithmetic"]], 
      "InlineFormula"],
     " that specifies rounding by discarding excess digits."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->19285]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->17118],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["RoundingRule",
    BaseStyle->"Link",
    ButtonData->"paclet:ComputerArithmetic/ref/RoundingRule"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Floor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Floor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RoundToEven",
    BaseStyle->"Link",
    ButtonData->"paclet:ComputerArithmetic/ref/RoundToEven"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RoundToInfinity",
    BaseStyle->"Link",
    ButtonData->"paclet:ComputerArithmetic/ref/RoundToInfinity"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->25668]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->26200],

Cell[TextData[ButtonBox["Computer Arithmetic Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:ComputerArithmetic/tutorial/ComputerArithmetic"]], "Tutorials",
 CellID->14590]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Truncation - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 56, 58.8476998}", "context" -> 
    "ComputerArithmetic`", "keywords" -> {}, "index" -> True, "label" -> 
    "Computer Arithmetic Package Symbol", "language" -> "en", "paclet" -> 
    "ComputerArithmetic Package", "status" -> "None", "summary" -> 
    "Truncation is a setting for the option RoundingRule of SetArithmetic \
that specifies rounding by discarding excess digits.", "synonyms" -> {}, 
    "title" -> "Truncation", "type" -> "Symbol", "uri" -> 
    "ComputerArithmetic/ref/Truncation"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1641, 40, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2264, 67, 48, 1, 70, "ObjectName",
 CellID->22777],
Cell[2315, 70, 743, 22, 70, "Usage",
 CellID->19285]
}, Open  ]],
Cell[CellGroupData[{
Cell[3095, 97, 311, 9, 70, "SeeAlsoSection",
 CellID->17118],
Cell[3409, 108, 1020, 35, 70, "SeeAlso",
 CellID->25668]
}, Open  ]],
Cell[CellGroupData[{
Cell[4466, 148, 314, 9, 70, "TutorialsSection",
 CellID->26200],
Cell[4783, 159, 178, 4, 70, "Tutorials",
 CellID->14590]
}, Open  ]],
Cell[4976, 166, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

