(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7915,        275]
NotebookOptionsPosition[      6026,        213]
NotebookOutlinePosition[      7051,        242]
CellTagsIndexPosition[      7008,        239]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["COMPUTER ARITHMETIC PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Computer Arithmetic Package" :> 
          Documentation`HelpLookup[
           "paclet:ComputerArithmetic/tutorial/ComputerArithmetic"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Computer Arithmetic Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Ulps" :> 
          Documentation`HelpLookup["paclet:ComputerArithmetic/ref/Ulps"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Ulps\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Computer Arithmetic Package" :> 
          Documentation`HelpLookup[
           "paclet:ComputerArithmetic/guide/ComputerArithmeticPackage"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Computer Arithmetic Package\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Ulp", "ObjectName",
 CellID->31148],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Ulp", "[", 
       StyleBox["x", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the size of an ulp for numbers near ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->5874]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The difference between two consecutive machine numbers is called an ulp, \
which stands for ",
 StyleBox["U",
  FontVariations->{"Underline"->True}],
 "nit in the ",
 StyleBox["L",
  FontVariations->{"Underline"->True}],
 "ast ",
 StyleBox["P",
  FontVariations->{"Underline"->True}],
 "lace."
}], "Notes",
 CellID->25774],

Cell[TextData[{
 "The size of an ulp varies depending on where you are in the set of machine \
numbers. Between 1 and 2 an ulp is equal to ",
 Cell[BoxData[
  ButtonBox["$MachineEpsilon",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MachineEpsilon"]], "InlineFormula"],
 ", between 2 and 4 an ulp is equal to ",
 Cell[BoxData[
  RowBox[{"2", 
   ButtonBox["$MachineEpsilon",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$MachineEpsilon"]}]], "InlineFormula"],
 ", etc."
}], "Notes",
 CellID->7043]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->21858],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["Ulps",
   BaseStyle->"Link",
   ButtonData->"paclet:ComputerArithmetic/ref/Ulps"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->511622174]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->9429],

Cell[TextData[ButtonBox["Computer Arithmetic Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:ComputerArithmetic/tutorial/ComputerArithmetic"]], "Tutorials",
 CellID->5536]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->342598079],

Cell[TextData[ButtonBox["Computer Arithmetic Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:ComputerArithmetic/guide/ComputerArithmeticPackage"]], "MoreAbout",
 CellID->523539259]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Ulp - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 56, 58.9883284}", "context" -> 
    "ComputerArithmetic`", "keywords" -> {}, "index" -> True, "label" -> 
    "Computer Arithmetic Package Symbol", "language" -> "en", "paclet" -> 
    "ComputerArithmetic Package", "status" -> "None", "summary" -> 
    "Ulp[x] gives the size of an ulp for numbers near x.", "synonyms" -> {}, 
    "title" -> "Ulp", "type" -> "Symbol", "uri" -> 
    "ComputerArithmetic/ref/Ulp"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1850, 49, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2473, 76, 41, 1, 70, "ObjectName",
 CellID->31148],
Cell[2517, 79, 464, 15, 70, "Usage",
 CellID->5874]
}, Open  ]],
Cell[CellGroupData[{
Cell[3018, 99, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3496, 116, 340, 13, 70, "Notes",
 CellID->25774],
Cell[3839, 131, 508, 15, 70, "Notes",
 CellID->7043]
}, Closed]],
Cell[CellGroupData[{
Cell[4384, 151, 311, 9, 70, "SeeAlsoSection",
 CellID->21858],
Cell[4698, 162, 211, 6, 70, "SeeAlso",
 CellID->511622174]
}, Open  ]],
Cell[CellGroupData[{
Cell[4946, 173, 313, 9, 70, "TutorialsSection",
 CellID->9429],
Cell[5262, 184, 177, 4, 70, "Tutorials",
 CellID->5536]
}, Open  ]],
Cell[CellGroupData[{
Cell[5476, 193, 319, 9, 70, "MoreAboutSection",
 CellID->342598079],
Cell[5798, 204, 186, 4, 70, "MoreAbout",
 CellID->523539259]
}, Open  ]],
Cell[5999, 211, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

