(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6079,        207]
NotebookOptionsPosition[      4425,        157]
NotebookOutlinePosition[      5590,        188]
CellTagsIndexPosition[      5547,        185]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DEVELOPER PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"FullSimplify" :> 
         Documentation`HelpLookup["paclet:ref/FullSimplify"], 
         "FunctionExpand" :> 
         Documentation`HelpLookup["paclet:ref/FunctionExpand"], "BesselI" :> 
         Documentation`HelpLookup["paclet:ref/BesselI"], "BesselJ" :> 
         Documentation`HelpLookup["paclet:ref/BesselJ"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"FullSimplify\"\>", 2->"\<\"FunctionExpand\"\>", 
      3->"\<\"BesselI\"\>", 4->"\<\"BesselJ\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["BesselSimplify", "ObjectName",
 CellID->16590],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"BesselSimplify", "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]transforms Bessel functions in ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ", trying to either decrease the number of Bessel functions, or convert \
Bessel functions into more elementary functions. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->8823]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["BesselSimplify"], "InlineFormula"],
 " is automatically used inside ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["FunctionExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionExpand"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->2237]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->2327],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FullSimplify",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FullSimplify"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FunctionExpand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FunctionExpand"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BesselI",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BesselI"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BesselJ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BesselJ"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->320193084]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"BesselSimplify - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 57, 0.2383604}", "context" -> "Developer`", 
    "keywords" -> {"BesselSimplify"}, "index" -> True, "label" -> 
    "Developer Package Symbol", "language" -> "en", "paclet" -> 
    "Developer Package", "status" -> "None", "summary" -> 
    "BesselSimplify[expr] transforms Bessel functions in expr, trying to \
either decrease the number of Bessel functions, or convert Bessel functions \
into more elementary functions. ", "synonyms" -> {}, "title" -> 
    "BesselSimplify", "type" -> "Symbol", "uri" -> 
    "Developer/ref/BesselSimplify"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 884, 19, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1507, 46, 52, 1, 70, "ObjectName",
 CellID->16590],
Cell[1562, 49, 592, 16, 70, "Usage",
 CellID->8823]
}, Open  ]],
Cell[CellGroupData[{
Cell[2191, 70, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2669, 87, 403, 14, 70, "Notes",
 CellID->2237]
}, Closed]],
Cell[CellGroupData[{
Cell[3109, 106, 310, 9, 70, "SeeAlsoSection",
 CellID->2327],
Cell[3422, 117, 961, 35, 70, "SeeAlso",
 CellID->320193084]
}, Open  ]],
Cell[4398, 155, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

