(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12124,        404]
NotebookOptionsPosition[      9935,        345]
NotebookOutlinePosition[     11524,        381]
CellTagsIndexPosition[     11481,        378]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DEVELOPER PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"ListCorrelate" :> 
         Documentation`HelpLookup["paclet:ref/ListCorrelate"], "Partition" :> 
         Documentation`HelpLookup["paclet:ref/Partition"], "Map" :> 
         Documentation`HelpLookup["paclet:ref/Map"], "Apply" :> 
         Documentation`HelpLookup["paclet:ref/Apply"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"ListCorrelate\"\>", 2->"\<\"Partition\"\>", 
      3->"\<\"Map\"\>", 4->"\<\"Apply\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["PartitionMap", "ObjectName",
 CellID->21575],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"PartitionMap", "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        StyleBox["list", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]applies ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     " after partitioning into non\[Hyphen]overlapping sublists of length ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"PartitionMap", "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        StyleBox["list", "TI"], ",", 
        StyleBox["n", "TI"], ",", 
        StyleBox["d", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]applies ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " to sublists obtained by partitioning with offset ",
     Cell[BoxData[
      StyleBox["d", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"PartitionMap", "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        StyleBox["list", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["n", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["n", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]applies ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " after partitioning a nested list into blocks of size ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["n", "1"], "\[Cross]", 
        SubscriptBox["n", "2"], "\[Cross]", "\[Ellipsis]", " "}], 
       TraditionalForm]], "InlineMath"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"PartitionMap", "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        StyleBox["list", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["n", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["n", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["d", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["d", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]applies ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " after partitioning using offset ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["d", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " at level ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"PartitionMap", "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        StyleBox["list", "TI"], ",", 
        StyleBox["n", "TI"], ",", 
        StyleBox["d", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["k", "TI"], 
           StyleBox["L", "TI"]], ",", 
          SubscriptBox[
           StyleBox["k", "TI"], 
           StyleBox["R", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]specifies where sublists should begin and end. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"PartitionMap", "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        StyleBox["list", "TI"], ",", 
        StyleBox["n", "TI"], ",", 
        StyleBox["d", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["k", "TI"], 
           StyleBox["L", "TI"]], ",", 
          SubscriptBox[
           StyleBox["k", "TI"], 
           StyleBox["R", "TI"]]}], "}"}], ",", 
        StyleBox["padding", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]specifies what padding should be used. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->6724]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"PartitionMap", "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["list", "TI"], ",", 
    StyleBox["n", "TI"], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Map",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Map"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    RowBox[{
     ButtonBox["Partition",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Partition"], "[", 
     RowBox[{
      StyleBox["list", "TI"], ",", 
      StyleBox["n", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "]"}]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->25981],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"PartitionMap", "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["list", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"], ",", 
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["d", "TI"]]}], "}"}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Map",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Map"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    RowBox[{
     ButtonBox["Partition",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Partition"], "[", 
     RowBox[{
      StyleBox["list", "TI"], ",", 
      StyleBox["n", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "]"}], ",", 
    RowBox[{"{", 
     StyleBox["d", "TI"], "}"}]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->27700],

Cell[TextData[{
 Cell[BoxData["PartitionMap"], "InlineFormula"],
 " can be used on ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"FunctionLink",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects. "
}], "Notes",
 CellID->7961]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->24016],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ListCorrelate",
    BaseStyle->"FunctionLink",
    ButtonData->"paclet:ref/ListCorrelate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Partition",
    BaseStyle->"FunctionLink",
    ButtonData->"paclet:ref/Partition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Map",
    BaseStyle->"FunctionLink",
    ButtonData->"paclet:ref/Map"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Apply",
    BaseStyle->"FunctionLink",
    ButtonData->"paclet:ref/Apply"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->15137]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PartitionMap - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 57, 14.5668522}", "context" -> "Developer`", 
    "keywords" -> {"PartitionMap"}, "index" -> True, "label" -> 
    "Developer Package Symbol", "language" -> "en", "paclet" -> 
    "Developer Package", "status" -> "None", "summary" -> 
    "PartitionMap[f, list, n] applies f to list after partitioning into \
non-overlapping sublists of length n. PartitionMap[f, list, n, d] applies f \
to sublists obtained by partitioning with offset d. PartitionMap[f, list, \
{n_1, n_2, ...}] applies f after partitioning a nested list into blocks of \
size n_1*n_2*... . PartitionMap[f, list, {n_1, n_2, ...}, {d_1, d_2, ...}] \
applies f after partitioning using offset d_i at level i. PartitionMap[f, \
list, n, d, {k_L, k_R}] specifies where sublists should begin and end. \
PartitionMap[f, list, n, d, {k_L, k_R}, padding] specifies what padding \
should be used. ", "synonyms" -> {}, "title" -> "PartitionMap", "type" -> 
    "Symbol", "uri" -> "Developer/ref/PartitionMap"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 844, 18, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1467, 45, 50, 1, 70, "ObjectName",
 CellID->21575],
Cell[1520, 48, 4478, 141, 70, "Usage",
 CellID->6724]
}, Open  ]],
Cell[CellGroupData[{
Cell[6035, 194, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6513, 211, 716, 26, 70, "Notes",
 CellID->25981],
Cell[7232, 239, 1078, 39, 70, "Notes",
 CellID->27700],
Cell[8313, 280, 260, 9, 70, "Notes",
 CellID->7961]
}, Closed]],
Cell[CellGroupData[{
Cell[8610, 294, 311, 9, 70, "SeeAlsoSection",
 CellID->24016],
Cell[8924, 305, 969, 35, 70, "SeeAlso",
 CellID->15137]
}, Open  ]],
Cell[9908, 343, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

