(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      5807,        198]
NotebookOptionsPosition[      4126,        148]
NotebookOutlinePosition[      5317,        179]
CellTagsIndexPosition[      5274,        176]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DEVELOPER PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"FullSimplify" :> 
         Documentation`HelpLookup["paclet:ref/FullSimplify"], 
         "FunctionExpand" :> 
         Documentation`HelpLookup["paclet:ref/FunctionExpand"], "PolyGamma" :> 
         Documentation`HelpLookup["paclet:ref/PolyGamma"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"FullSimplify\"\>", 
      2->"\<\"FunctionExpand\"\>", 
      3->"\<\"PolyGamma\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["PolyGammaSimplify", "ObjectName",
 CellID->14878],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"PolyGammaSimplify", "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]transforms polygamma functions in ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ", trying to either decrease the number of polygamma functions, or \
convert combinations of them into more elementary functions. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->6923]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["PolyGammaSimplify"], "InlineFormula"],
 " is automatically used inside ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["FunctionExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionExpand"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->27085]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->9412],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FullSimplify",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FullSimplify"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FunctionExpand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FunctionExpand"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PolyGamma",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PolyGamma"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->872481803]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PolyGammaSimplify - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 57, 14.7387316}", "context" -> "Developer`", 
    "keywords" -> {"PolyGammaSimplify"}, "index" -> True, "label" -> 
    "Developer Package Symbol", "language" -> "en", "paclet" -> 
    "Developer Package", "status" -> "None", "summary" -> 
    "PolyGammaSimplify[expr] transforms polygamma functions in expr, trying \
to either decrease the number of polygamma functions, or convert combinations \
of them into more elementary functions. ", "synonyms" -> {}, "title" -> 
    "PolyGammaSimplify", "type" -> "Symbol", "uri" -> 
    "Developer/ref/PolyGammaSimplify"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 804, 19, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1427, 46, 55, 1, 70, "ObjectName",
 CellID->14878],
Cell[1485, 49, 605, 16, 70, "Usage",
 CellID->6923]
}, Open  ]],
Cell[CellGroupData[{
Cell[2127, 70, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2605, 87, 407, 14, 70, "Notes",
 CellID->27085]
}, Closed]],
Cell[CellGroupData[{
Cell[3049, 106, 310, 9, 70, "SeeAlsoSection",
 CellID->9412],
Cell[3362, 117, 722, 26, 70, "SeeAlso",
 CellID->872481803]
}, Open  ]],
Cell[4099, 146, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

