(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7479,        267]
NotebookOptionsPosition[      5596,        207]
NotebookOutlinePosition[      6666,        236]
CellTagsIndexPosition[      6623,        233]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DEVELOPER PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"FromPackedArray" :> 
         Documentation`HelpLookup["paclet:Developer/ref/FromPackedArray"], 
         "ByteCount" :> Documentation`HelpLookup["paclet:ref/ByteCount"], 
         "Compress" :> Documentation`HelpLookup["paclet:ref/Compress"]}, #, 
        2]& , Evaluator -> Automatic], {1->"\<\"FromPackedArray\"\>", 
      2->"\<\"ByteCount\"\>", 3->"\<\"Compress\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ToPackedArray", "ObjectName",
 CellID->24593],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ToPackedArray", "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]uses packed arrays if possible in the internal \
representation of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->30806]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Using ",
 Cell[BoxData["ToPackedArray"], "InlineFormula"],
 " will not change results generated by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", but can enhance speed of execution and reduce memory usage. "
}], "Notes",
 CellID->29849],

Cell[TextData[{
 Cell[BoxData["ToPackedArray"], "InlineFormula"],
 " is effectively used automatically by many functions that generate large \
lists. "
}], "Notes",
 CellID->14854],

Cell[TextData[{
 Cell[BoxData["ToPackedArray"], "InlineFormula"],
 " will successfully pack full lists of any depth containing \
machine\[Hyphen]sized integers and machine\[Hyphen]sized approximate real and \
complex numbers. "
}], "Notes",
 CellID->24272],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"ToPackedArray", "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["type", "TI"]}], "]"}]], "InlineFormula"],
 " will when possible convert entries in ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " to be of the specified type. "
}], "Notes",
 CellID->26160],

Cell[TextData[{
 "Possible types are: ",
 Cell[BoxData[
  ButtonBox["Integer",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integer"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Real",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Real"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Complex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Complex"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->12294],

Cell["\<\
Only machine\[Hyphen]sized numbers can be stored in packed form. \
\>", "Notes",
 CellID->12054],

Cell[TextData[{
 "The option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Tolerance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tolerance"], "->", 
   StyleBox["tol", "TI"]}]], "InlineFormula"],
 " can be used to specify when small numerical values can be ignored in \
conversion to more restrictive types, and when they must prevent conversion \
to packed form. "
}], "Notes",
 CellID->26333]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->22241],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FromPackedArray",
    BaseStyle->"Link",
    ButtonData->"paclet:Developer/ref/FromPackedArray"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ByteCount",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ByteCount"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Compress",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Compress"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->29421]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ToPackedArray - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 57, 15.2074936}", "context" -> "Developer`", 
    "keywords" -> {"ToPackedArray"}, "index" -> True, "label" -> 
    "Developer Package Symbol", "language" -> "en", "paclet" -> 
    "Developer Package", "status" -> "None", "summary" -> 
    "ToPackedArray[expr] uses packed arrays if possible in the internal \
representation of expr. ", "synonyms" -> {}, "title" -> "ToPackedArray", 
    "type" -> "Symbol", "uri" -> "Developer/ref/ToPackedArray"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 789, 17, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1412, 44, 51, 1, 70, "ObjectName",
 CellID->24593],
Cell[1466, 47, 508, 16, 70, "Usage",
 CellID->30806]
}, Open  ]],
Cell[CellGroupData[{
Cell[2011, 68, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2489, 85, 263, 8, 70, "Notes",
 CellID->29849],
Cell[2755, 95, 180, 5, 70, "Notes",
 CellID->14854],
Cell[2938, 102, 256, 6, 70, "Notes",
 CellID->24272],
Cell[3197, 110, 332, 11, 70, "Notes",
 CellID->26160],
Cell[3532, 123, 437, 18, 70, "Notes",
 CellID->12294],
Cell[3972, 143, 106, 3, 70, "Notes",
 CellID->12054],
Cell[4081, 148, 400, 12, 70, "Notes",
 CellID->26333]
}, Closed]],
Cell[CellGroupData[{
Cell[4518, 165, 311, 9, 70, "SeeAlsoSection",
 CellID->22241],
Cell[4832, 176, 722, 26, 70, "SeeAlso",
 CellID->29421]
}, Open  ]],
Cell[5569, 205, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

