(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      5550,        197]
NotebookOptionsPosition[      3930,        147]
NotebookOutlinePosition[      5006,        176]
CellTagsIndexPosition[      4963,        173]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["DEVELOPER PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"FullSimplify" :> 
         Documentation`HelpLookup["paclet:ref/FullSimplify"], 
         "FunctionExpand" :> 
         Documentation`HelpLookup["paclet:ref/FunctionExpand"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"FullSimplify\"\>", 
      2->"\<\"FunctionExpand\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["TrigToRadicals", "ObjectName",
 CellID->23492],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"TrigToRadicals", "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]converts trigonometric functions to radicals whenever \
possible in ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->21292]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["TrigToRadicals"], "InlineFormula"],
 " operates on trigonometric functions whose arguments are rational multiples \
of ",
 Cell[BoxData[
  FormBox["\[Pi]", TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->20237],

Cell[TextData[{
 Cell[BoxData["TrigToRadicals"], "InlineFormula"],
 " is automatically used inside ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["FunctionExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionExpand"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->27530]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->5628],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FullSimplify",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FullSimplify"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FunctionExpand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FunctionExpand"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->174800886]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"TrigToRadicals - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 57, 15.3793730}", "context" -> "Developer`", 
    "keywords" -> {"TrigToRadicals"}, "index" -> True, "label" -> 
    "Developer Package Symbol", "language" -> "en", "paclet" -> 
    "Developer Package", "status" -> "None", "summary" -> 
    "TrigToRadicals[expr] converts trigonometric functions to radicals \
whenever possible in expr. ", "synonyms" -> {}, "title" -> "TrigToRadicals", 
    "type" -> "Symbol", "uri" -> "Developer/ref/TrigToRadicals"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 698, 17, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1321, 44, 52, 1, 70, "ObjectName",
 CellID->23492],
Cell[1376, 47, 510, 16, 70, "Usage",
 CellID->21292]
}, Open  ]],
Cell[CellGroupData[{
Cell[1923, 68, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2401, 85, 255, 8, 70, "Notes",
 CellID->20237],
Cell[2659, 95, 404, 14, 70, "Notes",
 CellID->27530]
}, Closed]],
Cell[CellGroupData[{
Cell[3100, 114, 310, 9, 70, "SeeAlsoSection",
 CellID->5628],
Cell[3413, 125, 475, 17, 70, "SeeAlso",
 CellID->174800886]
}, Open  ]],
Cell[3903, 145, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

