(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     22164,        718]
NotebookOptionsPosition[     18993,        626]
NotebookOutlinePosition[     20671,        663]
CellTagsIndexPosition[     20628,        660]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["EQUATION TREKKER PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"EquationTrekker Package" :> 
          Documentation`HelpLookup[
           "paclet:EquationTrekker/tutorial/EquationTrekker"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"EquationTrekker Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"EquationTrekkerState" :> 
          Documentation`HelpLookup[
           "paclet:EquationTrekker/ref/EquationTrekkerState"], 
          "TrekParameters" :> 
          Documentation`HelpLookup[
           "paclet:EquationTrekker/ref/TrekParameters"], "TrekGenerator" :> 
          Documentation`HelpLookup[
           "paclet:EquationTrekker/ref/TrekGenerator"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"EquationTrekkerState\"\>", 
       2->"\<\"TrekParameters\"\>", 
       3->"\<\"TrekGenerator\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"EquationTrekker Package" :> 
          Documentation`HelpLookup[
           "paclet:EquationTrekker/guide/EquationTrekkerPackage"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"EquationTrekker Package\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["EquationTrekker", "ObjectName",
 CellID->28642],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"EquationTrekker", "[", 
       RowBox[{
        StyleBox["eqn", "TI"], ",", 
        StyleBox["x", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["t", "TI"], ",", 
          SubscriptBox[
           StyleBox["t", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["t", "TI"], 
           StyleBox["max", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]opens a graphical interface for specifying initial \
conditions and plotting the resulting numerical solution to the first or \
second order ordinary differential equation ",
     Cell[BoxData[
      StyleBox["eqn", "TI"]], "InlineFormula"],
     " for the function ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " with the independent variable ",
     Cell[BoxData[
      StyleBox["t", "TI"]], "InlineFormula"],
     " in the range ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["t", "TI"], 
       StyleBox["min", "TI"]]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["t", "TI"], 
       StyleBox["max", "TI"]]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"EquationTrekker", "[", 
       RowBox[{
        StyleBox["eqns", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          StyleBox["y", "TI"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["t", "TI"], ",", 
          SubscriptBox[
           StyleBox["t", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["t", "TI"], 
           StyleBox["max", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]opens a graphical interface for specifying initial \
conditions and plotting the resulting numerical solution to the system of two \
first order ordinary differential equations ",
     Cell[BoxData[
      StyleBox["eqns", "TI"]], "InlineFormula"],
     " for the functions ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"EquationTrekker", "[", 
       StyleBox["state", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]reopens a graphical interface with the treks saved in \
the ",
     Cell[BoxData[
      ButtonBox["EquationTrekkerState",
       BaseStyle->"Link",
       ButtonData->"paclet:EquationTrekker/ref/EquationTrekkerState"]], 
      "InlineFormula"],
     " object ",
     Cell[BoxData[
      StyleBox["state", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->16339]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  StyleBox["eqn", "TI"]], "InlineFormula"],
 " is a single first order ODE, plots of ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "[", 
   StyleBox["t", "TI"], "]"}]], "InlineFormula"],
 " versus ",
 Cell[BoxData[
  StyleBox["t", "TI"]], "InlineFormula"],
 " are displayed. If ",
 Cell[BoxData[
  StyleBox["eqn", "TI"]], "InlineFormula"],
 " is a single second order ODE, plots of ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox["x", "TI"], "'"}], "[", 
   StyleBox["t", "TI"], "]"}]], "InlineFormula"],
 " versus ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "[", 
   StyleBox["t", "TI"], "]"}]], "InlineFormula"],
 " are displayed. If ",
 Cell[BoxData[
  StyleBox["eqns", "TI"]], "InlineFormula"],
 " consist of a system of two first order ODEs, plots of ",
 Cell[BoxData[
  RowBox[{
   StyleBox["y", "TI"], "[", 
   StyleBox["t", "TI"], "]"}]], "InlineFormula"],
 " versus ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "[", 
   StyleBox["t", "TI"], "]"}]], "InlineFormula"],
 " are displayed."
}], "Notes",
 CellID->6336],

Cell["\<\
Treks are invoked by right clicking on a coordinate, generating a trek that \
starts at the point specified by the mouse cursor.\
\>", "Notes",
 CellID->32621],

Cell[TextData[{
 "The initial position of a trek is highlighted in yellow, and by default \
corresponds to an initial condition specified at ",
 Cell[BoxData[
  RowBox[{
   StyleBox["t", "TI"], "=", "0"}]], "InlineFormula"],
 ". However, only the section of the trek from ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["t", "TI"], 
   StyleBox["min", "TI"]]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["t", "TI"], 
   StyleBox["max", "TI"]]], "InlineFormula"],
 " is displayed, with the coordinate associated with ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["t", "TI"], 
   StyleBox["min", "TI"]]], "InlineFormula"],
 " displayed as a point and the coordinate associated with ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["t", "TI"], 
   StyleBox["max", "TI"]]], "InlineFormula"],
 " displayed as an arrow head."
}], "Notes",
 CellID->21501],

Cell[TextData[{
 "Changing defaults for newly created treks may be accomplished by typing a \
value in the text field and clicking on the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["", Cell[GraphicsData["CompressedBitmap", "\<\
eJx1k81rE1EUxU8+Rl10Kbjtxv/CtYrQpeA2FGmL37W7UleCgi4EUXBXLIIo
CILUVangQqgfRWyrtk2aTJppMpNMZibJZDpNE899M9FW4+LeOfPe+d135715
I5mp8YtXMlMTo5nhM5OZ6+MTozeHT1+b5FAqAeC4xDBE9yj76Qhq5jrqtS00
3B34rRrafh2B76QRtJ0UwtBPiYJkD7uBx6eLBJEcC6RhGiuoVn5g5slLnLxw
ewg4NUXziZFbuHz/GVpNi+a2bytzqbCMsTuzOHfjIeZevRmSHmh+/XYeZ68+
wKV7czQLIuZi7pMqs/hhCfrWWt+88f0z5hcW1FSCXRtqtJj7qFauWgaSsKwS
C1SZ5T2OZMTLm6YclXIB2/o68tkVxSbg2vqhao5j0es4ZjpiqVi3bpdhKvan
uBJw7ELccYS5blVC/NYRIZOqEsl6BZZZREnf6JP5Q6Tn1SSSgh9TH6ypaoJX
rW0Yxc241X9JW0LsNfWlaVHMjlNVO2EUs4PXbDbrEhoaDTsmqZilGbtmoFzK
DSZbLVdCI+7EJJXi62qXKkZ+MOn7DQmNyYtJKmYp6XKXLe7vf8imhJCN32RD
kR5Ji6R+kPxzmEHQ5u8eBH6MUTG32y3+RDavgTEYC8OQWBjuxhiVygF/VI9u
8yCmQc9G2P5+R0Wn06G909lLRqdJxeJ7eyF84tFZyvXrL8k7hMUvm1yy2+3G
DBVnu919zmwoR0Jd2/6+TD96jvMzT/FuOauh1+vFGBWx1a2ympx+/IKYubMa
3cT8Mgz9q0L/urZjd2dR3v5Gs2TpSyAB5NuOorC5lEJ27X1KFGdlVLoQR3+B
xC8wePil\
\>"], "Graphics",
     Evaluatable->False,
     GeneratedCell->False,
     CellAutoOverwrite->False,
     ImageSize->{20, 20},
     ImageMargins->{{0, 0}, {0, 0}},
     ImageRegion->{{0, 1}, {0, 1}},
     GridBoxOptions->{
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxItemSize->{"Columns" -> {
         Scaled[0.4], {
          Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{
      "Columns" -> {0.28, {0.7}, 0.28}, "ColumnsIndexed" -> {}, 
       "Rows" -> {0.2, {0.6}, 0.2}, "RowsIndexed" -> {}}}]], 
   TraditionalForm]],
  GridBoxOptions->{
  GridBoxAlignment->{
   "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
    "RowsIndexed" -> {}},
  GridBoxItemSize->{"Columns" -> {
      Scaled[0.4], {
       Scaled[0.6]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}},
  GridBoxSpacings->{
   "Columns" -> {0.28, {0.7}, 0.28}, "ColumnsIndexed" -> {}, 
    "Rows" -> {0.2, {0.6}, 0.2}, "RowsIndexed" -> {}}}],
 " button."
}], "Notes",
 CellID->26034],

Cell[TextData[{
 Cell[BoxData["EquationTrekker"], "InlineFormula"],
 " generates a modal dialog, and the kernel is controlled by the graphical \
interface until the window is closed."
}], "Notes",
 CellID->18129],

Cell[TextData[{
 "When the window is closed, a list containing an ",
 Cell[BoxData[
  ButtonBox["EquationTrekkerState",
   BaseStyle->"Link",
   ButtonData->"paclet:EquationTrekker/ref/EquationTrekkerState"]], 
  "InlineFormula"],
 " object and a graphic is returned. The ",
 Cell[BoxData[
  ButtonBox["EquationTrekkerState",
   BaseStyle->"Link",
   ButtonData->"paclet:EquationTrekker/ref/EquationTrekkerState"]], 
  "InlineFormula"],
 " object contains all of the information necessary to reopen the window with \
the treks that were displayed when the window was closed."
}], "Notes",
 CellID->21358],

Cell["The following options can be given:", "Notes",
 CellID->1436],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ImageSize",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ImageSize"], 
    RowBox[{"{", 
     RowBox[{"400", ",", "400"}], "}"}], Cell[TextData[{
     "absolute size of ",
     Cell[BoxData["EquationTrekker"], "InlineFormula"],
     " window"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PlotRange",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotRange"], 
    RowBox[{"{", 
     RowBox[{
      ButtonBox["Automatic",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Automatic"], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}], Cell[
    "range of values to include", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["TrekParameters",
     BaseStyle->"Link",
     ButtonData->"paclet:EquationTrekker/ref/TrekParameters"], 
    RowBox[{"{", "}"}], Cell[
    "list of parameters and parameter ranges", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["TrekGenerator",
     BaseStyle->"Link",
     ButtonData->"paclet:EquationTrekker/ref/TrekGenerator"], 
    ButtonBox["DifferentialEquationTrek",
     BaseStyle->"Link",
     ButtonData->"paclet:EquationTrekker/ref/DifferentialEquationTrek"], Cell[
    "method used to generate treks", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->28469],

Cell[TextData[{
 "A valid setting for ",
 Cell[BoxData[
  ButtonBox["TrekParameters",
   BaseStyle->"Link",
   ButtonData->"paclet:EquationTrekker/ref/TrekParameters"]], 
  "InlineFormula"],
 " is a list of rules of the form ",
 Cell[BoxData[
  RowBox[{
   StyleBox["param", "TI"], "->", 
   StyleBox["range", "TI"]}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  StyleBox["range", "TI"]], "InlineFormula"],
 " consists of a starting value and a range, ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["v", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["min", "TI"]], ",", 
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["max", "TI"]]}], "}"}]}], "}"}]], "InlineFormula"],
 ". The ",
 Cell[BoxData[
  StyleBox["range", "TI"]], "InlineFormula"],
 " specification may also consist of a single value ",
 Cell[BoxData[
  StyleBox["v", "TI"]], "InlineFormula"],
 ", which is equivalent to ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["v", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"2", 
       StyleBox["v", "TI"]}]}], "}"}]}], "}"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->22897],

Cell[TextData[{
 "Valid settings for ",
 Cell[BoxData[
  ButtonBox["TrekGenerator",
   BaseStyle->"Link",
   ButtonData->"paclet:EquationTrekker/ref/TrekGenerator"]], 
  "InlineFormula"],
 " are ",
 Cell[BoxData[
  ButtonBox["DifferentialEquationTrek",
   BaseStyle->"Link",
   ButtonData->"paclet:EquationTrekker/ref/DifferentialEquationTrek"]], 
  "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["PoincareSection",
   BaseStyle->"Link",
   ButtonData->"paclet:EquationTrekker/ref/PoincareSection"]], 
  "InlineFormula"],
 "."
}], "Notes",
 CellID->28504],

Cell[TextData[{
 "The default setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["TrekGenerator",
    BaseStyle->"Link",
    ButtonData->"paclet:EquationTrekker/ref/TrekGenerator"], "->", 
   ButtonBox["DifferentialEquationTrek",
    BaseStyle->"Link",
    ButtonData->"paclet:EquationTrekker/ref/DifferentialEquationTrek"]}]], 
  "InlineFormula"],
 " creates treks by following the path of the dependent variables generated \
using ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->4798],

Cell[TextData[{
 "The setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["TrekGenerator",
    BaseStyle->"Link",
    ButtonData->"paclet:EquationTrekker/ref/TrekGenerator"], "->", 
   ButtonBox["PoincareSection",
    BaseStyle->"Link",
    ButtonData->"paclet:EquationTrekker/ref/PoincareSection"]}]], 
  "InlineFormula"],
 " creates treks by sampling the phase space. The sampling interval is \
typically periodic."
}], "Notes",
 CellID->4202],

Cell[TextData[{
 "The setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["TrekGenerator",
    BaseStyle->"Link",
    ButtonData->"paclet:EquationTrekker/ref/TrekGenerator"], "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["method", "TI"], ",", 
     StyleBox["subopts", "TI"]}], "}"}]}]], "InlineFormula"],
 " may be used to include the suboptions ",
 Cell[BoxData[
  StyleBox["subopts", "TI"]], "InlineFormula"],
 " for the ",
 Cell[BoxData[
  ButtonBox["TrekGenerator",
   BaseStyle->"Link",
   ButtonData->"paclet:EquationTrekker/ref/TrekGenerator"]], 
  "InlineFormula"],
 " method ",
 Cell[BoxData[
  StyleBox["method", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->23105]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14481],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["EquationTrekkerState",
    BaseStyle->"Link",
    ButtonData->"paclet:EquationTrekker/ref/EquationTrekkerState"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrekParameters",
    BaseStyle->"Link",
    ButtonData->"paclet:EquationTrekker/ref/TrekParameters"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrekGenerator",
    BaseStyle->"Link",
    ButtonData->"paclet:EquationTrekker/ref/TrekGenerator"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->15579]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->1238],

Cell[TextData[ButtonBox["EquationTrekker Package",
 BaseStyle->"Link",
 ButtonData->"paclet:EquationTrekker/tutorial/EquationTrekker"]], "Tutorials",\

 CellID->15032]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->287969676],

Cell[TextData[ButtonBox["EquationTrekker Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:EquationTrekker/guide/EquationTrekkerPackage"]], "MoreAbout",
 CellID->323208229]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"EquationTrekker - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 57, 22.8639396}", "context" -> 
    "EquationTrekker`", "keywords" -> {}, "index" -> True, "label" -> 
    "Equation Trekker Package Symbol", "language" -> "en", "paclet" -> 
    "EquationTrekker Package", "status" -> "None", "summary" -> 
    "EquationTrekker[eqn, x, {t, t_min, t_max}] opens a graphical interface \
for specifying initial conditions and plotting the resulting numerical \
solution to the first or second order ordinary differential equation eqn for \
the function x with the independent variable t in the range t_min to t_max. \
EquationTrekker[eqns, {x, y}, {t, t_min, t_max}] opens a graphical interface \
for specifying initial conditions and plotting the resulting numerical \
solution to the system of two first order ordinary differential equations \
eqns for the functions x and y. EquationTrekker[state] reopens a graphical \
interface with the treks saved in the EquationTrekkerState object state.", 
    "synonyms" -> {}, "title" -> "EquationTrekker", "type" -> "Symbol", "uri" -> 
    "EquationTrekker/ref/EquationTrekker"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2176, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2799, 83, 53, 1, 70, "ObjectName",
 CellID->28642],
Cell[2855, 86, 2966, 91, 70, "Usage",
 CellID->16339]
}, Open  ]],
Cell[CellGroupData[{
Cell[5858, 182, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6336, 199, 1091, 41, 70, "Notes",
 CellID->6336],
Cell[7430, 242, 169, 4, 70, "Notes",
 CellID->32621],
Cell[7602, 248, 870, 28, 70, "Notes",
 CellID->21501],
Cell[8475, 278, 2251, 53, 70, "Notes",
 CellID->26034],
Cell[10729, 333, 212, 5, 70, "Notes",
 CellID->18129],
Cell[10944, 340, 604, 16, 70, "Notes",
 CellID->21358],
Cell[11551, 358, 67, 1, 70, "Notes",
 CellID->1436],
Cell[11621, 361, 1624, 44, 70, "3ColumnTableMod",
 CellID->28469],
Cell[13248, 407, 1219, 45, 70, "Notes",
 CellID->22897],
Cell[14470, 454, 563, 21, 70, "Notes",
 CellID->28504],
Cell[15036, 477, 584, 19, 70, "Notes",
 CellID->4798],
Cell[15623, 498, 443, 14, 70, "Notes",
 CellID->4202],
Cell[16069, 514, 686, 25, 70, "Notes",
 CellID->23105]
}, Closed]],
Cell[CellGroupData[{
Cell[16792, 544, 311, 9, 70, "SeeAlsoSection",
 CellID->14481],
Cell[17106, 555, 790, 26, 70, "SeeAlso",
 CellID->15579]
}, Open  ]],
Cell[CellGroupData[{
Cell[17933, 586, 313, 9, 70, "TutorialsSection",
 CellID->1238],
Cell[18249, 597, 167, 4, 70, "Tutorials",
 CellID->15032]
}, Open  ]],
Cell[CellGroupData[{
Cell[18453, 606, 319, 9, 70, "MoreAboutSection",
 CellID->287969676],
Cell[18775, 617, 176, 4, 70, "MoreAbout",
 CellID->323208229]
}, Open  ]],
Cell[18966, 624, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

