(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6993,        244]
NotebookOptionsPosition[      5249,        189]
NotebookOutlinePosition[      6348,        219]
CellTagsIndexPosition[      6305,        216]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["EQUATION TREKKER PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"EquationTrekker Package" :> 
          Documentation`HelpLookup[
           "paclet:EquationTrekker/tutorial/EquationTrekker"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"EquationTrekker Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"EquationTrekker" :> 
          Documentation`HelpLookup[
           "paclet:EquationTrekker/ref/EquationTrekker"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"EquationTrekker\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["TrekParameters", "ObjectName",
 CellID->27892],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["TrekParameters"], "InlineFormula"],
     " \[LineSeparator]is an option to ",
     Cell[BoxData[
      ButtonBox["EquationTrekker",
       BaseStyle->"Link",
       ButtonData->"paclet:EquationTrekker/ref/EquationTrekker"]], 
      "InlineFormula"],
     " that specifies the dynamic parameters and their ranges."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->18848]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "A valid setting for ",
 Cell[BoxData["TrekParameters"], "InlineFormula"],
 " is a list of rules of the form ",
 Cell[BoxData[
  RowBox[{
   StyleBox["param", "TI"], "->", 
   StyleBox["range", "TI"]}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  StyleBox["range", "TI"]], "InlineFormula"],
 " consists of a starting value and a range, ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["v", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["min", "TI"]], ",", 
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["max", "TI"]]}], "}"}]}], "}"}]], "InlineFormula"],
 ". The ",
 Cell[BoxData[
  StyleBox["range", "TI"]], "InlineFormula"],
 " specification may also consist of a single value ",
 Cell[BoxData[
  StyleBox["v", "TI"]], "InlineFormula"],
 ", which is equivalent to ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["v", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"2", 
       StyleBox["v", "TI"]}]}], "}"}]}], "}"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->6784]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->18258],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["EquationTrekker",
   BaseStyle->"Link",
   ButtonData->"paclet:EquationTrekker/ref/EquationTrekker"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->19176]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->30245],

Cell[TextData[ButtonBox["EquationTrekker Package",
 BaseStyle->"Link",
 ButtonData->"paclet:EquationTrekker/tutorial/EquationTrekker"]], "Tutorials",\

 CellID->12187]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"TrekParameters - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 57, 30.5360110}", "context" -> 
    "EquationTrekker`", "keywords" -> {}, "index" -> True, "label" -> 
    "Equation Trekker Package Symbol", "language" -> "en", "paclet" -> 
    "EquationTrekker Package", "status" -> "None", "summary" -> 
    "TrekParameters is an option to EquationTrekker that specifies the \
dynamic parameters and their ranges.", "synonyms" -> {}, "title" -> 
    "TrekParameters", "type" -> "Symbol", "uri" -> 
    "EquationTrekker/ref/TrekParameters"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1240, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1863, 60, 52, 1, 70, "ObjectName",
 CellID->27892],
Cell[1918, 63, 557, 16, 70, "Usage",
 CellID->18848]
}, Open  ]],
Cell[CellGroupData[{
Cell[2512, 84, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2990, 101, 1119, 41, 70, "Notes",
 CellID->6784]
}, Closed]],
Cell[CellGroupData[{
Cell[4146, 147, 311, 9, 70, "SeeAlsoSection",
 CellID->18258],
Cell[4460, 158, 226, 6, 70, "SeeAlso",
 CellID->19176]
}, Open  ]],
Cell[CellGroupData[{
Cell[4723, 169, 314, 9, 70, "TutorialsSection",
 CellID->30245],
Cell[5040, 180, 167, 4, 70, "Tutorials",
 CellID->12187]
}, Open  ]],
Cell[5222, 187, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

