(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10595,        360]
NotebookOptionsPosition[      8068,        279]
NotebookOutlinePosition[      9454,        317]
CellTagsIndexPosition[      9370,        312]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["ERROR BAR PLOTS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[
    Cell[BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"ErrorListPlot" :> 
         Documentation`HelpLookup["paclet:ErrorBarPlots/ref/ErrorListPlot"], 
         "ErrorBarFunction" :> 
         Documentation`HelpLookup[
          "paclet:ErrorBarPlots/ref/ErrorBarFunction"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"ErrorListPlot\"\>", 
      2->"\<\"ErrorBarFunction\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ErrorBar", "ObjectName",
 CellID->30502],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       RowBox[{"ErrorBar", "[", "{"}], 
       StyleBox["negerror", "TI"], ",", 
       StyleBox["poserror", "TI"], 
       RowBox[{"}", "]"}]}]], "InlineFormula"],
     " \[LineSeparator] error in the positive and negative directions."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ErrorBar", "[", 
       StyleBox["yerr", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]error ",
     Cell[BoxData[
      StyleBox["yerr", "TI"]], "InlineFormula"],
     " in both the positive and negative directions"
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ErrorBar", "[", 
       RowBox[{
        StyleBox["xerr", "TI"], ",", 
        StyleBox["yerr", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]errors specified for both the x and the y coordinates"
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->17713]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["ErrorBar"], "InlineFormula"],
 " is used in a list of data points for ",
 Cell[BoxData[
  ButtonBox["ErrorListPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ErrorBarPlots/ref/ErrorListPlot"]], "InlineFormula"],
 " to represent error in a data point."
}], "Notes",
 CellID->31707],

Cell[TextData[{
 "The syntax of a data point, with associated error, is generally ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["pt", "TI"], ",", " ", 
    RowBox[{"ErrorBar", "[", 
     StyleBox["err", "TI"], "]"}]}], "}"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->28271],

Cell["\<\
The error is expressed as a change in the value at the point.\
\>", "Notes",
 CellID->10281]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->59724156],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->126041411],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<ErrorBarPlots`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->72157237],

Cell[TextData[{
 "Use ",
 Cell[BoxData["ErrorBar"], "InlineFormula"],
 " to represent errors in a plot:"
}], "ExampleText",
 CellID->477905686],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ErrorListPlot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}], ",", 
        RowBox[{"ErrorBar", "[", 
         RowBox[{"0.2", ",", "0.3"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2", ",", "2"}], "}"}], ",", 
        RowBox[{"ErrorBar", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "0.5"}], ",", "1.5"}], "}"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"3", ",", "4"}], "}"}], ",", 
        RowBox[{"ErrorBar", "[", "0.3", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"4", ",", "6"}], "}"}], ",", 
        RowBox[{"ErrorBar", "[", "0.4", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"5", ",", "7"}], "}"}], ",", 
        RowBox[{"ErrorBar", "[", "0.8", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"6", ",", "10"}], "}"}], ",", 
        RowBox[{"ErrorBar", "[", 
         RowBox[{"0.5", ",", " ", "1.2"}], "]"}]}], "}"}]}], "}"}], ",", " ", 
    
    RowBox[{"AxesOrigin", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}]}]}], "]"}], " "}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1635679686],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwbAHifAkGIPs/kAXG
zP///2dgrq/dZW87q7fnMAMLkM80f96ZFSBxBmZ725kgYgZQFsRkBfPb2/b/
BwOGZRBVYDOmTjkW6L94+7Yb6GaAZYHi7W0HQEyw7OfPPyGyTCCS9fCh+9VV
O5OT1i5dcv7nzz8MaxFyLOfPPZ0z+/SE/iOrV11aBxZXBYtfvfLi9KnHQFmg
Wd1gcRWwWW/ffs3P2+zjvTAtdR3INRA5NbArgBJADSAmtUTBbmEGOhsYMlUV
Oxh6kETDQ5cBRV0cZ6OInjzxyNtrwczpJ6CitHLZyBOFxD8w/QCjIzxsGTCZ
AqWxyHV1HgSmKITcFjDpDlYBTLbAOAMib8/5wITFkAGW8wDbB9QBtBLEzCQo
2tN1EGgIKEchiwb6LwKKujrPQRFdvvQ8MEWA0io+c/G5bwsNyEykEAMG5cwZ
J4G5lMENLJcFzoHADAkPZoh4Nlq84BPNQss57kiiiJyDLIrIOe5YzZUDu/j2
rTfAQAKGPLQsUcajFsiZPOmYt+cCoA5QaGJXKw/mP3/+CegsEFMFNXyApR4k
SoBG4VDbOwCiM6afgKZAZNGQoCXQFIgsumP7TaAQKAUOnHuJE+2BxTEk3lDi
uAcWp8Dc3dK8DyVOKckJ62GpHRiYQGuBwcSIJA7kAisuYPUFzB4Q8Q1glwOr
O6AUiDn8ReeDRYFhAwxwEJMPj6rgwCV799wGlb68IAJSUs5KSVrDwATiQ1X5
eC3IzNgAzIMMvCCC2dV5LlCVg91MBiYQH6oKqARY3YOYvLASApgbuzoOQNoO
OFzLwAgAKg1pWg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 111},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->422135633]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->20994],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ErrorListPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ErrorBarPlots/ref/ErrorListPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ErrorBarFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ErrorBarPlots/ref/ErrorBarFunction"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->18286]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ErrorBar - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 57, 33.5204624}", "context" -> 
    "ErrorBarPlots`", "keywords" -> {}, "index" -> True, "label" -> 
    "Error Bar Plots Package Symbol", "language" -> "en", "paclet" -> 
    "ErrorBarPlots Package", "status" -> "None", "summary" -> 
    "ErrorBar[{ negerror, poserror }] error in the positive and negative \
directions. ErrorBar[yerr] error yerr in both the positive and negative \
directions ErrorBar[xerr, yerr] errors specified for both the x and the y \
coordinates", "synonyms" -> {}, "title" -> "ErrorBar", "type" -> "Symbol", 
    "uri" -> "ErrorBarPlots/ref/ErrorBar"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3769, 133, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->59724156]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 9228, 305}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 752, 18, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1375, 45, 46, 1, 70, "ObjectName",
 CellID->30502],
Cell[1424, 48, 1079, 32, 70, "Usage",
 CellID->17713]
}, Open  ]],
Cell[CellGroupData[{
Cell[2540, 85, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3018, 102, 315, 9, 70, "Notes",
 CellID->31707],
Cell[3336, 113, 291, 10, 70, "Notes",
 CellID->28271],
Cell[3630, 125, 102, 3, 70, "Notes",
 CellID->10281]
}, Closed]],
Cell[CellGroupData[{
Cell[3769, 133, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->59724156],
Cell[CellGroupData[{
Cell[4153, 147, 148, 5, 70, "ExampleSection",
 CellID->126041411],
Cell[4304, 154, 137, 4, 70, "Input",
 CellID->72157237],
Cell[4444, 160, 143, 5, 70, "ExampleText",
 CellID->477905686],
Cell[CellGroupData[{
Cell[4612, 169, 1448, 46, 65, "Input",
 CellID->1635679686],
Cell[6063, 217, 1083, 22, 132, "Output",
 Evaluatable->False,
 CellID->422135633]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7207, 246, 311, 9, 70, "SeeAlsoSection",
 CellID->20994],
Cell[7521, 257, 505, 17, 70, "SeeAlso",
 CellID->18286]
}, Open  ]],
Cell[8041, 277, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

