(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13480,        447]
NotebookOptionsPosition[     10761,        357]
NotebookOutlinePosition[     12069,        394]
CellTagsIndexPosition[     11984,        389]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["ERROR BAR PLOTS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[
    Cell[BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"ErrorListPlot" :> 
         Documentation`HelpLookup[
          "paclet:ErrorBarPlots/ref/ErrorListPlot"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"ErrorListPlot\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ErrorBarFunction", "ObjectName",
 CellID->5814],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["ErrorBarFunction"], "InlineFormula"],
     " \[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["ErrorListPlot",
       BaseStyle->"Link",
       ButtonData->"paclet:ErrorBarPlots/ref/ErrorListPlot"]], 
      "InlineFormula"],
     " that specifies a function to apply to determine the shape of error \
bars. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->11331]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"ErrorBarFunction", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " generates default error bars."
}], "Notes",
 CellID->26737],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"ErrorBarFunction", "->", 
   StyleBox["f", "TI"]}]], "InlineFormula"],
 " specifies that the function ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " of two arguments is used to generate the error bar."
}], "Notes",
 CellID->10780],

Cell[TextData[{
 "With setting ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 ", the first argument supplied to ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula",
  ShowStringCharacters->False],
 " is the point around which the error bars are drawn."
}], "Notes",
 CellID->31849],

Cell[TextData[{
 "With setting ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 ", the second argument supplied to ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " is an ",
 Cell[BoxData[
  ButtonBox["ErrorBar",
   BaseStyle->"Link",
   ButtonData->"paclet:ErrorBarPlots/ref/ErrorBar"]], "InlineFormula"],
 " object indicating the ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " errors."
}], "Notes",
 CellID->4548]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->61393031],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->64790239],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<ErrorBarPlots`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->38369215],

Cell["Error bars display as intersecting lines by default:", "ExampleText",
 CellID->1915373806],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ErrorListPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], ",", 
       RowBox[{"ErrorBar", "[", 
        RowBox[{"0.2", ",", "0.3"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "2"}], "}"}], ",", 
       RowBox[{"ErrorBar", "[", 
        RowBox[{"0.2", ",", "0.3"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "4"}], "}"}], ",", 
       RowBox[{"ErrorBar", "[", 
        RowBox[{"0.2", ",", "0.5"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"4", ",", "8"}], "}"}], ",", 
       RowBox[{"ErrorBar", "[", 
        RowBox[{"1", ",", "2"}], "]"}]}], "}"}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"ErrorBarFunction", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1717468021],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWEtIVGEUvnrvHacWadrCFoZLt6WLIEPJUlODHpTLmKSaMcoaXYS16YFC
2KY2PcTGUkMTEpI0sIdK0ouEKKiEQiNskQhJCyGYzvn//86999zXjDMIheL8
9z//Oee75/2P7go0BQ8fDzSF6gL5FeHAyWCorjG/vCEMR3KaJEmD8DmbK8E+
Cjv2GYxG4Wld82CVQSAdKdywU6Dhsxb2CuHhFnlZNjyjHh7JDnqUp+nl4F6N
yWsceKZrGtIGgukjdCbBVfCp6HxugVEigyCspVZbELKJhEroLELLFoT0uHzx
xqG2UoTkfVkj8myNY3w+JG8BZhTzr1o0swTHb2OzMcNWTXvbFYG3LmGbZaGZ
k3DGtHdmO3rpbKulVkx61oxlWk5orKn98XlO8+3mR57gZ4inJu8jtMbX5oWP
0Bqf2qPFk08L46SjVdLrcorW98dQqAydh5Y5t8L/p/iUZrVryXouodcnybft
NU8r3Ko20VPskz4XGTbL1cm33xtOPAAerLAXPH5rIi1JuNrjcHp87KugOwy6
3V2TIHi5bVxaxeiSrddNUtjJChyilavhGTHovnwxA6dDDz866NrbMfX5p0mK
+7e4+CfmBuxNvn94/yPmO+yTjig93YSLsrCwCO9+/eobvKLRWU4Ff+tDA5UV
HWDN3NxvKczjpM16g3who2dnf9Xu78EtR+Vi2rVIdQoYDbZcvTKhx0zH8BN+
kMF49VqBhrJ39x0Msx8X+fy5EUhZ8+lhQT8emdq3p0tHtetYJDnazMx8ZTkG
QfLjIm8vawe00pIbgg4FB2qqIu5oVhshoqCoezo89GlHWTvWmJ/wgyKAltvW
OwP8QmE/9O7lOYZwQHyrd0ZudbyBWIsc29cD1DNIQQdBK2Hl2ssuvTqXc9Ys
12kIFwXyAoEeG/0CHVdssrGeRfZe37u6Q/011Z1nmh9hZLfYYjFZmc9H3Ban
XMqruw4yGiycnp6PxipXR/ET/sYEUClK26VR6DKc15yGzmhteaajanMIgTgC
xBeaEpSkHFxgSl87euS+rmH5ju5pw93uyeqqiN6T1Aa3/uKIfNY6x0rneyMu
LWeprBpWzSrcr60tT2sP9IiZoVdrrKIVPitgtEBp22P93zMgle92qwkh4Xo3
xCPDri8F6htSBj0HWVMdtFCJS0MdQLXAL6hxadnGwk6MBtSCz+QLru6S2v9h
qKVmKRqxRLn4htspRVyxdbk9cesPIunaA3wGwkTjf0BIRQnr6vOziNHhU4Pi
DlNtLZW1eSlPPJ/eVnoTr63NsChLfuPFC09gMOON5dS/RoxjjIZvJ4IudIxr
r4lj/b+ulPYXpcMNhA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 124},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->598368275]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData["ErrorBarFunction"], "InlineFormula"],
 " can be used to show error regions as rectangles:"
}], "ExampleText",
 CellID->1732068111],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ErrorListPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], ",", 
       RowBox[{"ErrorBar", "[", 
        RowBox[{"0.2", ",", "0.3"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "2"}], "}"}], ",", 
       RowBox[{"ErrorBar", "[", 
        RowBox[{"0.2", ",", "0.3"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "4"}], "}"}], ",", 
       RowBox[{"ErrorBar", "[", 
        RowBox[{"0.2", ",", "0.5"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"4", ",", "8"}], "}"}], ",", 
       RowBox[{"ErrorBar", "[", 
        RowBox[{"1", ",", "2"}], "]"}]}], "}"}]}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"ErrorBarFunction", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"coords", ",", " ", "errs"}], "}"}], ",", " ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Opacity", "[", "0.2", "]"}], ",", 
        RowBox[{"Rectangle", "[", 
         RowBox[{
          RowBox[{"coords", "+", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"errs", "\[LeftDoubleBracket]", 
              RowBox[{"1", ",", "1"}], "\[RightDoubleBracket]"}], ",", 
             RowBox[{"errs", "\[LeftDoubleBracket]", 
              RowBox[{"2", ",", "1"}], "\[RightDoubleBracket]"}]}], "}"}]}], 
          ",", 
          RowBox[{"coords", "+", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"errs", "\[LeftDoubleBracket]", 
              RowBox[{"1", ",", "2"}], "\[RightDoubleBracket]"}], ",", 
             RowBox[{"errs", "\[LeftDoubleBracket]", 
              RowBox[{"2", ",", "2"}], "\[RightDoubleBracket]"}]}], "}"}]}]}],
          "]"}]}], "}"}]}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->907688912],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[{{1., 1.}, {2., 2.}, {3., 4.}, {4., 8.}, {1., 1.}, {2., 
   2.}, {3., 4.}, {4., 8.}}, {{}, 
    {Hue[0.67, 0.6, 0.6], PointBox[{5, 6, 7, 8}], {
      {Opacity[0.2], RectangleBox[{0.8, 0.7}, {1.2, 1.3}]}, 
      {Opacity[0.2], RectangleBox[{1.8, 1.7}, {2.2, 2.3}]}, 
      {Opacity[0.2], RectangleBox[{2.8, 3.5}, {3.2, 4.5}]}, 
      {Opacity[0.2], RectangleBox[{3, 6}, {5, 10}]}}}, {}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.618033988749895],
  Axes->True,
  PlotRange->{{1., 4.}, {0., 8.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 124},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->374914912]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->32195],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["ErrorListPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ErrorBarPlots/ref/ErrorListPlot"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->14491]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ErrorBarFunction - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 57, 33.3329576}", "context" -> 
    "ErrorBarPlots`", "keywords" -> {}, "index" -> True, "label" -> 
    "Error Bar Plots Package Symbol", "language" -> "en", "paclet" -> 
    "ErrorBarPlots Package", "status" -> "None", "summary" -> 
    "ErrorBarFunction is an option for ErrorListPlot that specifies a \
function to apply to determine the shape of error bars. ", "synonyms" -> {}, 
    "title" -> "ErrorBarFunction", "type" -> "Symbol", "uri" -> 
    "ErrorBarPlots/ref/ErrorBarFunction"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3768, 142, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->61393031]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11842, 382}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 601, 15, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1224, 42, 53, 1, 70, "ObjectName",
 CellID->5814],
Cell[1280, 45, 574, 17, 70, "Usage",
 CellID->11331]
}, Open  ]],
Cell[CellGroupData[{
Cell[1891, 67, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2369, 84, 241, 8, 70, "Notes",
 CellID->26737],
Cell[2613, 94, 288, 9, 70, "Notes",
 CellID->10780],
Cell[2904, 105, 301, 10, 70, "Notes",
 CellID->31849],
Cell[3208, 117, 523, 20, 70, "Notes",
 CellID->4548]
}, Closed]],
Cell[CellGroupData[{
Cell[3768, 142, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->61393031],
Cell[CellGroupData[{
Cell[4152, 156, 147, 5, 70, "ExampleSection",
 CellID->64790239],
Cell[4302, 163, 137, 4, 70, "Input",
 CellID->38369215],
Cell[4442, 169, 96, 1, 70, "ExampleText",
 CellID->1915373806],
Cell[CellGroupData[{
Cell[4563, 174, 1010, 32, 65, "Input",
 CellID->1717468021],
Cell[5576, 208, 1575, 30, 145, "Output",
 Evaluatable->False,
 CellID->598368275]
}, Open  ]],
Cell[7166, 241, 161, 4, 70, "ExampleText",
 CellID->1732068111],
Cell[CellGroupData[{
Cell[7352, 249, 1993, 57, 70, "Input",
 CellID->907688912],
Cell[9348, 308, 776, 20, 145, "Output",
 CellID->374914912]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10185, 335, 311, 9, 70, "SeeAlsoSection",
 CellID->32195],
Cell[10499, 346, 220, 6, 70, "SeeAlso",
 CellID->14491]
}, Open  ]],
Cell[10734, 355, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

