(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18688,        583]
NotebookOptionsPosition[     15597,        485]
NotebookOutlinePosition[     17118,        525]
CellTagsIndexPosition[     17033,        520]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["ERROR BAR PLOTS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[
    Cell[BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"ListPlot" :> Documentation`HelpLookup["paclet:ref/ListPlot"], 
         "ErrorBarFunction" :> 
         Documentation`HelpLookup[
          "paclet:ErrorBarPlots/ref/ErrorBarFunction"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"ListPlot\"\>", 
      2->"\<\"ErrorBarFunction\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ErrorListPlot", "ObjectName",
 CellID->15420],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ErrorListPlot", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["y", "TI"], 
            StyleBox["1", "TR"]], ",", 
           SubscriptBox[
            StyleBox["dy", "TI"], 
            StyleBox["1", "TR"]]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["y", "TI"], 
            StyleBox["2", "TR"]], ",", 
           SubscriptBox[
            StyleBox["dy", "TI"], 
            StyleBox["2", "TR"]]}], "}"}], ",", 
         StyleBox["\[Ellipsis]", "TI"]}], "}"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]plots points corresponding to a list of values ",
     Cell[BoxData[
      RowBox[{
       SubscriptBox[
        StyleBox["y", "TI"], 
        StyleBox["1", "TR"]], ",", " ", 
       SubscriptBox[
        StyleBox["y", "TI"], 
        StyleBox["2", "TR"]], ",", " ", 
       StyleBox["\[Ellipsis]", "TR"]}]], "InlineFormula"],
     ", with corresponding error bars. The errors have magnitudes ",
     Cell[BoxData[
      RowBox[{
       SubscriptBox[
        StyleBox["dy", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["dy", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ErrorListPlot", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             SubscriptBox[
              StyleBox["x", "TI"], 
              StyleBox["1", "TR"]], ",", 
             SubscriptBox[
              StyleBox["y", "TI"], 
              StyleBox["1", "TR"]]}], "}"}], ",", 
           RowBox[{
            ButtonBox["ErrorBar",
             BaseStyle->"Link",
             ButtonData->"paclet:ErrorBarPlots/ref/ErrorBar"], "[", 
            SubscriptBox[
             StyleBox["err", "TI"], "1"], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             SubscriptBox[
              StyleBox["x", "TI"], 
              StyleBox["2", "TR"]], ",", 
             SubscriptBox[
              StyleBox["y", "TI"], 
              StyleBox["2", "TR"]]}], "}"}], ",", 
           RowBox[{
            ButtonBox["ErrorBar",
             BaseStyle->"Link",
             ButtonData->"paclet:ErrorBarPlots/ref/ErrorBar"], "[", 
            SubscriptBox[
             StyleBox["err", "TI"], 
             StyleBox["2", "TR"]], "]"}]}], "}"}], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]plots points with specified ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     " coordinates and error magnitudes."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->23054]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["ErrorListPlot"], "InlineFormula"],
 " takes the same options as ",
 Cell[BoxData[
  ButtonBox["ListPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListPlot"]], "InlineFormula"],
 ", with the following addition:"
}], "Notes",
 CellID->913145359],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ErrorBarFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ErrorBarPlots/ref/ErrorBarFunction"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "how to render errors", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->1666570751]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->225917960],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->130759858],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<ErrorBarPlots`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->47058797],

Cell["Plot data with associated errors:", "ExampleText",
 CellID->166862003],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ErrorListPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"i", ",", 
      RowBox[{"RandomReal", "[", "0.5", "]"}]}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"i", ",", " ", "10"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->317614506],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzFWFtIVFEUPc6dqejxVR+RWkF9lX3lZw9TK7IsLMugwsZHaKSZDyjLHlQa
pRSVmGZmpWlqUfis7KVpmpIlBT0+QiP0IyjySwhsnXPude7j3Jk7Y9Aw3nse
a++z9157n3OcSGdmUmKKMzM53jl/bbozLSk5PmP+mv3pGJL8CCEN+MueTdAe
Q4v9NYyN4W18LsLTDsBc2pMokn1IIB42eZy+A/Cm0za5LzHpxSopItBCpYjd
1SeWRuga1A0/+mZDQTq9/rLVgf9I/xKd/jkivzQ6lPgYLfCs3V8VW8miF0at
i0xtmucDC0b9i020KRmhrBagyghXZqhzbIZOQ4XXo1PxrJatNGIcE+wHCjx0
Nz/R9SShF2WWUJ5iRxmonHDUp7N+ZUXfyuXFBfntpFCjn806Bgd/hYZcBSBk
RcmN673kslDTNIYdGRnNymiMjCjft/fBu7dDJljv88J3jykntADswtlJqlEi
QAXo4nOa4SYLGKRdfxaD4eHfQPNvUeErcorJTNHJ2HR9fyV+p04+jdp089DB
lr433y3KujzV1rq5zzSW+mz1PdLsdHCMjv6J2nSL+33pYifJFGL5HpmX+7y5
6SNtilFBrriXpKXWkyyNbVxHzNbbmA1bVaKaNero7hqEVWfPPDdBeWGPvbam
Pz7u7uHsh+1tXz3gkCzFV7o1ON/yV5Rr3qOWMbsuXugAN9kHW4aGfieM54xS
HRTOcWGhpZTGFSUnjre6cOo60ecOlys417YlqiIzvRGxTLCQa+5nrXmuRDaS
WTAw8LPn9bfOjoEvn39EC6O6geHAzfaYqphtt0G8GEf12a6X9W71cZZI6Qca
5F0jWmPpRja7fl05ZleHlRLz9YmEzQBGIpxuUL5aySOBFN2fWo8vFtHaySOK
YRQzvEBS8/MAjeSk+7tja1EIqHkSJtS+k0kj0YqLurIymj68Hw4X4naxPlYB
E7QZ7jYzxGjPOx+XO5bzCDsGZcSdHBXj+I0bbgBPOfJuncLLndhzKGsuOcmy
N5N0KPEaeqnJcsSsoRWO2awDU3zb3rXjjjmj4l1qn8IzjqsnrV/wDDbHOWBH
fFzd+ohy5A7OOrJUiE1h/fyzL+T6CdbYnMpmcUbK9SNej+uoquzDYpQJd1ah
BvJyn6HQcOBQ/8VWcU/hYOnVngvnX6IMxDq1+1IOW4FLHc15jGpErMgCoeQR
hsU8Kg77g2yNGMv0SsDiGKTNheO5I6obMdpzPnO5K0VdMhPu5CTFWyl6c4XM
jRWrWpo/AUo58s4qX72xGjPOBg4SEzb07GKvBrs0q8WM+XbrVY/mK/nBj5Y9
iffoajM1FhUwTE11//idvb9/SIUx6LNDB8rEGVuLnXrWP7Tc032H06N8lN8b
xHcBm4Fb/R1YfCf2Xq5UYXT8Dk/v4ZIX2mj3GhtnN1RWB/b/Zo0g7pIr7sr/
8nVsyPirEfH7CwZY/Co=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 122},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->200895797]
}, Open  ]],

Cell["Plot data with error bars:", "ExampleText",
 CellID->791141009],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ErrorListPlot", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], ",", 
       RowBox[{"ErrorBar", "[", "0.2", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "2"}], "}"}], ",", 
       RowBox[{"ErrorBar", "[", "0.1", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"3", ",", "4"}], "}"}], ",", 
       RowBox[{"ErrorBar", "[", "0.3", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"4", ",", "6"}], "}"}], ",", 
       RowBox[{"ErrorBar", "[", "0.4", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"5", ",", "7"}], "}"}], ",", 
       RowBox[{"ErrorBar", "[", "0.8", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"6", ",", "10"}], "}"}], ",", 
       RowBox[{"ErrorBar", "[", "0.5", "]"}]}], "}"}]}], "}"}], "]"}], 
  " "}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1415817212],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVVs9rFDEUTiezFqreBVtd6r9hbXG1KuJRVw8K61ppUbe19qpWrPaiFz1o
VVoP2y6ICLKLXsSfWFoVe1EQBaGK1IMg2FNBGL+XZDrZTGZ2t62LDjMveZnv
vZfkvbyXPZmB7q4TmYGebCa5oz/T192TPZXs7O3HEG9gjJXw9a5j6Hvoia/k
eWjXEuXEi4flxegaou7M22/4Abqw8Fsb5+P5GYxfvvSCNYN30aeWlCQNbevV
+Ea0DlpX05LeO8Hk06JJMYXWtbQY/AaLFeYGPGNcNKuJJjD5wjhNeOTa1Pz8
QlXaXMss4q3Mzv7szRVpl3NF2jebVtoBfZxF7JjNiuknU3+zZc98e37LFz1g
agtbNVffbJm/bR7BbB3lWb+1xYf/348P+1rzyx4Vu+M+fPDh6pVJvOgMxeMO
pAvtbSN9uaLENYHeEbFqSjRV4B2hceT6NIZ2do4eP3bfrVFDJZ4b/N/W71h3
bksFvnVJPqSYGF+S5PJH62O7ViubiSSQx8ZG3yADg87N/WLZGCz+A4VoBv30
8YfCNlbwsvQfpBRfnVSb4FEfIEj14YiQSngyo1JkEliikP+B2p66paH0zJiw
6p6e+gIpnFAltUrtoYm2zz8KLXfq/bvvyN5bO26Col/lmqUsqgzS/uTLWVku
Izzyr0fXSts+RJyL2vj61Ve86KSsUgcFDhGzP13Ai44dR/ocxPG2WG+Wo8Tf
stpmZkgxS95/sqSiNhUjx/1V8d27bqv4jcOH7Qydf5zeN0ERHMjxmFWI+4o6
xecGH6lT3Lq4A3G5v1yHzBoyE1DWkDoaPe1uFvIJXDZ84QleGJW1PjhT9pwu
5VDxjnbdyx6+O3zxabQc2R2sSuvZuqPOeOW5bFMMKshlAYrWJi0FOcuuo/5r
i0bVxyNRJ/c0EXWX7mi/oe7SUqby+ZLSMhM/f/YZlO771UrnQzOjn/mapJdi
5X/K5/WpWGOemUHsd85RgdMzlB1H+igLcs0l/uNEeKJcxgn51THwJr8S8npN
cmrQw/091GpULfLheQQ1azl6NB/wwAdceaBQhiiFKGv4Azx4OSg=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 111},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->374109326]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ErrorListPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ErrorBarPlots/ref/ErrorBar"]], "InlineFormula"],
 " takes the same options as ",
 Cell[BoxData[
  ButtonBox["ListPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListPlot"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->15351678],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ErrorListPlot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}], ",", 
        RowBox[{"ErrorBar", "[", "0.2", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2", ",", "2"}], "}"}], ",", 
        RowBox[{"ErrorBar", "[", "0.1", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"3", ",", "4"}], "}"}], ",", 
        RowBox[{"ErrorBar", "[", "0.3", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"4", ",", "6"}], "}"}], ",", 
        RowBox[{"ErrorBar", "[", "0.4", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"5", ",", "7"}], "}"}], ",", 
        RowBox[{"ErrorBar", "[", "0.8", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"6", ",", "10"}], "}"}], ",", 
        RowBox[{"ErrorBar", "[", "0.5", "]"}]}], "}"}]}], "}"}], ",", " ", 
    RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}], " "}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1635679686],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[{{1., 1.}, {2., 2.}, {3., 4.}, {4., 6.}, {5., 7.}, {6., 
   10.}}, {{}, {}, 
    {Hue[0.67, 0.6, 0.6], 
     LineBox[{1, 2, 3, 4, 5, 
      6}], {{LineBox[{{1., 1.2}, {1., 0.8}}], 
       LineBox[{Offset[{1.5, 0}, {1., 1.2}], Offset[{-1.5, 0}, {1., 1.2}]}], 
       LineBox[{
        Offset[{1.5, 0}, {1., 0.8}], Offset[{-1.5, 0}, {1., 0.8}]}]}, {
       LineBox[{{2., 2.1}, {2., 1.9}}], 
       LineBox[{Offset[{1.5, 0}, {2., 2.1}], Offset[{-1.5, 0}, {2., 2.1}]}], 
       LineBox[{
        Offset[{1.5, 0}, {2., 1.9}], Offset[{-1.5, 0}, {2., 1.9}]}]}, {
       LineBox[{{3., 4.3}, {3., 3.7}}], 
       LineBox[{Offset[{1.5, 0}, {3., 4.3}], Offset[{-1.5, 0}, {3., 4.3}]}], 
       LineBox[{
        Offset[{1.5, 0}, {3., 3.7}], Offset[{-1.5, 0}, {3., 3.7}]}]}, {
       LineBox[{{4., 6.4}, {4., 5.6}}], 
       LineBox[{Offset[{1.5, 0}, {4., 6.4}], Offset[{-1.5, 0}, {4., 6.4}]}], 
       LineBox[{
        Offset[{1.5, 0}, {4., 5.6}], Offset[{-1.5, 0}, {4., 5.6}]}]}, {
       LineBox[{{5., 7.8}, {5., 6.2}}], 
       LineBox[{Offset[{1.5, 0}, {5., 7.8}], Offset[{-1.5, 0}, {5., 7.8}]}], 
       LineBox[{
        Offset[{1.5, 0}, {5., 6.2}], Offset[{-1.5, 0}, {5., 6.2}]}]}, {
       LineBox[{{6., 10.5}, {6., 9.5}}], 
       LineBox[{Offset[{1.5, 0}, {6., 10.5}], Offset[{-1.5, 0}, {6., 10.5}]}],
        LineBox[{
        Offset[{1.5, 0}, {6., 9.5}], Offset[{-1.5, 0}, {6., 9.5}]}]}}}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.618033988749895],
  Axes->True,
  PlotRange->{{1., 6.}, {1., 10.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 111},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->930317355]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1789],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ListPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ErrorBarFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ErrorBarPlots/ref/ErrorBarFunction"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->18801]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ErrorListPlot - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 57, 33.7235926}", "context" -> 
    "ErrorBarPlots`", "keywords" -> {}, "index" -> True, "label" -> 
    "Error Bar Plots Package Symbol", "language" -> "en", "paclet" -> 
    "ErrorBarPlots Package", "status" -> "None", "summary" -> 
    "ErrorListPlot[{{y_1, dy_1}, {y_2, dy_2}, ...}] plots points \
corresponding to a list of values y_1, y_2, ..., with corresponding error \
bars. The errors have magnitudes dy_1, dy_2, .... ErrorListPlot[{{{x_1, y_1}, \
ErrorBar[err_1]}, {{x_2, y_2}, ErrorBar[err_2]}, ...}] plots points with \
specified x and y coordinates and error magnitudes.", "synonyms" -> {}, 
    "title" -> "ErrorListPlot", "type" -> "Symbol", "uri" -> 
    "ErrorBarPlots/ref/ErrorListPlot"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5953, 197, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->225917960]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 16890, 513}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 713, 17, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1336, 44, 51, 1, 70, "ObjectName",
 CellID->15420],
Cell[1390, 47, 3173, 97, 70, "Usage",
 CellID->23054]
}, Open  ]],
Cell[CellGroupData[{
Cell[4600, 149, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5078, 166, 283, 9, 70, "Notes",
 CellID->913145359],
Cell[5364, 177, 552, 15, 70, "3ColumnTableMod",
 CellID->1666570751]
}, Closed]],
Cell[CellGroupData[{
Cell[5953, 197, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->225917960],
Cell[CellGroupData[{
Cell[6338, 211, 148, 5, 70, "ExampleSection",
 CellID->130759858],
Cell[6489, 218, 137, 4, 70, "Input",
 CellID->47058797],
Cell[6629, 224, 76, 1, 70, "ExampleText",
 CellID->166862003],
Cell[CellGroupData[{
Cell[6730, 229, 321, 10, 28, "Input",
 CellID->317614506],
Cell[7054, 241, 1697, 32, 143, "Output",
 Evaluatable->False,
 CellID->200895797]
}, Open  ]],
Cell[8766, 276, 69, 1, 70, "ExampleText",
 CellID->791141009],
Cell[CellGroupData[{
Cell[8860, 281, 1133, 37, 65, "Input",
 CellID->1415817212],
Cell[9996, 320, 1302, 25, 132, "Output",
 Evaluatable->False,
 CellID->374109326]
}, Open  ]],
Cell[11313, 348, 347, 12, 70, "ExampleText",
 CellID->15351678],
Cell[CellGroupData[{
Cell[11685, 364, 1230, 38, 70, "Input",
 CellID->1635679686],
Cell[12918, 404, 1782, 41, 132, "Output",
 CellID->930317355]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14761, 452, 310, 9, 70, "SeeAlsoSection",
 CellID->1789],
Cell[15074, 463, 481, 17, 70, "SeeAlso",
 CellID->18801]
}, Open  ]],
Cell[15570, 483, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

