(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      5686,        208]
NotebookOptionsPosition[      4002,        156]
NotebookOutlinePosition[      5092,        185]
CellTagsIndexPosition[      5049,        182]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["EXPERIMENTAL PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Trace" :> Documentation`HelpLookup["paclet:ref/Trace"]}, #, 
        2]& , Evaluator -> Automatic], {
      1->"\<\"Trace\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ValueFunction", "ObjectName",
 CellID->4006],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ValueFunction", "[", 
       StyleBox["symb", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a function to be applied whenever the symbol \
",
     Cell[BoxData[
      StyleBox["symb", "TI"]], "InlineFormula"],
     " gets a new value.  "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->4931]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The assignment ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"ValueFunction", "[", 
    StyleBox["symb", "TI"], "]"}], "=", 
   StyleBox["f", "TI"]}]], "InlineFormula"],
 " specifies that whenever ",
 Cell[BoxData[
  StyleBox["symb", "TI"]], "InlineFormula"],
 " gets a new value ",
 Cell[BoxData[
  StyleBox["val", "TI"]], "InlineFormula"],
 ", the expression ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "[", 
   RowBox[{
    StyleBox["symb", "TI"], ",", 
    StyleBox["val", "TI"]}], "]"}]], "InlineFormula"],
 " should be evaluated. "
}], "Notes",
 CellID->22197],

Cell[TextData[{
 "If the value of ",
 Cell[BoxData[
  StyleBox["symb", "TI"]], "InlineFormula"],
 " is cleared, ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "[", 
   StyleBox["symb", "TI"], "]"}]], "InlineFormula"],
 " is evaluated. "
}], "Notes",
 CellID->27505],

Cell[TextData[{
 Cell[BoxData["ValueFunction"], "InlineFormula"],
 " takes account of all ways that the value of a symbol can be changed, not \
just ",
 Cell[BoxData[
  ButtonBox["Set",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Set"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->29236]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->21447],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["Trace",
   BaseStyle->"FunctionLink",
   ButtonData->"paclet:ref/Trace"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->1084]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ValueFunction - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 57, 39.1768572}", "context" -> 
    "Experimental`", "keywords" -> {"ValueFunction"}, "index" -> True, 
    "label" -> "Experimental Package Symbol", "language" -> "en", "paclet" -> 
    "Experimental Package", "status" -> "None", "summary" -> 
    "ValueFunction[symb] represents a function to be applied whenever the \
symbol symb gets a new value. ", "synonyms" -> {}, "title" -> "ValueFunction",
     "type" -> "Symbol", "uri" -> "Experimental/ref/ValueFunction"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 547, 14, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1170, 41, 50, 1, 70, "ObjectName",
 CellID->4006],
Cell[1223, 44, 515, 16, 70, "Usage",
 CellID->4931]
}, Open  ]],
Cell[CellGroupData[{
Cell[1775, 65, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2253, 82, 587, 22, 70, "Notes",
 CellID->22197],
Cell[2843, 106, 271, 11, 70, "Notes",
 CellID->27505],
Cell[3117, 119, 295, 10, 70, "Notes",
 CellID->29236]
}, Closed]],
Cell[CellGroupData[{
Cell[3449, 134, 311, 9, 70, "SeeAlsoSection",
 CellID->21447],
Cell[3763, 145, 197, 6, 70, "SeeAlso",
 CellID->1084]
}, Open  ]],
Cell[3975, 154, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

