(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6231,        206]
NotebookOptionsPosition[      4594,        157]
NotebookOutlinePosition[      5774,        188]
CellTagsIndexPosition[      5731,        185]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["FINITE FIELDS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Finite Fields Package" :> 
          Documentation`HelpLookup[
           "paclet:FiniteFields/tutorial/FiniteFields"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Finite Fields Package\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"IrreduciblePolynomial" :> 
          Documentation`HelpLookup[
           "paclet:FiniteFields/ref/IrreduciblePolynomial"], 
          "PolynomialToElement" :> 
          Documentation`HelpLookup[
           "paclet:FiniteFields/ref/PolynomialToElement"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"IrreduciblePolynomial\"\>", 
       2->"\<\"PolynomialToElement\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ElementToPolynomial", "ObjectName",
 CellID->16105],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ElementToPolynomial", "[", 
       RowBox[{
        StyleBox["e", "TI"], ",", 
        StyleBox["s", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives a polynomial in the symbol ",
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"],
     " corresponding to the field element ",
     Cell[BoxData[
      StyleBox["e", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ElementToPolynomial", "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        StyleBox["s", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the irreducible polynomial in ",
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"],
     " of the field ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->24488]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->11701],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["IrreduciblePolynomial",
    BaseStyle->"Link",
    ButtonData->"paclet:FiniteFields/ref/IrreduciblePolynomial"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PolynomialToElement",
    BaseStyle->"Link",
    ButtonData->"paclet:FiniteFields/ref/PolynomialToElement"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->31316]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->16282],

Cell[TextData[ButtonBox["Finite Fields Package",
 BaseStyle->"Link",
 ButtonData->"paclet:FiniteFields/tutorial/FiniteFields"]], "Tutorials",
 CellID->12455]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ElementToPolynomial - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 57, 46.5989222}", "context" -> 
    "FiniteFields`", "keywords" -> {}, "index" -> True, "label" -> 
    "Finite Fields Package Symbol", "language" -> "en", "paclet" -> 
    "FiniteFields Package", "status" -> "None", "summary" -> 
    "ElementToPolynomial[e, s] gives a polynomial in the symbol s \
corresponding to the field element e. ElementToPolynomial[f, s] gives the \
irreducible polynomial in s of the field f.", "synonyms" -> {}, "title" -> 
    "ElementToPolynomial", "type" -> "Symbol", "uri" -> 
    "FiniteFields/ref/ElementToPolynomial"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1411, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2034, 63, 57, 1, 70, "ObjectName",
 CellID->16105],
Cell[2094, 66, 1071, 34, 70, "Usage",
 CellID->24488]
}, Open  ]],
Cell[CellGroupData[{
Cell[3202, 105, 311, 9, 70, "SeeAlsoSection",
 CellID->11701],
Cell[3516, 116, 525, 17, 70, "SeeAlso",
 CellID->31316]
}, Open  ]],
Cell[CellGroupData[{
Cell[4078, 138, 314, 9, 70, "TutorialsSection",
 CellID->16282],
Cell[4395, 149, 157, 3, 70, "Tutorials",
 CellID->12455]
}, Open  ]],
Cell[4567, 155, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

