(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7710,        275]
NotebookOptionsPosition[      5937,        217]
NotebookOutlinePosition[      6961,        246]
CellTagsIndexPosition[      6918,        243]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["FINITE FIELDS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Finite Fields Package" :> 
          Documentation`HelpLookup[
           "paclet:FiniteFields/tutorial/FiniteFields"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Finite Fields Package\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FieldExp" :> 
          Documentation`HelpLookup["paclet:FiniteFields/ref/FieldExp"], 
          "PowerList" :> 
          Documentation`HelpLookup["paclet:FiniteFields/ref/PowerList"], 
          "PowerListQ" :> 
          Documentation`HelpLookup["paclet:FiniteFields/ref/PowerListQ"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"FieldExp\"\>", 
       2->"\<\"PowerList\"\>", 3->"\<\"PowerListQ\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["FieldInd", "ObjectName",
 CellID->28520],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"FieldInd", "[", 
       StyleBox["e", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the value of the discrete logarithm of ",
     Cell[BoxData[
      StyleBox["e", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->6902]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 " a primitive element of the field associated with the element ",
 Cell[BoxData[
  StyleBox["e", "TI"]], "InlineFormula"],
 ", the value of the discrete logarithm of ",
 Cell[BoxData[
  StyleBox["e", "TI"]], "InlineFormula"],
 " is the integer ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " such that ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox[
    StyleBox["p", "TI"], 
    StyleBox["n", "TI"]], "==", 
   StyleBox["e", "TI"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->14962],

Cell[TextData[{
 Cell[BoxData["FieldInd"], "InlineFormula"],
 " is defined only if ",
 Cell[BoxData[
  ButtonBox["PowerListQ",
   BaseStyle->"Link",
   ButtonData->"paclet:FiniteFields/ref/PowerListQ"]], "InlineFormula"],
 " has been set ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " for the field."
}], "Notes",
 CellID->123],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"FieldInd", "[", "0", "]"}]], "InlineFormula"],
 " gives ",
 Cell[BoxData[
  RowBox[{"-", "\[Infinity]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->24596]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1264],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FieldExp",
    BaseStyle->"Link",
    ButtonData->"paclet:FiniteFields/ref/FieldExp"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PowerList",
    BaseStyle->"Link",
    ButtonData->"paclet:FiniteFields/ref/PowerList"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PowerListQ",
    BaseStyle->"Link",
    ButtonData->"paclet:FiniteFields/ref/PowerListQ"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->8260]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->3737],

Cell[TextData[ButtonBox["Finite Fields Package",
 BaseStyle->"Link",
 ButtonData->"paclet:FiniteFields/tutorial/FiniteFields"]], "Tutorials",
 CellID->13261]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FieldInd - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 57, 47.1458112}", "context" -> 
    "FiniteFields`", "keywords" -> {}, "index" -> True, "label" -> 
    "Finite Fields Package Symbol", "language" -> "en", "paclet" -> 
    "FiniteFields Package", "status" -> "None", "summary" -> 
    "FieldInd[e] gives the value of the discrete logarithm of e.", 
    "synonyms" -> {}, "title" -> "FieldInd", "type" -> "Symbol", "uri" -> 
    "FiniteFields/ref/FieldInd"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1446, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2069, 63, 46, 1, 70, "ObjectName",
 CellID->28520],
Cell[2118, 66, 473, 15, 70, "Usage",
 CellID->6902]
}, Open  ]],
Cell[CellGroupData[{
Cell[2628, 86, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3106, 103, 586, 22, 70, "Notes",
 CellID->14962],
Cell[3695, 127, 397, 14, 70, "Notes",
 CellID->123],
Cell[4095, 143, 200, 8, 70, "Notes",
 CellID->24596]
}, Closed]],
Cell[CellGroupData[{
Cell[4332, 156, 310, 9, 70, "SeeAlsoSection",
 CellID->1264],
Cell[4645, 167, 740, 26, 70, "SeeAlso",
 CellID->8260]
}, Open  ]],
Cell[CellGroupData[{
Cell[5422, 198, 313, 9, 70, "TutorialsSection",
 CellID->3737],
Cell[5738, 209, 157, 3, 70, "Tutorials",
 CellID->13261]
}, Open  ]],
Cell[5910, 215, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

