(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9147,        294]
NotebookOptionsPosition[      7137,        236]
NotebookOutlinePosition[      8529,        270]
CellTagsIndexPosition[      8486,        267]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["FINITE FIELDS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Finite Fields Package" :> 
          Documentation`HelpLookup[
           "paclet:FiniteFields/tutorial/FiniteFields"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Finite Fields Package\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Characteristic" :> 
          Documentation`HelpLookup["paclet:FiniteFields/ref/Characteristic"], 
          "ExtensionDegree" :> 
          Documentation`HelpLookup["paclet:FiniteFields/ref/ExtensionDegree"],
           "FieldIrreducible" :> 
          Documentation`HelpLookup[
           "paclet:FiniteFields/ref/FieldIrreducible"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Characteristic\"\>", 
       2->"\<\"ExtensionDegree\"\>", 
       3->"\<\"FieldIrreducible\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Finite Fields Package" :> 
          Documentation`HelpLookup[
           "paclet:FiniteFields/guide/FiniteFieldsPackage"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Finite Fields Package\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["GF", "ObjectName",
 CellID->20601],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"GF", "[", 
       RowBox[{
        StyleBox["p", "TI"], ",", 
        StyleBox["d", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the Galois field that is a degree ",
     Cell[BoxData[
      StyleBox["d", "TI"]], "InlineFormula"],
     " extension of the prime field of ",
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"],
     " elements."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"GF", "[", 
       StyleBox["q", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives, for ",
     Cell[BoxData[
      StyleBox["q", "TI"]], "InlineFormula"],
     " a prime power, the Galois field with ",
     Cell[BoxData[
      StyleBox["q", "TI"]], "InlineFormula"],
     " elements."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"GF", "[", 
       RowBox[{
        StyleBox["p", "TI"], ",", 
        StyleBox["ilist", "TI"]}], 
       StyleBox["]", "TI"]}]], "InlineFormula"],
     " \[LineSeparator]represents the Galois field with prime characteristic \
",
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"],
     " and irreducible polynomial whose coefficient list is given by ",
     Cell[BoxData[
      StyleBox["ilist", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       RowBox[{"GF", "[", 
        RowBox[{
         StyleBox["p", "TI"], ",", 
         StyleBox["ilist", "TI"]}], "]"}], "[", 
       StyleBox["elist", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]represents an element of the Galois field ",
     Cell[BoxData[
      RowBox[{"GF", "[", 
       RowBox[{
        StyleBox["p", "TI"], ",", 
        StyleBox["ilist", "TI"]}], "]"}]], "InlineFormula"],
     " whose polynomial representation has coefficient list ",
     Cell[BoxData[
      StyleBox["elist", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->6077]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->25824],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Characteristic",
    BaseStyle->"Link",
    ButtonData->"paclet:FiniteFields/ref/Characteristic"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ExtensionDegree",
    BaseStyle->"Link",
    ButtonData->"paclet:FiniteFields/ref/ExtensionDegree"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FieldIrreducible",
    BaseStyle->"Link",
    ButtonData->"paclet:FiniteFields/ref/FieldIrreducible"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->5601]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->20215],

Cell[TextData[ButtonBox["Finite Fields Package",
 BaseStyle->"Link",
 ButtonData->"paclet:FiniteFields/tutorial/FiniteFields"]], "Tutorials",
 CellID->8683]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->160912898],

Cell[TextData[ButtonBox["Finite Fields Package",
 BaseStyle->"Link",
 ButtonData->"paclet:FiniteFields/guide/FiniteFieldsPackage"]], "MoreAbout",
 CellID->219374247]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GF - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 57, 54.3803714}", "context" -> 
    "FiniteFields`", "keywords" -> {}, "index" -> True, "label" -> 
    "Finite Fields Package Symbol", "language" -> "en", "paclet" -> 
    "FiniteFields Package", "status" -> "None", "summary" -> 
    "GF[p, d] gives the Galois field that is a degree d extension of the \
prime field of p elements. GF[q] gives, for q a prime power, the Galois field \
with q elements. GF[p, ilist] represents the Galois field with prime \
characteristic p and irreducible polynomial whose coefficient list is given \
by ilist. GF[p, ilist][elist] represents an element of the Galois field GF[p, \
ilist] whose polynomial representation has coefficient list elist.", 
    "synonyms" -> {}, "title" -> "GF", "type" -> "Symbol", "uri" -> 
    "FiniteFields/ref/GF"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2120, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2743, 81, 40, 1, 70, "ObjectName",
 CellID->20601],
Cell[2786, 84, 2148, 67, 70, "Usage",
 CellID->6077]
}, Open  ]],
Cell[CellGroupData[{
Cell[4971, 156, 311, 9, 70, "SeeAlsoSection",
 CellID->25824],
Cell[5285, 167, 776, 26, 70, "SeeAlso",
 CellID->5601]
}, Open  ]],
Cell[CellGroupData[{
Cell[6098, 198, 314, 9, 70, "TutorialsSection",
 CellID->20215],
Cell[6415, 209, 156, 3, 70, "Tutorials",
 CellID->8683]
}, Open  ]],
Cell[CellGroupData[{
Cell[6608, 217, 319, 9, 70, "MoreAboutSection",
 CellID->160912898],
Cell[6930, 228, 165, 3, 70, "MoreAbout",
 CellID->219374247]
}, Open  ]],
Cell[7110, 234, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

