(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7432,        253]
NotebookOptionsPosition[      5653,        198]
NotebookOutlinePosition[      6787,        228]
CellTagsIndexPosition[      6744,        225]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["FINITE FIELDS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Finite Fields Package" :> 
          Documentation`HelpLookup[
           "paclet:FiniteFields/tutorial/FiniteFields"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Finite Fields Package\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GF" :> Documentation`HelpLookup["paclet:FiniteFields/ref/GF"], 
          "FieldIrreducible" :> 
          Documentation`HelpLookup[
           "paclet:FiniteFields/ref/FieldIrreducible"], "ElementToPolynomial" :> 
          Documentation`HelpLookup[
           "paclet:FiniteFields/ref/ElementToPolynomial"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"GF\"\>", 
       2->"\<\"FieldIrreducible\"\>", 
       3->"\<\"ElementToPolynomial\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["IrreduciblePolynomial", "ObjectName",
 CellID->17864],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"IrreduciblePolynomial", "[", 
       RowBox[{
        StyleBox["s", "TI"], ",", 
        StyleBox["p", "TI"], ",", 
        StyleBox["d", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives an irreducible polynomial in the symbol ",
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"],
     " of degree ",
     Cell[BoxData[
      StyleBox["d", "TI"]], "InlineFormula"],
     " over the integers modulo the prime ",
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->22913]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"IrreduciblePolynomial", "[", 
   RowBox[{
    StyleBox["s", "TI"], ",", 
    StyleBox["p", "TI"], ",", 
    StyleBox["d", "TI"]}], "]"}]], "InlineFormula"],
 " gives the default irreducible polynomial used to generate the Galois field \
",
 Cell[BoxData[
  RowBox[{
   ButtonBox["GF",
    BaseStyle->"Link",
    ButtonData->"paclet:FiniteFields/ref/GF"], "[", 
   RowBox[{
    StyleBox["p", "TI"], ",", 
    StyleBox["d", "TI"]}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->11075]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1769],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["GF",
    BaseStyle->"Link",
    ButtonData->"paclet:FiniteFields/ref/GF"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FieldIrreducible",
    BaseStyle->"Link",
    ButtonData->"paclet:FiniteFields/ref/FieldIrreducible"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ElementToPolynomial",
    BaseStyle->"Link",
    ButtonData->"paclet:FiniteFields/ref/ElementToPolynomial"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->15262]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->21545],

Cell[TextData[ButtonBox["Finite Fields Package",
 BaseStyle->"Link",
 ButtonData->"paclet:FiniteFields/tutorial/FiniteFields"]], "Tutorials",
 CellID->28712]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"IrreduciblePolynomial - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 57, 54.5678762}", "context" -> 
    "FiniteFields`", "keywords" -> {}, "index" -> True, "label" -> 
    "Finite Fields Package Symbol", "language" -> "en", "paclet" -> 
    "FiniteFields Package", "status" -> "None", "summary" -> 
    "IrreduciblePolynomial[s, p, d] gives an irreducible polynomial in the \
symbol s of degree d over the integers modulo the prime p.", "synonyms" -> {},
     "title" -> "IrreduciblePolynomial", "type" -> "Symbol", "uri" -> 
    "FiniteFields/ref/IrreduciblePolynomial"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1485, 37, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2108, 64, 59, 1, 70, "ObjectName",
 CellID->17864],
Cell[2170, 67, 772, 24, 70, "Usage",
 CellID->22913]
}, Open  ]],
Cell[CellGroupData[{
Cell[2979, 96, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3457, 113, 532, 19, 70, "Notes",
 CellID->11075]
}, Closed]],
Cell[CellGroupData[{
Cell[4026, 137, 310, 9, 70, "SeeAlsoSection",
 CellID->1769],
Cell[4339, 148, 761, 26, 70, "SeeAlso",
 CellID->15262]
}, Open  ]],
Cell[CellGroupData[{
Cell[5137, 179, 314, 9, 70, "TutorialsSection",
 CellID->21545],
Cell[5454, 190, 157, 3, 70, "Tutorials",
 CellID->28712]
}, Open  ]],
Cell[5626, 196, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

