(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6096,        207]
NotebookOptionsPosition[      4319,        152]
NotebookOutlinePosition[      5454,        182]
CellTagsIndexPosition[      5411,        179]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["FINITE FIELDS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Finite Fields Package" :> 
          Documentation`HelpLookup[
           "paclet:FiniteFields/tutorial/FiniteFields"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Finite Fields Package\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ElementToPolynomial" :> 
          Documentation`HelpLookup[
           "paclet:FiniteFields/ref/ElementToPolynomial"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"ElementToPolynomial\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["PolynomialToElement", "ObjectName",
 CellID->6705],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"PolynomialToElement", "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        StyleBox["poly", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives an element in the field ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " corresponding to the univariate polynomial ",
     Cell[BoxData[
      StyleBox["poly", "TI"]], "InlineFormula"],
     " with integer coefficients."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->20626]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The polynomial variable must be a symbol.", "Notes",
 CellID->29812]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14736],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["ElementToPolynomial",
   BaseStyle->"Link",
   ButtonData->"paclet:FiniteFields/ref/ElementToPolynomial"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->29141]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->19375],

Cell[TextData[ButtonBox["Finite Fields Package",
 BaseStyle->"Link",
 ButtonData->"paclet:FiniteFields/tutorial/FiniteFields"]], "Tutorials",
 CellID->30093]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PolynomialToElement - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 57, 54.8960096}", "context" -> 
    "FiniteFields`", "keywords" -> {}, "index" -> True, "label" -> 
    "Finite Fields Package Symbol", "language" -> "en", "paclet" -> 
    "FiniteFields Package", "status" -> "None", "summary" -> 
    "PolynomialToElement[f, poly] gives an element in the field f \
corresponding to the univariate polynomial poly with integer coefficients.", 
    "synonyms" -> {}, "title" -> "PolynomialToElement", "type" -> "Symbol", 
    "uri" -> "FiniteFields/ref/PolynomialToElement"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1239, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1862, 60, 56, 1, 70, "ObjectName",
 CellID->6705],
Cell[1921, 63, 674, 20, 70, "Usage",
 CellID->20626]
}, Open  ]],
Cell[CellGroupData[{
Cell[2632, 88, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3110, 105, 74, 1, 70, "Notes",
 CellID->29812]
}, Closed]],
Cell[CellGroupData[{
Cell[3221, 111, 311, 9, 70, "SeeAlsoSection",
 CellID->14736],
Cell[3535, 122, 231, 6, 70, "SeeAlso",
 CellID->29141]
}, Open  ]],
Cell[CellGroupData[{
Cell[3803, 133, 314, 9, 70, "TutorialsSection",
 CellID->19375],
Cell[4120, 144, 157, 3, 70, "Tutorials",
 CellID->30093]
}, Open  ]],
Cell[4292, 150, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

