(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8497,        297]
NotebookOptionsPosition[      6624,        238]
NotebookOutlinePosition[      7743,        268]
CellTagsIndexPosition[      7700,        265]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["FINITE FIELDS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Finite Fields Package" :> 
          Documentation`HelpLookup[
           "paclet:FiniteFields/tutorial/FiniteFields"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Finite Fields Package\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PowerList" :> 
          Documentation`HelpLookup["paclet:FiniteFields/ref/PowerList"], 
          "FieldExp" :> 
          Documentation`HelpLookup["paclet:FiniteFields/ref/FieldExp"], 
          "FieldInd" :> 
          Documentation`HelpLookup["paclet:FiniteFields/ref/FieldInd"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"PowerList\"\>", 
       2->"\<\"FieldExp\"\>", 3->"\<\"FieldInd\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["PowerListQ", "ObjectName",
 CellID->14700],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"PowerListQ", "[", 
       StyleBox["f", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if the list representing the powers of a primitive element of the \
field is used to do field arithmetic, and ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     " otherwise."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->13971]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["PowerListQ"], "InlineFormula"],
 " is returned unevaluated if ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " is not a field."
}], "Notes",
 CellID->26264],

Cell[TextData[{
 "Setting ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"PowerListQ", "[", 
    StyleBox["f", "TI"], "]"}], "=", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " computes the ",
 Cell[BoxData[
  ButtonBox["PowerList",
   BaseStyle->"Link",
   ButtonData->"paclet:FiniteFields/ref/PowerList"]], "InlineFormula"],
 " of ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " if it does not yet exist, and enables arithmetic based on ",
 Cell[BoxData[
  ButtonBox["FieldExp",
   BaseStyle->"Link",
   ButtonData->"paclet:FiniteFields/ref/FieldExp"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["FieldInd",
   BaseStyle->"Link",
   ButtonData->"paclet:FiniteFields/ref/FieldInd"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->15117],

Cell[TextData[{
 "Setting ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"PowerListQ", "[", 
    StyleBox["f", "TI"], "]"}], "=", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 " disables field arithmetic based on ",
 Cell[BoxData[
  ButtonBox["FieldExp",
   BaseStyle->"Link",
   ButtonData->"paclet:FiniteFields/ref/FieldExp"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["FieldInd",
   BaseStyle->"Link",
   ButtonData->"paclet:FiniteFields/ref/FieldInd"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->16215]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->30212],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PowerList",
    BaseStyle->"Link",
    ButtonData->"paclet:FiniteFields/ref/PowerList"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FieldExp",
    BaseStyle->"Link",
    ButtonData->"paclet:FiniteFields/ref/FieldExp"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FieldInd",
    BaseStyle->"Link",
    ButtonData->"paclet:FiniteFields/ref/FieldInd"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->29288]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->24555],

Cell[TextData[ButtonBox["Finite Fields Package",
 BaseStyle->"Link",
 ButtonData->"paclet:FiniteFields/tutorial/FiniteFields"]], "Tutorials",
 CellID->7815]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PowerListQ - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 57, 55.2085176}", "context" -> 
    "FiniteFields`", "keywords" -> {}, "index" -> True, "label" -> 
    "Finite Fields Package Symbol", "language" -> "en", "paclet" -> 
    "FiniteFields Package", "status" -> "None", "summary" -> 
    "PowerListQ[f] gives True if the list representing the powers of a \
primitive element of the field is used to do field arithmetic, and False \
otherwise.", "synonyms" -> {}, "title" -> "PowerListQ", "type" -> "Symbol", 
    "uri" -> "FiniteFields/ref/PowerListQ"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1440, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2063, 63, 48, 1, 70, "ObjectName",
 CellID->14700],
Cell[2114, 66, 758, 23, 70, "Usage",
 CellID->13971]
}, Open  ]],
Cell[CellGroupData[{
Cell[2909, 94, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3387, 111, 201, 7, 70, "Notes",
 CellID->26264],
Cell[3591, 120, 815, 29, 70, "Notes",
 CellID->15117],
Cell[4409, 151, 575, 21, 70, "Notes",
 CellID->16215]
}, Closed]],
Cell[CellGroupData[{
Cell[5021, 177, 311, 9, 70, "SeeAlsoSection",
 CellID->30212],
Cell[5335, 188, 737, 26, 70, "SeeAlso",
 CellID->29288]
}, Open  ]],
Cell[CellGroupData[{
Cell[6109, 219, 314, 9, 70, "TutorialsSection",
 CellID->24555],
Cell[6426, 230, 156, 3, 70, "Tutorials",
 CellID->7815]
}, Open  ]],
Cell[6597, 236, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

