(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10185,        365]
NotebookOptionsPosition[      8210,        301]
NotebookOutlinePosition[      9259,        330]
CellTagsIndexPosition[      9216,        327]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["FINITE FIELDS PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Finite Fields Package" :> 
          Documentation`HelpLookup[
           "paclet:FiniteFields/tutorial/FiniteFields"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Finite Fields Package\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FunctionOfCode" :> 
          Documentation`HelpLookup["paclet:FiniteFields/ref/FunctionOfCode"], 
          "FunctionOfCoefficients" :> 
          Documentation`HelpLookup[
           "paclet:FiniteFields/ref/FunctionOfCoefficients"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"FunctionOfCode\"\>", 
       2->"\<\"FunctionOfCoefficients\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SetFieldFormat", "ObjectName",
 CellID->20799],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SetFieldFormat", "[", 
       StyleBox["f", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]sets the output form of elements in the field ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->18352]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following option can be given:", "Notes",
 CellID->20448],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["FormatType",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FormatType"], "Subscripted", Cell[
    "specifies the output form", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->13882],

Cell[TextData[{
 "The default setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FormatType",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FormatType"], 
   RowBox[{"->", " ", "Subscripted"}]}]], "InlineFormula"],
 " sets the output form to be a subscripted vector."
}], "Notes",
 CellID->540],

Cell[TextData[{
 "The setting ",
 Cell[BoxData[
  ButtonBox["FullForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullForm"]], "InlineFormula"],
 " sets the output form to ",
 Cell[BoxData[
  ButtonBox["FullForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullForm"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->28315],

Cell[TextData[{
 "The setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FunctionOfCoefficients",
    BaseStyle->"Link",
    ButtonData->"paclet:FiniteFields/ref/FunctionOfCoefficients"], "[", 
   StyleBox["g", "TI"], "]"}]], "InlineFormula"],
 " sets the input form and output form for the element ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["GF",
     BaseStyle->"Link",
     ButtonData->"paclet:FiniteFields/ref/GF"], "[", 
    RowBox[{
     StyleBox["p", "TI"], ",", 
     StyleBox["ilist", "TI"]}], "]"}], "[", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["e", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["e", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
 " to be ",
 Cell[BoxData[
  RowBox[{
   StyleBox["g", "TI"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["e", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["e", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->4575],

Cell[TextData[{
 "The setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FunctionOfCode",
    BaseStyle->"Link",
    ButtonData->"paclet:FiniteFields/ref/FunctionOfCode"], "[", 
   StyleBox["g", "TI"], "]"}]], "InlineFormula"],
 " sets the input form and output form for the element ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["GF",
     BaseStyle->"Link",
     ButtonData->"paclet:FiniteFields/ref/GF"], "[", 
    RowBox[{
     StyleBox["p", "TI"], ",", 
     StyleBox["ilist", "TI"]}], "]"}], "[", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["e", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["e", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
 " to be ",
 Cell[BoxData[
  RowBox[{
   StyleBox["g", "TI"], "[", 
   StyleBox["i", "TI"], "]"}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  StyleBox["i", "TI"]], "InlineFormula"],
 " is the element code ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["e", "TI"], 
    StyleBox["1", "TR"]], "+", 
   RowBox[{
    SubscriptBox[
     StyleBox["e", "TI"], 
     StyleBox["2", "TR"]], 
    StyleBox["p", "TI"]}], "+", 
   RowBox[{
    SubscriptBox[
     StyleBox["e", "TI"], 
     StyleBox["3", "TR"]], " ", 
    SuperscriptBox[
     StyleBox["p", "TI"], "2"]}], "+", 
   StyleBox["\[Ellipsis]", "TR"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->8762]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->19897],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FunctionOfCode",
    BaseStyle->"Link",
    ButtonData->"paclet:FiniteFields/ref/FunctionOfCode"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FunctionOfCoefficients",
    BaseStyle->"Link",
    ButtonData->"paclet:FiniteFields/ref/FunctionOfCoefficients"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->25828]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->9567],

Cell[TextData[ButtonBox["Finite Fields Package",
 BaseStyle->"Link",
 ButtonData->"paclet:FiniteFields/tutorial/FiniteFields"]], "Tutorials",
 CellID->22336]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SetFieldFormat - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 57, 55.6772796}", "context" -> 
    "FiniteFields`", "keywords" -> {}, "index" -> True, "label" -> 
    "Finite Fields Package Symbol", "language" -> "en", "paclet" -> 
    "FiniteFields Package", "status" -> "None", "summary" -> 
    "SetFieldFormat[f] sets the output form of elements in the field f.", 
    "synonyms" -> {}, "title" -> "SetFieldFormat", "type" -> "Symbol", "uri" -> 
    "FiniteFields/ref/SetFieldFormat"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1387, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2010, 62, 52, 1, 70, "ObjectName",
 CellID->20799],
Cell[2065, 65, 481, 15, 70, "Usage",
 CellID->18352]
}, Open  ]],
Cell[CellGroupData[{
Cell[2583, 85, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3061, 102, 67, 1, 70, "Notes",
 CellID->20448],
Cell[3131, 105, 447, 12, 70, "3ColumnTableMod",
 CellID->13882],
Cell[3581, 119, 299, 10, 70, "Notes",
 CellID->540],
Cell[3883, 131, 334, 13, 70, "Notes",
 CellID->28315],
Cell[4220, 146, 1122, 41, 70, "Notes",
 CellID->4575],
Cell[5345, 189, 1445, 55, 70, "Notes",
 CellID->8762]
}, Closed]],
Cell[CellGroupData[{
Cell[6827, 249, 311, 9, 70, "SeeAlsoSection",
 CellID->19897],
Cell[7141, 260, 517, 17, 70, "SeeAlso",
 CellID->25828]
}, Open  ]],
Cell[CellGroupData[{
Cell[7695, 282, 313, 9, 70, "TutorialsSection",
 CellID->9567],
Cell[8011, 293, 157, 3, 70, "Tutorials",
 CellID->22336]
}, Open  ]],
Cell[8183, 299, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

