(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18927,        667]
NotebookOptionsPosition[     15521,        552]
NotebookOutlinePosition[     16873,        589]
CellTagsIndexPosition[     16788,        584]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["FOURIER SERIES PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Fourier Series Package" :> 
          Documentation`HelpLookup[
           "paclet:FourierSeries/tutorial/FourierSeries"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Fourier Series Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FourierSinCoefficient" :> 
          Documentation`HelpLookup[
           "paclet:FourierSeries/ref/FourierSinCoefficient"], 
          "FourierCosCoefficient" :> 
          Documentation`HelpLookup[
           "paclet:FourierSeries/ref/FourierCosCoefficient"], 
          "NFourierCoefficient" :> 
          Documentation`HelpLookup[
           "paclet:FourierSeries/ref/NFourierCoefficient"], 
          "NFourierSinCoefficient" :> 
          Documentation`HelpLookup[
           "paclet:FourierSeries/ref/NFourierSinCoefficient"], 
          "NFourierCosCoefficient" :> 
          Documentation`HelpLookup[
           "paclet:FourierSeries/ref/NFourierCosCoefficient"], 
          "InverseFourierCoefficient" :> 
          Documentation`HelpLookup[
           "paclet:FourierSeries/ref/InverseFourierCoefficient"], 
          "NInverseFourierCoefficient" :> 
          Documentation`HelpLookup[
           "paclet:FourierSeries/ref/NInverseFourierCoefficient"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"FourierSinCoefficient\"\>", 
       2->"\<\"FourierCosCoefficient\"\>", 3->"\<\"NFourierCoefficient\"\>", 
       4->"\<\"NFourierSinCoefficient\"\>", 
       5->"\<\"NFourierCosCoefficient\"\>", 
       6->"\<\"InverseFourierCoefficient\"\>", 
       7->"\<\"NInverseFourierCoefficient\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["FourierCoefficient", "ObjectName",
 CellID->6120],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"FourierCoefficient", "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["t", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the ",
     Cell[BoxData[
      SuperscriptBox[
       StyleBox["n", "TI"], "th"]], "InlineFormula"],
     " coefficient in the Fourier exponential series expansion of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ", where ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " is a periodic function of ",
     Cell[BoxData[
      StyleBox["t", "TI"]], "InlineFormula"],
     " with period ",
     Cell[BoxData[
      StyleBox["1", "TR"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->27393]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  SuperscriptBox[
   StyleBox["n", "TI"], "th"]], "InlineFormula"],
 " coefficient in the Fourier exponential series expansion of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " is by default defined to be ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Integrate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Integrate"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["expr", "TI"], " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"2", 
       StyleBox["\[Pi]", "TR"], " ", "\[ImaginaryI]", " ", 
       StyleBox["n", "TI"], " ", 
       StyleBox["t", "TI"]}]]}], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["t", "TI"], ",", 
      RowBox[{"-", 
       FractionBox["1", "2"]}], ",", 
      FractionBox["1", "2"]}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->6292],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " is numeric, it should be an explicit integer."
}], "Notes",
 CellID->14962],

Cell[TextData[{
 "Different choices for the definition of the Fourier exponential series \
expansion can be specified using the option ",
 Cell[BoxData[
  ButtonBox["FourierParameters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FourierParameters"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->14214],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FourierParameters",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FourierParameters"], "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"]}], "}"}]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " is assumed to have a period of ",
 Cell[BoxData[
  FractionBox["1", 
   RowBox[{"\[VerticalSeparator]", 
    StyleBox["b", "TI"], "\[VerticalSeparator]"}]]], "InlineFormula"],
 ", and the ",
 Cell[BoxData[
  SuperscriptBox[
   StyleBox["n", "TI"], "th"]], "InlineFormula"],
 " coefficient computed by ",
 Cell[BoxData["FourierCoefficient"], "InlineFormula"],
 " is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox[
     StyleBox[
      RowBox[{"\[LeftBracketingBar]", "b", "\[RightBracketingBar]"}], "TI"], 
     FractionBox[
      RowBox[{"1", "-", 
       StyleBox["a", "TI"]}], "2"]], " ", 
    RowBox[{
     ButtonBox["Integrate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Integrate"], "[", 
     RowBox[{
      RowBox[{
       StyleBox["expr", "TI"], " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", 
         StyleBox["\[Pi]", "TR"], " ", "\[ImaginaryI]", " ", 
         StyleBox["b", "TI"], " ", 
         StyleBox["n", "TI"], " ", 
         StyleBox["t", "TI"]}]]}], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["t", "TI"], ",", 
        RowBox[{"-", 
         FractionBox["1", 
          RowBox[{"2", "\[VerticalSeparator]", 
           StyleBox["b", "TI"], "\[VerticalSeparator]"}]]}], ",", 
        FractionBox["1", 
         RowBox[{"2", "\[VerticalSeparator]", 
          StyleBox["b", "TI"], "\[VerticalSeparator]"}]]}], "}"}]}], "]"}]}], 
   TraditionalForm]], "InlineFormula"],
 "."
}], "Notes",
 CellID->12527],

Cell[TextData[{
 "In addition to the option ",
 Cell[BoxData[
  ButtonBox["FourierParameters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FourierParameters"]], "InlineFormula"],
 ", ",
 Cell[BoxData["FourierCoefficient"], "InlineFormula"],
 " can also accept the options available to ",
 Cell[BoxData[
  ButtonBox["Integrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integrate"]], "InlineFormula"],
 ". These options are passed directly to ",
 Cell[BoxData[
  ButtonBox["Integrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integrate"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->26807]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->52764322],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->607868955],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<FourierSeries`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->32906638],

Cell["\<\
Use different definitions for calculating a coefficient in a Fourier series:\
\>", "ExampleText",
 CellID->320560372],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierCoefficient", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"t", "^", "2"}], "+", "t"}], ",", " ", "t", ",", " ", "n"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->437943540],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"-", "1"}], ")"}], 
    RowBox[{"Abs", "[", "n", "]"}]], " ", 
   RowBox[{"(", 
    RowBox[{"1", "-", 
     RowBox[{"\[ImaginaryI]", " ", "n", " ", "\[Pi]"}]}], ")"}]}], 
  RowBox[{"2", " ", 
   SuperscriptBox["n", "2"], " ", 
   SuperscriptBox["\[Pi]", "2"]}]]], "Output",
 ImageSize->{133, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->507608054]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierCoefficient", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"t", "^", "2"}], "+", "t"}], ",", " ", "t", ",", " ", "n", ",", 
   " ", 
   RowBox[{"FourierParameters", " ", "\[Rule]", " ", 
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"-", "1"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->262955044],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"-", "1"}], ")"}], 
    RowBox[{"Abs", "[", "n", "]"}]], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     RowBox[{"\[ImaginaryI]", " ", "n", " ", "\[Pi]"}]}], ")"}]}], 
  RowBox[{"2", " ", 
   SuperscriptBox["n", "2"], " ", 
   SuperscriptBox["\[Pi]", "2"]}]]], "Output",
 ImageSize->{133, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->4368806]
}, Open  ]],

Cell["Compare with the answer from a numerical approximation:", "ExampleText",
 CellID->67562546],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierCoefficient", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"t", "^", "2"}], "+", "t"}], ",", " ", "t", ",", " ", "n"}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->144209699],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"-", "1"}], ")"}], 
    RowBox[{"Abs", "[", "n", "]"}]], " ", 
   RowBox[{"(", 
    RowBox[{"1", "-", 
     RowBox[{"\[ImaginaryI]", " ", "n", " ", "\[Pi]"}]}], ")"}]}], 
  RowBox[{"2", " ", 
   SuperscriptBox["n", "2"], " ", 
   SuperscriptBox["\[Pi]", "2"]}]]], "Output",
 ImageSize->{133, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->345858007]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{"{", 
   RowBox[{"n", "\[Rule]", " ", "5."}], "}"}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->537939928],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "0.0020264236728467556`"}], "+", 
  RowBox[{"0.03183098861837907`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{162, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->329975668]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NFourierCoefficient", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"t", "^", "2"}], "+", "t"}], ",", " ", "t", ",", " ", "5"}], 
  "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->24706839],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "0.0020264236728467382`"}], "+", 
  RowBox[{"0.03183098861837903`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{162, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->12379288]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->18913],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FourierSinCoefficient",
    BaseStyle->"Link",
    ButtonData->"paclet:FourierSeries/ref/FourierSinCoefficient"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FourierCosCoefficient",
    BaseStyle->"Link",
    ButtonData->"paclet:FourierSeries/ref/FourierCosCoefficient"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NFourierCoefficient",
    BaseStyle->"Link",
    ButtonData->"paclet:FourierSeries/ref/NFourierCoefficient"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NFourierSinCoefficient",
    BaseStyle->"Link",
    ButtonData->"paclet:FourierSeries/ref/NFourierSinCoefficient"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NFourierCosCoefficient",
    BaseStyle->"Link",
    ButtonData->"paclet:FourierSeries/ref/NFourierCosCoefficient"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseFourierCoefficient",
    BaseStyle->"Link",
    ButtonData->"paclet:FourierSeries/ref/InverseFourierCoefficient"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NInverseFourierCoefficient",
    BaseStyle->"Link",
    ButtonData->"paclet:FourierSeries/ref/NInverseFourierCoefficient"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->6693]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->13194],

Cell[TextData[ButtonBox["Fourier Series Package",
 BaseStyle->"Link",
 ButtonData->"paclet:FourierSeries/tutorial/FourierSeries"]], "Tutorials",
 CellID->8705]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FourierCoefficient - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 58, 3.5212304}", "context" -> 
    "FourierSeries`", "keywords" -> {}, "index" -> True, "label" -> 
    "Fourier Series Package Symbol", "language" -> "en", "paclet" -> 
    "FourierSeries Package", "status" -> "None", "summary" -> 
    "FourierCoefficient[expr, t, n] gives the n^th coefficient in the Fourier \
exponential series expansion of expr, where expr is a periodic function of t \
with period 1.", "synonyms" -> {}, "title" -> "FourierCoefficient", "type" -> 
    "Symbol", "uri" -> "FourierSeries/ref/FourierCoefficient"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8371, 277, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->52764322]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 16646, 577}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2348, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2971, 82, 55, 1, 70, "ObjectName",
 CellID->6120],
Cell[3029, 85, 980, 31, 70, "Usage",
 CellID->27393]
}, Open  ]],
Cell[CellGroupData[{
Cell[4046, 121, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4524, 138, 863, 30, 70, "Notes",
 CellID->6292],
Cell[5390, 170, 159, 6, 70, "Notes",
 CellID->14962],
Cell[5552, 178, 309, 9, 70, "Notes",
 CellID->14214],
Cell[5864, 189, 1855, 61, 70, "Notes",
 CellID->12527],
Cell[7722, 252, 612, 20, 70, "Notes",
 CellID->26807]
}, Closed]],
Cell[CellGroupData[{
Cell[8371, 277, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->52764322],
Cell[CellGroupData[{
Cell[8755, 291, 148, 5, 70, "ExampleSection",
 CellID->607868955],
Cell[8906, 298, 137, 4, 70, "Input",
 CellID->32906638],
Cell[9046, 304, 127, 3, 70, "ExampleText",
 CellID->320560372],
Cell[CellGroupData[{
Cell[9198, 311, 209, 7, 28, "Input",
 CellID->437943540],
Cell[9410, 320, 493, 17, 56, "Output",
 CellID->507608054]
}, Open  ]],
Cell[CellGroupData[{
Cell[9940, 342, 354, 11, 28, "Input",
 CellID->262955044],
Cell[10297, 355, 491, 17, 56, "Output",
 CellID->4368806]
}, Open  ]],
Cell[10803, 375, 97, 1, 70, "ExampleText",
 CellID->67562546],
Cell[CellGroupData[{
Cell[10925, 380, 209, 7, 70, "Input",
 CellID->144209699],
Cell[11137, 389, 493, 17, 56, "Output",
 CellID->345858007]
}, Open  ]],
Cell[CellGroupData[{
Cell[11667, 411, 152, 5, 70, "Input",
 CellID->537939928],
Cell[11822, 418, 274, 8, 36, "Output",
 CellID->329975668]
}, Open  ]],
Cell[CellGroupData[{
Cell[12133, 431, 209, 7, 70, "Input",
 CellID->24706839],
Cell[12345, 440, 273, 8, 36, "Output",
 CellID->12379288]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12679, 455, 311, 9, 70, "SeeAlsoSection",
 CellID->18913],
Cell[12993, 466, 1973, 62, 70, "SeeAlso",
 CellID->6693]
}, Open  ]],
Cell[CellGroupData[{
Cell[15003, 533, 314, 9, 70, "TutorialsSection",
 CellID->13194],
Cell[15320, 544, 159, 3, 70, "Tutorials",
 CellID->8705]
}, Open  ]],
Cell[15494, 550, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

