(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     27424,        818]
NotebookOptionsPosition[     24430,        719]
NotebookOutlinePosition[     25768,        756]
CellTagsIndexPosition[     25683,        751]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["FOURIER SERIES PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[
    Cell[BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Fourier Series Package" :> 
         Documentation`HelpLookup[
          "paclet:FourierSeries/tutorial/FourierSeries"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"Fourier Series Package\"\>"}, "\<\"tutorials\"\>",
       
      StyleBox["\<\"tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["FourierTrigSeries", "ObjectName",
 CellID->28042],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       RowBox[{"FourierTrigSeries", "["}], 
       StyleBox["expr", "TI"], ",", 
       StyleBox["t", "TI"], ",", 
       StyleBox["k", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the order ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " Fourier trigonometric series expansion of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ", where ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " is a periodic function of ",
     Cell[BoxData[
      StyleBox["t", "TI"]], "InlineFormula"],
     " with period 1."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->6300]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The order ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " Fourier exponential series expansion of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " is by default defined to be ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], 
    SubscriptBox[
     StyleBox["c", "TI"], 
     StyleBox["0", "TR"]]}], "+", 
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{
      StyleBox["k", "TI"], "=", "1"}], 
     StyleBox["n", "TI"]], 
    RowBox[{
     SubscriptBox[
      StyleBox["c", "TI"], 
      StyleBox["k", "TI"]], 
     RowBox[{
      ButtonBox["Cos",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Cos"], "[", 
      RowBox[{"2", 
       StyleBox["\[Pi]", "TR"], " ", 
       StyleBox["k", "TI"], " ", 
       StyleBox["t", "TI"]}], "]"}]}]}], "+", 
   RowBox[{
    SubscriptBox[
     StyleBox["d", "TI"], 
     StyleBox["k", "TI"]], " ", 
    RowBox[{
     ButtonBox["Sin",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Sin"], "[", 
     RowBox[{"2", 
      StyleBox["\[Pi]", "TR"], " ", 
      StyleBox["k", "TI"], " ", 
      StyleBox["t", "TI"]}], "]"}]}]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->15811],

Cell[TextData[{
 "The coefficient ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["c", "TI"], 
   StyleBox["k", "TI"]]], "InlineFormula"],
 " is defined to be ",
 Cell[BoxData[
  RowBox[{"2", 
   RowBox[{
    ButtonBox["Integrate",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Integrate"], "[", 
    RowBox[{
     RowBox[{
      StyleBox["expr", "TI"], " ", 
      RowBox[{
       ButtonBox["Cos",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Cos"], "[", 
       RowBox[{"2", 
        StyleBox["\[Pi]", "TR"], " ", 
        StyleBox["k", "TI"], " ", 
        StyleBox["t", "TI"]}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{
       StyleBox["t", "TI"], ",", 
       RowBox[{"-", 
        FractionBox["1", "2"]}], ",", 
       FractionBox["1", "2"]}], "}"}]}], "]"}]}]], "InlineFormula"],
 " and the coefficient ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["d", "TI"], 
   StyleBox["k", "TI"]]], "InlineFormula"],
 " is defined to be ",
 Cell[BoxData[
  RowBox[{"2", 
   RowBox[{
    ButtonBox["Integrate",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Integrate"], "[", 
    RowBox[{
     RowBox[{
      StyleBox["expr", "TI"], " ", 
      RowBox[{
       ButtonBox["Sin",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Sin"], "[", 
       RowBox[{"2", 
        StyleBox["\[Pi]", "TR"], " ", 
        StyleBox["k", "TI"], " ", 
        StyleBox["t", "TI"]}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{
       StyleBox["t", "TI"], ",", 
       RowBox[{"-", 
        FractionBox["1", "2"]}], ",", 
       FractionBox["1", "2"]}], "}"}]}], "]"}]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->5225],

Cell[TextData[{
 "Different choices for the period of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " can be specified using the option ",
 Cell[BoxData[
  ButtonBox["FourierParameters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FourierParameters"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->21143],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FourierParameters",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FourierParameters"], "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"]}], "}"}]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " is assumed to have a period of ",
 Cell[BoxData[
  FractionBox["1", 
   RowBox[{"\[VerticalSeparator]", 
    StyleBox["b", "TI"], "\[VerticalSeparator]"}]]], "InlineFormula"],
 ", and the order ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " Fourier exponential series expansion computed by ",
 Cell[BoxData["FourierTrigSeries"], "InlineFormula"],
 " is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     FractionBox["1", "2"], 
     SubscriptBox[
      StyleBox["c", "TI"], 
      StyleBox["0", "TR"]]}], "+", 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{
       StyleBox["k", "TI"], "=", "1"}], 
      StyleBox["n", "TI"]], 
     RowBox[{
      SubscriptBox[
       StyleBox["c", "TI"], 
       StyleBox["k", "TI"]], " ", 
      RowBox[{
       ButtonBox["Cos",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Cos"], "[", 
       RowBox[{"2", 
        StyleBox["\[Pi]", "TR"], " ", 
        StyleBox["b", "TI"], " ", 
        StyleBox["k", "TI"], " ", 
        StyleBox["t", "TI"]}], "]"}]}]}], "+", 
    RowBox[{
     SubscriptBox[
      StyleBox["d", "TI"], 
      StyleBox["k", "TI"]], " ", 
     RowBox[{
      ButtonBox["Sin",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Sin"], "[", 
      RowBox[{"2", 
       StyleBox["\[Pi]", "TR"], " ", 
       StyleBox["b", "TI"], " ", 
       StyleBox["k", "TI"], " ", 
       StyleBox["t", "TI"]}], "]"}]}]}], TraditionalForm]], "InlineFormula"],
 ". Here, the coefficient ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["c", "TI"], 
   StyleBox["k", "TI"]]], "InlineFormula"],
 " is defined to be ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["2", "TR"], 
    StyleBox[
     RowBox[{"\[LeftBracketingBar]", "b", "\[RightBracketingBar]"}], "TI"], 
    " ", 
    RowBox[{
     ButtonBox["Integrate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Integrate"], "[", 
     RowBox[{
      RowBox[{
       StyleBox["expr", "TI"], " ", 
       RowBox[{
        ButtonBox["Cos",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/Cos"], "[", 
        RowBox[{"2", 
         StyleBox["\[Pi]", "TR"], " ", 
         StyleBox["b", "TI"], " ", "k", " ", 
         StyleBox["t", "TI"]}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["t", "TI"], ",", 
        RowBox[{"-", 
         FractionBox["1", 
          RowBox[{"2", "\[VerticalSeparator]", 
           StyleBox["b", "TI"], "\[VerticalSeparator]"}]]}], ",", 
        FractionBox["1", 
         RowBox[{"2", "\[VerticalSeparator]", 
          StyleBox["b", "TI"], "\[VerticalSeparator]"}]]}], "}"}]}], "]"}]}], 
   TraditionalForm]], "InlineFormula"],
 " and the coefficient ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["d", "TI"], 
   StyleBox["k", "TI"]]], "InlineFormula"],
 " is defined to be ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["2", "TR"], 
    StyleBox[
     RowBox[{"\[LeftBracketingBar]", "b", "\[RightBracketingBar]"}], "TI"], 
    " ", 
    RowBox[{
     ButtonBox["Integrate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Integrate"], "[", 
     RowBox[{
      RowBox[{
       StyleBox["expr", "TI"], " ", 
       RowBox[{
        ButtonBox["Sin",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/Sin"], "[", 
        RowBox[{"2", 
         StyleBox["\[Pi]", "TR"], " ", 
         StyleBox["b", "TI"], " ", 
         StyleBox["k", "TI"], " ", 
         StyleBox["t", "TI"]}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["t", "TI"], ",", 
        RowBox[{"-", 
         FractionBox["1", 
          RowBox[{"2", "\[VerticalSeparator]", 
           StyleBox["b", "TI"], "\[VerticalSeparator]"}]]}], ",", 
        FractionBox["1", 
         RowBox[{"2", "\[VerticalSeparator]", 
          StyleBox["b", "TI"], "\[VerticalSeparator]"}]]}], "}"}]}], "]"}]}], 
   TraditionalForm]], "InlineFormula"],
 "."
}], "Notes",
 CellID->21595],

Cell[TextData[{
 "In addition to the option ",
 Cell[BoxData[
  ButtonBox["FourierParameters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FourierParameters"]], "InlineFormula"],
 ", ",
 Cell[BoxData["FourierTrigSeries"], "InlineFormula"],
 " can also accept the options available to ",
 Cell[BoxData[
  ButtonBox["Integrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integrate"]], "InlineFormula"],
 ". These options are passed directly to ",
 Cell[BoxData[
  ButtonBox["Integrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integrate"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->21016]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->335185275],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->27294562],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<FourierSeries`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->35028374],

Cell["\<\
Compute the trigonometric Fourier series for a periodic function of t with \
period 1:\
\>", "ExampleText",
 CellID->391515445],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FourierTrigSeries", "[", 
   RowBox[{
    RowBox[{"E", "^", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "4"}], 
       RowBox[{"Abs", "[", "t", "]"}]}], ")"}]}], ",", "t", ",", " ", "3"}], 
   "]"}], " "}]], "Input",
 CellLabel->"In[2]:=",
 CellID->252796276],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    SuperscriptBox["\[ExponentialE]", "2"]}], 
   RowBox[{"2", " ", 
    SuperscriptBox["\[ExponentialE]", "2"]}]], "+", 
  FractionBox[
   RowBox[{"4", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      SuperscriptBox["\[ExponentialE]", "2"]}], ")"}], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"2", " ", "\[Pi]", " ", "t"}], "]"}]}], 
   RowBox[{
    SuperscriptBox["\[ExponentialE]", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"4", "+", 
      SuperscriptBox["\[Pi]", "2"]}], ")"}]}]], "+", 
  FractionBox[
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["\[ExponentialE]", "2"]}], ")"}], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"4", " ", "\[Pi]", " ", "t"}], "]"}]}], 
   RowBox[{
    SuperscriptBox["\[ExponentialE]", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      SuperscriptBox["\[Pi]", "2"]}], ")"}]}]], "+", 
  FractionBox[
   RowBox[{"4", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      SuperscriptBox["\[ExponentialE]", "2"]}], ")"}], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"6", " ", "\[Pi]", " ", "t"}], "]"}]}], 
   RowBox[{
    SuperscriptBox["\[ExponentialE]", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"4", "+", 
      RowBox[{"9", " ", 
       SuperscriptBox["\[Pi]", "2"]}]}], ")"}]}]]}]], "Output",
 ImageSize->{463, 41},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->311122295]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{"%", ",", " ", 
   RowBox[{"{", 
    RowBox[{"t", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->564171855],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->127468243]
}, Open  ]],

Cell["Compare with a plot of the original function:", "ExampleText",
 CellID->247795875],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"E", "^", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "4"}], 
      RowBox[{"Abs", "[", 
       RowBox[{"t", "-", 
        RowBox[{"Round", "[", "t", "]"}]}], "]"}]}], ")"}]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"t", ",", 
     RowBox[{"-", "2"}], ",", " ", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->3952088],

Cell[GraphicsData["CompressedBitmap", "\<\
eJytW0uLZVcZPal77q26Xbfq1vvZSVX1o27/CXEgKhIliCYORKRtlfTAJMSW
oE50oiI60UlaxAw0ATVIQocEIUIwIDaIATFE1CBpkDiwCRgcNAjXb++1z17f
WWffVAVt6Krz2Odb61vfY+/zqI9cvvbg575w+drVK5cPP/jo5UcevHrli4cf
ePhRO9S7q6qq5+z/YzuVbU9tK/5/bjq1392fA/tZ24CJ/e7Z7/vS7+N0vI6j
5sPPcDjuVdUltx82j9/FfpWtVr20a//mml131WHioMdPQpvIPmCGcnQc97/8
2Au3br0VNjfk/Ercv3HjtR88fjNsrsv51bj/9tt3Hn7oRthck/MY/+1vvfT6
67dL5+eKrJbj/s3f3vr8Z3/xpWvPV5sl1vWdO/954ONP3f+xJ2/f/neZ1ze/
8dIjD9149plXO7jYf+X3f79y+Wmj3vFrLudFVfNoBeS+IV/5zNNvvPHWV7/y
y5d//beOauD3/e/95uc/+8OvXvzr17/2YrAfoht59f/y53/a9abapz75UyOf
2Ar7gHL1wWdsbEIZd9gwL4PtGKuBQRqwbRo9AzEja63zhveJ+5+yw7Zn5828
ahPH9U0Vk8c2YTAeDVbW2yjZ3Did70dOO9GmnTSI4GHUswdFwub5aMXi88Lz
fwKsgRmkcok+z5v3pgEOZVVgo2f7RqCEsemY8Ohcwwy0q3NxHxGZNnXSg+Ss
AK0YKEd7mWGyl/Xp4IHVdsP93g89EY7WwvJIWPSEpbJaFhawZ+llWTBNXcRr
pXgbjhW51w33j973Y1qhLzHWPatQK1Vqo6yoVS32D2fhJftgFXx/NvbHgdjv
F/dDraDJ5vFJtZOu1/N1o5odCqrlGeDNN/91muvL/KwdKL8nf/LK6a////nr
upw7uhT3c/0nrxnFpeJ4K2QrZ45nVJdl/CjuW/ezrAraYrxJalEvjV+SLMN4
awKv/vEfJT7wCnOGpb8VQdhciPs2F3z3Oy+HzbvFCqwy98qs6dWCsDorXije
mmN1/fGbKeILTYalPgArrPNhkzE2jZR8HUlsFiQWwd7cEz/63VBwPBsjnPJZ
0faF7bDJt9RllM2iaK6o8I5dCefzLIB5L82mFhYLTtg8E/dNZhObrCx5LFgt
FDtkWRVZhZloJOzPCNqeaK04no0F0ULJUeyksILZixoQZVTUiJqfkev3iqzp
nWdFDRR1V1gvim/KSlksCuqesFa8OB+lVRStAAUrILJS1kQps6IWI0HdkUwZ
Cb5nRS1GkpU7ctWSoCwWWVGLkWi7U2RNLz0rWtEuty1WlkRLZTWUbF4qeqld
nLUe5+60LmYFowuyn4CV9l7zylAaVqH2gkah74zFq624r72e9j0LnUG4DtkS
VKBwxjpT1IbnFXVL9pdL9hMrWhmLFpsSoXHSQCO10FhP899YNAEbrv10xRnZ
pXsGxncloW1J9o6lRlQbsGFPX5G8hFcGYoS9V2PHQirO7evVK7Kvd35gw3Up
xrN2N07AozaBo2q0ITWyKjVQZkPlV0SrjRk4PkLMF91flyxflSwcplrK+ZKy
cVX2N07AiTWauLdXAIH7hmQbrtY5nJrMC0tUBef0tRk4y44F44XR7J3rkh9r
sr9QZMP8WJPsXyviSa9PrNhr10ThNcmbddGszIp5s1bUjJFXzTwr9s51sYpI
cYW5nPIl3iv2bQPWo63uKn8gPsI6u9Ca+Ijz7HYjx5HxwSjWb34Ok+IRPWs9
w4ir9X6OyDuyZZ4ga9mlVk/gAbZjiSOssGOvisIz2KZIBZ699MQj6D6fMh09
j11lpYjKLuK5MSc2JB4rEq/lDrcY99pA8iPGsoqMKTAs6a/j6d6K5Kly8EwZ
09IM4WM1iymiUxXv7Adis9z3Wfd6J7PomDKem+L/WPyfxRSKlJn2RaNNidPK
CRzAdNnlVegAWymXVgqM55onfzW79CxezLIt4VFC9PnneXH1sCVWx6L7lsSt
zIp1qauVZakVxfOs2PnKq0rGYFt8L7Nib1MtynjtVW/Dijm5LVosSV1sixZl
Vrx+S2JRxpM7y84zOIzirLKUMg33B6z98rMwarwtGpRxmLlgU74r0bsc9s5t
yYcyK+bHjmgAe+9/3w/xwDvZY8V7VkSBFc4LS0XfzKQZnsUqaLorGoyKOGTv
2RB9R64aCTpQuALTp3y1sNgRDUZFDdlbPCtGCqjvfc/1hLIoLNX3MiuyVi1G
wnJXIjl0rJjNuxKpRdFyN0VGI9Yraso7zpF4ozieDbNvV7J5saghfVaN9Kk/
nsKwIyyKhrDHbgpW+XlrqtQ9UXax6BvjX2bFTgF77J75iVXSUvE8K3azPdFC
fduT+NdFVtQW4/W53Ww8z4qdfq9UC863fcmDMitqC3ucWc5Ifu5J3nlWnCn2
hIX6ti++l1mpttKHnJb7ov2CY8Xa2xerQ9FyX/JAWeW1dUtb1Z5aqvaeFZ8x
7stVw6Jv+uZMWbEG8QybfW8oLGCPNQ9W+Uln8u2ssBgWfaPvZVbMm/KTdUZM
n+R7VuobrQ7FavMmWb9FmIu3QnCN+aVsGfmz4i3un7m2UB6eLSN1VrJefY53
c9335X1/xDBnaMvqAQ6rD2y5jtN3Np6t+swurD6vnYKtYc5gy+4LHFadvoc6
K5no2dJnvB1jFc2Lz6dhG767qFsZQ3tnxZ4+9wM+Z9J5x5K+lt/hyTu3Dste
zFb24MhtkEfZP0TpnniSvXhBsraInjjSU4zinDwvnnY59t0RZHvdYYhsO5i2
Mx62Wa9F7M4cFvwMayL1r/lmpfm+JFr2WddihGoFI3bDeWF4t8dKTNjloLi+
SaY/OM/e22WBejsQTwZFHPYXrwtzEqPYX9SXeyRHu2xQT2DD3gs27GNFnMSG
WarZCCvsH0DhbDyXojYnx2GHNTIo4rBPeTbMWs08rBH5fAbn2U+62kC3A7lu
UMSR5wmdlYBmXV98xHn2YjxzzGxQCulrFCqqT8sUxXPhUYzi/B+fDlrGH0rO
CQckJ7/Tad1ZqnXJ7MSB0TgQFfsSjQPJOOGC1EzfIDG/9XmEooDLUPJUv/HR
b4YOZLxwSV+fgQvfadSSpYriuTC7NAZ98TCer7OO06bv2QbKN/FgRwUPzv1A
YG17HsQ9FP3Bg30tnu/nvhdtNJXMzDpMmaVP+g6Fk+fAGsjfciXd9flO9LSf
49TiwDkPVlhp5S+8JJ8TF+bjkeRvT+IGLnl8iwtnWmCxf5e/qeP4vuPCfMQo
zjl6t3uUVI/oaZaGf/jyT9fsrNUj0c7js8KPhE8v4UXrC1lpaGA/EbFzonNd
tNruSg02K/pI4tIrxan272pQH4zUOdG4V0SQzsSvoBL7c5KrehcdrSzkXM1a
IErnRWfkCXuFfqHpOTB65yTuPVE0nu+zZvHOJUTqvGg9V7QsXSjhq5LM5p7U
yOZ09r1YPDbPvhZPIozpq1muRuaKuNKbOt+VYRS7hd67b7rqAIO6cyReM884
xVNI/MRSZux3wCdLRoBsNAKnZ8coxlMIf2Inc7lji/PMjdppyLkD30Dn2pg2
30Bvdbg0bxgRa1YP7mRQarkuXCyLX1276vS82HHAK2f6tKmrLq8Zqg2oRFUh
CheK+cKKBjN5jpaYsReDWb5q2qz3T8+MGRTv/Y3NhWKuMCvPC1PPjH0NzPwM
BdW3U+QGPoIDRqiqsH2xkwuoXrCTJ3npToScw6g8J6mqA/+WEP5HtL6PsOVq
dXHq1hMJg9deaOtn/6BRPF6TSxV7IBByTmGZERF8FXtvqAmQcufLWsAmNMK7
2LAiw9GsEJY9CUnWAgmJK6WI1M8rpaTDsVPHQFCwWZ0YwrRCBgpXWh6F8wtQ
8koraQEUrGgNJW3AmzzLYyPhsHo8Djt5HFWj64ATMJIDVYVC6mgTvMJfD7Fj
9RwCOxYQEA1cf5xVMfspNBfbqiZ4IMjKICFwXQ8EZBbyJF5XJyGqyrLsuK1n
mjFgnx3E22cHgX1UiNFuPK/Ry5FVE6cj7MF2e03W2GYPgG3UPfIRtpHZiPHE
KYifx6IxbA+kwqkzqxt46caxquzExHkbMnmSrqqdTWaRV9b5WWOlZBbt+KTx
3IbZZemvyrje92xZwbCDIkHEJ01+mdngRmQWvqno8bMf5CVnVW+bNQu9sD4J
9i41eYXulhhaVdj5UKMT4eatshMdN9qY58F5WDUTlcuJMMMbUKA9ES1pNeh9
qfE29U6MRoKFpjJpPLUhjRo+2p4je/+k8TR5Mmkyp8Jfp2RPzWrojJckP/1f
ezCLcJW5kZQI72F7+e6qva7EnWZgjNUurjWPDNG8SYisNo/IGp80+603u/J2
qjubh6xr4ZrPhhu65iVB8Lhkk6NgDrwbXDTPsJnjmtbV2aJf6TNuaaWeo506
0ylx6xDTqpV/pkDLpu37e5zqwyda1ne5D/xP1907ba9uPh2Pdv++trrrv3EH
9LU=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->88572292]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->26615],

Cell[TextData[ButtonBox["Fourier Series Package",
 BaseStyle->"Link",
 ButtonData->"paclet:FourierSeries/tutorial/FourierSeries"]], "Tutorials",
 CellID->28804]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"FourierTrigSeries - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 58, 10.4120318}", "context" -> 
    "FourierSeries`", "keywords" -> {}, "index" -> True, "label" -> 
    "Fourier Series Package Symbol", "language" -> "en", "paclet" -> 
    "FourierSeries Package", "status" -> "None", "summary" -> 
    "FourierTrigSeries[ expr, t, k] gives the order n Fourier trigonometric \
series expansion of expr, where expr is a periodic function of t with period \
1.", "synonyms" -> {}, "title" -> "FourierTrigSeries", "type" -> "Symbol", 
    "uri" -> "FourierSeries/ref/FourierTrigSeries"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[10809, 391, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->335185275]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 25539, 744}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 632, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1255, 43, 55, 1, 70, "ObjectName",
 CellID->28042],
Cell[1313, 46, 862, 27, 70, "Usage",
 CellID->6300]
}, Open  ]],
Cell[CellGroupData[{
Cell[2212, 78, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2690, 95, 1211, 46, 70, "Notes",
 CellID->15811],
Cell[3904, 143, 1649, 61, 70, "Notes",
 CellID->5225],
Cell[5556, 206, 328, 11, 70, "Notes",
 CellID->21143],
Cell[5887, 219, 4271, 145, 70, "Notes",
 CellID->21595],
Cell[10161, 366, 611, 20, 70, "Notes",
 CellID->21016]
}, Closed]],
Cell[CellGroupData[{
Cell[10809, 391, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->335185275],
Cell[CellGroupData[{
Cell[11194, 405, 147, 5, 70, "ExampleSection",
 CellID->27294562],
Cell[11344, 412, 137, 4, 70, "Input",
 CellID->35028374],
Cell[11484, 418, 137, 4, 70, "ExampleText",
 CellID->391515445],
Cell[CellGroupData[{
Cell[11646, 426, 305, 11, 28, "Input",
 CellID->252796276],
Cell[11954, 439, 1511, 50, 62, "Output",
 CellID->311122295]
}, Open  ]],
Cell[CellGroupData[{
Cell[13502, 494, 208, 7, 28, "Input",
 CellID->564171855],
Cell[13713, 503, 4873, 84, 140, "Output",
 Evaluatable->False,
 CellID->127468243]
}, Open  ]],
Cell[18601, 590, 88, 1, 70, "ExampleText",
 CellID->247795875],
Cell[CellGroupData[{
Cell[18714, 595, 403, 14, 28, "Input",
 CellID->3952088],
Cell[19120, 611, 4730, 82, 140, "Output",
 Evaluatable->False,
 CellID->88572292]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[23911, 700, 314, 9, 70, "TutorialsSection",
 CellID->26615],
Cell[24228, 711, 160, 3, 70, "Tutorials",
 CellID->28804]
}, Open  ]],
Cell[24403, 717, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

