(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14017,        509]
NotebookOptionsPosition[     10895,        405]
NotebookOutlinePosition[     12277,        443]
CellTagsIndexPosition[     12192,        438]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["FOURIER SERIES PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[
    Cell[BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Fourier Series Package" :> 
         Documentation`HelpLookup[
          "paclet:FourierSeries/tutorial/FourierSeries"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"Fourier Series Package\"\>"}, "\<\"tutorials\"\>",
       
      StyleBox["\<\"tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["InverseDTFourierTransform", "ObjectName",
 CellID->4640],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"InverseDTFourierTransform", "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["\[Omega]", "TR"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the inverse discrete time Fourier transform of ",
     
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ", where ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " is a periodic function of ",
     Cell[BoxData[
      StyleBox["\[Omega]", "TR"]], "InlineFormula"],
     " with period 1."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->25079]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The inverse discrete time Fourier transform of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " is by default defined to be ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Integrate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Integrate"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["expr", "TI"], " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "2"}], 
       StyleBox["\[Pi]", "TR"], " ", "\[ImaginaryI]", " ", 
       StyleBox["n", "TI"], " ", 
       StyleBox["\[Omega]", "TR"]}]]}], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["\[Omega]", "TR"], ",", 
      RowBox[{"-", 
       FractionBox["1", "2"]}], ",", 
      FractionBox["1", "2"]}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->10041],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " is numeric, it should be an explicit integer."
}], "Notes",
 CellID->18125],

Cell[TextData[{
 "Different choices for the definition of the inverse discrete time Fourier \
transform can be specified using the option ",
 Cell[BoxData[
  ButtonBox["FourierParameters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FourierParameters"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->12534],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FourierParameters",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FourierParameters"], "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"]}], "}"}]}]], "InlineFormula"],
 ",",
 " ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " is assumed to have a period of ",
 Cell[BoxData[
  FractionBox["1", 
   RowBox[{"\[VerticalSeparator]", 
    StyleBox["b", "TI"], "\[VerticalSeparator]"}]]], "InlineFormula"],
 ", and",
 " the inverse discrete time Fourier transform computed by ",
 Cell[BoxData["InverseDTFourierTransform"], "InlineFormula"],
 " is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox[
     StyleBox[
      RowBox[{"\[LeftBracketingBar]", "b", "\[RightBracketingBar]"}], "TI"], 
     FractionBox[
      RowBox[{"1", "+", 
       StyleBox["a", "TI"]}], "2"]], " ", 
    RowBox[{
     ButtonBox["Integrate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Integrate"], "[", 
     RowBox[{
      RowBox[{
       StyleBox["expr", "TI"], " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         StyleBox["\[Pi]", "TR"], " ", "\[ImaginaryI]", " ", 
         StyleBox["b", "TI"], " ", 
         StyleBox["n", "TI"], " ", 
         StyleBox["\[Omega]", "TR"]}]]}], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["\[Omega]", "TR"], ",", 
        RowBox[{"-", 
         FractionBox["1", 
          RowBox[{"2", "\[VerticalSeparator]", 
           StyleBox["b", "TI"], "\[VerticalSeparator]"}]]}], ",", 
        FractionBox["1", 
         RowBox[{"2", "\[VerticalSeparator]", 
          StyleBox["b", "TI"], "\[VerticalSeparator]"}]]}], "}"}]}], "]"}]}], 
   TraditionalForm]], "InlineFormula"],
 "."
}], "Notes",
 CellID->4860],

Cell[TextData[{
 "In addition to the option ",
 Cell[BoxData[
  ButtonBox["FourierParameters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FourierParameters"]], "InlineFormula"],
 ", ",
 Cell[BoxData["InverseDTFourierTransform"], "InlineFormula"],
 " can also accept the options available to ",
 Cell[BoxData[
  ButtonBox["Integrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integrate"]], "InlineFormula"],
 ". These options are passed directly to ",
 Cell[BoxData[
  ButtonBox["Integrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integrate"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->23000]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->470143152],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->61656471],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<FourierSeries`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->254321244],

Cell["\<\
Find a sequence with a given discrete time Fourier transform:\
\>", "ExampleText",
 CellID->320560372],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseDTFourierTransform", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"-", 
     RowBox[{"\[Omega]", "^", "2"}]}], "]"}], ",", " ", "\[Omega]", ",", " ", 
   "n"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->147863104],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["n", "2"]}], " ", 
    SuperscriptBox["\[Pi]", "2"]}]], " ", 
  SqrtBox["\[Pi]"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"Erf", "[", 
     RowBox[{
      FractionBox["1", "2"], "-", 
      RowBox[{"\[ImaginaryI]", " ", "n", " ", "\[Pi]"}]}], "]"}], "+", 
    RowBox[{"Erf", "[", 
     RowBox[{
      FractionBox["1", "2"], "+", 
      RowBox[{"\[ImaginaryI]", " ", "n", " ", "\[Pi]"}]}], "]"}]}], 
   ")"}]}]], "Output",
 ImageSize->{288, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->151091326]
}, Open  ]],

Cell["Compare with the answer from a numerical approximation:", "ExampleText",
 CellID->67562546],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseDTFourierTransform", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"-", 
     RowBox[{"\[Omega]", "^", "2"}]}], "]"}], ",", " ", "\[Omega]", ",", " ", 
   "n"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->75201933],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["n", "2"]}], " ", 
    SuperscriptBox["\[Pi]", "2"]}]], " ", 
  SqrtBox["\[Pi]"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"Erf", "[", 
     RowBox[{
      FractionBox["1", "2"], "-", 
      RowBox[{"\[ImaginaryI]", " ", "n", " ", "\[Pi]"}]}], "]"}], "+", 
    RowBox[{"Erf", "[", 
     RowBox[{
      FractionBox["1", "2"], "+", 
      RowBox[{"\[ImaginaryI]", " ", "n", " ", "\[Pi]"}]}], "]"}]}], 
   ")"}]}]], "Output",
 ImageSize->{288, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->385154683]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{"{", 
   RowBox[{"n", "\[Rule]", " ", "5."}], "}"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->131969966],

Cell[BoxData[
 RowBox[{"0.001586242692432749`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{112, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->67739868]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NInverseDTFourierTransform", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"-", 
     RowBox[{"\[Omega]", "^", "2"}]}], "]"}], ",", " ", "\[Omega]", ",", " ", 
   "5"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->133278707],

Cell[BoxData[
 RowBox[{"0.0015862426924327933`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{112, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->753197378]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->4907],

Cell[TextData[ButtonBox["Fourier Series Package",
 BaseStyle->"Link",
 ButtonData->"paclet:FourierSeries/tutorial/FourierSeries"]], "Tutorials",
 CellID->32621]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"InverseDTFourierTransform - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 58, 10.9120446}", "context" -> 
    "FourierSeries`", "keywords" -> {}, "index" -> True, "label" -> 
    "Fourier Series Package Symbol", "language" -> "en", "paclet" -> 
    "FourierSeries Package", "status" -> "None", "summary" -> 
    "InverseDTFourierTransform[expr, \\[Omega], n] gives the inverse discrete \
time Fourier transform of expr, where expr is a periodic function of \
\\[Omega] with period 1.", "synonyms" -> {}, "title" -> 
    "InverseDTFourierTransform", "type" -> "Symbol", "uri" -> 
    "FourierSeries/ref/InverseDTFourierTransform"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6433, 228, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->470143152]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12049, 431}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 632, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1255, 43, 62, 1, 70, "ObjectName",
 CellID->4640],
Cell[1320, 46, 814, 25, 70, "Usage",
 CellID->25079]
}, Open  ]],
Cell[CellGroupData[{
Cell[2171, 76, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2649, 93, 796, 27, 70, "Notes",
 CellID->10041],
Cell[3448, 122, 159, 6, 70, "Notes",
 CellID->18125],
Cell[3610, 130, 312, 9, 70, "Notes",
 CellID->12534],
Cell[3925, 141, 1849, 60, 70, "Notes",
 CellID->4860],
Cell[5777, 203, 619, 20, 70, "Notes",
 CellID->23000]
}, Closed]],
Cell[CellGroupData[{
Cell[6433, 228, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->470143152],
Cell[CellGroupData[{
Cell[6818, 242, 147, 5, 70, "ExampleSection",
 CellID->61656471],
Cell[6968, 249, 138, 4, 70, "Input",
 CellID->254321244],
Cell[7109, 255, 112, 3, 70, "ExampleText",
 CellID->320560372],
Cell[CellGroupData[{
Cell[7246, 262, 259, 8, 28, "Input",
 CellID->147863104],
Cell[7508, 272, 700, 24, 51, "Output",
 CellID->151091326]
}, Open  ]],
Cell[8223, 299, 97, 1, 70, "ExampleText",
 CellID->67562546],
Cell[CellGroupData[{
Cell[8345, 304, 258, 8, 70, "Input",
 CellID->75201933],
Cell[8606, 314, 700, 24, 51, "Output",
 CellID->385154683]
}, Open  ]],
Cell[CellGroupData[{
Cell[9343, 343, 152, 5, 70, "Input",
 CellID->131969966],
Cell[9498, 350, 258, 7, 36, "Output",
 CellID->67739868]
}, Open  ]],
Cell[CellGroupData[{
Cell[9793, 362, 260, 8, 70, "Input",
 CellID->133278707],
Cell[10056, 372, 260, 7, 36, "Output",
 CellID->753197378]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10377, 386, 313, 9, 70, "TutorialsSection",
 CellID->4907],
Cell[10693, 397, 160, 3, 70, "Tutorials",
 CellID->32621]
}, Open  ]],
Cell[10868, 403, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

