(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17448,        597]
NotebookOptionsPosition[     14214,        489]
NotebookOutlinePosition[     15602,        527]
CellTagsIndexPosition[     15517,        522]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["FOURIER SERIES PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Fourier Series Package" :> 
          Documentation`HelpLookup[
           "paclet:FourierSeries/tutorial/FourierSeries"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Fourier Series Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FourierCoefficient" :> 
          Documentation`HelpLookup[
           "paclet:FourierSeries/ref/FourierCoefficient"], 
          "FourierSinCoefficient" :> 
          Documentation`HelpLookup[
           "paclet:FourierSeries/ref/FourierSinCoefficient"], 
          "FourierCosCoefficient" :> 
          Documentation`HelpLookup[
           "paclet:FourierSeries/ref/FourierCosCoefficient"], 
          "NFourierCoefficient" :> 
          Documentation`HelpLookup[
           "paclet:FourierSeries/ref/NFourierCoefficient"], 
          "NFourierSinCoefficient" :> 
          Documentation`HelpLookup[
           "paclet:FourierSeries/ref/NFourierSinCoefficient"], 
          "NFourierCosCoefficient" :> 
          Documentation`HelpLookup[
           "paclet:FourierSeries/ref/NFourierCosCoefficient"], 
          "NInverseFourierCoefficient" :> 
          Documentation`HelpLookup[
           "paclet:FourierSeries/ref/NInverseFourierCoefficient"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"FourierCoefficient\"\>", 
       2->"\<\"FourierSinCoefficient\"\>", 3->"\<\"FourierCosCoefficient\"\>",
        4->"\<\"NFourierCoefficient\"\>", 5->"\<\"NFourierSinCoefficient\"\>",
        6->"\<\"NFourierCosCoefficient\"\>", 
       7->"\<\"NInverseFourierCoefficient\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["InverseFourierCoefficient", "ObjectName",
 CellID->32444],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"InverseFourierCoefficient", "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["n", "TI"], ",", 
        StyleBox["t", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the function of ",
     Cell[BoxData[
      StyleBox["t", "TI"]], "InlineFormula"],
     " whose Fourier exponential series representation has coefficients given \
by ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ", where ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " is a function of ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->29897]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The Fourier exponential series representation used by ",
 Cell[BoxData["InverseFourierCoefficient"], "InlineFormula"],
 " is by default defined to be ",
 Cell[BoxData[
  RowBox[{
   UnderoverscriptBox["\[Sum]", 
    RowBox[{
     StyleBox["n", "TI"], "=", 
     RowBox[{"-", "\[Infinity]"}]}], "\[Infinity]"], 
   RowBox[{
    StyleBox["expr", "TI"], " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "2"}], 
      StyleBox["\[Pi]", "TR"], " ", "\[ImaginaryI]", " ", 
      StyleBox["n", "TI"], " ", 
      StyleBox["t", "TI"]}]]}]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->1201],

Cell[TextData[{
 Cell[BoxData["InverseFourierCoefficient"], "InlineFormula"],
 " returns a periodic function of ",
 Cell[BoxData[
  StyleBox["t", "TI"]], "InlineFormula"],
 " with default period 1."
}], "Notes",
 CellID->3328],

Cell[TextData[{
 "Different choices for the definition of the Fourier exponential series \
representation can be specified using the option ",
 Cell[BoxData[
  ButtonBox["FourierParameters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FourierParameters"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->24942],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FourierParameters",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FourierParameters"], "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"]}], "}"}]}]], "InlineFormula"],
 ", the Fourier exponential series representation used by ",
 Cell[BoxData["InverseFourierCoefficient"], "InlineFormula"],
 " is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox[
     StyleBox[
      RowBox[{"\[LeftBracketingBar]", "b", "\[RightBracketingBar]"}], "TI"], 
     FractionBox[
      RowBox[{"1", "+", 
       StyleBox["a", "TI"]}], "2"]], " ", 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{
       StyleBox["n", "TI"], "=", 
       RowBox[{"-", "\[Infinity]"}]}], "\[Infinity]"], 
     RowBox[{
      StyleBox["expr", "TI"], " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "2"}], " ", 
        StyleBox["\[Pi]", "TR"], " ", "\[ImaginaryI]", " ", 
        StyleBox["b", "TI"], " ", 
        StyleBox["n", "TI"], " ", 
        StyleBox["t", "TI"]}]]}]}]}], TraditionalForm]], "InlineFormula"],
 ", a periodic function of ",
 Cell[BoxData[
  StyleBox["t", "TI"]], "InlineFormula"],
 " with period ",
 Cell[BoxData[
  FractionBox["1", 
   RowBox[{"\[VerticalSeparator]", 
    StyleBox["b", "TI"], "\[VerticalSeparator]"}]]], "InlineFormula"],
 "."
}], "Notes",
 CellID->7104]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->159210010],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->129458412],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<FourierSeries`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->855103247],

Cell["Find a function with a given Fourier series:", "ExampleText",
 CellID->320560372],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierCoefficient", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"3", "n"}], "+", "1"}], ")"}], "^", "2"}]}], ",", " ", "n", 
   ",", " ", "t"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->48328544],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "9"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"LerchPhi", "[", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", "\[Pi]", " ", "t"}]], 
      ",", "2", ",", 
      FractionBox["1", "3"]}], "]"}], "+", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Pi]", " ", "t"}]], " ", 
     RowBox[{"LerchPhi", "[", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Pi]", " ", "t"}]], ",", 
       "2", ",", 
       FractionBox["2", "3"]}], "]"}]}]}], ")"}]}]], "Output",
 ImageSize->{378, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->557566962]
}, Open  ]],

Cell["Compare with the answer from a numerical approximation:", "ExampleText",
 CellID->67562546],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierCoefficient", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"3", "n"}], "+", "1"}], ")"}], "^", "2"}]}], ",", " ", "n", 
   ",", " ", "t"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->8319193],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "9"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"LerchPhi", "[", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", "\[Pi]", " ", "t"}]], 
      ",", "2", ",", 
      FractionBox["1", "3"]}], "]"}], "+", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Pi]", " ", "t"}]], " ", 
     RowBox[{"LerchPhi", "[", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Pi]", " ", "t"}]], ",", 
       "2", ",", 
       FractionBox["2", "3"]}], "]"}]}]}], ")"}]}]], "Output",
 ImageSize->{378, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->368099296]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{"{", 
   RowBox[{"t", "\[Rule]", " ", "0.6"}], "}"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->18739961],

Cell[BoxData[
 RowBox[{"0.7677604180046728`", "\[InvisibleSpace]", "-", 
  RowBox[{"0.09571950111741324`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{140, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->20477726]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NInverseFourierCoefficient", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"3", "n"}], "+", "1"}], ")"}], "^", "2"}]}], ",", " ", "n", 
   ",", " ", "0.6"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->351988020],

Cell[BoxData[
 RowBox[{"0.7677604180046727`", "\[InvisibleSpace]", "-", 
  RowBox[{"0.0957195011174132`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{140, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->214182947]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->11262],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FourierCoefficient",
    BaseStyle->"Link",
    ButtonData->"paclet:FourierSeries/ref/FourierCoefficient"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FourierSinCoefficient",
    BaseStyle->"Link",
    ButtonData->"paclet:FourierSeries/ref/FourierSinCoefficient"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FourierCosCoefficient",
    BaseStyle->"Link",
    ButtonData->"paclet:FourierSeries/ref/FourierCosCoefficient"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NFourierCoefficient",
    BaseStyle->"Link",
    ButtonData->"paclet:FourierSeries/ref/NFourierCoefficient"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NFourierSinCoefficient",
    BaseStyle->"Link",
    ButtonData->"paclet:FourierSeries/ref/NFourierSinCoefficient"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NFourierCosCoefficient",
    BaseStyle->"Link",
    ButtonData->"paclet:FourierSeries/ref/NFourierCosCoefficient"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NInverseFourierCoefficient",
    BaseStyle->"Link",
    ButtonData->"paclet:FourierSeries/ref/NInverseFourierCoefficient"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->10720]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->1768],

Cell[TextData[ButtonBox["Fourier Series Package",
 BaseStyle->"Link",
 ButtonData->"paclet:FourierSeries/tutorial/FourierSeries"]], "Tutorials",
 CellID->29768]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"InverseFourierCoefficient - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 58, 11.0995494}", "context" -> 
    "FourierSeries`", "keywords" -> {}, "index" -> True, "label" -> 
    "Fourier Series Package Symbol", "language" -> "en", "paclet" -> 
    "FourierSeries Package", "status" -> "None", "summary" -> 
    "InverseFourierCoefficient[expr, n, t] gives the function of t whose \
Fourier exponential series representation has coefficients given by expr, \
where expr is a function of n.", "synonyms" -> {}, "title" -> 
    "InverseFourierCoefficient", "type" -> "Symbol", "uri" -> 
    "FourierSeries/ref/InverseFourierCoefficient"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7075, 228, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->159210010]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 15374, 515}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2319, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2942, 81, 63, 1, 70, "ObjectName",
 CellID->32444],
Cell[3008, 84, 891, 28, 70, "Usage",
 CellID->29897]
}, Open  ]],
Cell[CellGroupData[{
Cell[3936, 117, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4414, 134, 632, 20, 70, "Notes",
 CellID->1201],
Cell[5049, 156, 226, 7, 70, "Notes",
 CellID->3328],
Cell[5278, 165, 314, 9, 70, "Notes",
 CellID->24942],
Cell[5595, 176, 1443, 47, 70, "Notes",
 CellID->7104]
}, Closed]],
Cell[CellGroupData[{
Cell[7075, 228, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->159210010],
Cell[CellGroupData[{
Cell[7460, 242, 148, 5, 70, "ExampleSection",
 CellID->129458412],
Cell[7611, 249, 138, 4, 70, "Input",
 CellID->855103247],
Cell[7752, 255, 87, 1, 70, "ExampleText",
 CellID->320560372],
Cell[CellGroupData[{
Cell[7864, 260, 292, 10, 28, "Input",
 CellID->48328544],
Cell[8159, 272, 830, 25, 51, "Output",
 CellID->557566962]
}, Open  ]],
Cell[9004, 300, 97, 1, 70, "ExampleText",
 CellID->67562546],
Cell[CellGroupData[{
Cell[9126, 305, 291, 10, 70, "Input",
 CellID->8319193],
Cell[9420, 317, 830, 25, 51, "Output",
 CellID->368099296]
}, Open  ]],
Cell[CellGroupData[{
Cell[10287, 347, 152, 5, 70, "Input",
 CellID->18739961],
Cell[10442, 354, 273, 7, 36, "Output",
 CellID->20477726]
}, Open  ]],
Cell[CellGroupData[{
Cell[10752, 366, 296, 10, 70, "Input",
 CellID->351988020],
Cell[11051, 378, 273, 7, 36, "Output",
 CellID->214182947]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11385, 392, 311, 9, 70, "SeeAlsoSection",
 CellID->11262],
Cell[11699, 403, 1960, 62, 70, "SeeAlso",
 CellID->10720]
}, Open  ]],
Cell[CellGroupData[{
Cell[13696, 470, 313, 9, 70, "TutorialsSection",
 CellID->1768],
Cell[14012, 481, 160, 3, 70, "Tutorials",
 CellID->29768]
}, Open  ]],
Cell[14187, 487, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

