(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14831,        542]
NotebookOptionsPosition[     11549,        432]
NotebookOutlinePosition[     12940,        470]
CellTagsIndexPosition[     12855,        465]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["FOURIER SERIES PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[
    Cell[BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Fourier Series Package" :> 
         Documentation`HelpLookup[
          "paclet:FourierSeries/tutorial/FourierSeries"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"Fourier Series Package\"\>"}, "\<\"tutorials\"\>",
       
      StyleBox["\<\"tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NDTFourierTransform", "ObjectName",
 CellID->19104],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"NDTFourierTransform", "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["n", "TI"], ",", 
        StyleBox["\[Omega]", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a numerical approximation to the discrete time \
Fourier transform of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " evaluated at the numerical value ",
     Cell[BoxData[
      StyleBox["\[Omega]", "TR"]], "InlineFormula"],
     ", where ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " is a function of ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->484]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The numerical approximation to the discrete time Fourier transform of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " is by default defined to be ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["NSum",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NSum"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["expr", "TI"], " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"2", 
       StyleBox["\[Pi]", "TR"], " ", "\[ImaginaryI]", " ", 
       StyleBox["n", "TI"], " ", 
       StyleBox["\[Omega]", "TR"]}]]}], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["n", "TI"], ",", 
      RowBox[{"-", "\[Infinity]"}], ",", "\[Infinity]"}], "}"}]}], "]"}]], 
  "InlineFormula"],
 "."
}], "Notes",
 CellID->2943],

Cell[TextData[{
 "Different choices for the definition of the discrete time Fourier transform \
can be specified using the option ",
 Cell[BoxData[
  ButtonBox["FourierParameters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FourierParameters"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->11495],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FourierParameters",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FourierParameters"], "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"]}], "}"}]}]], "InlineFormula"],
 ", the discrete time Fourier transform computed by ",
 Cell[BoxData["NDTFourierTransform"], "InlineFormula"],
 " is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox[
     StyleBox[
      RowBox[{"\[LeftBracketingBar]", "b", "\[RightBracketingBar]"}], "TI"], 
     FractionBox[
      RowBox[{"1", "-", 
       StyleBox["a", "TI"]}], "2"]], " ", 
    RowBox[{
     ButtonBox["NSum",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NSum"], "[", 
     RowBox[{
      RowBox[{
       StyleBox["expr", "TI"], "  ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", 
         StyleBox["\[Pi]", "TR"], " ", "\[ImaginaryI]", " ", 
         StyleBox["b", "TI"], " ", 
         StyleBox["n", "TI"], " ", 
         StyleBox["\[Omega]", "TR"]}]]}], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        RowBox[{"-", "\[Infinity]"}], ",", "\[Infinity]"}], "}"}]}], "]"}]}], 
   TraditionalForm]], "InlineFormula"],
 "."
}], "Notes",
 CellID->26811],

Cell[TextData[{
 "The parameter ",
 Cell[BoxData[
  StyleBox["b", "TI"]], "InlineFormula"],
 " in the setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FourierParameters",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FourierParameters"], "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"]}], "}"}]}]], "InlineFormula"],
 " must be numeric."
}], "Notes",
 CellID->1293],

Cell[TextData[{
 "In addition to the option ",
 Cell[BoxData[
  ButtonBox["FourierParameters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FourierParameters"]], "InlineFormula"],
 ", ",
 Cell[BoxData["NDTFourierTransform"], "InlineFormula"],
 " can also accept the options available to ",
 Cell[BoxData[
  ButtonBox["NSum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NSum"]], "InlineFormula"],
 ". These options are passed directly to ",
 Cell[BoxData[
  ButtonBox["NSum",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NSum"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->28892]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->508726179],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->87568247],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<FourierSeries`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->506372635],

Cell["\<\
Different definitions for numerical approximation of a discrete time Fourier \
transform:\
\>", "ExampleText",
 CellID->181216435],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDTFourierTransform", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"3", "n"}], "+", "5"}], ")"}], "^", "2"}]}], ",", " ", "n", 
   ",", "0.7"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->741030034],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "0.8041899882369108`"}], "-", 
  RowBox[{"0.3798812505176039`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{141, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->636840842]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDTFourierTransform", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"3", "n"}], "+", "5"}], ")"}], "^", "2"}]}], ",", " ", "n", 
   ",", "0.7", ",", " ", 
   RowBox[{"FourierParameters", " ", "\[Rule]", " ", 
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"-", "1"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->313783340],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "0.8041899882369108`"}], "+", 
  RowBox[{"0.3798812505176039`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{141, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->596876896]
}, Open  ]],

Cell["Compare with the answer from symbolic evaluation:", "ExampleText",
 CellID->42289798],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDTFourierTransform", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"3", "n"}], "+", "5"}], ")"}], "^", "2"}]}], ",", " ", "n", 
   ",", "0.7"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->28310929],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "0.8041899882369108`"}], "-", 
  RowBox[{"0.3798812505176039`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{141, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->228929317]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DTFourierTransform", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"3", "n"}], "+", "5"}], ")"}], "^", "2"}]}], ",", " ", "n", 
   ",", "\[Omega]"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->56487296],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "36"], " ", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"-", "4"}], " ", "\[ImaginaryI]", " ", "\[Pi]", " ", 
    "\[Omega]"}]], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"9", " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Pi]", " ", "\[Omega]"}]]}], 
    "+", 
    RowBox[{"4", " ", 
     RowBox[{"LerchPhi", "[", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", "\[Pi]", " ", 
         "\[Omega]"}]], ",", "2", ",", 
       FractionBox["1", "3"]}], "]"}]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"4", " ", "\[ImaginaryI]", " ", "\[Pi]", " ", "\[Omega]"}]], 
     " ", 
     RowBox[{"LerchPhi", "[", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Pi]", " ", "\[Omega]"}]], 
       ",", "2", ",", 
       FractionBox["5", "3"]}], "]"}]}]}], ")"}]}]], "Output",
 ImageSize->{504, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->298962843]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", " ", "/.", 
  RowBox[{"{", 
   RowBox[{"\[Omega]", " ", "\[Rule]", " ", "0.7"}], "}"}]}]], "Input",
 CellLabel->"In[6]:=",
 CellID->58779399],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "0.8041899882369105`"}], "-", 
  RowBox[{"0.37988125051760396`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{141, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->44931866]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->6798],

Cell[TextData[ButtonBox["Fourier Series Package",
 BaseStyle->"Link",
 ButtonData->"paclet:FourierSeries/tutorial/FourierSeries"]], "Tutorials",
 CellID->1990]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NDTFourierTransform - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 58, 11.3026796}", "context" -> 
    "FourierSeries`", "keywords" -> {}, "index" -> True, "label" -> 
    "Fourier Series Package Symbol", "language" -> "en", "paclet" -> 
    "FourierSeries Package", "status" -> "None", "summary" -> 
    "NDTFourierTransform[expr, n, \\[Omega]] gives a numerical approximation \
to the discrete time Fourier transform of expr evaluated at the numerical \
value \\[Omega], where expr is a function of n.", "synonyms" -> {}, "title" -> 
    "NDTFourierTransform", "type" -> "Symbol", "uri" -> 
    "FourierSeries/ref/NDTFourierTransform"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6149, 222, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->508726179]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12712, 458}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 632, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1255, 43, 57, 1, 70, "ObjectName",
 CellID->19104],
Cell[1315, 46, 907, 28, 70, "Usage",
 CellID->484]
}, Open  ]],
Cell[CellGroupData[{
Cell[2259, 79, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2737, 96, 750, 25, 70, "Notes",
 CellID->2943],
Cell[3490, 123, 304, 9, 70, "Notes",
 CellID->11495],
Cell[3797, 134, 1298, 43, 70, "Notes",
 CellID->26811],
Cell[5098, 179, 418, 16, 70, "Notes",
 CellID->1293],
Cell[5519, 197, 593, 20, 70, "Notes",
 CellID->28892]
}, Closed]],
Cell[CellGroupData[{
Cell[6149, 222, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->508726179],
Cell[CellGroupData[{
Cell[6534, 236, 147, 5, 70, "ExampleSection",
 CellID->87568247],
Cell[6684, 243, 138, 4, 70, "Input",
 CellID->506372635],
Cell[6825, 249, 140, 4, 70, "ExampleText",
 CellID->181216435],
Cell[CellGroupData[{
Cell[6990, 257, 284, 10, 28, "Input",
 CellID->741030034],
Cell[7277, 269, 270, 8, 36, "Output",
 CellID->636840842]
}, Open  ]],
Cell[CellGroupData[{
Cell[7584, 282, 428, 14, 28, "Input",
 CellID->313783340],
Cell[8015, 298, 270, 8, 36, "Output",
 CellID->596876896]
}, Open  ]],
Cell[8300, 309, 91, 1, 70, "ExampleText",
 CellID->42289798],
Cell[CellGroupData[{
Cell[8416, 314, 283, 10, 70, "Input",
 CellID->28310929],
Cell[8702, 326, 270, 8, 36, "Output",
 CellID->228929317]
}, Open  ]],
Cell[CellGroupData[{
Cell[9009, 339, 287, 10, 70, "Input",
 CellID->56487296],
Cell[9299, 351, 1193, 35, 51, "Output",
 CellID->298962843]
}, Open  ]],
Cell[CellGroupData[{
Cell[10529, 391, 169, 5, 70, "Input",
 CellID->58779399],
Cell[10701, 398, 270, 8, 36, "Output",
 CellID->44931866]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11032, 413, 313, 9, 70, "TutorialsSection",
 CellID->6798],
Cell[11348, 424, 159, 3, 70, "Tutorials",
 CellID->1990]
}, Open  ]],
Cell[11522, 430, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

