(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18990,        664]
NotebookOptionsPosition[     15541,        548]
NotebookOutlinePosition[     16933,        586]
CellTagsIndexPosition[     16848,        581]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["FOURIER SERIES PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Fourier Series Package" :> 
          Documentation`HelpLookup[
           "paclet:FourierSeries/tutorial/FourierSeries"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Fourier Series Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FourierCoefficient" :> 
          Documentation`HelpLookup[
           "paclet:FourierSeries/ref/FourierCoefficient"], 
          "FourierSinCoefficient" :> 
          Documentation`HelpLookup[
           "paclet:FourierSeries/ref/FourierSinCoefficient"], 
          "FourierCosCoefficient" :> 
          Documentation`HelpLookup[
           "paclet:FourierSeries/ref/FourierCosCoefficient"], 
          "NFourierSinCoefficient" :> 
          Documentation`HelpLookup[
           "paclet:FourierSeries/ref/NFourierSinCoefficient"], 
          "NFourierCosCoefficient" :> 
          Documentation`HelpLookup[
           "paclet:FourierSeries/ref/NFourierCosCoefficient"], 
          "InverseFourierCoefficient" :> 
          Documentation`HelpLookup[
           "paclet:FourierSeries/ref/InverseFourierCoefficient"], 
          "NInverseFourierCoefficient" :> 
          Documentation`HelpLookup[
           "paclet:FourierSeries/ref/NInverseFourierCoefficient"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"FourierCoefficient\"\>", 
       2->"\<\"FourierSinCoefficient\"\>", 3->"\<\"FourierCosCoefficient\"\>",
        4->"\<\"NFourierSinCoefficient\"\>", 
       5->"\<\"NFourierCosCoefficient\"\>", 
       6->"\<\"InverseFourierCoefficient\"\>", 
       7->"\<\"NInverseFourierCoefficient\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NFourierCoefficient", "ObjectName",
 CellID->13406],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"NFourierCoefficient", "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["t", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a numerical approximation to the ",
     Cell[BoxData[
      SuperscriptBox[
       StyleBox["n", "TI"], "th"]], "InlineFormula"],
     " coefficient in the Fourier exponential series expansion of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ", where ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " is a periodic function of ",
     Cell[BoxData[
      StyleBox["t", "TI"]], "InlineFormula"],
     " with period ",
     Cell[BoxData[
      StyleBox["1", "TR"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->4510]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The numerical approximation to the ",
 Cell[BoxData[
  SuperscriptBox[
   StyleBox["n", "TI"], "th"]], "InlineFormula"],
 " coefficient in the Fourier exponential series expansion of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " is by default defined to be ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["NIntegrate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NIntegrate"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["expr", "TI"], " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"2", 
       StyleBox["\[Pi]", "TR"], " ", "\[ImaginaryI]", " ", 
       StyleBox["n", "TI"], " ", 
       StyleBox["t", "TI"]}]]}], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["t", "TI"], ",", 
      RowBox[{"-", 
       FractionBox["1", "2"]}], ",", 
      FractionBox["1", "2"]}], "}"}]}], "]"}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " must be an integer."
}], "Notes",
 CellID->25813],

Cell[TextData[{
 "Different choices for the definition of the Fourier exponential series \
expansion can be specified using the option ",
 Cell[BoxData[
  ButtonBox["FourierParameters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FourierParameters"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->14651],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FourierParameters",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FourierParameters"], "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"]}], "}"}]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " is assumed to have a period of ",
 Cell[BoxData[
  FractionBox["1", 
   RowBox[{"\[VerticalSeparator]", 
    StyleBox["b", "TI"], "\[VerticalSeparator]"}]]], "InlineFormula"],
 ", and the ",
 Cell[BoxData[
  SuperscriptBox[
   StyleBox["n", "TI"], "th"]], "InlineFormula"],
 " coefficient computed by ",
 Cell[BoxData["NFourierCoefficient"], "InlineFormula"],
 " is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox[
     StyleBox[
      RowBox[{"\[LeftBracketingBar]", "b", "\[RightBracketingBar]"}], "TI"], 
     FractionBox[
      RowBox[{"1", "-", 
       StyleBox["a", "TI"]}], "2"]], " ", 
    RowBox[{
     ButtonBox["NIntegrate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NIntegrate"], "[", 
     RowBox[{
      RowBox[{
       StyleBox["expr", "TI"], " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"2", 
         StyleBox["\[Pi]", "TR"], " ", "\[ImaginaryI]", " ", 
         StyleBox["b", "TI"], " ", 
         StyleBox["n", "TI"], " ", 
         StyleBox["t", "TI"]}]]}], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["t", "TI"], ",", 
        RowBox[{"-", 
         FractionBox["1", 
          RowBox[{"2", "\[VerticalSeparator]", 
           StyleBox["b", "TI"], "\[VerticalSeparator]"}]]}], ",", 
        FractionBox["1", 
         RowBox[{"2", "\[VerticalSeparator]", 
          StyleBox["b", "TI"], "\[VerticalSeparator]"}]]}], "}"}]}], "]"}]}], 
   TraditionalForm]], "InlineFormula"],
 "."
}], "Notes",
 CellID->25880],

Cell[TextData[{
 "The parameter ",
 Cell[BoxData[
  StyleBox["b", "TI"]], "InlineFormula"],
 " in the setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FourierParameters",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FourierParameters"], "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"]}], "}"}]}]], "InlineFormula"],
 " must be numeric."
}], "Notes",
 CellID->27844],

Cell[TextData[{
 "In addition to the option ",
 Cell[BoxData[
  ButtonBox["FourierParameters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FourierParameters"]], "InlineFormula"],
 ", ",
 Cell[BoxData["NFourierCoefficient"], "InlineFormula"],
 " can also accept the options available to ",
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 ". These options are passed directly to ",
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->24743]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->433680050],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->245687254],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<FourierSeries`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->3707510],

Cell["\<\
Use different definitions for calculating numerical approximation for a \
Fourier coefficient:\
\>", "ExampleText",
 CellID->320560372],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NFourierCoefficient", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"t", "^", "2"}], "+", 
    RowBox[{"3", "t"}]}], ",", "t", ",", "5"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->60547135],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "0.0020264236728467335`"}], "+", 
  RowBox[{"0.09549296585513703`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{162, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->82980290]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NFourierCoefficient", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"t", "^", "2"}], "+", 
    RowBox[{"3", "t"}]}], ",", "t", ",", "5", ",", 
   RowBox[{"FourierParameters", " ", "\[Rule]", " ", 
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"-", "1"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->107291147],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "0.0020264236728467335`"}], "-", 
  RowBox[{"0.09549296585513703`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{162, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->43096061]
}, Open  ]],

Cell["Compare with the answer from symbolic evaluation:", "ExampleText",
 CellID->67562546],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NFourierCoefficient", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"t", "^", "2"}], "+", 
    RowBox[{"3", "t"}]}], ",", "t", ",", "5"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->713085727],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "0.0020264236728467335`"}], "+", 
  RowBox[{"0.09549296585513703`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{162, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->318468599]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierCoefficient", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"t", "^", "2"}], "+", 
    RowBox[{"3", "t"}]}], ",", "t", ",", "n"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->165513799],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"-", "1"}], ")"}], 
    RowBox[{"Abs", "[", "n", "]"}]], " ", 
   RowBox[{"(", 
    RowBox[{"1", "-", 
     RowBox[{"3", " ", "\[ImaginaryI]", " ", "n", " ", "\[Pi]"}]}], ")"}]}], 
  RowBox[{"2", " ", 
   SuperscriptBox["n", "2"], " ", 
   SuperscriptBox["\[Pi]", "2"]}]]], "Output",
 ImageSize->{143, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->98694704]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{"{", 
   RowBox[{"n", "\[Rule]", " ", "5."}], "}"}]}]], "Input",
 CellLabel->"In[6]:=",
 CellID->151253485],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "0.0020264236728467556`"}], "+", 
  RowBox[{"0.0954929658551372`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{162, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->772141112]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->21705],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FourierCoefficient",
    BaseStyle->"Link",
    ButtonData->"paclet:FourierSeries/ref/FourierCoefficient"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FourierSinCoefficient",
    BaseStyle->"Link",
    ButtonData->"paclet:FourierSeries/ref/FourierSinCoefficient"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FourierCosCoefficient",
    BaseStyle->"Link",
    ButtonData->"paclet:FourierSeries/ref/FourierCosCoefficient"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NFourierSinCoefficient",
    BaseStyle->"Link",
    ButtonData->"paclet:FourierSeries/ref/NFourierSinCoefficient"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NFourierCosCoefficient",
    BaseStyle->"Link",
    ButtonData->"paclet:FourierSeries/ref/NFourierCosCoefficient"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseFourierCoefficient",
    BaseStyle->"Link",
    ButtonData->"paclet:FourierSeries/ref/InverseFourierCoefficient"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NInverseFourierCoefficient",
    BaseStyle->"Link",
    ButtonData->"paclet:FourierSeries/ref/NInverseFourierCoefficient"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->24514]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->7741],

Cell[TextData[ButtonBox["Fourier Series Package",
 BaseStyle->"Link",
 ButtonData->"paclet:FourierSeries/tutorial/FourierSeries"]], "Tutorials",
 CellID->11245]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NFourierCoefficient - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 58, 11.4901844}", "context" -> 
    "FourierSeries`", "keywords" -> {}, "index" -> True, "label" -> 
    "Fourier Series Package Symbol", "language" -> "en", "paclet" -> 
    "FourierSeries Package", "status" -> "None", "summary" -> 
    "NFourierCoefficient[expr, t, n] gives a numerical approximation to the \
n^th coefficient in the Fourier exponential series expansion of expr, where \
expr is a periodic function of t with period 1.", "synonyms" -> {}, "title" -> 
    "NFourierCoefficient", "type" -> "Symbol", "uri" -> 
    "FourierSeries/ref/NFourierCoefficient"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8785, 290, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->433680050]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 16705, 574}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2345, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2968, 82, 57, 1, 70, "ObjectName",
 CellID->13406],
Cell[3028, 85, 1009, 31, 70, "Usage",
 CellID->4510]
}, Open  ]],
Cell[CellGroupData[{
Cell[4074, 121, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4552, 138, 986, 33, 70, "Notes",
 CellID->25813],
Cell[5541, 173, 309, 9, 70, "Notes",
 CellID->14651],
Cell[5853, 184, 1853, 61, 70, "Notes",
 CellID->25880],
Cell[7709, 247, 419, 16, 70, "Notes",
 CellID->27844],
Cell[8131, 265, 617, 20, 70, "Notes",
 CellID->24743]
}, Closed]],
Cell[CellGroupData[{
Cell[8785, 290, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->433680050],
Cell[CellGroupData[{
Cell[9170, 304, 148, 5, 70, "ExampleSection",
 CellID->245687254],
Cell[9321, 311, 136, 4, 70, "Input",
 CellID->3707510],
Cell[9460, 317, 145, 4, 70, "ExampleText",
 CellID->320560372],
Cell[CellGroupData[{
Cell[9630, 325, 216, 7, 28, "Input",
 CellID->60547135],
Cell[9849, 334, 273, 8, 36, "Output",
 CellID->82980290]
}, Open  ]],
Cell[CellGroupData[{
Cell[10159, 347, 356, 11, 28, "Input",
 CellID->107291147],
Cell[10518, 360, 273, 8, 36, "Output",
 CellID->43096061]
}, Open  ]],
Cell[10806, 371, 91, 1, 70, "ExampleText",
 CellID->67562546],
Cell[CellGroupData[{
Cell[10922, 376, 217, 7, 70, "Input",
 CellID->713085727],
Cell[11142, 385, 274, 8, 36, "Output",
 CellID->318468599]
}, Open  ]],
Cell[CellGroupData[{
Cell[11453, 398, 216, 7, 70, "Input",
 CellID->165513799],
Cell[11672, 407, 502, 17, 56, "Output",
 CellID->98694704]
}, Open  ]],
Cell[CellGroupData[{
Cell[12211, 429, 152, 5, 70, "Input",
 CellID->151253485],
Cell[12366, 436, 273, 8, 36, "Output",
 CellID->772141112]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12700, 451, 311, 9, 70, "SeeAlsoSection",
 CellID->21705],
Cell[13014, 462, 1972, 62, 70, "SeeAlso",
 CellID->24514]
}, Open  ]],
Cell[CellGroupData[{
Cell[15023, 529, 313, 9, 70, "TutorialsSection",
 CellID->7741],
Cell[15339, 540, 160, 3, 70, "Tutorials",
 CellID->11245]
}, Open  ]],
Cell[15514, 546, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

