(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     19067,        673]
NotebookOptionsPosition[     15612,        557]
NotebookOutlinePosition[     17009,        595]
CellTagsIndexPosition[     16924,        590]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["FOURIER SERIES PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Fourier Series Package" :> 
          Documentation`HelpLookup[
           "paclet:FourierSeries/tutorial/FourierSeries"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Fourier Series Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FourierCoefficient" :> 
          Documentation`HelpLookup[
           "paclet:FourierSeries/ref/FourierCoefficient"], 
          "FourierSinCoefficient" :> 
          Documentation`HelpLookup[
           "paclet:FourierSeries/ref/FourierSinCoefficient"], 
          "FourierCosCoefficient" :> 
          Documentation`HelpLookup[
           "paclet:FourierSeries/ref/FourierCosCoefficient"], 
          "NFourierCoefficient" :> 
          Documentation`HelpLookup[
           "paclet:FourierSeries/ref/NFourierCoefficient"], 
          "NFourierCosCoefficient" :> 
          Documentation`HelpLookup[
           "paclet:FourierSeries/ref/NFourierCosCoefficient"], 
          "InverseFourierCoefficient" :> 
          Documentation`HelpLookup[
           "paclet:FourierSeries/ref/InverseFourierCoefficient"], 
          "NInverseFourierCoefficient" :> 
          Documentation`HelpLookup[
           "paclet:FourierSeries/ref/NInverseFourierCoefficient"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"FourierCoefficient\"\>", 
       2->"\<\"FourierSinCoefficient\"\>", 3->"\<\"FourierCosCoefficient\"\>",
        4->"\<\"NFourierCoefficient\"\>", 5->"\<\"NFourierCosCoefficient\"\>",
        6->"\<\"InverseFourierCoefficient\"\>", 
       7->"\<\"NInverseFourierCoefficient\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NFourierSinCoefficient", "ObjectName",
 CellID->29795],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"NFourierSinCoefficient", "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["t", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a numerical approximation to the ",
     Cell[BoxData[
      SuperscriptBox[
       StyleBox["n", "TI"], "th"]], "InlineFormula"],
     " coefficient in the Fourier sine series expansion of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ", where ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " is a periodic function of ",
     Cell[BoxData[
      StyleBox["t", "TI"]], "InlineFormula"],
     " with period ",
     Cell[BoxData[
      StyleBox["1", "TR"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->30742]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The numerical approximation to the ",
 Cell[BoxData[
  SuperscriptBox[
   StyleBox["n", "TI"], "th"]], "InlineFormula"],
 " coefficient in the Fourier sine series expansion of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " is by default defined to be ",
 Cell[BoxData[
  RowBox[{"2", 
   RowBox[{"NIntegrate", "[", 
    RowBox[{
     RowBox[{
      StyleBox["expr", "TI"], " ", 
      RowBox[{
       ButtonBox["Sin",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Sin"], "[", 
       RowBox[{"2", 
        StyleBox["\[Pi]", "TR"], " ", 
        StyleBox["n", "TI"], " ", 
        StyleBox["t", "TI"]}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{
       StyleBox["t", "TI"], ",", 
       RowBox[{"-", 
        FractionBox["1", "2"]}], ",", 
       FractionBox["1", "2"]}], "}"}]}], "]"}]}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " must be an integer."
}], "Notes",
 CellID->30037],

Cell[TextData[{
 "Different choices for the definition of the Fourier sine series expansion \
can be specified using the option ",
 Cell[BoxData[
  ButtonBox["FourierParameters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FourierParameters"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->5506],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FourierParameters",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FourierParameters"], "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"]}], "}"}]}]], "InlineFormula"],
 ",",
 " ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " is assumed to have a period of ",
 Cell[BoxData[
  FractionBox["1", 
   RowBox[{"\[VerticalSeparator]", 
    StyleBox["b", "TI"], "\[VerticalSeparator]"}]]], "InlineFormula"],
 ", and",
 " the ",
 Cell[BoxData[
  SuperscriptBox[
   StyleBox["n", "TI"], "th"]], "InlineFormula"],
 " coefficient computed by ",
 Cell[BoxData["NFourierSinCoefficient"], "InlineFormula"],
 " is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["2", "TR"], 
    SuperscriptBox[
     StyleBox[
      RowBox[{"\[LeftBracketingBar]", "b", "\[RightBracketingBar]"}], "TI"], 
     FractionBox[
      RowBox[{"1", "-", 
       StyleBox["a", "TI"]}], "2"]], " ", 
    RowBox[{
     ButtonBox["NIntegrate",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NIntegrate"], "[", 
     RowBox[{
      RowBox[{
       StyleBox["expr", "TI"], " ", 
       RowBox[{
        ButtonBox["Sin",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/Sin"], "[", 
        RowBox[{"2", 
         StyleBox["\[Pi]", "TR"], " ", 
         StyleBox["b", "TI"], " ", 
         StyleBox["n", "TI"], " ", 
         StyleBox["t", "TI"]}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["t", "TI"], ",", 
        RowBox[{"-", 
         FractionBox["1", 
          RowBox[{"2", "\[VerticalSeparator]", 
           StyleBox["b", "TI"], "\[VerticalSeparator]"}]]}], ",", 
        FractionBox["1", 
         RowBox[{"2", "\[VerticalSeparator]", 
          StyleBox["b", "TI"], "\[VerticalSeparator]"}]]}], "}"}]}], "]"}]}], 
   TraditionalForm]], "InlineFormula"],
 "."
}], "Notes",
 CellID->6767],

Cell[TextData[{
 "The parameter ",
 Cell[BoxData[
  StyleBox["b", "TI"]], "InlineFormula"],
 " in the setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FourierParameters",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FourierParameters"], "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"]}], "}"}]}]], "InlineFormula"],
 " must be numeric."
}], "Notes",
 CellID->5053],

Cell[TextData[{
 "In addition to the option ",
 Cell[BoxData[
  ButtonBox["FourierParameters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FourierParameters"]], "InlineFormula"],
 ", ",
 Cell[BoxData["NFourierSinCoefficient"], "InlineFormula"],
 " can also accept the options available to ",
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 ". These options are passed directly to ",
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->9793]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->542691269],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->190800037],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<FourierSeries`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->303069652],

Cell["\<\
Use different definitions for calculating numerical approximation for a \
Fourier sine coefficient:\
\>", "ExampleText",
 CellID->320560372],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NFourierSinCoefficient", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Abs", "[", "t", "]"}], "+", 
    RowBox[{"E", "^", 
     RowBox[{"(", 
      RowBox[{"-", "t"}], ")"}]}]}], ",", "t", ",", "3"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->84235003],

Cell[BoxData[
 RowBox[{"-", "0.1102695072275276`"}]], "Output",
 ImageSize->{61, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->146311584]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NFourierSinCoefficient", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Abs", "[", "t", "]"}], "+", 
    RowBox[{"E", "^", 
     RowBox[{"(", 
      RowBox[{"-", "t"}], ")"}]}]}], ",", "t", ",", "3", ",", 
   RowBox[{"FourierParameters", " ", "\[Rule]", " ", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->181680556],

Cell[BoxData[
 RowBox[{"-", "0.02678415342250215`"}]], "Output",
 ImageSize->{75, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->142395035]
}, Open  ]],

Cell["Compare with the answer from symbolic evaluation:", "ExampleText",
 CellID->67562546],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NFourierSinCoefficient", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Abs", "[", "t", "]"}], "+", 
    RowBox[{"E", "^", 
     RowBox[{"(", 
      RowBox[{"-", "t"}], ")"}]}]}], ",", "t", ",", "3"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->198367830],

Cell[BoxData[
 RowBox[{"-", "0.1102695072275276`"}]], "Output",
 ImageSize->{61, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->389922387]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierSinCoefficient", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Abs", "[", "t", "]"}], "+", 
    RowBox[{"E", "^", 
     RowBox[{"(", 
      RowBox[{"-", "t"}], ")"}]}]}], ",", "t", ",", "n"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->53220470],

Cell[BoxData[
 FractionBox[
  RowBox[{"4", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"-", "1"}], ")"}], "n"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "\[ExponentialE]"}], ")"}], " ", "n", " ", 
   "\[Pi]"}], 
  RowBox[{
   SqrtBox["\[ExponentialE]"], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     RowBox[{"4", " ", 
      SuperscriptBox["n", "2"], " ", 
      SuperscriptBox["\[Pi]", "2"]}]}], ")"}]}]]], "Output",
 ImageSize->{125, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->378351853]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{"{", 
   RowBox[{"n", "\[Rule]", " ", "3."}], "}"}]}]], "Input",
 CellLabel->"In[6]:=",
 CellID->502359097],

Cell[BoxData[
 RowBox[{"-", "0.11026950722752737`"}]], "Output",
 ImageSize->{61, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->78717706]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->19854],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FourierCoefficient",
    BaseStyle->"Link",
    ButtonData->"paclet:FourierSeries/ref/FourierCoefficient"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FourierSinCoefficient",
    BaseStyle->"Link",
    ButtonData->"paclet:FourierSeries/ref/FourierSinCoefficient"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FourierCosCoefficient",
    BaseStyle->"Link",
    ButtonData->"paclet:FourierSeries/ref/FourierCosCoefficient"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NFourierCoefficient",
    BaseStyle->"Link",
    ButtonData->"paclet:FourierSeries/ref/NFourierCoefficient"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NFourierCosCoefficient",
    BaseStyle->"Link",
    ButtonData->"paclet:FourierSeries/ref/NFourierCosCoefficient"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseFourierCoefficient",
    BaseStyle->"Link",
    ButtonData->"paclet:FourierSeries/ref/InverseFourierCoefficient"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NInverseFourierCoefficient",
    BaseStyle->"Link",
    ButtonData->"paclet:FourierSeries/ref/NInverseFourierCoefficient"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->29465]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->28505],

Cell[TextData[ButtonBox["Fourier Series Package",
 BaseStyle->"Link",
 ButtonData->"paclet:FourierSeries/tutorial/FourierSeries"]], "Tutorials",
 CellID->24146]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NFourierSinCoefficient - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 58, 12.5214608}", "context" -> 
    "FourierSeries`", "keywords" -> {}, "index" -> True, "label" -> 
    "Fourier Series Package Symbol", "language" -> "en", "paclet" -> 
    "FourierSeries Package", "status" -> "None", "summary" -> 
    "NFourierSinCoefficient[expr, t, n] gives a numerical approximation to \
the n^th coefficient in the Fourier sine series expansion of expr, where expr \
is a periodic function of t with period 1.", "synonyms" -> {}, "title" -> 
    "NFourierSinCoefficient", "type" -> "Symbol", "uri" -> 
    "FourierSeries/ref/NFourierSinCoefficient"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8857, 296, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->542691269]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 16781, 583}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2328, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2951, 81, 60, 1, 70, "ObjectName",
 CellID->29795],
Cell[3014, 84, 1006, 31, 70, "Usage",
 CellID->30742]
}, Open  ]],
Cell[CellGroupData[{
Cell[4057, 120, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4535, 137, 987, 34, 70, "Notes",
 CellID->30037],
Cell[5525, 173, 301, 9, 70, "Notes",
 CellID->5506],
Cell[5829, 184, 1948, 67, 70, "Notes",
 CellID->6767],
Cell[7780, 253, 418, 16, 70, "Notes",
 CellID->5053],
Cell[8201, 271, 619, 20, 70, "Notes",
 CellID->9793]
}, Closed]],
Cell[CellGroupData[{
Cell[8857, 296, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->542691269],
Cell[CellGroupData[{
Cell[9242, 310, 148, 5, 70, "ExampleSection",
 CellID->190800037],
Cell[9393, 317, 138, 4, 70, "Input",
 CellID->303069652],
Cell[9534, 323, 150, 4, 70, "ExampleText",
 CellID->320560372],
Cell[CellGroupData[{
Cell[9709, 331, 279, 9, 28, "Input",
 CellID->84235003],
Cell[9991, 342, 193, 6, 36, "Output",
 CellID->146311584]
}, Open  ]],
Cell[CellGroupData[{
Cell[10221, 353, 397, 12, 28, "Input",
 CellID->181680556],
Cell[10621, 367, 194, 6, 36, "Output",
 CellID->142395035]
}, Open  ]],
Cell[10830, 376, 91, 1, 70, "ExampleText",
 CellID->67562546],
Cell[CellGroupData[{
Cell[10946, 381, 280, 9, 70, "Input",
 CellID->198367830],
Cell[11229, 392, 193, 6, 36, "Output",
 CellID->389922387]
}, Open  ]],
Cell[CellGroupData[{
Cell[11459, 403, 278, 9, 70, "Input",
 CellID->53220470],
Cell[11740, 414, 590, 21, 60, "Output",
 CellID->378351853]
}, Open  ]],
Cell[CellGroupData[{
Cell[12367, 440, 152, 5, 70, "Input",
 CellID->502359097],
Cell[12522, 447, 193, 6, 36, "Output",
 CellID->78717706]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12776, 460, 311, 9, 70, "SeeAlsoSection",
 CellID->19854],
Cell[13090, 471, 1966, 62, 70, "SeeAlso",
 CellID->29465]
}, Open  ]],
Cell[CellGroupData[{
Cell[15093, 538, 314, 9, 70, "TutorialsSection",
 CellID->28505],
Cell[15410, 549, 160, 3, 70, "Tutorials",
 CellID->24146]
}, Open  ]],
Cell[15585, 555, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

