(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15603,        553]
NotebookOptionsPosition[     12430,        449]
NotebookOutlinePosition[     13854,        487]
CellTagsIndexPosition[     13769,        482]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["FOURIER SERIES PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Fourier Series Package" :> 
          Documentation`HelpLookup[
           "paclet:FourierSeries/tutorial/FourierSeries"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Fourier Series Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NFourierTransform" :> 
          Documentation`HelpLookup[
           "paclet:FourierSeries/ref/NFourierTransform"], 
          "NInverseFourierTransform" :> 
          Documentation`HelpLookup[
           "paclet:FourierSeries/ref/NInverseFourierTransform"], 
          "NFourierSinTransform" :> 
          Documentation`HelpLookup[
           "paclet:FourierSeries/ref/NFourierSinTransform"], 
          "NFourierCosTransform" :> 
          Documentation`HelpLookup[
           "paclet:FourierSeries/ref/NFourierCosTransform"], 
          "NInverseFourierSinTransform" :> 
          Documentation`HelpLookup[
           "paclet:FourierSeries/ref/NInverseFourierSinTransform"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"NFourierTransform\"\>", 
       2->"\<\"NInverseFourierTransform\"\>", 
       3->"\<\"NFourierSinTransform\"\>", 4->"\<\"NFourierCosTransform\"\>", 
       5->"\<\"NInverseFourierSinTransform\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NInverseFourierCosTransform", "ObjectName",
 CellID->22632],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"NInverseFourierCosTransform", "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["\[Omega]", "TR"], ",", 
        StyleBox["t", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives a numerical approximation to the inverse Fourier \
cosine transform of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " evaluated at the numerical value ",
     Cell[BoxData[
      StyleBox["t", "TI"]], "InlineFormula"],
     ", where ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " is a function of ",
     Cell[BoxData[
      StyleBox["\[Omega]", "TR"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->20189]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The numerical approximation to the inverse Fourier cosine transform of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " is by default defined to be ",
 Cell[BoxData[
  RowBox[{
   SqrtBox[
    FractionBox["2", 
     StyleBox["\[Pi]", "TR"]]], 
   RowBox[{
    ButtonBox["NIntegrate",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/NIntegrate"], "[", 
    RowBox[{
     RowBox[{
      StyleBox["expr", "TI"], " ", 
      RowBox[{
       ButtonBox["Cos",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Cos"], "[", 
       RowBox[{
        StyleBox["\[Omega]", "TR"], " ", 
        StyleBox["t", "TI"]}], 
       StyleBox["]", "TI"]}]}], ",", 
     RowBox[{"{", 
      RowBox[{
       StyleBox["\[Omega]", "TR"], ",", "0", ",", "\[Infinity]"}], "}"}]}], 
    "]"}]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->17839],

Cell[TextData[{
 "Different choices for the definition of the inverse Fourier cosine \
transform can be specified using the option ",
 Cell[BoxData[
  ButtonBox["FourierParameters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FourierParameters"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->20183],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FourierParameters",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FourierParameters"], "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"]}], "}"}]}]], "InlineFormula"],
 ", the inverse Fourier cosine transform computed by ",
 Cell[BoxData["NInverseFourierCosTransform"], "InlineFormula"],
 " is ",
 Cell[BoxData[
  RowBox[{"2", 
   SqrtBox[
    FractionBox[
     FormBox[
      RowBox[{"\[VerticalSeparator]", 
       StyleBox["b", "TI"], "\[VerticalSeparator]"}],
      TraditionalForm], 
     SuperscriptBox[
      StyleBox[
       RowBox[{"(", 
        RowBox[{"2", "\[Pi]"}], ")"}], "TR"], 
      RowBox[{"1", "+", 
       StyleBox["a", "TI"]}]]]], 
   RowBox[{
    ButtonBox["NIntegrate",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/NIntegrate"], "[", 
    RowBox[{
     RowBox[{
      StyleBox["expr", "TI"], " ", 
      RowBox[{
       ButtonBox["Cos",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Cos"], "[", 
       RowBox[{
        StyleBox["b", "TI"], " ", 
        StyleBox["\[Omega]", "TR"], " ", 
        StyleBox["t", "TI"]}], 
       StyleBox["]", "TI"]}]}], ",", 
     RowBox[{"{", 
      RowBox[{
       StyleBox["\[Omega]", "TR"], ",", "0", ",", "\[Infinity]"}], "}"}]}], 
    "]"}]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->13817],

Cell[TextData[{
 "The parameter ",
 Cell[BoxData[
  StyleBox["b", "TI"]], "InlineFormula"],
 " in the setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FourierParameters",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FourierParameters"], "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"]}], "}"}]}]], "InlineFormula"],
 " must be numeric."
}], "Notes",
 CellID->22129],

Cell[TextData[{
 "In addition to the option ",
 Cell[BoxData[
  ButtonBox["FourierParameters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FourierParameters"]], "InlineFormula"],
 ", ",
 Cell[BoxData["NInverseFourierCosTransform"], "InlineFormula"],
 " can also accept the options available to ",
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 ". These options are passed directly to ",
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->6753]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->238346847],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->45541453],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<FourierSeries`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->97613840],

Cell["\<\
Numerical approximation for an inverse Fourier cosine transform:\
\>", "ExampleText",
 CellID->60323419],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NInverseFourierCosTransform", "[", 
  RowBox[{
   RowBox[{"E", "^", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "6"}], "\[Omega]"}], ")"}]}], ",", " ", "\[Omega]", ",", 
   " ", "1.4"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->13514770],

Cell[BoxData["0.12611452494029046`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->488302454]
}, Open  ]],

Cell["Compare with the answer from symbolic evaluation:", "ExampleText",
 CellID->813151740],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierCosTransform", "[", 
  RowBox[{
   RowBox[{"E", "^", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "6"}], "\[Omega]"}], ")"}]}], ",", "  ", "\[Omega]", ",", 
   " ", "t"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->666270353],

Cell[BoxData[
 FractionBox[
  RowBox[{"6", " ", 
   SqrtBox[
    FractionBox["2", "\[Pi]"]]}], 
  RowBox[{"36", "+", 
   SuperscriptBox["t", "2"]}]]], "Output",
 ImageSize->{49, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->263221641]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{"{", 
   RowBox[{"t", "\[Rule]", " ", "1.4"}], "}"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->13445192],

Cell[BoxData["0.12611452488981015`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->341213482]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->15145],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["NFourierTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:FourierSeries/ref/NFourierTransform"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NInverseFourierTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:FourierSeries/ref/NInverseFourierTransform"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NFourierSinTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:FourierSeries/ref/NFourierSinTransform"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NFourierCosTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:FourierSeries/ref/NFourierCosTransform"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NInverseFourierSinTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:FourierSeries/ref/NInverseFourierSinTransform"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->19861]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->10679],

Cell[TextData[ButtonBox["Fourier Series Package",
 BaseStyle->"Link",
 ButtonData->"paclet:FourierSeries/tutorial/FourierSeries"]], "Tutorials",
 CellID->18613]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NInverseFourierCosTransform - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 58, 19.8185226}", "context" -> 
    "FourierSeries`", "keywords" -> {}, "index" -> True, "label" -> 
    "Fourier Series Package Symbol", "language" -> "en", "paclet" -> 
    "FourierSeries Package", "status" -> "None", "summary" -> 
    "NInverseFourierCosTransform[expr, \\[Omega], t] gives a numerical \
approximation to the inverse Fourier cosine transform of expr evaluated at \
the numerical value t, where expr is a function of \\[Omega].", 
    "synonyms" -> {}, "title" -> "NInverseFourierCosTransform", "type" -> 
    "Symbol", "uri" -> "FourierSeries/ref/NInverseFourierCosTransform"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7766, 266, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->238346847]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 13626, 475}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1968, 47, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2591, 74, 65, 1, 70, "ObjectName",
 CellID->22632],
Cell[2659, 77, 919, 28, 70, "Usage",
 CellID->20189]
}, Open  ]],
Cell[CellGroupData[{
Cell[3615, 110, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4093, 127, 870, 31, 70, "Notes",
 CellID->17839],
Cell[4966, 160, 305, 9, 70, "Notes",
 CellID->20183],
Cell[5274, 171, 1406, 50, 70, "Notes",
 CellID->13817],
Cell[6683, 223, 419, 16, 70, "Notes",
 CellID->22129],
Cell[7105, 241, 624, 20, 70, "Notes",
 CellID->6753]
}, Closed]],
Cell[CellGroupData[{
Cell[7766, 266, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->238346847],
Cell[CellGroupData[{
Cell[8151, 280, 147, 5, 70, "ExampleSection",
 CellID->45541453],
Cell[8301, 287, 137, 4, 70, "Input",
 CellID->97613840],
Cell[8441, 293, 114, 3, 70, "ExampleText",
 CellID->60323419],
Cell[CellGroupData[{
Cell[8580, 300, 277, 9, 28, "Input",
 CellID->13514770],
Cell[8860, 311, 177, 5, 36, "Output",
 CellID->488302454]
}, Open  ]],
Cell[9052, 319, 92, 1, 70, "ExampleText",
 CellID->813151740],
Cell[CellGroupData[{
Cell[9169, 324, 276, 9, 70, "Input",
 CellID->666270353],
Cell[9448, 335, 290, 11, 77, "Output",
 CellID->263221641]
}, Open  ]],
Cell[CellGroupData[{
Cell[9775, 351, 152, 5, 70, "Input",
 CellID->13445192],
Cell[9930, 358, 177, 5, 36, "Output",
 CellID->341213482]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10168, 370, 311, 9, 70, "SeeAlsoSection",
 CellID->15145],
Cell[10482, 381, 1392, 44, 70, "SeeAlso",
 CellID->19861]
}, Open  ]],
Cell[CellGroupData[{
Cell[11911, 430, 314, 9, 70, "TutorialsSection",
 CellID->10679],
Cell[12228, 441, 160, 3, 70, "Tutorials",
 CellID->18613]
}, Open  ]],
Cell[12403, 447, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

