(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15861,        563]
NotebookOptionsPosition[     12694,        459]
NotebookOutlinePosition[     14115,        497]
CellTagsIndexPosition[     14030,        492]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["FOURIER SERIES PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Fourier Series Package" :> 
          Documentation`HelpLookup[
           "paclet:FourierSeries/tutorial/FourierSeries"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Fourier Series Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NFourierTransform" :> 
          Documentation`HelpLookup[
           "paclet:FourierSeries/ref/NFourierTransform"], 
          "NInverseFourierTransform" :> 
          Documentation`HelpLookup[
           "paclet:FourierSeries/ref/NInverseFourierTransform"], 
          "NFourierSinTransform" :> 
          Documentation`HelpLookup[
           "paclet:FourierSeries/ref/NFourierSinTransform"], 
          "NFourierCosTransform" :> 
          Documentation`HelpLookup[
           "paclet:FourierSeries/ref/NFourierCosTransform"], 
          "NInverseFourierCosTransform" :> 
          Documentation`HelpLookup[
           "paclet:FourierSeries/ref/NInverseFourierCosTransform"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"NFourierTransform\"\>", 
       2->"\<\"NInverseFourierTransform\"\>", 
       3->"\<\"NFourierSinTransform\"\>", 4->"\<\"NFourierCosTransform\"\>", 
       5->"\<\"NInverseFourierCosTransform\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NInverseFourierSinTransform", "ObjectName",
 CellID->8833],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"NInverseFourierSinTransform", "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["\[Omega]", "TR"], ",", 
        StyleBox["t", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives a numerical approximation to the inverse Fourier \
sine transform of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " evaluated at the numerical value ",
     Cell[BoxData[
      StyleBox["t", "TI"]], "InlineFormula"],
     ", where ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " is a function of ",
     Cell[BoxData[
      StyleBox["\[Omega]", "TR"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->7611]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The numerical approximation to the inverse Fourier sine transform of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " is by default defined to be ",
 Cell[BoxData[
  RowBox[{
   SqrtBox[
    FractionBox["2", 
     StyleBox["\[Pi]", "TR"]]], 
   RowBox[{
    ButtonBox["NIntegrate",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/NIntegrate"], "[", 
    RowBox[{
     RowBox[{
      StyleBox["expr", "TI"], " ", 
      RowBox[{
       ButtonBox["Sin",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Sin"], "[", 
       RowBox[{
        StyleBox["\[Omega]", "TR"], " ", 
        StyleBox["t", "TI"]}], 
       StyleBox["]", "TI"]}]}], ",", 
     RowBox[{"{", 
      RowBox[{
       StyleBox["\[Omega]", "TR"], ",", "0", ",", "\[Infinity]"}], "}"}]}], 
    "]"}]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->19067],

Cell[TextData[{
 "Different choices for the definition of the inverse Fourier sine transform \
can be specified using the option ",
 Cell[BoxData[
  ButtonBox["FourierParameters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FourierParameters"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->415],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FourierParameters",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FourierParameters"], "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"]}], "}"}]}]], "InlineFormula"],
 ", the inverse Fourier sine transform computed by ",
 Cell[BoxData["NInverseFourierSinTransform"], "InlineFormula"],
 " is ",
 Cell[BoxData[
  RowBox[{"2", 
   SqrtBox[
    FractionBox[
     FormBox[
      RowBox[{"\[VerticalSeparator]", 
       StyleBox["b", "TI"], "\[VerticalSeparator]"}],
      TraditionalForm], 
     SuperscriptBox[
      StyleBox[
       RowBox[{"(", 
        RowBox[{"2", "\[Pi]"}], ")"}], "TR"], 
      RowBox[{"1", "+", 
       StyleBox["a", "TI"]}]]]], 
   RowBox[{
    ButtonBox["NIntegrate",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/NIntegrate"], "[", 
    RowBox[{
     RowBox[{
      StyleBox["expr", "TI"], " ", 
      RowBox[{
       ButtonBox["Sin",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Sin"], "[", 
       RowBox[{
        StyleBox["b", "TI"], " ", 
        StyleBox["\[Omega]", "TR"], " ", 
        StyleBox["t", "TI"]}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{
       StyleBox["\[Omega]", "TR"], ",", "0", ",", "\[Infinity]"}], "}"}]}], 
    "]"}]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->6645],

Cell[TextData[{
 "The parameter ",
 Cell[BoxData[
  StyleBox["b", "TI"]], "InlineFormula"],
 " in the setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FourierParameters",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FourierParameters"], "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"]}], "}"}]}]], "InlineFormula"],
 " must be numeric."
}], "Notes",
 CellID->30175],

Cell[TextData[{
 "In addition to the option ",
 Cell[BoxData[
  ButtonBox["FourierParameters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FourierParameters"]], "InlineFormula"],
 ", ",
 Cell[BoxData["NInverseFourierSinTransform"], "InlineFormula"],
 " can also accept the options available to ",
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 ". These options are passed directly to ",
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->6354]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->93501132],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->199623772],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<FourierSeries`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->557313676],

Cell["\<\
Numerical approximation for an inverse Fourier sine transform:\
\>", "ExampleText",
 CellID->60323419],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NInverseFourierSinTransform", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"\[Omega]", "^", "2"}], "+", "1"}], ")"}], " ", 
    RowBox[{"E", "^", 
     RowBox[{"(", 
      RowBox[{"-", "\[Omega]"}], ")"}]}]}], ",", " ", "\[Omega]", ",", " ", 
   "2.9"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->13514770],

Cell[BoxData["0.21584760935848696`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->19645600]
}, Open  ]],

Cell["Compare with the answer from symbolic evaluation:", "ExampleText",
 CellID->813151740],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierSinTransform", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"\[Omega]", "^", "2"}], "+", "1"}], ")"}], " ", 
    RowBox[{"E", "^", 
     RowBox[{"(", 
      RowBox[{"-", "\[Omega]"}], ")"}]}]}], ",", "\[Omega]", ",", "t"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->666270353],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SqrtBox[
    FractionBox["2", "\[Pi]"]], " ", "t", " ", 
   RowBox[{"(", 
    RowBox[{"7", "+", 
     SuperscriptBox["t", "4"]}], ")"}]}], 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SuperscriptBox["t", "2"]}], ")"}], "3"]]], "Output",
 ImageSize->{98, 62},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->631265135]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{"{", 
   RowBox[{"t", "\[Rule]", " ", "2.9"}], "}"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->13445192],

Cell[BoxData["0.21584760837217343`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->10574508]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->26321],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["NFourierTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:FourierSeries/ref/NFourierTransform"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NInverseFourierTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:FourierSeries/ref/NInverseFourierTransform"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NFourierSinTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:FourierSeries/ref/NFourierSinTransform"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NFourierCosTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:FourierSeries/ref/NFourierCosTransform"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NInverseFourierCosTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:FourierSeries/ref/NInverseFourierCosTransform"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->7592]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->23448],

Cell[TextData[ButtonBox["Fourier Series Package",
 BaseStyle->"Link",
 ButtonData->"paclet:FourierSeries/tutorial/FourierSeries"]], "Tutorials",
 CellID->24919]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NInverseFourierSinTransform - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 58, 20.0372782}", "context" -> 
    "FourierSeries`", "keywords" -> {}, "index" -> True, "label" -> 
    "Fourier Series Package Symbol", "language" -> "en", "paclet" -> 
    "FourierSeries Package", "status" -> "None", "summary" -> 
    "NInverseFourierSinTransform[expr, \\[Omega], t] gives a numerical \
approximation to the inverse Fourier sine transform of expr evaluated at the \
numerical value t, where expr is a function of \\[Omega].", "synonyms" -> {}, 
    "title" -> "NInverseFourierSinTransform", "type" -> "Symbol", "uri" -> 
    "FourierSeries/ref/NInverseFourierSinTransform"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7729, 265, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->93501132]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 13888, 485}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1968, 47, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2591, 74, 64, 1, 70, "ObjectName",
 CellID->8833],
Cell[2658, 77, 916, 28, 70, "Usage",
 CellID->7611]
}, Open  ]],
Cell[CellGroupData[{
Cell[3611, 110, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4089, 127, 868, 31, 70, "Notes",
 CellID->19067],
Cell[4960, 160, 301, 9, 70, "Notes",
 CellID->415],
Cell[5264, 171, 1379, 49, 70, "Notes",
 CellID->6645],
Cell[6646, 222, 419, 16, 70, "Notes",
 CellID->30175],
Cell[7068, 240, 624, 20, 70, "Notes",
 CellID->6354]
}, Closed]],
Cell[CellGroupData[{
Cell[7729, 265, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->93501132],
Cell[CellGroupData[{
Cell[8113, 279, 148, 5, 70, "ExampleSection",
 CellID->199623772],
Cell[8264, 286, 138, 4, 70, "Input",
 CellID->557313676],
Cell[8405, 292, 112, 3, 70, "ExampleText",
 CellID->60323419],
Cell[CellGroupData[{
Cell[8542, 299, 367, 12, 28, "Input",
 CellID->13514770],
Cell[8912, 313, 176, 5, 36, "Output",
 CellID->19645600]
}, Open  ]],
Cell[9103, 321, 92, 1, 70, "ExampleText",
 CellID->813151740],
Cell[CellGroupData[{
Cell[9220, 326, 354, 12, 70, "Input",
 CellID->666270353],
Cell[9577, 340, 427, 16, 83, "Output",
 CellID->631265135]
}, Open  ]],
Cell[CellGroupData[{
Cell[10041, 361, 152, 5, 70, "Input",
 CellID->13445192],
Cell[10196, 368, 176, 5, 36, "Output",
 CellID->10574508]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10433, 380, 311, 9, 70, "SeeAlsoSection",
 CellID->26321],
Cell[10747, 391, 1391, 44, 70, "SeeAlso",
 CellID->7592]
}, Open  ]],
Cell[CellGroupData[{
Cell[12175, 440, 314, 9, 70, "TutorialsSection",
 CellID->23448],
Cell[12492, 451, 160, 3, 70, "Tutorials",
 CellID->24919]
}, Open  ]],
Cell[12667, 457, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

