(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16321,        572]
NotebookOptionsPosition[     13162,        468]
NotebookOutlinePosition[     14567,        506]
CellTagsIndexPosition[     14482,        501]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["FOURIER SERIES PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Fourier Series Package" :> 
          Documentation`HelpLookup[
           "paclet:FourierSeries/tutorial/FourierSeries"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Fourier Series Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NFourierTransform" :> 
          Documentation`HelpLookup[
           "paclet:FourierSeries/ref/NFourierTransform"], 
          "NFourierSinTransform" :> 
          Documentation`HelpLookup[
           "paclet:FourierSeries/ref/NFourierSinTransform"], 
          "NFourierCosTransform" :> 
          Documentation`HelpLookup[
           "paclet:FourierSeries/ref/NFourierCosTransform"], 
          "NInverseFourierSinTransform" :> 
          Documentation`HelpLookup[
           "paclet:FourierSeries/ref/NInverseFourierSinTransform"], 
          "NInverseFourierCosTransform" :> 
          Documentation`HelpLookup[
           "paclet:FourierSeries/ref/NInverseFourierCosTransform"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"NFourierTransform\"\>", 
       2->"\<\"NFourierSinTransform\"\>", 3->"\<\"NFourierCosTransform\"\>", 
       4->"\<\"NInverseFourierSinTransform\"\>", 
       5->"\<\"NInverseFourierCosTransform\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NInverseFourierTransform", "ObjectName",
 CellID->20481],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"NInverseFourierTransform", "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["\[Omega]", "TR"], ",", 
        StyleBox["t", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives a numerical approximation to the inverse Fourier \
transform of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " evaluated at the numerical value ",
     Cell[BoxData[
      StyleBox["t", "TI"]], "InlineFormula"],
     ", where ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " is a function of ",
     Cell[BoxData[
      StyleBox["\[Omega]", "TR"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->11714]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The numerical approximation to the inverse Fourier transform of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " is by default defined to be ",
 Cell[BoxData[
  RowBox[{
   SqrtBox[
    FractionBox["1", 
     StyleBox[
      RowBox[{"2", "\[Pi]"}], "TR"]]], 
   RowBox[{
    ButtonBox["NIntegrate",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/NIntegrate"], "[", 
    RowBox[{
     RowBox[{
      StyleBox["expr", "TI"], " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", 
        StyleBox["\[Omega]", "TR"], " ", 
        StyleBox["t", "TI"]}]]}], ",", 
     RowBox[{"{", 
      RowBox[{
       StyleBox["\[Omega]", "TR"], ",", 
       RowBox[{"-", "\[Infinity]"}], ",", "\[Infinity]"}], "}"}]}], "]"}]}]], 
  "InlineFormula"],
 "."
}], "Notes",
 CellID->20149],

Cell[TextData[{
 "Different choices for the definition of the inverse Fourier transform can \
be specified using the option ",
 Cell[BoxData[
  ButtonBox["FourierParameters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FourierParameters"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->24168],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FourierParameters",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FourierParameters"], "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"]}], "}"}]}]], "InlineFormula"],
 ", the inverse Fourier transform computed by ",
 Cell[BoxData["NInverseFourierTransform"], "InlineFormula"],
 " is ",
 Cell[BoxData[
  RowBox[{
   SqrtBox[
    FractionBox[
     RowBox[{"\[VerticalSeparator]", 
      StyleBox["b", "TI"], "\[VerticalSeparator]"}], 
     SuperscriptBox[
      StyleBox[
       RowBox[{"(", 
        RowBox[{"2", "\[Pi]"}], ")"}], "TR"], 
      RowBox[{"1", "+", 
       StyleBox["a", "TI"]}]]]], 
   RowBox[{
    ButtonBox["NIntegrate",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/NIntegrate"], "[", 
    RowBox[{
     RowBox[{
      StyleBox["expr", "TI"], " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", 
        StyleBox["b", "TI"], " ", 
        StyleBox["\[Omega]", "TR"], " ", 
        StyleBox["t", "TI"]}]]}], ",", 
     RowBox[{"{", 
      RowBox[{
       StyleBox["\[Omega]", "TR"], ",", 
       RowBox[{"-", "\[Infinity]"}], ",", "\[Infinity]"}], "}"}]}], "]"}]}]], 
  "InlineFormula"],
 "."
}], "Notes",
 CellID->13338],

Cell[TextData[{
 "The parameter ",
 Cell[BoxData[
  StyleBox["b", "TI"]], "InlineFormula"],
 " in the setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["FourierParameters",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FourierParameters"], "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"]}], "}"}]}]], "InlineFormula"],
 " must be numeric."
}], "Notes",
 CellID->20307],

Cell[TextData[{
 "In addition to the option ",
 Cell[BoxData[
  ButtonBox["FourierParameters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FourierParameters"]], "InlineFormula"],
 ", ",
 Cell[BoxData["NInverseFourierTransform"], "InlineFormula"],
 " can also accept the options available to ",
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 ". These options are passed directly to ",
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->26793]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->194771657],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->63666498],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<FourierSeries`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->108065481],

Cell["\<\
Numerical inverse Fourier transform for a polynomial-exponential function:\
\>", "ExampleText",
 CellID->591648357],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NInverseFourierTransform", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"\[Omega]", "^", "2"}], "+", 
      RowBox[{"3", "\[Omega]"}], "+", "5"}], ")"}], "*", 
    RowBox[{"E", "^", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"\[Omega]", "^", "2"}]}], " ", "+", "1"}], ")"}]}]}], ",", 
   " ", "\[Omega]", ",", " ", "3.7"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->52769919],

Cell[BoxData[
 RowBox[{"0.13030097104075808`", "\[InvisibleSpace]", "-", 
  RowBox[{"0.3480964569319978`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{140, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->119468636]
}, Open  ]],

Cell["Compare with the answer from symbolic evaluation:", "ExampleText",
 CellID->1005649655],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFourierTransform", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"\[Omega]", "^", "2"}], "+", 
      RowBox[{"3", "\[Omega]"}], "+", "5"}], ")"}], "*", 
    RowBox[{"E", "^", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        RowBox[{"\[Omega]", "^", "2"}]}], "+", "1"}], ")"}]}]}], ",", " ", 
   "\[Omega]", ",", " ", "t"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->4619607],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"1", "-", 
      FractionBox[
       SuperscriptBox["t", "2"], "4"]}]], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "22"}], "+", 
      RowBox[{"6", " ", "\[ImaginaryI]", " ", "t"}], "+", 
      SuperscriptBox["t", "2"]}], ")"}]}], 
   RowBox[{"4", " ", 
    SqrtBox["2"]}]]}]], "Output",
 ImageSize->{152, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->182584725]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", 
  RowBox[{"{", 
   RowBox[{"t", "\[Rule]", " ", "3.7"}], "}"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->541406134],

Cell[BoxData[
 RowBox[{"0.13030097104076188`", "\[InvisibleSpace]", "-", 
  RowBox[{"0.34809645693199937`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{140, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->12552635]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->15955],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["NFourierTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:FourierSeries/ref/NFourierTransform"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NFourierSinTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:FourierSeries/ref/NFourierSinTransform"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NFourierCosTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:FourierSeries/ref/NFourierCosTransform"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NInverseFourierSinTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:FourierSeries/ref/NInverseFourierSinTransform"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NInverseFourierCosTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:FourierSeries/ref/NInverseFourierCosTransform"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->16641]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->23504],

Cell[TextData[ButtonBox["Fourier Series Package",
 BaseStyle->"Link",
 ButtonData->"paclet:FourierSeries/tutorial/FourierSeries"]], "Tutorials",
 CellID->1105]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NInverseFourierTransform - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 58, 20.2560338}", "context" -> 
    "FourierSeries`", "keywords" -> {}, "index" -> True, "label" -> 
    "Fourier Series Package Symbol", "language" -> "en", "paclet" -> 
    "FourierSeries Package", "status" -> "None", "summary" -> 
    "NInverseFourierTransform[expr, \\[Omega], t] gives a numerical \
approximation to the inverse Fourier transform of expr evaluated at the \
numerical value t, where expr is a function of \\[Omega].", "synonyms" -> {}, 
    "title" -> "NInverseFourierTransform", "type" -> "Symbol", "uri" -> 
    "FourierSeries/ref/NInverseFourierTransform"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7667, 261, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->194771657]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 14339, 494}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1977, 47, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2600, 74, 62, 1, 70, "ObjectName",
 CellID->20481],
Cell[2665, 77, 909, 28, 70, "Usage",
 CellID->11714]
}, Open  ]],
Cell[CellGroupData[{
Cell[3611, 110, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4089, 127, 862, 30, 70, "Notes",
 CellID->20149],
Cell[4954, 159, 298, 9, 70, "Notes",
 CellID->24168],
Cell[5255, 170, 1328, 46, 70, "Notes",
 CellID->13338],
Cell[6586, 218, 419, 16, 70, "Notes",
 CellID->20307],
Cell[7008, 236, 622, 20, 70, "Notes",
 CellID->26793]
}, Closed]],
Cell[CellGroupData[{
Cell[7667, 261, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->194771657],
Cell[CellGroupData[{
Cell[8052, 275, 147, 5, 70, "ExampleSection",
 CellID->63666498],
Cell[8202, 282, 138, 4, 70, "Input",
 CellID->108065481],
Cell[8343, 288, 125, 3, 70, "ExampleText",
 CellID->591648357],
Cell[CellGroupData[{
Cell[8493, 295, 465, 15, 28, "Input",
 CellID->52769919],
Cell[8961, 312, 274, 7, 36, "Output",
 CellID->119468636]
}, Open  ]],
Cell[9250, 322, 93, 1, 70, "ExampleText",
 CellID->1005649655],
Cell[CellGroupData[{
Cell[9368, 327, 456, 15, 70, "Input",
 CellID->4619607],
Cell[9827, 344, 540, 19, 70, "Output",
 CellID->182584725]
}, Open  ]],
Cell[CellGroupData[{
Cell[10404, 368, 153, 5, 70, "Input",
 CellID->541406134],
Cell[10560, 375, 274, 7, 36, "Output",
 CellID->12552635]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10895, 389, 311, 9, 70, "SeeAlsoSection",
 CellID->15955],
Cell[11209, 400, 1398, 44, 70, "SeeAlso",
 CellID->16641]
}, Open  ]],
Cell[CellGroupData[{
Cell[12644, 449, 314, 9, 70, "TutorialsSection",
 CellID->23504],
Cell[12961, 460, 159, 3, 70, "Tutorials",
 CellID->1105]
}, Open  ]],
Cell[13135, 466, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

