(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    115160,       3342]
NotebookOptionsPosition[    107679,       3102]
NotebookOutlinePosition[    109808,       3150]
CellTagsIndexPosition[    109765,       3147]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["FOURIER SERIES PACKAGE TUTORIAL", "PacletNameCell"], Cell[TextData[
    Cell[BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"DTFourierTransform" :> 
         Documentation`HelpLookup[
          "paclet:FourierSeries/ref/DTFourierTransform"], 
         "FourierCoefficient" :> 
         Documentation`HelpLookup[
          "paclet:FourierSeries/ref/FourierCoefficient"], 
         "FourierCosCoefficient" :> 
         Documentation`HelpLookup[
          "paclet:FourierSeries/ref/FourierCosCoefficient"], "FourierSeries" :> 
         Documentation`HelpLookup["paclet:FourierSeries/ref/FourierSeries"], 
         "FourierSinCoefficient" :> 
         Documentation`HelpLookup[
          "paclet:FourierSeries/ref/FourierSinCoefficient"], 
         "FourierTrigSeries" :> 
         Documentation`HelpLookup[
          "paclet:FourierSeries/ref/FourierTrigSeries"], 
         "InverseDTFourierTransform" :> 
         Documentation`HelpLookup[
          "paclet:FourierSeries/ref/InverseDTFourierTransform"], 
         "InverseFourierCoefficient" :> 
         Documentation`HelpLookup[
          "paclet:FourierSeries/ref/InverseFourierCoefficient"], 
         "NDTFourierTransform" :> 
         Documentation`HelpLookup[
          "paclet:FourierSeries/ref/NDTFourierTransform"], 
         "NFourierCoefficient" :> 
         Documentation`HelpLookup[
          "paclet:FourierSeries/ref/NFourierCoefficient"], 
         "NFourierCosCoefficient" :> 
         Documentation`HelpLookup[
          "paclet:FourierSeries/ref/NFourierCosCoefficient"], 
         "NFourierCosTransform" :> 
         Documentation`HelpLookup[
          "paclet:FourierSeries/ref/NFourierCosTransform"], "NFourierSeries" :> 
         Documentation`HelpLookup["paclet:FourierSeries/ref/NFourierSeries"], 
         "NFourierSinCoefficient" :> 
         Documentation`HelpLookup[
          "paclet:FourierSeries/ref/NFourierSinCoefficient"], 
         "NFourierSinTransform" :> 
         Documentation`HelpLookup[
          "paclet:FourierSeries/ref/NFourierSinTransform"], 
         "NFourierTransform" :> 
         Documentation`HelpLookup[
          "paclet:FourierSeries/ref/NFourierTransform"], "NFourierTrigSeries" :> 
         Documentation`HelpLookup[
          "paclet:FourierSeries/ref/NFourierTrigSeries"], 
         "NInverseDTFourierTransform" :> 
         Documentation`HelpLookup[
          "paclet:FourierSeries/ref/NInverseDTFourierTransform"], 
         "NInverseFourierCoefficient" :> 
         Documentation`HelpLookup[
          "paclet:FourierSeries/ref/NInverseFourierCoefficient"], 
         "NInverseFourierCosTransform" :> 
         Documentation`HelpLookup[
          "paclet:FourierSeries/ref/NInverseFourierCosTransform"], 
         "NInverseFourierSinTransform" :> 
         Documentation`HelpLookup[
          "paclet:FourierSeries/ref/NInverseFourierSinTransform"], 
         "NInverseFourierTransform" :> 
         Documentation`HelpLookup[
          "paclet:FourierSeries/ref/NInverseFourierTransform"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"DTFourierTransform\"\>", 
      2->"\<\"FourierCoefficient\"\>", 3->"\<\"FourierCosCoefficient\"\>", 
      4->"\<\"FourierSeries\"\>", 5->"\<\"FourierSinCoefficient\"\>", 
      6->"\<\"FourierTrigSeries\"\>", 7->"\<\"InverseDTFourierTransform\"\>", 
      8->"\<\"InverseFourierCoefficient\"\>", 
      9->"\<\"NDTFourierTransform\"\>", 10->"\<\"NFourierCoefficient\"\>", 
      11->"\<\"NFourierCosCoefficient\"\>", 
      12->"\<\"NFourierCosTransform\"\>", 13->"\<\"NFourierSeries\"\>", 
      14->"\<\"NFourierSinCoefficient\"\>", 
      15->"\<\"NFourierSinTransform\"\>", 16->"\<\"NFourierTransform\"\>", 
      17->"\<\"NFourierTrigSeries\"\>", 
      18->"\<\"NInverseDTFourierTransform\"\>", 
      19->"\<\"NInverseFourierCoefficient\"\>", 
      20->"\<\"NInverseFourierCosTransform\"\>", 
      21->"\<\"NInverseFourierSinTransform\"\>", 
      22->"\<\"NInverseFourierTransform\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Fourier Series Package", "Title",
 CellID->20975],

Cell[TextData[{
 "The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel provides the functions ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FourierTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FourierTransform"], "MR"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseFourierTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseFourierTransform"], "MR"]], 
  "InlineFormula"],
 " for computing the symbolic Fourier exponential transform and inverse \
transform. It also provides the functions ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FourierSinTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FourierSinTransform"], "MR"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseFourierSinTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseFourierSinTransform"], "MR"]], 
  "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FourierCosTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FourierCosTransform"], "MR"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InverseFourierCosTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseFourierCosTransform"], "MR"]], 
  "InlineFormula"],
 " for computing the symbolic Fourier sine and cosine transforms and their \
inverses. This package provides functions giving numerical approximations to \
these Fourier transforms. It also provides functions for Fourier series, \
Fourier coefficients, discrete\[Hyphen]time Fourier transforms, and their \
numerical counterparts. The numerical approximations use ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "\[CloseCurlyQuote]s numerical integration and summation directly without \
first trying for an exact solution. "
}], "Text",
 CellID->15585],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["NFourierTransform",
      BaseStyle->"Link",
      ButtonData->"paclet:FourierSeries/ref/NFourierTransform"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["t", "TI"], ",", "\[Omega]", "]"}], Cell[TextData[{
     "find a numerical approximation to the Fourier transform of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " evaluated at the numerical value ",
     Cell[BoxData["\[Omega]"], "InlineFormula"],
     ", where ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " is treated as a function of ",
     Cell[BoxData[
      StyleBox["t", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["NInverseFourierTransform",
      BaseStyle->"Link",
      ButtonData->"paclet:FourierSeries/ref/NInverseFourierTransform"], "[", 
     StyleBox["expr", "TI"], ",", "\[Omega]", ",", 
     StyleBox["t", "TI"], "]"}], Cell[TextData[{
     "find a numerical approximation to the inverse Fourier transform of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " evaluated at the numerical value ",
     Cell[BoxData[
      StyleBox["t", "TI"]], "InlineFormula"],
     ", where ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " is treated as a function of ",
     Cell[BoxData["\[Omega]"], "InlineFormula"],
     " "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["NFourierSinTransform",
      BaseStyle->"Link",
      ButtonData->"paclet:FourierSeries/ref/NFourierSinTransform"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["t", "TI"], ",", "\[Omega]", "]"}], Cell[TextData[{
     "find a numerical approximation to the Fourier sine transform of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " evaluated at the numerical value ",
     Cell[BoxData["\[Omega]"], "InlineFormula"],
     ", where ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " is treated as a function of ",
     Cell[BoxData[
      StyleBox["t", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["NInverseFourierSinTransform",
      BaseStyle->"Link",
      ButtonData->"paclet:FourierSeries/ref/NInverseFourierSinTransform"], 
     "[", 
     StyleBox["expr", "TI"], ",", "\[Omega]", ",", 
     StyleBox["t", "TI"], "]"}], Cell[TextData[{
     "find a numerical approximation to the inverse Fourier sine transform of \
",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " evaluated at the numerical value ",
     Cell[BoxData[
      StyleBox["t", "TI"]], "InlineFormula"],
     ", where ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " is treated as a function of ",
     Cell[BoxData["\[Omega]"], "InlineFormula"],
     " "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["NFourierCosTransform",
      BaseStyle->"Link",
      ButtonData->"paclet:FourierSeries/ref/NFourierCosTransform"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["t", "TI"], ",", "\[Omega]", "]"}], Cell[TextData[{
     "find a numerical approximation to the Fourier cosine transform of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " evaluated at the numerical value ",
     Cell[BoxData["\[Omega]"], "InlineFormula"],
     ", where ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " is treated as a function of ",
     Cell[BoxData[
      StyleBox["t", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["NInverseFourierCosTransform",
      BaseStyle->"Link",
      ButtonData->"paclet:FourierSeries/ref/NInverseFourierCosTransform"], 
     "[", 
     StyleBox["expr", "TI"], ",", "\[Omega]", ",", 
     StyleBox["t", "TI"], "]"}], Cell[TextData[{
     "find a numerical approximation to the inverse Fourier cosine transform \
of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " evaluated at the numerical value ",
     Cell[BoxData[
      StyleBox["t", "TI"]], "InlineFormula"],
     ", where ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " is treated as a function of ",
     Cell[BoxData["\[Omega]"], "InlineFormula"],
     " "
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
   "RowsIndexed" -> {}}},
 CellID->22777],

Cell["Finding numerical approximations to Fourier transforms. ", "Caption",
 CellID->13719],

Cell["This loads the package. ", "MathCaption",
 CellID->30203],

Cell[BoxData[
 RowBox[{"<<", "FourierSeries`"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14145],

Cell[TextData[{
 "This gives a numerical approximation to the Fourier transform of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"exp", 
    RowBox[{"(", 
     RowBox[{"-", 
      SuperscriptBox[
       StyleBox["t", "TI"], "2"]}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{"1", "+", "\[LeftBracketingBar]", 
      StyleBox["t", "TI"], "\[RightBracketingBar]"}], ")"}]}], 
   TraditionalForm]], "InlineFormula"],
 " with respect to ",
 Cell[BoxData[
  FormBox["\[Omega]", TraditionalForm]], "InlineFormula"],
 " at ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Omega]", "=", "1"}], TraditionalForm]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->7307],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NFourierTransform", "[", 
  RowBox[{
   FractionBox[
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"-", 
      SuperscriptBox["t", "2"]}]], 
    RowBox[{"1", "+", 
     RowBox[{"Abs", "[", "t", "]"}]}]], ",", "t", ",", "1"}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->8201],

Cell[BoxData[
 RowBox[{"0.40402407559580034`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->16118]
}, Open  ]],

Cell[TextData[{
 "In addition to supporting the ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NIntegrate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NIntegrate"], "MR"]], "InlineFormula"],
 " options, the numerical Fourier transform functions support the option ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FourierParameters",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FourierParameters"], "MR"]], "InlineFormula"],
 ". This option allows you to choose among the various conventions used for \
defining Fourier transforms. "
}], "Text",
 CellID->22496],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["case", "TableHeader"],
     " "
    }]], Cell[TextData[{
     StyleBox["value", "TableHeader"],
     " "
    }]], Cell[TextData[{
     StyleBox["Fourier transform and inverse", "TableHeader"],
     " "
    }]]},
   {Cell[TextData[{
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " default "
    }]], Cell[TextData[{
     StyleBox["{0,", "MR"],
     " ",
     StyleBox["1}", "MR"],
     " "
    }]], Cell[TextData[{
     Cell[BoxData[
      FormBox[
       RowBox[{
        FractionBox["1", 
         SqrtBox[
          RowBox[{"2", "\[Pi]"}]]], 
        SubsuperscriptBox["\[Integral]", 
         RowBox[{"-", "\[Infinity]"}], "\[Infinity]"], 
        StyleBox["f", "TI"], 
        RowBox[{"(", 
         StyleBox["t", "TI"], ")"}], " ", 
        SuperscriptBox[
         StyleBox["e", "TI"], 
         RowBox[{
          StyleBox["i", "TI"], "\[Omega]", 
          StyleBox["t", "TI"]}]], "\[DifferentialD]", 
        StyleBox["t", "TI"]}], TraditionalForm]], "InlineFormula"],
     " "
    }]]},
   {Cell[""], Cell[""], Cell[TextData[{
     Cell[BoxData[
      FormBox[
       RowBox[{
        FractionBox["1", 
         SqrtBox[
          RowBox[{"2", "\[Pi]"}]]], 
        SubsuperscriptBox["\[Integral]", 
         RowBox[{"-", "\[Infinity]"}], "\[Infinity]"], 
        StyleBox["F", "TI"], 
        RowBox[{"(", "\[Omega]", ")"}], " ", 
        SuperscriptBox[
         StyleBox["e", "TI"], 
         RowBox[{"-", 
          StyleBox["i", "TI"], "\[Omega]", 
          StyleBox["t", "TI"]}]], "\[DifferentialD]", "\[Omega]"}], 
       TraditionalForm]], "InlineFormula"],
     " "
    }]]},
   {Cell["general case "], Cell[TextData[{
     StyleBox["{", "MR"],
     StyleBox["a", "TI"],
     StyleBox[",", "MR"],
     " ",
     StyleBox["b", "TI"],
     StyleBox["}", "MR"],
     " "
    }]], Cell[TextData[{
     Cell[BoxData[
      FormBox[
       RowBox[{
        SqrtBox[
         FractionBox[
          RowBox[{"\[LeftBracketingBar]", 
           StyleBox["b", "TI"], "\[RightBracketingBar]"}], 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"2", "\[Pi]"}], ")"}], 
           RowBox[{"1", "-", 
            StyleBox["a", "TI"]}]]]], 
        SubsuperscriptBox["\[Integral]", 
         RowBox[{"-", "\[Infinity]"}], "\[Infinity]"], 
        StyleBox["f", "TI"], 
        RowBox[{"(", 
         StyleBox["t", "TI"], ")"}], " ", 
        SuperscriptBox[
         StyleBox["e", "TI"], 
         RowBox[{
          StyleBox["i", "TI"], 
          StyleBox["b", "TI"], "\[Omega]", 
          StyleBox["t", "TI"]}]], "\[DifferentialD]", 
        StyleBox["t", "TI"]}], TraditionalForm]], "InlineFormula"],
     " "
    }]]},
   {Cell[""], Cell[""], Cell[TextData[{
     Cell[BoxData[
      FormBox[
       RowBox[{
        SqrtBox[
         FractionBox[
          RowBox[{"\[LeftBracketingBar]", 
           StyleBox["b", "TI"], "\[RightBracketingBar]"}], 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"2", "\[Pi]"}], ")"}], 
           RowBox[{"1", "+", 
            StyleBox["a", "TI"]}]]]], 
        SubsuperscriptBox["\[Integral]", 
         RowBox[{"-", "\[Infinity]"}], "\[Infinity]"], 
        StyleBox["F", "TI"], 
        RowBox[{"(", "\[Omega]", ")"}], " ", 
        SuperscriptBox[
         StyleBox["e", "TI"], 
         RowBox[{"-", 
          StyleBox["i", "TI"], 
          StyleBox["b", "TI"], "\[Omega]", 
          StyleBox["t", "TI"]}]], "\[DifferentialD]", "\[Omega]"}], 
       TraditionalForm]], "InlineFormula"],
     " "
    }]]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellID->11802],

Cell[TextData[{
 "Effect of ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FourierParameters",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FourierParameters"], "MR"]], "InlineFormula"],
 " setting on Fourier transform."
}], "Caption",
 CellID->602],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["setting", "TableHeader"],
     " "
    }]], Cell[TextData[{
     StyleBox["Fourier sine transform", "TableHeader"],
     " "
    }]], Cell[TextData[{
     StyleBox["inverse Fourier sine transform", "TableHeader"],
     " "
    }]]},
   {Cell[TextData[{
     StyleBox["{0,", "MR"],
     " ",
     StyleBox["1}", "MR"],
     " "
    }]], Cell[TextData[{
     Cell[BoxData[
      FormBox[
       RowBox[{
        SqrtBox[
         FractionBox["2", "\[Pi]"]], 
        SubsuperscriptBox["\[Integral]", "0", "\[Infinity]"], 
        StyleBox["f", "TI"], 
        RowBox[{"(", 
         StyleBox["t", "TI"], ")"}], " ", "sin", 
        RowBox[{"(", 
         RowBox[{"\[Omega]", 
          StyleBox["t", "TI"]}], ")"}], "\[DifferentialD]", 
        StyleBox["t", "TI"]}], TraditionalForm]], "InlineFormula"],
     " "
    }]], Cell[TextData[{
     Cell[BoxData[
      FormBox[
       RowBox[{
        SqrtBox[
         FractionBox["2", "\[Pi]"]], 
        SubsuperscriptBox["\[Integral]", "0", "\[Infinity]"], 
        StyleBox["F", "TI"], 
        RowBox[{"(", "\[Omega]", ")"}], " ", "sin", 
        RowBox[{"(", 
         RowBox[{"\[Omega]", 
          StyleBox["t", "TI"]}], ")"}], "\[DifferentialD]", "\[Omega]"}], 
       TraditionalForm]], "InlineFormula"],
     " "
    }]]},
   {Cell[TextData[{
     StyleBox["{", "MR"],
     StyleBox["a", "TI"],
     StyleBox[",", "MR"],
     " ",
     StyleBox["b", "TI"],
     StyleBox["}", "MR"],
     " "
    }]], Cell[TextData[{
     Cell[BoxData[
      FormBox[
       RowBox[{"2", 
        SqrtBox[
         FractionBox[
          RowBox[{"\[LeftBracketingBar]", 
           StyleBox["b", "TI"], "\[RightBracketingBar]"}], 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"2", "\[Pi]"}], ")"}], 
           RowBox[{"1", "-", 
            StyleBox["a", "TI"]}]]]], 
        SubsuperscriptBox["\[Integral]", "0", "\[Infinity]"], 
        StyleBox["f", "TI"], 
        RowBox[{"(", 
         StyleBox["t", "TI"], ")"}], " ", "sin", 
        RowBox[{"(", 
         RowBox[{
          StyleBox["b", "TI"], "\[Omega]", 
          StyleBox["t", "TI"]}], ")"}], "\[DifferentialD]", 
        StyleBox["t", "TI"]}], TraditionalForm]], "InlineFormula"],
     " "
    }]], Cell[TextData[{
     Cell[BoxData[
      FormBox[
       RowBox[{"2", 
        SqrtBox[
         FractionBox[
          RowBox[{"\[LeftBracketingBar]", 
           StyleBox["b", "TI"], "\[RightBracketingBar]"}], 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"2", "\[Pi]"}], ")"}], 
           RowBox[{"1", "+", 
            StyleBox["a", "TI"]}]]]], 
        SubsuperscriptBox["\[Integral]", "0", "\[Infinity]"], 
        StyleBox["F", "TI"], 
        RowBox[{"(", "\[Omega]", ")"}], " ", "sin", 
        RowBox[{"(", 
         RowBox[{
          StyleBox["b", "TI"], "\[Omega]", 
          StyleBox["t", "TI"]}], ")"}], "\[DifferentialD]", "\[Omega]"}], 
       TraditionalForm]], "InlineFormula"],
     " "
    }]]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellID->28607],

Cell[TextData[{
 "Effect of ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FourierParameters",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FourierParameters"], "MR"]], "InlineFormula"],
 " setting on Fourier sine transform."
}], "Caption",
 CellID->23638],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["setting", "TableHeader"],
     " "
    }]], Cell[TextData[{
     StyleBox["Fourier cosine transform", "TableHeader"],
     " "
    }]], Cell[TextData[{
     StyleBox["inverse Fourier cosine transform", "TableHeader"],
     " "
    }]]},
   {Cell[TextData[{
     StyleBox["{0,", "MR"],
     " ",
     StyleBox["1}", "MR"],
     " "
    }]], Cell[TextData[{
     Cell[BoxData[
      FormBox[
       RowBox[{
        SqrtBox[
         FractionBox["2", "\[Pi]"]], 
        SubsuperscriptBox["\[Integral]", "0", "\[Infinity]"], 
        StyleBox["f", "TI"], 
        RowBox[{"(", 
         StyleBox["t", "TI"], ")"}], " ", "cos", 
        RowBox[{"(", 
         RowBox[{"\[Omega]", 
          StyleBox["t", "TI"]}], ")"}], "\[DifferentialD]", 
        StyleBox["t", "TI"]}], TraditionalForm]], "InlineFormula"],
     " "
    }]], Cell[TextData[{
     Cell[BoxData[
      FormBox[
       RowBox[{
        SqrtBox[
         FractionBox["2", "\[Pi]"]], 
        SubsuperscriptBox["\[Integral]", "0", "\[Infinity]"], 
        StyleBox["F", "TI"], 
        RowBox[{"(", "\[Omega]", ")"}], " ", "cos", 
        RowBox[{"(", 
         RowBox[{"\[Omega]", 
          StyleBox["t", "TI"]}], ")"}], "\[DifferentialD]", "\[Omega]"}], 
       TraditionalForm]], "InlineFormula"],
     " "
    }]]},
   {Cell[TextData[{
     StyleBox["{", "MR"],
     StyleBox["a", "TI"],
     StyleBox[",", "MR"],
     " ",
     StyleBox["b", "TI"],
     StyleBox["}", "MR"],
     " "
    }]], Cell[TextData[{
     Cell[BoxData[
      FormBox[
       RowBox[{"2", 
        SqrtBox[
         FractionBox[
          RowBox[{"\[LeftBracketingBar]", 
           StyleBox["b", "TI"], "\[RightBracketingBar]"}], 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"2", "\[Pi]"}], ")"}], 
           RowBox[{"1", "-", 
            StyleBox["a", "TI"]}]]]], 
        SubsuperscriptBox["\[Integral]", "0", "\[Infinity]"], 
        StyleBox["f", "TI"], 
        RowBox[{"(", 
         StyleBox["t", "TI"], ")"}], " ", "cos", 
        RowBox[{"(", 
         RowBox[{
          StyleBox["b", "TI"], "\[Omega]", 
          StyleBox["t", "TI"]}], ")"}], "\[DifferentialD]", 
        StyleBox["t", "TI"]}], TraditionalForm]], "InlineFormula"],
     " "
    }]], Cell[TextData[{
     Cell[BoxData[
      FormBox[
       RowBox[{"2", 
        SqrtBox[
         FractionBox[
          RowBox[{"\[LeftBracketingBar]", 
           StyleBox["b", "TI"], "\[RightBracketingBar]"}], 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"2", "\[Pi]"}], ")"}], 
           RowBox[{"1", "+", 
            StyleBox["a", "TI"]}]]]], 
        SubsuperscriptBox["\[Integral]", "0", "\[Infinity]"], 
        StyleBox["F", "TI"], 
        RowBox[{"(", "\[Omega]", ")"}], " ", "cos", 
        RowBox[{"(", 
         RowBox[{
          StyleBox["b", "TI"], "\[Omega]", 
          StyleBox["t", "TI"]}], ")"}], "\[DifferentialD]", "\[Omega]"}], 
       TraditionalForm]], "InlineFormula"],
     " "
    }]]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellID->24237],

Cell[TextData[{
 "Effect of ",
 StyleBox["FourierParameters", "MR"],
 " setting on Fourier cosine transform."
}], "Caption",
 CellID->3076],

Cell[TextData[{
 "The Fourier transform is commonly used to transform a problem from the \
continuous \[OpenCurlyDoubleQuote]time domain\[CloseCurlyDoubleQuote] into \
the continuous \[OpenCurlyDoubleQuote]frequency domain.\
\[CloseCurlyDoubleQuote] The Fourier transform may be viewed as the \
continuous analog of the Fourier series decomposition, which expresses a \
periodic function as a superposition of exponential or trigonometric \
functions. Fourier exponential and trigonometric series decompositions may be \
computed using the functions ",
 Cell[BoxData[
  ButtonBox["FourierSeries",
   BaseStyle->"Link",
   ButtonData->"paclet:FourierSeries/ref/FourierSeries"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["FourierTrigSeries",
   BaseStyle->"Link",
   ButtonData->"paclet:FourierSeries/ref/FourierTrigSeries"]], 
  "InlineFormula"],
 ". The coefficients of the exponential series are found using ",
 Cell[BoxData[
  ButtonBox["FourierCoefficient",
   BaseStyle->"Link",
   ButtonData->"paclet:FourierSeries/ref/FourierCoefficient"]], 
  "InlineFormula"],
 " and the coefficients of the trigonometric series are found using ",
 Cell[BoxData[
  ButtonBox["FourierSinCoefficient",
   BaseStyle->"Link",
   ButtonData->"paclet:FourierSeries/ref/FourierSinCoefficient"]], 
  "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["FourierCosCoefficient",
   BaseStyle->"Link",
   ButtonData->"paclet:FourierSeries/ref/FourierCosCoefficient"]], 
  "InlineFormula"],
 ". If the option setting ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FourierParameters",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FourierParameters"], "MR"]], "InlineFormula"],
 " ",
 StyleBox["->", "MR"],
 " ",
 StyleBox["{", "MR"],
 StyleBox["a", "TI"],
 StyleBox[",", "MR"],
 " ",
 StyleBox["b", "TI"],
 StyleBox["}", "MR"],
 " is specified, the continuous function of ",
 Cell[BoxData[
  FormBox[
   StyleBox["t", "TI"], TraditionalForm]], "InlineFormula"],
 " is treated as having a period of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "/", "\[LeftBracketingBar]", 
    StyleBox["b", "TI"], "\[RightBracketingBar]"}], TraditionalForm]], 
  "InlineFormula"],
 ", instead of the default period of ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineFormula"],
 ". "
}], "Text",
 CellID->215],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["FourierCoefficient",
      BaseStyle->"Link",
      ButtonData->"paclet:FourierSeries/ref/FourierCoefficient"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["t", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "give the ",
     Cell[BoxData[
      SuperscriptBox[
       StyleBox["n", "TI"], "th"]], "InlineFormula"],
     " coefficient in the exponential series expansion of the periodic \
function of ",
     Cell[BoxData[
      StyleBox["t", "TI"]], "InlineFormula"],
     " equal to ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " on the interval ",
     Cell[BoxData[
      RowBox[{
       StyleBox["t", "TI"], "=", "-", 
       FractionBox["1", "2"]}]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      RowBox[{
       StyleBox["t", "TI"], "=", 
       FractionBox["1", "2"]}]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["FourierSinCoefficient",
      BaseStyle->"Link",
      ButtonData->"paclet:FourierSeries/ref/FourierSinCoefficient"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["t", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "give the ",
     Cell[BoxData[
      SuperscriptBox[
       StyleBox["n", "TI"], "th"]], "InlineFormula"],
     " coefficient in the sine series expansion"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["FourierCosCoefficient",
      BaseStyle->"Link",
      ButtonData->"paclet:FourierSeries/ref/FourierCosCoefficient"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["t", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "give the ",
     Cell[BoxData[
      SuperscriptBox[
       StyleBox["n", "TI"], "th"]], "InlineFormula"],
     " coefficient in the cosine series expansion"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["FourierSeries",
      BaseStyle->"Link",
      ButtonData->"paclet:FourierSeries/ref/FourierSeries"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["t", "TI"], ",", 
     StyleBox["k", "TI"], "]"}], Cell[TextData[{
     "give the exponential series expansion to order ",
     Cell[BoxData[
      StyleBox["k", "TI"]], "InlineFormula"],
     " of the periodic function of ",
     Cell[BoxData[
      StyleBox["t", "TI"]], "InlineFormula"],
     " equal to ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " on the interval ",
     Cell[BoxData[
      RowBox[{
       StyleBox["t", "TI"], "=", "-", 
       FractionBox["1", "2"]}]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      RowBox[{
       StyleBox["t", "TI"], "=", 
       FractionBox["1", "2"]}]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["FourierTrigSeries",
      BaseStyle->"Link",
      ButtonData->"paclet:FourierSeries/ref/FourierTrigSeries"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["t", "TI"], ",", 
     StyleBox["k", "TI"], "]"}], Cell[TextData[{
     "give the trigonometric series expansion to order ",
     StyleBox["k", "TI"]
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, True, {False}, False}, 
   "RowsIndexed" -> {}}},
 CellID->7691],

Cell["Computing Fourier coefficients and series. ", "Caption",
 CellID->15579],

Cell[TextData[{
 "Here is a plot of the difference between ",
 Cell[BoxData[
  FormBox[
   StyleBox["t", "TI"], TraditionalForm]], "InlineFormula"],
 " and the integer closest to ",
 Cell[BoxData[
  FormBox[
   StyleBox["t", "TI"], TraditionalForm]], "InlineFormula"],
 ". It is a periodic function with fundamental interval from ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", 
    FractionBox["1", "2"]}], TraditionalForm]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  FormBox[
   FractionBox["1", "2"], TraditionalForm]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->212],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"rndplt", "=", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"t", "-", 
     RowBox[{"Round", "[", "t", "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", 
      RowBox[{"-", "1.5"}], ",", "1.5"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->2206],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->50618494]
}, Open  ]],

Cell["\<\
This gives a piece of the Fourier trigonometric series of the difference \
function. The difference function is odd so its trigonometric series contains \
only sines. \
\>", "MathCaption",
 CellID->1692],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierTrigSeries", "[", 
  RowBox[{"t", ",", "t", ",", "3"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->28655],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"Sin", "[", 
    RowBox[{"2", " ", "\[Pi]", " ", "t"}], "]"}], "\[Pi]"], "-", 
  FractionBox[
   RowBox[{"Sin", "[", 
    RowBox[{"4", " ", "\[Pi]", " ", "t"}], "]"}], 
   RowBox[{"2", " ", "\[Pi]"}]], "+", 
  FractionBox[
   RowBox[{"Sin", "[", 
    RowBox[{"6", " ", "\[Pi]", " ", "t"}], "]"}], 
   RowBox[{"3", " ", "\[Pi]"}]]}]], "Output",
 ImageSize->{231, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->22929]
}, Open  ]],

Cell["\<\
The plot of the truncated series is similar to that of the function. \
\>", "MathCaption",
 CellID->29188],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", 
     RowBox[{"-", "1.5"}], ",", "1.5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->31529],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->54452846]
}, Open  ]],

Cell["Here are the two plots on the same axes. ", "MathCaption",
 CellID->30493],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"rndplt", ",", "%"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->26228],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->501069794]
}, Open  ]],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["setting", "TableHeader"],
     " "
    }]], Cell[TextData[{
     StyleBox["Fourier coefficient", "TableHeader"],
     " "
    }]]},
   {Cell[TextData[{
     StyleBox["{0,", "MR"],
     " ",
     StyleBox["1}", "MR"],
     " "
    }]], Cell[TextData[{
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubsuperscriptBox["\[Integral]", 
         RowBox[{
          RowBox[{"-", "1"}], "/", "2"}], 
         RowBox[{"1", "/", "2"}]], 
        StyleBox["f", "TI"], 
        RowBox[{"(", 
         StyleBox["t", "TI"], ")"}], " ", 
        SuperscriptBox[
         StyleBox["e", "TI"], 
         RowBox[{"2", "\[Pi]", 
          StyleBox["i", "TI"], 
          StyleBox["n", "TI"], 
          StyleBox["t", "TI"]}]], "\[DifferentialD]", 
        StyleBox["t", "TI"]}], TraditionalForm]], "InlineFormula"],
     " "
    }]]},
   {Cell[TextData[{
     StyleBox["{", "MR"],
     StyleBox["a", "TI"],
     StyleBox[",", "MR"],
     " ",
     StyleBox["b", "TI"],
     StyleBox["}", "MR"],
     " "
    }]], Cell[TextData[{
     Cell[BoxData[
      FormBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"\[LeftBracketingBar]", 
          StyleBox["b", "TI"], "\[RightBracketingBar]"}], 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", 
            StyleBox["a", "TI"]}], ")"}], "/", "2"}]], 
        SubsuperscriptBox["\[Integral]", 
         RowBox[{
          RowBox[{"-", "1"}], "/", 
          RowBox[{"(", 
           RowBox[{"2", "\[LeftBracketingBar]", 
            StyleBox["b", "TI"], "\[RightBracketingBar]"}], ")"}]}], 
         RowBox[{"1", "/", 
          RowBox[{"(", 
           RowBox[{"2", "\[LeftBracketingBar]", 
            StyleBox["b", "TI"], "\[RightBracketingBar]"}], ")"}]}]], 
        StyleBox["f", "TI"], 
        RowBox[{"(", 
         StyleBox["t", "TI"], ")"}], " ", 
        SuperscriptBox[
         StyleBox["e", "TI"], 
         RowBox[{"2", "\[Pi]", 
          StyleBox["i", "TI"], 
          StyleBox["b", "TI"], 
          StyleBox["n", "TI"], 
          StyleBox["t", "TI"]}]], "\[DifferentialD]", 
        StyleBox["t", "TI"]}], TraditionalForm]], "InlineFormula"],
     " "
    }]]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellID->18899],

Cell[TextData[{
 "Effect of ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FourierParameters",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FourierParameters"], "MR"]], "InlineFormula"],
 " setting on Fourier exponential coefficients."
}], "Caption",
 CellID->23836],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["setting", "TableHeader"],
     " "
    }]], Cell[TextData[{
     StyleBox["Fourier series", "TableHeader"],
     " "
    }]], "\[Null]"},
   {Cell[TextData[{
     StyleBox["{0,", "MR"],
     " ",
     StyleBox["1}", "MR"],
     " "
    }]], Cell[TextData[{
     Cell[BoxData[
      FormBox[
       RowBox[{
        UnderoverscriptBox["\[Sum]", 
         RowBox[{
          StyleBox["n", "TI"], "=", "-", 
          StyleBox["k", "TI"]}], 
         StyleBox["k", "TI"],
         LimitsPositioning->True], 
        SubscriptBox[
         StyleBox["F", "TI"], 
         StyleBox["n", "TI"]], " ", 
        SuperscriptBox[
         StyleBox["e", "TI"], 
         RowBox[{
          RowBox[{"-", "2"}], "\[Pi]", 
          StyleBox["i", "TI"], 
          StyleBox["n", "TI"], 
          StyleBox["t", "TI"]}]]}], TraditionalForm]], "InlineFormula"],
     " "
    }]], "\[Null]"},
   {Cell[TextData[{
     StyleBox["{", "MR"],
     StyleBox["a", "TI"],
     StyleBox[",", "MR"],
     " ",
     StyleBox["b", "TI"],
     StyleBox["}", "MR"],
     " "
    }]], Cell[TextData[{
     Cell[BoxData[
      FormBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"\[LeftBracketingBar]", 
          StyleBox["b", "TI"], "\[RightBracketingBar]"}], 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", 
            StyleBox["a", "TI"]}], ")"}], "/", "2"}]], 
        UnderoverscriptBox["\[Sum]", 
         RowBox[{
          StyleBox["n", "TI"], "=", "-", 
          StyleBox["k", "TI"]}], 
         StyleBox["k", "TI"],
         LimitsPositioning->True], 
        SubscriptBox[
         StyleBox["F", "TI"], 
         StyleBox["n", "TI"]], " ", 
        SuperscriptBox[
         StyleBox["e", "TI"], 
         RowBox[{
          RowBox[{"-", "2"}], "\[Pi]", 
          StyleBox["i", "TI"], 
          StyleBox["b", "TI"], 
          StyleBox["n", "TI"], 
          StyleBox["t", "TI"]}]]}], TraditionalForm]], "InlineFormula"],
     " "
    }]], "\[Null]"}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellID->815],

Cell[TextData[{
 "Effect of ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FourierParameters",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FourierParameters"], "MR"]], "InlineFormula"],
 " setting on Fourier exponential series."
}], "Caption",
 CellID->11872],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["setting", "TableHeader"],
     " "
    }]], Cell[TextData[{
     Cell[BoxData[
      FormBox[
       SubscriptBox[
        StyleBox["c", "TI"], "0"], TraditionalForm]], "InlineFormula"],
     " "
    }]], Cell[TextData[{
     Cell[BoxData[
      FormBox[
       SubscriptBox[
        StyleBox["c", "TI"], 
        StyleBox["n", "TI"]], TraditionalForm]], "InlineFormula"],
     " "
    }]]},
   {Cell[TextData[{
     StyleBox["{0,", "MR"],
     " ",
     StyleBox["1}", "MR"],
     " "
    }]], Cell[TextData[{
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubsuperscriptBox["\[Integral]", 
         RowBox[{
          RowBox[{"-", "1"}], "/", "2"}], 
         RowBox[{"1", "/", "2"}]], 
        StyleBox["f", "TI"], 
        RowBox[{"(", 
         StyleBox["t", "TI"], ")"}], "\[DifferentialD]", 
        StyleBox["t", "TI"]}], TraditionalForm]], "InlineFormula"],
     " "
    }]], Cell[TextData[{
     Cell[BoxData[
      FormBox[
       RowBox[{"2", 
        SubsuperscriptBox["\[Integral]", 
         RowBox[{
          RowBox[{"-", "1"}], "/", "2"}], 
         RowBox[{"1", "/", "2"}]], 
        StyleBox["f", "TI"], 
        RowBox[{"(", 
         StyleBox["t", "TI"], ")"}], " ", "cos", 
        RowBox[{"(", 
         RowBox[{"2", "\[Pi]", 
          StyleBox["n", "TI"], 
          StyleBox["t", "TI"]}], ")"}], "\[DifferentialD]", 
        StyleBox["t", "TI"]}], TraditionalForm]], "InlineFormula"],
     " "
    }]]},
   {Cell[TextData[{
     StyleBox["{", "MR"],
     StyleBox["a", "TI"],
     StyleBox[",", "MR"],
     " ",
     StyleBox["b", "TI"],
     StyleBox["}", "MR"],
     " "
    }]], Cell[TextData[{
     Cell[BoxData[
      FormBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"\[LeftBracketingBar]", 
          StyleBox["b", "TI"], "\[RightBracketingBar]"}], 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", 
            StyleBox["a", "TI"]}], ")"}], "/", "2"}]], 
        SubsuperscriptBox["\[Integral]", 
         RowBox[{
          RowBox[{"-", "1"}], "/", 
          RowBox[{"(", 
           RowBox[{"2", "\[LeftBracketingBar]", 
            StyleBox["b", "TI"], "\[RightBracketingBar]"}], ")"}]}], 
         RowBox[{"1", "/", 
          RowBox[{"(", 
           RowBox[{"2", "\[LeftBracketingBar]", 
            StyleBox["b", "TI"], "\[RightBracketingBar]"}], ")"}]}]], 
        StyleBox["f", "TI"], 
        RowBox[{"(", 
         StyleBox["t", "TI"], ")"}], "\[DifferentialD]", 
        StyleBox["t", "TI"]}], TraditionalForm]], "InlineFormula"],
     " "
    }]], Cell[TextData[{
     Cell[BoxData[
      FormBox[
       RowBox[{"2", 
        SuperscriptBox[
         RowBox[{"\[LeftBracketingBar]", 
          StyleBox["b", "TI"], "\[RightBracketingBar]"}], 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", 
            StyleBox["a", "TI"]}], ")"}], "/", "2"}]], 
        SubsuperscriptBox["\[Integral]", 
         RowBox[{
          RowBox[{"-", "1"}], "/", 
          RowBox[{"(", 
           RowBox[{"2", "\[LeftBracketingBar]", 
            StyleBox["b", "TI"], "\[RightBracketingBar]"}], ")"}]}], 
         RowBox[{"1", "/", 
          RowBox[{"(", 
           RowBox[{"2", "\[LeftBracketingBar]", 
            StyleBox["b", "TI"], "\[RightBracketingBar]"}], ")"}]}]], 
        StyleBox["f", "TI"], 
        RowBox[{"(", 
         StyleBox["t", "TI"], ")"}], " ", "cos", 
        RowBox[{"(", 
         RowBox[{"2", "\[Pi]", 
          StyleBox["b", "TI"], 
          StyleBox["n", "TI"], 
          StyleBox["t", "TI"]}], ")"}], "\[DifferentialD]", 
        StyleBox["t", "TI"]}], TraditionalForm]], "InlineFormula"],
     " "
    }]]}
  },
  GridBoxAlignment->{
   "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
    "RowsIndexed" -> {}}]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellID->23814],

Cell[TextData[{
 "Effect of ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FourierParameters",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FourierParameters"], "MR"]], "InlineFormula"],
 " setting on Fourier cosine coefficients."
}], "Caption",
 CellID->26388],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["setting", "TableHeader"],
     " "
    }]], Cell[TextData[{
     Cell[BoxData[
      FormBox[
       SubscriptBox[
        StyleBox["d", "TI"], 
        StyleBox["n", "TI"]], TraditionalForm]], "InlineFormula"],
     " "
    }]]},
   {Cell[TextData[{
     StyleBox["{0,", "MR"],
     " ",
     StyleBox["1}", "MR"],
     " "
    }]], Cell[TextData[{
     Cell[BoxData[
      FormBox[
       RowBox[{"2", 
        SubsuperscriptBox["\[Integral]", 
         RowBox[{
          RowBox[{"-", "1"}], "/", "2"}], 
         RowBox[{"1", "/", "2"}]], 
        StyleBox["f", "TI"], 
        RowBox[{"(", 
         StyleBox["t", "TI"], ")"}], " ", "sin", 
        RowBox[{"(", 
         RowBox[{"2", "\[Pi]", 
          StyleBox["n", "TI"], 
          StyleBox["t", "TI"]}], ")"}], "\[DifferentialD]", 
        StyleBox["t", "TI"]}], TraditionalForm]], "InlineFormula"],
     " "
    }]]},
   {Cell[TextData[{
     StyleBox["{", "MR"],
     StyleBox["a", "TI"],
     StyleBox[",", "MR"],
     " ",
     StyleBox["b", "TI"],
     StyleBox["}", "MR"],
     " "
    }]], Cell[TextData[{
     Cell[BoxData[
      FormBox[
       RowBox[{"2", 
        SuperscriptBox[
         RowBox[{"\[LeftBracketingBar]", 
          StyleBox["b", "TI"], "\[RightBracketingBar]"}], 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", 
            StyleBox["a", "TI"]}], ")"}], "/", "2"}]], 
        SubsuperscriptBox["\[Integral]", 
         RowBox[{
          RowBox[{"-", "1"}], "/", 
          RowBox[{"(", 
           RowBox[{"2", "\[LeftBracketingBar]", 
            StyleBox["b", "TI"], "\[RightBracketingBar]"}], ")"}]}], 
         RowBox[{"1", "/", 
          RowBox[{"(", 
           RowBox[{"2", "\[LeftBracketingBar]", 
            StyleBox["b", "TI"], "\[RightBracketingBar]"}], ")"}]}]], 
        StyleBox["f", "TI"], 
        RowBox[{"(", 
         StyleBox["t", "TI"], ")"}], " ", "sin", 
        RowBox[{"(", 
         RowBox[{"2", "\[Pi]", 
          StyleBox["b", "TI"], 
          StyleBox["n", "TI"], 
          StyleBox["t", "TI"]}], ")"}], "\[DifferentialD]", 
        StyleBox["t", "TI"]}], TraditionalForm]], "InlineFormula"],
     " "
    }]]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellID->21204],

Cell[TextData[{
 "Effect of ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FourierParameters",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FourierParameters"], "MR"]], "InlineFormula"],
 " setting on Fourier sine coefficients."
}], "Caption",
 CellID->19978],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["setting", "TableHeader"],
     " "
    }]], Cell[TextData[{
     StyleBox["Fourier trigonometric series", "TableHeader"],
     " "
    }]]},
   {Cell[TextData[{
     StyleBox["{0,", "MR"],
     " ",
     StyleBox["1}", "MR"],
     " "
    }]], Cell[TextData[{
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox[
         StyleBox["c", "TI"], "0"], "+", 
        UnderoverscriptBox["\[Sum]", 
         RowBox[{
          StyleBox["n", "TI"], "=", "1"}], 
         StyleBox["k", "TI"],
         LimitsPositioning->True], 
        SubscriptBox[
         StyleBox["c", "TI"], 
         StyleBox["n", "TI"]], "cos", 
        RowBox[{"(", 
         RowBox[{"2", "\[Pi]", 
          StyleBox["n", "TI"], 
          StyleBox["t", "TI"]}], ")"}], "+", 
        SubscriptBox[
         StyleBox["d", "TI"], 
         StyleBox["n", "TI"]], "sin", 
        RowBox[{"(", 
         RowBox[{"2", "\[Pi]", 
          StyleBox["n", "TI"], 
          StyleBox["t", "TI"]}], ")"}]}], TraditionalForm]], "InlineFormula"],
     
     " "
    }]]},
   {Cell[TextData[{
     StyleBox["{", "MR"],
     StyleBox["a", "TI"],
     StyleBox[",", "MR"],
     " ",
     StyleBox["b", "TI"],
     StyleBox["}", "MR"],
     " "
    }]], Cell[TextData[{
     Cell[BoxData[
      FormBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"\[LeftBracketingBar]", 
          StyleBox["b", "TI"], "\[RightBracketingBar]"}], 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", 
            StyleBox["a", "TI"]}], ")"}], "/", "2"}]], 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox[
           StyleBox["c", "TI"], "0"], "+", 
          UnderoverscriptBox["\[Sum]", 
           RowBox[{
            StyleBox["n", "TI"], "=", "1"}], 
           StyleBox["k", "TI"],
           LimitsPositioning->True], 
          SubscriptBox[
           StyleBox["c", "TI"], 
           StyleBox["n", "TI"]], "cos", 
          RowBox[{"(", 
           RowBox[{"2", "\[Pi]", 
            StyleBox["b", "TI"], 
            StyleBox["n", "TI"], 
            StyleBox["t", "TI"]}], ")"}], "+", 
          SubscriptBox[
           StyleBox["d", "TI"], 
           StyleBox["n", "TI"]], "sin", 
          RowBox[{"(", 
           RowBox[{"2", "\[Pi]", 
            StyleBox["b", "TI"], 
            StyleBox["n", "TI"], 
            StyleBox["t", "TI"]}], ")"}]}], ")"}]}], TraditionalForm]], 
      "InlineFormula"],
     " "
    }]]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellID->19580],

Cell[TextData[{
 "Effect of ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FourierParameters",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FourierParameters"], "MR"]], "InlineFormula"],
 " setting on Fourier trigonometric series."
}], "Caption",
 CellID->16025],

Cell[TextData[{
 "In certain circumstances you will not want exact or symbolic coefficients, \
but numerical approximations to the coefficients. In these cases you can use \
the numerical versions of the Fourier series functions. The numerical \
approximation functions accept the ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FourierParameters",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FourierParameters"], "MR"]], "InlineFormula"],
 " option, allowing you to specify the period. "
}], "Text",
 CellID->9938],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["NFourierCoefficient",
      BaseStyle->"Link",
      ButtonData->"paclet:FourierSeries/ref/NFourierCoefficient"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["t", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "find a numerical approximation to the ",
     Cell[BoxData[
      SuperscriptBox[
       StyleBox["n", "TI"], "th"]], "InlineFormula"],
     " coefficient in the exponential series expansion "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["NFourierSinCoefficient",
      BaseStyle->"Link",
      ButtonData->"paclet:FourierSeries/ref/NFourierSinCoefficient"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["t", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "find a numerical approximation to the ",
     Cell[BoxData[
      SuperscriptBox[
       StyleBox["n", "TI"], "th"]], "InlineFormula"],
     " coefficient in the sine series expansion"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["NFourierCosCoefficient",
      BaseStyle->"Link",
      ButtonData->"paclet:FourierSeries/ref/NFourierCosCoefficient"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["t", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "find a numerical approximation to the ",
     Cell[BoxData[
      SuperscriptBox[
       StyleBox["n", "TI"], "th"]], "InlineFormula"],
     " coefficient in the cosine series expansion"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["NFourierSeries",
      BaseStyle->"Link",
      ButtonData->"paclet:FourierSeries/ref/NFourierSeries"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["t", "TI"], ",", 
     StyleBox["k", "TI"], "]"}], Cell[TextData[{
     "find the exponential series expansion to order ",
     Cell[BoxData[
      StyleBox["k", "TI"]], "InlineFormula"],
     " using numerical approximations for the coefficients"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["NFourierTrigSeries",
      BaseStyle->"Link",
      ButtonData->"paclet:FourierSeries/ref/NFourierTrigSeries"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["t", "TI"], ",", 
     StyleBox["k", "TI"], "]"}], Cell[TextData[{
     "find the trigonometric series expansion to order ",
     Cell[BoxData[
      StyleBox["k", "TI"]], "InlineFormula"],
     " using numerical approximations for the coefficients"
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, False, False, True, {False}, False},
    "RowsIndexed" -> {}}},
 CellID->23973],

Cell["\<\
Finding approximate numerical values for Fourier coefficients and series. \
\>", "Caption",
 CellID->10534],

Cell[TextData[{
 "Here is a piece of the trigonometric series of a function that looks like \
",
 Cell[BoxData[
  FormBox[
   RowBox[{"sin", 
    RowBox[{"(", 
     RowBox[{"cos", 
      RowBox[{"(", 
       RowBox[{
        StyleBox["t", "TI"], "+", 
        FractionBox["1", "2"]}], ")"}]}], ")"}]}], TraditionalForm]], 
  "InlineFormula"],
 " on the interval from ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", 
    FractionBox["1", "2"]}], TraditionalForm]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  FormBox[
   FractionBox["1", "2"], TraditionalForm]], "InlineFormula"],
 ". The function elsewhere is obtained by repeating this with period ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->31592],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NFourierTrigSeries", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"Cos", "[", 
     RowBox[{"t", "+", 
      FractionBox["1", "2"]}], "]"}], "]"}], ",", "t", ",", "3"}], 
  "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->6214],

Cell[BoxData[
 RowBox[{"0.7386429980368909`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.037078333227460264`", " ", 
   RowBox[{"Cos", "[", 
    RowBox[{"2", " ", "\[Pi]", " ", "t"}], "]"}]}], "-", 
  RowBox[{"0.009180560815768079`", " ", 
   RowBox[{"Cos", "[", 
    RowBox[{"4", " ", "\[Pi]", " ", "t"}], "]"}]}], "+", 
  RowBox[{"0.004070198115637115`", " ", 
   RowBox[{"Cos", "[", 
    RowBox[{"6", " ", "\[Pi]", " ", "t"}], "]"}]}], "-", 
  RowBox[{"0.1003376185880478`", " ", 
   RowBox[{"Sin", "[", 
    RowBox[{"2", " ", "\[Pi]", " ", "t"}], "]"}]}], "+", 
  RowBox[{"0.05172778998316851`", " ", 
   RowBox[{"Sin", "[", 
    RowBox[{"4", " ", "\[Pi]", " ", "t"}], "]"}]}], "-", 
  RowBox[{"0.03461313084639009`", " ", 
   RowBox[{"Sin", "[", 
    RowBox[{"6", " ", "\[Pi]", " ", "t"}], "]"}]}]}]], "Output",
 ImageSize->{502, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->31115]
}, Open  ]],

Cell["\<\
Here is a plot of the trigonometric polynomial over three periods. \
\>", "MathCaption",
 CellID->23204],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", 
     RowBox[{"-", "1.5"}], ",", "1.5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->32301],

Cell[GraphicsData["CompressedBitmap", "\<\
eJytW0uoXVcZ3jnn7HNv7j03aXLuK/cmN4lN0jyM1VoVBHEgKiIiDtoOgoMY
hATRSo0TnehEJzrRiQWxAx9gdVCxVIQKYkEsiAWxICpIhdIOLIUWBwHh+K/1
rbW+f397ndxHvST3nL3X4/v+f/3/tx57309cv33zs5+/fvvWjetnPvrY9S/e
vHXjS2c+8uhjdmt4qGmap+3/5zYb+z6zb/H/07OZfeL3Nfs9sJuPxKv3h9/D
737n98//4V/h6068Dm3iT3M81P7Zk39+MN63SlY1fF2OrRfsd6g8cK2acG3/
j1XKwtdQthK+jKzbb37jt4889JPXXvtPuDus9LIqrY/Fls/97p9N/DFC+8W+
J94zSAPO9Wt9RDbNovQwluujch1bjXjdNJN459PXfvrSS6//+EcvVFi1FRsD
g+O5r988+w9YvLBv9FBj8MQP/tgMX3nljWRg6CUEyqHwiWrDZLi3/S5WB6+M
KvX6+EupZtO++JdXfUHPlmNyHcdpfOfOf+2W/X7zzTv4sv8RiDVaG25zAe4E
X/S98NbHOmbFosU1sgQ3jTm+7M1iC2nf5d//9u/98zgSe7IY/9Qnf1huWhTt
bvNo5mJvD7Z+9Su/ttAsN1/408v40qZ+VtNntHUcAtF18YunXtw7HmwyMIMs
N83PGamer6NdfD7PrhItuGmJS7t8+2l1DL98+xnfpbHcPw/Ya00tnMrNG5/5
uTKIahJja9Dw8570OU6f0aqhheLHP/ZEaTW0AUhZn9vV7bEwsmBCTQvIxKKG
g9i8dfMpS/eIE5oMP/yh77vxKIrbvC/Wtog3h5GVNbUOwteTwuZo1QoTBQA0
98dru7BbLAf7WdKtjGpD+vj3nmct9nrS2ebZDaW3q/HaZN3EneVWOc2lHu3r
X3vW8q/Wy3bVxqIhqT49CtSSB6m8xEkH1QbKhqvWSx312996zkKC9W16/tUz
fyUqfTYUloslCp8subhUi1SN+bdQvuf6GCKUj1FuSmT/ZtWcPjDOfninXLeQ
s8AbOGYWJhYse2P2f/OQliNQGs+LcZ5mst74bsp1VDAXqVEDRxZQFlboZ6va
osxbqQX1oN8CcQsvFgtGVITM9b2zbvxCj5nbIR+oX7yPejYV2IQQvr5dGLaC
79GYTegFypnR+nYzm9DrBz/weCq/Eq9tcn30C79kObPbo1qVNAsDlbpWRyVL
9Mp1ElCt0KqwvMz4HVTqGWpRg+tjTJVEfSoTUKlnrbAE6nviXY4z1khYZWdU
jqeyoxpfqbAJ6+VFh8JxG4uH1bYV8fhYbLkiLMGGGeFtY96gF2pxHVVZMpou
V33FaPKozBDUsou09skexfhRpcZyDTSqxViuPRptUs51G5Udbbhc9Rnz1KMy
1pR7HZXRgvpUg8vCCit85u3YoVIjlHvXs8qO43a5lgkutoH2YM1yxzmv1Hpz
QVqVDSvzzopYgD6Z45ckL1BOffLMqOYLYl9E7ayBR/U7d5nB4m7bZSD2A9S0
S+KzBWHumVL5FsX+ObwOwJTeWJTRvyjeQblkTGIqqz+nMAdlGi7BkOqEvqn/
YEjdQTkVwzNkq0XxeJ3PMEXooBKNE8FRz4AXsxrloh2JFz2FWsz1Pq/dVmPq
x0nF8jC3XKryp5/B790y/odn3ezPO7C8c8veyjuslap9VNiL1XHhysez4Bgf
TjaoUi5X2dKmi1U2MmclNI4cemEenqiidtl5ZQUq9RioXS3MqBwP9MK5pI6q
LMnivnjNGW9JWLQOlSsP9EI9OJHGUaMd9ajv9wlboFGrPBr9f1g8UbeR7NSG
C8IK5dRZoD4gUbEk13VUqvOSXF+osqKWeFR6Er1yttqc1c9ElsVHF8STQKNC
eDTm1bJ4QndF6IV5tiw2nJfxRbms0lMvaMJW1EC04mxSZ0FNXBbbzktUhfKQ
92OHThvPy7Xa1PU4NUdtQz+czSKq9elRadM5Gb+J+CArYf9sLZeoomvuZKsR
CVzPTB0fWgk+1LyJWNPnEfHbcgc3d93Fq94Ahyqpfll1bDnC58Rbk2Rrf94b
9+7sjSGjayLRdE6uPUNGw72zpBaWCeH4f0X82/fn3piGy8MSS2DImUO9Q4bB
RyjlDLAi1wdlps9Y/CwCDCp28Y6NcnhKsuZ8yFhALSrmithZz4185oM7++HL
aNe9MJhQJz1fRsLbhN8RsTpn7njGJ3w5k8NnmeHNa8Er2P9z3jqbWVl5ONJe
dyyIejazsgwLtfTcWdUUOzXMOJaX6eSYengmjyUGotlwqLQtPnttjbVFmIW8
eSRgHxMLNgQb+Wp+tV4M3kDQgmoV+x1ZdJrN9s/M3HT4nI1PxXpmpXnBKBj4
VOzYmHGNGbPDxjI8S5tKlMWehtaH2WCEsK/uzcM43acirQpvtRQRR1VZzSxS
jp6UWNp2qLRhW2rFOHQqHlEXvCbjWXHJMbfq2c4exENsMOjNvdvinTXhHRHH
HhFZFGIzqA3sYk57FPa6JdEUI9vlYx67OHhFNlCLmrotY+Cx9ASKfshMY1xx
PkO3aRzp8S2XLSVaEkb3vMmvxpTpRhfLZ5acrfhePRYjCetQai164Rqt+C5o
gKVmiIUN8feWxJlHIusTgrwhvsi7uL4uhzvlbCaVoF+oEdVJrdlxTGjTiVrc
O3sGPQa6WqqecKQWiBVgULvAlHOAZ0YfqD24pk71mekT8tpzjmEcPz7Uhb3c
WwCFa1PPjV7ZlFiOFrZF00Bn15OBuc9hANSLfaByXeq50S+oxfUTuMmT7Do3
enMmK+OUw1vVaGGenY69YxVFhUct5gQYlV7mMOqP71x/YvJI7LqKGvTojGNF
Fusyplsy8nlNkdcYerISYzMxgc+7Kuv95P3CGUG1TPmvZ/vSCh/lVI31PPJp
7eft5IywLr1uJa+UebVz1k426zK2vnflSK+iF85S68lbmFGoO3muOOt6pT6v
ydigNVfWxTMpE4DKvdC6+N9zl7Vnb9ajxWu517T63RZWKKdCeVvIVed59EJd
XsusGvxgnqdaYn1DrfEoypXaABSeH5T1TbIFKNQ9XUV5FFqMWjJnO65T55Fg
C8q5jliVaPEoVLDVFBs7UnvqPMveGelTYRd3EWkHQjWaCiesd8v1bP5zke6s
DF/5MaP3phLPngntOS6RgBU67ZmjifN2Zek+9QAeCp5Uv3s+zJJyJmUt7FZS
f6rajrN7d3540y/ocpeff/J/SjKw7IWMQXgrqZUov9fx5o4h7uJbu8COxUY/
ZNMwR1Xyxunki3R0RheWXWPcq6TYiozTutK9P1NRsoge3rIzXGtvumeJaikA
fM4nnrue+lvrtMeEp8zn0Hj7wUweFWxEXZ3j+2XMFtSspjHXIhggfL12sEdO
z5f8G332xWyDsCC7zjtb5O0ffWdpZIZafFvndjfm+4i+u4sVSe2yFRYj4eWd
prGWwZy6FdQ7PTeJXFqLJEsCCxPY03g7qNjliWTaz7W5rzRvw4risZlfK0Fh
G6cW/nw2rykQ99SkBcm08s6GNQ3WXnA89ckps+NSbpXmowXxybL4DKpFVdAn
yVcdqj5JJlc8j9bn2noSrqjyrNVZ8Y6IekQ8NBauQJVny67XOqq+aUArPKq+
mcEowpsbzOk2R0rSmElnfOUZqGPr0fQdGHoOaPpmDj01qdqob+pw9r7foWqv
9BxQucpsxZY6Ktcn+jaLR9U3r+g5vFHFHNR3m7qe5Yi0Mq4eTd45c54DGjVP
35Faqdoo7yi4aPSo3V7DjHNVWo+EnaKdkigcyji+06FprxzHq9VeuiezwaM7
EtNDGT+gHRWLyzu3afxiRI/QC/QP+zdzRTHsbu+WnBJ2Ont6Ft09Wk87FizE
/PyelqP9/eRu72aAE/MJnKh0nhPzYyCWgBPcUqDTfvqgnBhjA7l+l+PECBtI
LIBT+VsQQKcF7bz3LfLIYRVYvDBDjD9A3HHJI/tB1EZW48b9FQQe5tT3+DX0
iDr2ZwbYRwM3nrS3RS0gM/BFWMOlaImLisqZ2m7nNDuz/NczxSA8Scd777kE
7k2oWPcCMox9PjXQz9OxdtEzhI3rvRnh3NlArCxaG95rNVOtnrlA/4Ig9hfy
0HxglczH6Av1bKKxWA75ijcBzBjT27ASqvYTFNHKQ5zE92Tkr8auSZuH4c5D
/wNudeWE\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->832085675]
}, Open  ]],

Cell[TextData[{
 "The function ",
 Cell[BoxData[
  ButtonBox["FourierCoefficient",
   BaseStyle->"Link",
   ButtonData->"paclet:FourierSeries/ref/FourierCoefficient"]], 
  "InlineFormula"],
 ", giving the coefficients of the Fourier exponential series, can be thought \
of as a transform from the continuous time domain into the discrete frequency \
domain. Likewise, the (infinite sum) Fourier exponential series can be \
thought of as an inverse transform from the discrete frequency domain into \
the continuous time domain. This transform pair is given by ",
 Cell[BoxData[
  ButtonBox["FourierCoefficient",
   BaseStyle->"Link",
   ButtonData->"paclet:FourierSeries/ref/FourierCoefficient"]], 
  "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["InverseFourierCoefficient",
   BaseStyle->"Link",
   ButtonData->"paclet:FourierSeries/ref/InverseFourierCoefficient"]], 
  "InlineFormula"],
 ", and the numerical counterparts are given by ",
 Cell[BoxData[
  ButtonBox["NFourierCoefficient",
   BaseStyle->"Link",
   ButtonData->"paclet:FourierSeries/ref/NFourierCoefficient"]], 
  "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["NInverseFourierCoefficient",
   BaseStyle->"Link",
   ButtonData->"paclet:FourierSeries/ref/NInverseFourierCoefficient"]], 
  "InlineFormula"],
 ". If the option setting ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FourierParameters",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FourierParameters"], "MR"]], "InlineFormula"],
 " ",
 StyleBox["->", "MR"],
 " ",
 StyleBox["{", "MR"],
 StyleBox["a", "TI"],
 StyleBox[",", "MR"],
 " ",
 StyleBox["b", "TI"],
 StyleBox["}", "MR"],
 " is specified, the period of the original function is taken to be ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "/", "\[LeftBracketingBar]", 
    StyleBox["b", "TI"], "\[RightBracketingBar]"}], TraditionalForm]], 
  "InlineFormula"],
 ", instead of the default period of ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineFormula"],
 ". "
}], "Text",
 CellID->14858],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["FourierCoefficient",
      BaseStyle->"Link",
      ButtonData->"paclet:FourierSeries/ref/FourierCoefficient"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["t", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "give ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["F", "TI"], 
       StyleBox["n", "TI"]]], "InlineFormula"],
     ", a function of integer ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " and the ",
     Cell[BoxData[
      SuperscriptBox[
       StyleBox["n", "TI"], "th"]], "InlineFormula"],
     " coefficient in the exponential series expansion of the periodic \
function ",
     Cell[BoxData[
      RowBox[{
       StyleBox["f", "TI"], "(", 
       StyleBox["t", "TI"], ")"}]], "InlineFormula"],
     ", equal to ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " on the interval ",
     Cell[BoxData[
      RowBox[{
       StyleBox["t", "TI"], "=", "-", 
       FractionBox["1", "2"]}]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      RowBox[{
       StyleBox["t", "TI"], "=", 
       FractionBox["1", "2"]}]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["InverseFourierCoefficient",
      BaseStyle->"Link",
      ButtonData->"paclet:FourierSeries/ref/InverseFourierCoefficient"], "[", 
     
     StyleBox["expr", "TI"], ",", 
     StyleBox["n", "TI"], ",", 
     StyleBox["t", "TI"], "]"}], Cell[TextData[{
     "give ",
     Cell[BoxData[
      RowBox[{
       StyleBox["f", "TI"], "(", 
       StyleBox["t", "TI"], ")"}]], "InlineFormula"],
     ", a periodic function of ",
     Cell[BoxData[
      StyleBox["t", "TI"]], "InlineFormula"],
     ", represented by the Fourier exponential series coefficients ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ", where ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " is treated as a function of integer ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["NFourierCoefficient",
      BaseStyle->"Link",
      ButtonData->"paclet:FourierSeries/ref/NFourierCoefficient"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["t", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "find a numerical approximation to the function ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["F", "TI"], 
       StyleBox["n", "TI"]]], "InlineFormula"],
     " "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["NInverseFourierCoefficient",
      BaseStyle->"Link",
      ButtonData->"paclet:FourierSeries/ref/NInverseFourierCoefficient"], "[",
      
     StyleBox["expr", "TI"], ",", 
     StyleBox["n", "TI"], ",", 
     StyleBox["t", "TI"], "]"}], Cell[TextData[{
     "find a numerical approximation to the function ",
     Cell[BoxData[
      RowBox[{
       StyleBox["f", "TI"], "(", 
       StyleBox["t", "TI"], ")"}]], "InlineFormula"],
     " "
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->12350],

Cell["\<\
Continuous\[Hyphen]time and discrete\[Hyphen]frequency transform pairs: exact \
and numerical approximations. \
\>", "Caption",
 CellID->32691],

Cell[TextData[{
 "Here is a plot of a periodic function of ",
 Cell[BoxData[
  FormBox[
   StyleBox["t", "TI"], TraditionalForm]], "InlineFormula"],
 ", with a period of ",
 Cell[BoxData[
  FormBox[
   FractionBox["2", "3"], TraditionalForm]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->13140],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{"1", "+", 
    RowBox[{"2", " ", 
     RowBox[{"Cos", "[", 
      RowBox[{"3", " ", "\[Pi]", " ", "t"}], "]"}]}], "+", 
    RowBox[{"2", " ", 
     RowBox[{"Cos", "[", 
      RowBox[{"6", " ", "\[Pi]", " ", "t"}], "]"}]}]}]}], ";", 
  RowBox[{"Plot", "[", 
   RowBox[{"f", ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", 
      RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[9]:=",
 CellID->18917],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->79021661]
}, Open  ]],

Cell[TextData[{
 "You can use the ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FourierParameters",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FourierParameters"], "MR"]], "InlineFormula"],
 " option to specify the period of the function. "
}], "MathCaption",
 CellID->19981],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Chop", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"NFourierCoefficient", "[", 
     RowBox[{"f", ",", "t", ",", "n", ",", 
      RowBox[{"FourierParameters", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0", ",", 
         FractionBox["3", "2"]}], "}"}]}], ",", 
      RowBox[{"AccuracyGoal", "\[Rule]", "8"}], ",", 
      RowBox[{"PrecisionGoal", "\[Rule]", "8"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", 
      RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->12153],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
   ",", "0.8164965809277259`", ",", "0.8164965809277271`", ",", 
   "0.8164965809277266`", ",", "0.8164965809277271`", ",", 
   "0.8164965809277259`", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
   ",", "0", ",", "0", ",", "0"}], "}"}]], "Output",
 ImageSize->{354, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->22704]
}, Open  ]],

Cell["\<\
The inverse of the Fourier coefficients gives the original periodic function. \
\
\>", "MathCaption",
 CellID->21504],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"nifc", "=", 
   RowBox[{"Chop", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"t", ",", 
        RowBox[{"NInverseFourierCoefficient", "[", 
         RowBox[{
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "2"}], "\[LessEqual]", "n", "\[LessEqual]", "2"}], 
            ",", "0.816497", ",", "0"}], "]"}], ",", "n", ",", "t", ",", 
          RowBox[{"FourierParameters", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"0", ",", 
             FractionBox["3", "2"]}], "}"}]}]}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", 
        RowBox[{"-", "1"}], ",", "1", ",", 
        FractionBox["1", "30"]}], "}"}]}], "]"}], "]"}]}], ";", 
  RowBox[{"ListLinePlot", "[", "nifc", "]"}]}]], "Input",
 CellLabel->"In[15]:=",
 CellID->12559],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], 
    LineBox[{{-1., 1.00000051325662}, {-0.966666666666667, 
     0.715921323610756}, {-0.933333333333333, 
     0.}, {-0.9, -0.7936049006576}, {-0.866666666666667, -1.23606861191986}, \
{-0.833333333333333, -1.00000051325662}, {-0.8, 0.}, {-0.766666666666667, 
     1.55753731525098}, {-0.733333333333333, 3.23606963843309}, {-0.7, 
     4.52014934133558}, {-0.666666666666667, 
     5.00000256628309}, {-0.633333333333333, 4.52014934133557}, {-0.6, 
     3.2360696384331}, {-0.566666666666667, 
     1.55753731525097}, {-0.533333333333333, 
     0.}, {-0.5, -1.00000051325662}, {-0.466666666666667, -1.23606861191986}, \
{-0.433333333333333, -0.793604900657599}, {-0.4, 0.}, {-0.366666666666667, 
     0.715921323610756}, {-0.333333333333333, 1.00000051325662}, {-0.3, 
     0.715921323610757}, {-0.266666666666667, 
     0.}, {-0.233333333333333, -0.7936049006576}, {-0.2, -1.23606861191986}, \
{-0.166666666666667, -1.00000051325662}, {-0.133333333333333, 0.}, {-0.1, 
     1.55753731525098}, {-0.0666666666666667, 
     3.2360696384331}, {-0.0333333333333333, 4.52014934133558}, {0., 
     5.00000256628309}, {0.0333333333333333, 4.52014934133558}, {
     0.0666666666666667, 3.2360696384331}, {0.1, 1.55753731525098}, {
     0.133333333333333, 0.}, {0.166666666666667, -1.00000051325662}, {
     0.2, -1.23606861191986}, {0.233333333333333, -0.7936049006576}, {
     0.266666666666667, 0.}, {0.3, 0.715921323610757}, {0.333333333333333, 
     1.00000051325662}, {0.366666666666667, 0.715921323610756}, {0.4, 0.}, {
     0.433333333333333, -0.793604900657599}, {
     0.466666666666667, -1.23606861191986}, {0.5, -1.00000051325662}, {
     0.533333333333333, 0.}, {0.566666666666667, 1.55753731525097}, {0.6, 
     3.2360696384331}, {0.633333333333333, 4.52014934133557}, {
     0.666666666666667, 5.00000256628309}, {0.7, 4.52014934133558}, {
     0.733333333333333, 3.23606963843309}, {0.766666666666667, 
     1.55753731525098}, {0.8, 0.}, {0.833333333333333, -1.00000051325662}, {
     0.866666666666667, -1.23606861191986}, {0.9, -0.7936049006576}, {
     0.933333333333333, 0.}, {0.966666666666667, 0.715921323610756}, {1., 
     1.00000051325662}}]}},
  AspectRatio->GoldenRatio^(-1),
  Axes->True,
  ImageMargins->0.,
  ImageSize->Medium,
  PlotRange->{{-1., 1.}, {-1.23606861191986, 5.00000256628309}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{364, 223},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]=",
 CellID->22386]
}, Open  ]],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["setting", "TableHeader"],
     " "
    }]], Cell[TextData[{
     StyleBox["Fourier coefficient", "TableHeader"],
     " "
    }]], Cell[TextData[{
     StyleBox["inverse Fourier coefficient", "TableHeader"],
     " "
    }]]},
   {Cell[TextData[{
     StyleBox["{0,", "MR"],
     " ",
     StyleBox["1}", "MR"],
     " "
    }]], Cell[TextData[{
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubsuperscriptBox["\[Integral]", 
         RowBox[{
          RowBox[{"-", "1"}], "/", "2"}], 
         RowBox[{"1", "/", "2"}]], 
        StyleBox["f", "TI"], 
        RowBox[{"(", 
         StyleBox["t", "TI"], ")"}], " ", 
        SuperscriptBox[
         StyleBox["e", "TI"], 
         RowBox[{"2", "\[Pi]", 
          StyleBox["i", "TI"], 
          StyleBox["n", "TI"], 
          StyleBox["t", "TI"]}]], "\[DifferentialD]", 
        StyleBox["t", "TI"]}], TraditionalForm]], "InlineFormula"],
     " "
    }]], Cell[TextData[{
     Cell[BoxData[
      FormBox[
       RowBox[{
        UnderoverscriptBox["\[Sum]", 
         RowBox[{
          StyleBox["n", "TI"], "=", "-", "\[Infinity]"}], "\[Infinity]",
         LimitsPositioning->True], 
        SubscriptBox[
         StyleBox["F", "TI"], 
         StyleBox["n", "TI"]], " ", 
        SuperscriptBox[
         StyleBox["e", "TI"], 
         RowBox[{
          RowBox[{"-", "2"}], "\[Pi]", 
          StyleBox["i", "TI"], 
          StyleBox["n", "TI"], 
          StyleBox["t", "TI"]}]]}], TraditionalForm]], "InlineFormula"],
     " "
    }]]},
   {Cell[TextData[{
     StyleBox["{", "MR"],
     StyleBox["a", "TI"],
     StyleBox[",", "MR"],
     " ",
     StyleBox["b", "TI"],
     StyleBox["}", "MR"],
     " "
    }]], Cell[TextData[{
     Cell[BoxData[
      FormBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"\[LeftBracketingBar]", 
          StyleBox["b", "TI"], "\[RightBracketingBar]"}], 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", 
            StyleBox["a", "TI"]}], ")"}], "/", "2"}]], 
        SubsuperscriptBox["\[Integral]", 
         RowBox[{
          RowBox[{"-", "1"}], "/", 
          RowBox[{"(", 
           RowBox[{"2", "\[LeftBracketingBar]", 
            StyleBox["b", "TI"], "\[RightBracketingBar]"}], ")"}]}], 
         RowBox[{"1", "/", 
          RowBox[{"(", 
           RowBox[{"2", "\[LeftBracketingBar]", 
            StyleBox["b", "TI"], "\[RightBracketingBar]"}], ")"}]}]], 
        StyleBox["f", "TI"], 
        RowBox[{"(", 
         StyleBox["t", "TI"], ")"}], " ", 
        SuperscriptBox[
         StyleBox["e", "TI"], 
         RowBox[{"2", "\[Pi]", 
          StyleBox["i", "TI"], 
          StyleBox["b", "TI"], 
          StyleBox["n", "TI"], 
          StyleBox["t", "TI"]}]], "\[DifferentialD]", 
        StyleBox["t", "TI"]}], TraditionalForm]], "InlineFormula"],
     " "
    }]], Cell[TextData[{
     Cell[BoxData[
      FormBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"\[LeftBracketingBar]", 
          StyleBox["b", "TI"], "\[RightBracketingBar]"}], 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", 
            StyleBox["a", "TI"]}], ")"}], "/", "2"}]], 
        UnderoverscriptBox["\[Sum]", 
         RowBox[{
          StyleBox["n", "TI"], "=", "-", "\[Infinity]"}], "\[Infinity]",
         LimitsPositioning->True], 
        SubscriptBox[
         StyleBox["F", "TI"], 
         StyleBox["n", "TI"]], " ", 
        SuperscriptBox[
         StyleBox["e", "TI"], 
         RowBox[{
          RowBox[{"-", "2"}], "\[Pi]", 
          StyleBox["i", "TI"], 
          StyleBox["b", "TI"], 
          StyleBox["n", "TI"], 
          StyleBox["t", "TI"]}]]}], TraditionalForm]], "InlineFormula"],
     " "
    }]]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellID->21628],

Cell[TextData[{
 "Effect of ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FourierParameters",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FourierParameters"], "MR"]], "InlineFormula"],
 " setting on Fourier coefficient."
}], "Caption",
 CellID->9329],

Cell[TextData[{
 "The Fourier transform from the discrete time domain into the continuous \
frequency domain is usually termed the discrete\[Hyphen]time Fourier \
transform, or ",
 Cell[BoxData[
  ButtonBox["DTFourierTransform",
   BaseStyle->"Link",
   ButtonData->"paclet:FourierSeries/ref/DTFourierTransform"]], 
  "InlineFormula"],
 ". The inverse transform from the continuous frequency domain into the \
discrete time domain is given by ",
 Cell[BoxData[
  ButtonBox["InverseDTFourierTransform",
   BaseStyle->"Link",
   ButtonData->"paclet:FourierSeries/ref/InverseDTFourierTransform"]], 
  "InlineFormula"],
 ". Just as the Z transform is the discrete analog of the Laplace transform, \
the discrete\[Hyphen]time Fourier transform is the discrete analog of the \
continuous\[Hyphen]time Fourier transform. If the option setting ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FourierParameters",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FourierParameters"], "MR"]], "InlineFormula"],
 " ",
 StyleBox["->", "MR"],
 " ",
 StyleBox["{", "MR"],
 StyleBox["a", "TI"],
 StyleBox[",", "MR"],
 " ",
 StyleBox["b", "TI"],
 StyleBox["}", "MR"],
 " is specified, the period of the discrete\[Hyphen]time Fourier transform is \
taken to be ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "/", "\[LeftBracketingBar]", 
    StyleBox["b", "TI"], "\[RightBracketingBar]"}], TraditionalForm]], 
  "InlineFormula"],
 ", instead of the default period of ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineFormula"],
 ". "
}], "Text",
 CellID->16106],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["DTFourierTransform",
      BaseStyle->"Link",
      ButtonData->"paclet:FourierSeries/ref/DTFourierTransform"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["n", "TI"], ",", 
     StyleBox["omega", "TI"], "]"}], Cell[TextData[{
     "give ",
     Cell[BoxData[
      RowBox[{
       StyleBox["F", "TI"], "(", "\[Omega]", ")"}]], "InlineFormula"],
     ", a periodic function of ",
     Cell[BoxData["\[Omega]"], "InlineFormula"],
     ", equal to the Fourier sum of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ", where ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " is treated as a function of integer ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["InverseDTFourierTransform",
      BaseStyle->"Link",
      ButtonData->"paclet:FourierSeries/ref/InverseDTFourierTransform"], "[", 
     
     StyleBox["expr", "TI"], ",", 
     StyleBox["omega", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "give ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["f", "TI"], 
       StyleBox["n", "TI"]]], "InlineFormula"],
     ", a function of integer ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " and the inverse Fourier sum of the periodic function ",
     Cell[BoxData[
      RowBox[{
       StyleBox["F", "TI"], "(", "\[Omega]", ")"}]], "InlineFormula"],
     ", where ",
     Cell[BoxData[
      RowBox[{
       StyleBox["F", "TI"], "(", "\[Omega]", ")"}]], "InlineFormula"],
     " is equal to ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " on the interval ",
     Cell[BoxData[
      RowBox[{"\[Omega]", "=", 
       FractionBox["-", 
        RowBox[{"1", "2"}]]}]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      RowBox[{"\[Omega]", "=", 
       FractionBox["1", "2"]}]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["NDTFourierTransform",
      BaseStyle->"Link",
      ButtonData->"paclet:FourierSeries/ref/NDTFourierTransform"], "[", 
     StyleBox["expr", "TI"], ",", 
     StyleBox["n", "TI"], ",", 
     StyleBox["omega", "TI"], "]"}], Cell[TextData[{
     "find a numerical approximation to the function ",
     Cell[BoxData[
      RowBox[{
       StyleBox["F", "TI"], "(", "\[Omega]", ")"}]], "InlineFormula"],
     " "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["NInverseDTFourierTransform",
      BaseStyle->"Link",
      ButtonData->"paclet:FourierSeries/ref/NInverseDTFourierTransform"], "[",
      
     StyleBox["expr", "TI"], ",", 
     StyleBox["omega", "TI"], ",", 
     StyleBox["n", "TI"], "]"}], Cell[TextData[{
     "find a numerical approximation to the function ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["f", "TI"], 
       StyleBox["n", "TI"]]], "InlineFormula"],
     " "
    }], "TableText"]}
  }]], "DefinitionBox",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, False, False, False, True, False, False, {False}, False},
    "RowsIndexed" -> {}}},
 CellID->28455],

Cell["\<\
Discrete\[Hyphen]time and continuous\[Hyphen]frequency transform pairs: exact \
and numerical approximations. \
\>", "Caption",
 CellID->17254],

Cell[TextData[{
 "This computes the Fourier transform of a discrete\[Hyphen]time rectangular \
function centered at ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["n", "TI"], "=", "0"}], TraditionalForm]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->11251],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dtft", "=", 
  RowBox[{"DTFourierTransform", "[", 
   RowBox[{
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"j", "=", 
       RowBox[{"-", "1"}]}], "1"], 
     RowBox[{"DiscreteDelta", "[", 
      RowBox[{"n", "+", "j"}], "]"}]}], ",", "n", ",", "\[Omega]"}], 
   "]"}]}]], "Input",
 CellLabel->"In[12]:=",
 CellID->17887],

Cell[BoxData[
 RowBox[{"1", "+", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"-", "2"}], " ", "\[ImaginaryI]", " ", "\[Pi]", " ", 
    "\[Omega]"}]], "+", 
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
   "2", " ", "\[ImaginaryI]", " ", "\[Pi]", " ", "\[Omega]"}]]}]], "Output",
 ImageSize->{111, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->13977]
}, Open  ]],

Cell["\<\
Here is a plot of the amplitude spectrum over three periods. \
\>", "MathCaption",
 CellID->22897],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Abs", "[", "dtft", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Omega]", ",", 
     RowBox[{"-", "1.5"}], ",", "1.5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[13]:=",
 CellID->32657],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 122},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]=",
 CellID->6883566]
}, Open  ]],

Cell[TextData[{
 "Here is a numerical approximation to the inverse discrete\[Hyphen]time \
Fourier transform, for ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["n", "TI"], "=", 
    RowBox[{"-", "5"}], ",", "\[Ellipsis]", ",", "5"}], TraditionalForm]], 
  "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->10226],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Chop", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"NInverseDTFourierTransform", "[", 
     RowBox[{"dtft", ",", "\[Omega]", ",", "n", ",", 
      RowBox[{"AccuracyGoal", "\[Rule]", "8"}], ",", 
      RowBox[{"PrecisionGoal", "\[Rule]", "8"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", 
      RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[14]:=",
 CellID->29272],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "0", ",", "0", ",", "0", ",", "1.000000000000001`", ",", 
   "1.000000000000001`", ",", "1.000000000000001`", ",", "0", ",", "0", ",", 
   "0", ",", "0"}], "}"}]], "Output",
 ImageSize->{228, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]=",
 CellID->31673]
}, Open  ]],

Cell["\<\
The Fourier exponential series and discrete\[Hyphen]time Fourier transforms \
are mathematically equivalent, if one exchanges the roles of time and \
frequency. \
\>", "Text",
 CellID->16604],

Cell[BoxData[GridBox[{
   {Cell[TextData[{
     StyleBox["setting", "TableHeader"],
     " "
    }]], Cell[TextData[{
     StyleBox["discrete-time Fourier transform", "TableHeader"],
     " "
    }]], Cell[TextData[{
     StyleBox["inverse discrete-time Fourier coefficient", "TableHeader"],
     " "
    }]]},
   {Cell[TextData[{
     StyleBox["{0,", "MR"],
     " ",
     StyleBox["1}", "MR"],
     " "
    }]], Cell[TextData[{
     Cell[BoxData[
      FormBox[
       RowBox[{
        UnderoverscriptBox["\[Sum]", 
         RowBox[{
          StyleBox["n", "TI"], "=", "-", "\[Infinity]"}], "\[Infinity]",
         LimitsPositioning->True], 
        SubscriptBox[
         StyleBox["f", "TI"], 
         StyleBox["n", "TI"]], " ", 
        SuperscriptBox[
         StyleBox["e", "TI"], 
         RowBox[{"2", "\[Pi]", 
          StyleBox["i", "TI"], 
          StyleBox["n", "TI"], "\[Omega]"}]]}], TraditionalForm]], 
      "InlineFormula"],
     " "
    }]], Cell[TextData[{
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubsuperscriptBox["\[Integral]", 
         RowBox[{
          RowBox[{"-", "1"}], "/", "2"}], 
         RowBox[{"1", "/", "2"}]], 
        StyleBox["F", "TI"], 
        RowBox[{"(", "\[Omega]", ")"}], " ", 
        SuperscriptBox[
         StyleBox["e", "TI"], 
         RowBox[{
          RowBox[{"-", "2"}], "\[Pi]", 
          StyleBox["i", "TI"], 
          StyleBox["n", "TI"], "\[Omega]"}]], "\[DifferentialD]", 
        "\[Omega]"}], TraditionalForm]], "InlineFormula"],
     " "
    }]]},
   {Cell[TextData[{
     StyleBox["{", "MR"],
     StyleBox["a", "TI"],
     StyleBox[",", "MR"],
     " ",
     StyleBox["b", "TI"],
     StyleBox["}", "MR"],
     " "
    }]], Cell[TextData[{
     Cell[BoxData[
      FormBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"\[LeftBracketingBar]", 
          StyleBox["b", "TI"], "\[RightBracketingBar]"}], 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", 
            StyleBox["a", "TI"]}], ")"}], "/", "2"}]], 
        UnderoverscriptBox["\[Sum]", 
         RowBox[{
          StyleBox["n", "TI"], "=", "-", "\[Infinity]"}], "\[Infinity]",
         LimitsPositioning->True], 
        SubscriptBox[
         StyleBox["f", "TI"], 
         StyleBox["n", "TI"]], " ", 
        SuperscriptBox[
         StyleBox["e", "TI"], 
         RowBox[{"2", "\[Pi]", 
          StyleBox["i", "TI"], 
          StyleBox["b", "TI"], 
          StyleBox["n", "TI"], "\[Omega]"}]]}], TraditionalForm]], 
      "InlineFormula"],
     " "
    }]], Cell[TextData[{
     Cell[BoxData[
      FormBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"\[LeftBracketingBar]", 
          StyleBox["b", "TI"], "\[RightBracketingBar]"}], 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", 
            StyleBox["a", "TI"]}], ")"}], "/", "2"}]], 
        SubsuperscriptBox["\[Integral]", 
         RowBox[{
          RowBox[{"-", "1"}], "/", 
          RowBox[{"(", 
           RowBox[{"2", "\[LeftBracketingBar]", 
            StyleBox["b", "TI"], "\[RightBracketingBar]"}], ")"}]}], 
         RowBox[{"1", "/", 
          RowBox[{"(", 
           RowBox[{"2", "\[LeftBracketingBar]", 
            StyleBox["b", "TI"], "\[RightBracketingBar]"}], ")"}]}]], 
        StyleBox["F", "TI"], 
        RowBox[{"(", "\[Omega]", ")"}], " ", 
        SuperscriptBox[
         StyleBox["e", "TI"], 
         RowBox[{
          RowBox[{"-", "2"}], "\[Pi]", 
          StyleBox["i", "TI"], 
          StyleBox["b", "TI"], 
          StyleBox["n", "TI"], "\[Omega]"}]], "\[DifferentialD]", 
        "\[Omega]"}], TraditionalForm]], "InlineFormula"],
     " "
    }]]}
  },
  GridBoxAlignment->{
   "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
    "RowsIndexed" -> {}}]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellID->12426],

Cell[TextData[{
 "Effect of ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FourierParameters",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FourierParameters"], "MR"]], "InlineFormula"],
 " setting on discrete\[Hyphen]time Fourier transform."
}], "Caption",
 CellID->15225]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Fourier Series Package - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 58, 20.6154180}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Fourier Series Package Tutorial", "language" -> "en", "paclet" -> 
    "FourierSeries Package", "status" -> "None", "summary" -> 
    "The Mathematica kernel provides the functions FourierTransform and \
InverseFourierTransform for computing the symbolic Fourier exponential \
transform and inverse transform. It also provides the functions \
FourierSinTransform, InverseFourierSinTransform, FourierCosTransform, and \
InverseFourierCosTransform for computing the symbolic Fourier sine and cosine \
transforms and their inverses. This package provides functions giving \
numerical approximations to these Fourier transforms. It also provides \
functions for Fourier series, Fourier coefficients, discrete-time Fourier \
transforms, and their numerical counterparts. The numerical approximations \
use Mathematica's numerical integration and summation directly without first \
trying for an exact solution. Finding numerical approximations to Fourier \
transforms. This loads the package. ", "synonyms" -> {}, "title" -> 
    "Fourier Series Package", "type" -> "Tutorial", "uri" -> 
    "FourierSeries/tutorial/FourierSeries"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 4255, 88, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4880, 115, 55, 1, 70, "Title",
 CellID->20975],
Cell[4938, 118, 1839, 54, 70, "Text",
 CellID->15585],
Cell[6780, 174, 4492, 127, 70, "DefinitionBox",
 CellID->22777],
Cell[11275, 303, 91, 1, 70, "Caption",
 CellID->13719],
Cell[11369, 306, 63, 1, 70, "MathCaption",
 CellID->30203],
Cell[11435, 309, 97, 3, 70, "Input",
 CellID->14145],
Cell[11535, 314, 651, 22, 70, "MathCaption",
 CellID->7307],
Cell[CellGroupData[{
Cell[12211, 340, 312, 11, 50, "Input",
 CellID->8201],
Cell[12526, 353, 253, 7, 36, "Output",
 CellID->16118]
}, Open  ]],
Cell[12794, 363, 567, 16, 70, "Text",
 CellID->22496],
Cell[13364, 381, 3782, 125, 70, "DefinitionBox3Col",
 CellID->11802],
Cell[17149, 508, 252, 9, 70, "Caption",
 CellID->602],
Cell[17404, 519, 3231, 105, 70, "DefinitionBox3Col",
 CellID->28607],
Cell[20638, 626, 259, 9, 70, "Caption",
 CellID->23638],
Cell[20900, 637, 3235, 105, 70, "DefinitionBox3Col",
 CellID->24237],
Cell[24138, 744, 139, 5, 70, "Caption",
 CellID->3076],
Cell[24280, 751, 2301, 67, 70, "Text",
 CellID->215],
Cell[26584, 820, 3339, 104, 70, "DefinitionBox",
 CellID->7691],
Cell[29926, 926, 78, 1, 70, "Caption",
 CellID->15579],
Cell[30007, 929, 578, 20, 70, "MathCaption",
 CellID->212],
Cell[CellGroupData[{
Cell[30610, 953, 294, 10, 28, "Input",
 CellID->2206],
Cell[30907, 965, 2810, 50, 127, "Output",
 Evaluatable->False,
 CellID->50618494]
}, Open  ]],
Cell[33732, 1018, 213, 5, 70, "MathCaption",
 CellID->1692],
Cell[CellGroupData[{
Cell[33970, 1027, 142, 4, 70, "Input",
 CellID->28655],
Cell[34115, 1033, 520, 17, 52, "Output",
 CellID->22929]
}, Open  ]],
Cell[34650, 1053, 116, 3, 70, "MathCaption",
 CellID->29188],
Cell[CellGroupData[{
Cell[34791, 1060, 203, 7, 28, "Input",
 CellID->31529],
Cell[34997, 1069, 4311, 75, 127, "Output",
 Evaluatable->False,
 CellID->54452846]
}, Open  ]],
Cell[39323, 1147, 80, 1, 70, "MathCaption",
 CellID->30493],
Cell[CellGroupData[{
Cell[39428, 1152, 124, 4, 28, "Input",
 CellID->26228],
Cell[39555, 1158, 5792, 99, 127, "Output",
 Evaluatable->False,
 CellID->501069794]
}, Open  ]],
Cell[45362, 1260, 2409, 80, 70, "DefinitionBox",
 CellID->18899],
Cell[47774, 1342, 269, 9, 70, "Caption",
 CellID->23836],
Cell[48046, 1353, 2227, 78, 70, "DefinitionBox3Col",
 CellID->815],
Cell[50276, 1433, 263, 9, 70, "Caption",
 CellID->11872],
Cell[50542, 1444, 4029, 128, 70, "DefinitionBox3Col",
 CellID->23814],
Cell[54574, 1574, 264, 9, 70, "Caption",
 CellID->26388],
Cell[54841, 1585, 2414, 80, 70, "DefinitionBox",
 CellID->21204],
Cell[57258, 1667, 262, 9, 70, "Caption",
 CellID->19978],
Cell[57523, 1678, 2692, 93, 70, "DefinitionBox",
 CellID->19580],
Cell[60218, 1773, 265, 9, 70, "Caption",
 CellID->16025],
Cell[60486, 1784, 518, 12, 70, "Text",
 CellID->9938],
Cell[61007, 1798, 2669, 75, 70, "DefinitionBox",
 CellID->23973],
Cell[63679, 1875, 117, 3, 70, "Caption",
 CellID->10534],
Cell[63799, 1880, 756, 27, 70, "MathCaption",
 CellID->31592],
Cell[CellGroupData[{
Cell[64580, 1911, 259, 9, 70, "Input",
 CellID->6214],
Cell[64842, 1922, 940, 24, 54, "Output",
 CellID->31115]
}, Open  ]],
Cell[65797, 1949, 114, 3, 70, "MathCaption",
 CellID->23204],
Cell[CellGroupData[{
Cell[65936, 1956, 203, 7, 28, "Input",
 CellID->32301],
Cell[66142, 1965, 4430, 77, 128, "Output",
 Evaluatable->False,
 CellID->832085675]
}, Open  ]],
Cell[70587, 2045, 2004, 61, 70, "Text",
 CellID->14858],
Cell[72594, 2108, 3122, 100, 70, "DefinitionBox",
 CellID->12350],
Cell[75719, 2210, 153, 4, 70, "Caption",
 CellID->32691],
Cell[75875, 2216, 302, 11, 70, "MathCaption",
 CellID->13140],
Cell[CellGroupData[{
Cell[76202, 2231, 481, 16, 28, "Input",
 CellID->18917],
Cell[76686, 2249, 4750, 82, 131, "Output",
 Evaluatable->False,
 CellID->79021661]
}, Open  ]],
Cell[81451, 2334, 281, 9, 70, "MathCaption",
 CellID->19981],
Cell[CellGroupData[{
Cell[81757, 2347, 575, 16, 70, "Input",
 CellID->12153],
Cell[82335, 2365, 500, 12, 54, "Output",
 CellID->22704]
}, Open  ]],
Cell[82850, 2380, 127, 4, 70, "MathCaption",
 CellID->21504],
Cell[CellGroupData[{
Cell[83002, 2388, 883, 25, 70, "Input",
 CellID->12559],
Cell[83888, 2415, 2606, 49, 244, "Output",
 CellID->22386]
}, Open  ]],
Cell[86509, 2467, 3971, 129, 70, "DefinitionBox3Col",
 CellID->21628],
Cell[90483, 2598, 255, 9, 70, "Caption",
 CellID->9329],
Cell[90741, 2609, 1548, 45, 70, "Text",
 CellID->16106],
Cell[92292, 2656, 3210, 99, 70, "DefinitionBox",
 CellID->28455],
Cell[95505, 2757, 153, 4, 70, "Caption",
 CellID->17254],
Cell[95661, 2763, 271, 9, 70, "MathCaption",
 CellID->11251],
Cell[CellGroupData[{
Cell[95957, 2776, 363, 12, 70, "Input",
 CellID->17887],
Cell[96323, 2790, 427, 13, 38, "Output",
 CellID->13977]
}, Open  ]],
Cell[96765, 2806, 108, 3, 70, "MathCaption",
 CellID->22897],
Cell[CellGroupData[{
Cell[96898, 2813, 245, 8, 28, "Input",
 CellID->32657],
Cell[97146, 2823, 4831, 83, 143, "Output",
 Evaluatable->False,
 CellID->6883566]
}, Open  ]],
Cell[101992, 2909, 322, 11, 70, "MathCaption",
 CellID->10226],
Cell[CellGroupData[{
Cell[102339, 2924, 446, 12, 70, "Input",
 CellID->29272],
Cell[102788, 2938, 353, 10, 36, "Output",
 CellID->31673]
}, Open  ]],
Cell[103156, 2951, 201, 5, 70, "Text",
 CellID->16604],
Cell[103360, 2958, 3998, 128, 70, "DefinitionBox3Col",
 CellID->12426],
Cell[107361, 3088, 276, 9, 70, "Caption",
 CellID->15225]
}, Open  ]],
Cell[107652, 3100, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

