(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7252,        252]
NotebookOptionsPosition[      4522,        171]
NotebookOutlinePosition[      5794,        203]
CellTagsIndexPosition[      5751,        200]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Function Approximations Package", "GuideTitle",
 CellID->942062912],

Cell["\[NonBreakingSpace]", "GuideAbstract",
 CellID->1],

Cell[CellGroupData[{

Cell["Rational Approximations", "GuideFunctionsSubsection",
 CellID->732619263],

Cell[TextData[Cell[TextData[ButtonBox["EconomizedRationalApproximation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:FunctionApproximations/ref/EconomizedRationalApproximation"]], \
"InlineFunctionSans"]], "GuideText",
 CellID->19459664],

Cell[TextData[{
 Cell[TextData[ButtonBox["RationalInterpolation",
  BaseStyle->"Link",
  ButtonData->"paclet:FunctionApproximations/ref/RationalInterpolation"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["GeneralRationalInterpolation",
  BaseStyle->"Link",
  ButtonData->
   "paclet:FunctionApproximations/ref/GeneralRationalInterpolation"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->349535031],

Cell[TextData[{
 Cell[TextData[ButtonBox["MiniMaxApproximation",
  BaseStyle->"Link",
  ButtonData->"paclet:FunctionApproximations/ref/MiniMaxApproximation"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["GeneralMiniMaxApproximation",
  BaseStyle->"Link",
  ButtonData->
   "paclet:FunctionApproximations/ref/GeneralMiniMaxApproximation"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->1267491472]
}, Open  ]],

Cell[CellGroupData[{

Cell["Numerical Approximations", "GuideFunctionsSubsection",
 CellID->82249200],

Cell[TextData[{
 Cell[TextData[ButtonBox["InterpolateRoot",
  BaseStyle->"Link",
  ButtonData->"paclet:FunctionApproximations/ref/InterpolateRoot"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " solve an equation numerically"
}], "GuideText",
 CellID->37487054],

Cell[TextData[{
 Cell[TextData[ButtonBox["NIntegrateInterpolatingFunction",
  BaseStyle->"Link",
  ButtonData->
   "paclet:FunctionApproximations/ref/NIntegrateInterpolatingFunction"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " approximate an integral numerically"
}], "GuideText",
 CellID->277579462],

Cell["\t", "GuideDelimiterSubsection",
 CellID->311258892]
}, Open  ]],

Cell[CellGroupData[{

Cell["Visualization", "GuideFunctionsSubsection",
 CellID->320778338],

Cell[TextData[{
 Cell[TextData[ButtonBox["OrderStarPlot",
  BaseStyle->"Link",
  ButtonData->"paclet:FunctionApproximations/ref/OrderStarPlot"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ",
 "plot stability of a function approximation"
}], "GuideText",
 CellID->143290888]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Function Approximations Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:FunctionApproximations/tutorial/FunctionApproximations"]], \
"GuideTutorial",
 CellID->48681022]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Series Expansions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SeriesExpansions"]], "GuideMoreAboutSub",
 CellID->1332054554],

Cell[TextData[ButtonBox["Continued Fractions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ContinuedFractionsAndRationalApproximations"]], \
"GuideMoreAboutSub",
 CellID->323869103],

Cell[TextData[ButtonBox["Curve Fitting and Approximate Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/CurveFittingAndApproximateFunctions"]], "GuideMoreAbout",
 CellID->140365040],

Cell[TextData[ButtonBox["Differential Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DifferentialEquations"]], "GuideMoreAbout",
 CellID->1178182874]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Function Approximations Package - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 58, 26.3811906}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Function Approximations Package Guide", "language" -> "en", "paclet" -> 
    "FunctionApproximations Package", "status" -> "None", "summary" -> 
    "EconomizedRationalApproximation, InterpolateRoot -- solve an equation \
numerically, NIntegrateInterpolatingFunction -- approximate an integral \
numerically, OrderStarPlot -- plot stability of a function approximation", 
    "synonyms" -> {}, "title" -> "Function Approximations Package", "type" -> 
    "Guide", "uri" -> 
    "FunctionApproximations/guide/FunctionApproximationsPackage"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 73, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[695, 28, 56, 1, 70, "GuideAbstract",
 CellID->1],
Cell[CellGroupData[{
Cell[776, 33, 79, 1, 70, "GuideFunctionsSubsection",
 CellID->732619263],
Cell[858, 36, 237, 5, 70, "GuideText",
 CellID->19459664],
Cell[1098, 43, 518, 14, 70, "InlineGuideFunctionListing",
 CellID->349535031],
Cell[1619, 59, 515, 14, 70, "InlineGuideFunctionListing",
 CellID->1267491472]
}, Open  ]],
Cell[CellGroupData[{
Cell[2171, 78, 79, 1, 70, "GuideFunctionsSubsection",
 CellID->82249200],
Cell[2253, 81, 292, 9, 70, "GuideText",
 CellID->37487054],
Cell[2548, 92, 335, 10, 70, "GuideText",
 CellID->277579462],
Cell[2886, 104, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->311258892]
}, Open  ]],
Cell[CellGroupData[{
Cell[2981, 110, 69, 1, 70, "GuideFunctionsSubsection",
 CellID->320778338],
Cell[3053, 113, 307, 10, 70, "GuideText",
 CellID->143290888]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[3409, 129, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[3474, 132, 199, 5, 70, "GuideTutorial",
 CellID->48681022]
}, Open  ]],
Cell[CellGroupData[{
Cell[3710, 142, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[3775, 145, 154, 3, 70, "GuideMoreAboutSub",
 CellID->1332054554],
Cell[3932, 150, 187, 5, 70, "GuideMoreAboutSub",
 CellID->323869103],
Cell[4122, 157, 194, 4, 70, "GuideMoreAbout",
 CellID->140365040],
Cell[4319, 163, 161, 3, 70, "GuideMoreAbout",
 CellID->1178182874]
}, Open  ]],
Cell[4495, 169, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

