(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7467,        252]
NotebookOptionsPosition[      5621,        196]
NotebookOutlinePosition[      6824,        227]
CellTagsIndexPosition[      6781,        224]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["FUNCTION APPROXIMATIONS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Function Approximations Package" :> 
          Documentation`HelpLookup[
           "paclet:FunctionApproximations/tutorial/FunctionApproximations"]}, \
#, 2]& , Evaluator -> Automatic], {
       1->"\<\"Function Approximations Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Brake" :> 
          Documentation`HelpLookup["paclet:FunctionApproximations/ref/Brake"],
           "Derivatives" :> 
          Documentation`HelpLookup[
           "paclet:FunctionApproximations/ref/Derivatives"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Brake\"\>", 
       2->"\<\"Derivatives\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Bias", "ObjectName",
 CellID->153],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Bias"], "InlineFormula"],
     " \[LineSeparator]is an option to ",
     Cell[BoxData[
      ButtonBox["RationalInterpolation",
       BaseStyle->"Link",
       ButtonData->
        "paclet:FunctionApproximations/ref/RationalInterpolation"]], 
      "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["GeneralRationalInterpolation",
       BaseStyle->"Link",
       ButtonData->
        "paclet:FunctionApproximations/ref/GeneralRationalInterpolation"]], 
      "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["MiniMaxApproximation",
       BaseStyle->"Link",
       ButtonData->"paclet:FunctionApproximations/ref/MiniMaxApproximation"]],
       "InlineFormula"],
     ", and ",
     Cell[BoxData[
      ButtonBox["GeneralMiniMaxApproximation",
       BaseStyle->"Link",
       ButtonData->
        "paclet:FunctionApproximations/ref/GeneralMiniMaxApproximation"]], 
      "InlineFormula"],
     " that specifies the bias to apply when automatically picking \
interpolation points."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->292]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "A valid setting is a number between ",
 Cell[BoxData[
  RowBox[{"-", "1"}]], "InlineFormula"],
 " and ",
 Cell[BoxData["1"], "InlineFormula"],
 ". The default setting is ",
 Cell[BoxData[
  RowBox[{"Bias", "->", "0"}]], "InlineFormula"],
 " indicating that interpolation points should be chosen symmetrically."
}], "Notes",
 CellID->12382]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->5447],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Brake",
    BaseStyle->"Link",
    ButtonData->"paclet:FunctionApproximations/ref/Brake"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Derivatives",
    BaseStyle->"Link",
    ButtonData->"paclet:FunctionApproximations/ref/Derivatives"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->21726]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->17421],

Cell[TextData[ButtonBox["Function Approximations Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:FunctionApproximations/tutorial/FunctionApproximations"]], \
"Tutorials",
 CellID->18716]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Bias - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 58, 26.5218192}", "context" -> 
    "FunctionApproximations`", "keywords" -> {}, "index" -> True, "label" -> 
    "Function Approximations Package Symbol", "language" -> "en", "paclet" -> 
    "FunctionApproximations Package", "status" -> "None", "summary" -> 
    "Bias is an option to RationalInterpolation, \
GeneralRationalInterpolation, MiniMaxApproximation, and \
GeneralMiniMaxApproximation that specifies the bias to apply when \
automatically picking interpolation points.", "synonyms" -> {}, "title" -> 
    "Bias", "type" -> "Symbol", "uri" -> "FunctionApproximations/ref/Bias"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1395, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2018, 63, 40, 1, 70, "ObjectName",
 CellID->153],
Cell[2061, 66, 1253, 38, 70, "Usage",
 CellID->292]
}, Open  ]],
Cell[CellGroupData[{
Cell[3351, 109, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3829, 126, 357, 11, 70, "Notes",
 CellID->12382]
}, Closed]],
Cell[CellGroupData[{
Cell[4223, 142, 310, 9, 70, "SeeAlsoSection",
 CellID->5447],
Cell[4536, 153, 497, 17, 70, "SeeAlso",
 CellID->21726]
}, Open  ]],
Cell[CellGroupData[{
Cell[5070, 175, 314, 9, 70, "TutorialsSection",
 CellID->17421],
Cell[5387, 186, 192, 5, 70, "Tutorials",
 CellID->18716]
}, Open  ]],
Cell[5594, 194, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

