(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16518,        522]
NotebookOptionsPosition[     14055,        452]
NotebookOutlinePosition[     15584,        487]
CellTagsIndexPosition[     15541,        484]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["FUNCTION APPROXIMATIONS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Function Approximations Package" :> 
          Documentation`HelpLookup[
           "paclet:FunctionApproximations/tutorial/FunctionApproximations"]}, \
#, 2]& , Evaluator -> Automatic], {
       1->"\<\"Function Approximations Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PadeApproximant" :> 
          Documentation`HelpLookup["paclet:ref/PadeApproximant"], 
          "MiniMaxApproximation" :> 
          Documentation`HelpLookup[
           "paclet:FunctionApproximations/ref/MiniMaxApproximation"], 
          "EconomizedRationalApproximation" :> 
          Documentation`HelpLookup[
           "paclet:FunctionApproximations/ref/\
EconomizedRationalApproximation"], "RationalInterpolation" :> 
          Documentation`HelpLookup[
           "paclet:FunctionApproximations/ref/RationalInterpolation"], 
          "GeneralRationalInterpolation" :> 
          Documentation`HelpLookup[
           "paclet:FunctionApproximations/ref/GeneralRationalInterpolation"]},\
 #, 2]& , Evaluator -> Automatic], {1->"\<\"PadeApproximant\"\>", 
       2->"\<\"MiniMaxApproximation\"\>", 
       3->"\<\"EconomizedRationalApproximation\"\>", 
       4->"\<\"RationalInterpolation\"\>", 
       5->"\<\"GeneralRationalInterpolation\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["GeneralMiniMaxApproximation", "ObjectName",
 CellID->4596],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"GeneralMiniMaxApproximation", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["f", "TI"], 
           StyleBox["x", "TI"]], ",", 
          SubscriptBox[
           StyleBox["f", "TI"], 
           StyleBox["y", "TI"]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["t", "TI"], ",", 
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["t", "TI"], 
             StyleBox["0", "TR"]], ",", 
            SubscriptBox[
             StyleBox["t", "TI"], 
             StyleBox["1", "TR"]]}], "}"}], ",", 
          StyleBox["m", "TI"], ",", 
          StyleBox["n", "TI"]}], "}"}], ",", 
        StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]finds the rational polynomial function of ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ", with numerator order ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " and denominator order ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     ", that gives a mini-max approximation to the curve with ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     " coordinates ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["f", "TI"], 
       StyleBox["x", "TI"]]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["f", "TI"], 
       StyleBox["y", "TI"]]], "InlineFormula"],
     " generated as a function of ",
     Cell[BoxData[
      StyleBox["t", "TI"]], "InlineFormula"],
     " on the interval ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["t", "TI"], 
       StyleBox["0", "TR"]]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["t", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"GeneralMiniMaxApproximation", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["f", "TI"], 
           StyleBox["x", "TI"]], ",", 
          SubscriptBox[
           StyleBox["f", "TI"], 
           StyleBox["y", "TI"]]}], "}"}], ",", 
        StyleBox["approx", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["t", "TI"], ",", 
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["t", "TI"], 
             StyleBox["0", "TR"]], ",", 
            SubscriptBox[
             StyleBox["t", "TI"], 
             StyleBox["1", "TR"]]}], "}"}], ",", 
          StyleBox["m", "TI"], ",", 
          StyleBox["n", "TI"]}], "}"}], ",", 
        StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]finds the mini-max approximation, starting the \
iterative algorithm with ",
     Cell[BoxData[
      StyleBox["approx", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->24021]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["GeneralMiniMaxApproximation"], "InlineFormula"],
 " by default minimizes the maximum value of the relative error between the \
approximation and ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->27348],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"GeneralMiniMaxApproximation", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["f", "TI"], 
       StyleBox["x", "TI"]], ",", 
      SubscriptBox[
       StyleBox["f", "TI"], 
       StyleBox["y", "TI"]], ",", 
      StyleBox["g", "TI"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["t", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["t", "TI"], 
         StyleBox["0", "TR"]], ",", 
        SubscriptBox[
         StyleBox["t", "TI"], 
         StyleBox["1", "TR"]]}], "}"}], ",", 
      StyleBox["m", "TI"], ",", 
      StyleBox["n", "TI"]}], "}"}], ",", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 " computes the error using a factor of ",
 Cell[BoxData[
  StyleBox["g", "TI"]], "InlineFormula"],
 ". In this case the mini-max approximation returned by ",
 Cell[BoxData["GeneralMiniMaxApproximation"], "InlineFormula"],
 " is the rational function ",
 Cell[BoxData[
  RowBox[{
   StyleBox["h", "TI"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " that minimizes the maximum value of the quantity ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     SubscriptBox[
      StyleBox["f", "TI"], 
      StyleBox["y", "TI"]], "-", 
     RowBox[{
      StyleBox["h", "TI"], "[", 
      SubscriptBox[
       StyleBox["f", "TI"], 
       StyleBox["x", "TI"]], "]"}]}], ")"}], "/", 
   StyleBox["g", "TI"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->23199],

Cell[TextData[{
 Cell[BoxData["GeneralMiniMaxApproximation"], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["abscissa", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{
      StyleBox["approximation", "TI"], ",", 
      StyleBox["maxerror", "TI"]}], "}"}]}], "}"}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  StyleBox["abscissa", "TI"]], "InlineFormula"],
 " is a list of the abscissas where the relative error is a local maximum, ",
 Cell[BoxData[
  StyleBox["approximation", "TI"]], "InlineFormula"],
 " is the rational approximant, and ",
 Cell[BoxData[
  StyleBox["maxerror", "TI"]], "InlineFormula"],
 " is the global maximum of the relative error."
}], "Notes",
 CellID->19668],

Cell[TextData[{
 "When an approximation is given as the second argument of ",
 Cell[BoxData["GeneralMiniMaxApproximation"], "InlineFormula"],
 ", it must have the same form as the result returned by ",
 Cell[BoxData["GeneralMiniMaxApproximation"], "InlineFormula"],
 "."
}], "Notes",
 CellID->24484],

Cell["The following options can be given:", "Notes",
 CellID->8281],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Bias",
     BaseStyle->"Link",
     ButtonData->"paclet:FunctionApproximations/ref/Bias"], "0", Cell[
    "bias in the automatic choice of interpolation points", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Brake",
     BaseStyle->"Link",
     ButtonData->"paclet:FunctionApproximations/ref/Brake"], 
    RowBox[{"{", 
     RowBox[{"5", ",", "5"}], "}"}], Cell[
    "braking to apply on iterative algorithm", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Derivatives",
     BaseStyle->"Link",
     ButtonData->"paclet:FunctionApproximations/ref/Derivatives"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "function to use for derivatives", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["MaxIterations",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MaxIterations"], "20", Cell[
    "maximum number of iterations to use", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PlotFlag",
     BaseStyle->"Link",
     ButtonData->"paclet:FunctionApproximations/ref/PlotFlag"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to plot relative error", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PrintFlag",
     BaseStyle->"Link",
     ButtonData->"paclet:FunctionApproximations/ref/PrintFlag"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to print status information", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["WorkingPrecision",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/WorkingPrecision"], 
    ButtonBox["MachinePrecision",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MachinePrecision"], Cell[
    "precision to use in internal computations", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True}}}},
 CellID->4734]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->6900],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PadeApproximant",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PadeApproximant"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MiniMaxApproximation",
    BaseStyle->"Link",
    ButtonData->"paclet:FunctionApproximations/ref/MiniMaxApproximation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EconomizedRationalApproximation",
    BaseStyle->"Link",
    ButtonData->
     "paclet:FunctionApproximations/ref/EconomizedRationalApproximation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RationalInterpolation",
    BaseStyle->"Link",
    ButtonData->"paclet:FunctionApproximations/ref/RationalInterpolation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GeneralRationalInterpolation",
    BaseStyle->"Link",
    ButtonData->
     "paclet:FunctionApproximations/ref/GeneralRationalInterpolation"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->534384445]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->53],

Cell[TextData[ButtonBox["Function Approximations Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:FunctionApproximations/tutorial/FunctionApproximations"]], \
"Tutorials",
 CellID->1999]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GeneralMiniMaxApproximation - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 58, 27.1937114}", "context" -> 
    "FunctionApproximations`", "keywords" -> {}, "index" -> True, "label" -> 
    "Function Approximations Package Symbol", "language" -> "en", "paclet" -> 
    "FunctionApproximations Package", "status" -> "None", "summary" -> 
    "GeneralMiniMaxApproximation[{f_x, f_y}, {t, {t_0, t_1}, m, n}, x] finds \
the rational polynomial function of x, with numerator order m and denominator \
order n, that gives a mini-max approximation to the curve with x and y \
coordinates f_x and f_y generated as a function of t on the interval t_0 to \
t_1. GeneralMiniMaxApproximation[{f_x, f_y}, approx, {t, {t_0, t_1}, m, n}, \
x] finds the mini-max approximation, starting the iterative algorithm with \
approx.", "synonyms" -> {}, "title" -> "GeneralMiniMaxApproximation", "type" -> 
    "Symbol", "uri" -> 
    "FunctionApproximations/ref/GeneralMiniMaxApproximation"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2034, 48, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2657, 75, 64, 1, 70, "ObjectName",
 CellID->4596],
Cell[2724, 78, 3269, 105, 70, "Usage",
 CellID->24021]
}, Open  ]],
Cell[CellGroupData[{
Cell[6030, 188, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6508, 205, 272, 8, 70, "Notes",
 CellID->27348],
Cell[6783, 215, 1527, 53, 70, "Notes",
 CellID->23199],
Cell[8313, 270, 727, 22, 70, "Notes",
 CellID->19668],
Cell[9043, 294, 299, 7, 70, "Notes",
 CellID->24484],
Cell[9345, 303, 67, 1, 70, "Notes",
 CellID->8281],
Cell[9415, 306, 2262, 58, 70, "3ColumnTableMod",
 CellID->4734]
}, Closed]],
Cell[CellGroupData[{
Cell[11714, 369, 310, 9, 70, "SeeAlsoSection",
 CellID->6900],
Cell[12027, 380, 1444, 46, 70, "SeeAlso",
 CellID->534384445]
}, Open  ]],
Cell[CellGroupData[{
Cell[13508, 431, 311, 9, 70, "TutorialsSection",
 CellID->53],
Cell[13822, 442, 191, 5, 70, "Tutorials",
 CellID->1999]
}, Open  ]],
Cell[14028, 450, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

