(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12415,        390]
NotebookOptionsPosition[     10128,        328]
NotebookOutlinePosition[     11698,        363]
CellTagsIndexPosition[     11655,        360]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["FUNCTION APPROXIMATIONS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Function Approximations Package" :> 
          Documentation`HelpLookup[
           "paclet:FunctionApproximations/tutorial/FunctionApproximations"]}, \
#, 2]& , Evaluator -> Automatic], {
       1->"\<\"Function Approximations Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PadeApproximant" :> 
          Documentation`HelpLookup["paclet:ref/PadeApproximant"], 
          "RationalInterpolation" :> 
          Documentation`HelpLookup[
           "paclet:FunctionApproximations/ref/RationalInterpolation"], 
          "EconomizedRationalApproximation" :> 
          Documentation`HelpLookup[
           "paclet:FunctionApproximations/ref/\
EconomizedRationalApproximation"], "MiniMaxApproximation" :> 
          Documentation`HelpLookup[
           "paclet:FunctionApproximations/ref/MiniMaxApproximation"], 
          "GeneralMiniMaxApproximation" :> 
          Documentation`HelpLookup[
           "paclet:FunctionApproximations/ref/GeneralMiniMaxApproximation"]}, \
#, 2]& , Evaluator -> Automatic], {1->"\<\"PadeApproximant\"\>", 
       2->"\<\"RationalInterpolation\"\>", 
       3->"\<\"EconomizedRationalApproximation\"\>", 
       4->"\<\"MiniMaxApproximation\"\>", 
       5->"\<\"GeneralMiniMaxApproximation\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["GeneralRationalInterpolation", "ObjectName",
 CellID->19796],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       RowBox[{"GeneralRationalInterpolation", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["f", "TI"], 
            StyleBox["x", "TI"]], ",", 
           SubscriptBox[
            StyleBox["f", "TI"], 
            StyleBox["y", "TI"]]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           StyleBox["t", "TI"], ",", 
           StyleBox["m", "TI"], ",", 
           StyleBox["n", "TI"]}], "}"}], ",", 
         StyleBox["x", "TI"], ",", 
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["t", "TI"], 
            StyleBox["1", "TR"]], ",", 
           StyleBox["\[Ellipsis]", "TR"], ",", 
           SubscriptBox[
            StyleBox["t", "TI"], 
            RowBox[{
             StyleBox["m", "TI"], "+", 
             StyleBox["n", "TI"], "+", "1"}]]}], "}"}]}], "]"}], "]"}]], 
      "InlineFormula"],
     " \[LineSeparator]gives the rational polynomial function of ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ", with numerator order ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     " and denominator order ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     ", that interpolates the curve with ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     " coordinates ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["f", "TI"], 
       StyleBox["x", "TI"]]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["f", "TI"], 
       StyleBox["y", "TI"]]], "InlineFormula"],
     " generated as a function of ",
     Cell[BoxData[
      StyleBox["t", "TI"]], "InlineFormula"],
     ", at the interpolation points ",
     Cell[BoxData[
      RowBox[{
       SubscriptBox[
        StyleBox["t", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["t", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"GeneralRationalInterpolation", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["f", "TI"], 
           StyleBox["x", "TI"]], ",", 
          SubscriptBox[
           StyleBox["f", "TI"], 
           StyleBox["y", "TI"]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["t", "TI"], ",", 
          StyleBox["m", "TI"], ",", 
          StyleBox["n", "TI"]}], "}"}], ",", 
        StyleBox["x", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["t", "TI"], ",", 
          SubscriptBox[
           StyleBox["t", "TI"], 
           StyleBox["0", "TR"]], ",", 
          SubscriptBox[
           StyleBox["t", "TI"], 
           StyleBox["1", "TR"]]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the rational interpolant with the interpolation \
points chosen automatically from the interval ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["t", "TI"], 
       StyleBox["0", "TR"]]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["t", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->14798]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following options can be given:", "Notes",
 CellID->15281],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["WorkingPrecision",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/WorkingPrecision"], 
    ButtonBox["MachinePrecision",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MachinePrecision"], Cell[
    "precision to use in internal computations", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Bias",
     BaseStyle->"Link",
     ButtonData->"paclet:FunctionApproximations/ref/Bias"], "0", Cell[
    "bias in the automatic choice of interpolation points", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->19589]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->23622],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PadeApproximant",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PadeApproximant"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RationalInterpolation",
    BaseStyle->"Link",
    ButtonData->"paclet:FunctionApproximations/ref/RationalInterpolation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EconomizedRationalApproximation",
    BaseStyle->"Link",
    ButtonData->
     "paclet:FunctionApproximations/ref/EconomizedRationalApproximation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MiniMaxApproximation",
    BaseStyle->"Link",
    ButtonData->"paclet:FunctionApproximations/ref/MiniMaxApproximation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GeneralMiniMaxApproximation",
    BaseStyle->"Link",
    ButtonData->
     "paclet:FunctionApproximations/ref/GeneralMiniMaxApproximation"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->34640201]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->20798],

Cell[TextData[ButtonBox["Function Approximations Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:FunctionApproximations/tutorial/FunctionApproximations"]], \
"Tutorials",
 CellID->28009]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GeneralRationalInterpolation - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 58, 27.3968416}", "context" -> 
    "FunctionApproximations`", "keywords" -> {}, "index" -> True, "label" -> 
    "Function Approximations Package Symbol", "language" -> "en", "paclet" -> 
    "FunctionApproximations Package", "status" -> "None", "summary" -> 
    "GeneralRationalInterpolation[{f_x, f_y}, {t, m, n}, x, {t_1, ..., t m + \
n + 1}]] gives the rational polynomial function of x, with numerator order m \
and denominator order n, that interpolates the curve with x and y coordinates \
f_x and f_y generated as a function of t, at the interpolation points t_1, \
t_2, .... GeneralRationalInterpolation[{f_x, f_y}, {t, m, n}, x, {t, t_0, \
t_1}] gives the rational interpolant with the interpolation points chosen \
automatically from the interval t_0 to t_1.", "synonyms" -> {}, "title" -> 
    "GeneralRationalInterpolation", "type" -> "Symbol", "uri" -> 
    "FunctionApproximations/ref/GeneralRationalInterpolation"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2031, 48, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2654, 75, 66, 1, 70, "ObjectName",
 CellID->19796],
Cell[2723, 78, 3630, 117, 70, "Usage",
 CellID->14798]
}, Open  ]],
Cell[CellGroupData[{
Cell[6390, 200, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6868, 217, 68, 1, 70, "Notes",
 CellID->15281],
Cell[6939, 220, 809, 20, 70, "3ColumnTableMod",
 CellID->19589]
}, Closed]],
Cell[CellGroupData[{
Cell[7785, 245, 311, 9, 70, "SeeAlsoSection",
 CellID->23622],
Cell[8099, 256, 1441, 46, 70, "SeeAlso",
 CellID->34640201]
}, Open  ]],
Cell[CellGroupData[{
Cell[9577, 307, 314, 9, 70, "TutorialsSection",
 CellID->20798],
Cell[9894, 318, 192, 5, 70, "Tutorials",
 CellID->28009]
}, Open  ]],
Cell[10101, 326, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

