(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     35897,       1272]
NotebookOptionsPosition[     29464,       1043]
NotebookOutlinePosition[     30833,       1080]
CellTagsIndexPosition[     30747,       1075]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["FUNCTION APPROXIMATIONS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Function Approximations Package" :> 
          Documentation`HelpLookup[
           "paclet:FunctionApproximations/tutorial/FunctionApproximations"]}, \
#, 2]& , Evaluator -> Automatic], {
       1->"\<\"Function Approximations Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FindRoot" :> 
          Documentation`HelpLookup["paclet:ref/FindRoot"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"FindRoot\"\>"}, "\<\"see also\"\>", 
       
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Function Approximations Package" :> 
          Documentation`HelpLookup[
           "paclet:FunctionApproximations/guide/\
FunctionApproximationsPackage"]}, #, 2]& , Evaluator -> Automatic], {
       1->"\<\"Function Approximations Package\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["InterpolateRoot", "ObjectName",
 CellID->2514],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"InterpolateRoot", "[", 
       RowBox[{
        RowBox[{
         StyleBox["lhs", "TI"], "==", 
         StyleBox["rhs", "TI"]}], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["0", "TR"]], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["1", "TR"]]}], "}"}]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]searches for a numerical solution to the equation ",
     Cell[BoxData[
      RowBox[{
       StyleBox["lhs", "TI"], "==", 
       StyleBox["rhs", "TI"]}]], "InlineFormula"],
     " using ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["0", "TR"]]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " as the first two values of ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->10966]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["InterpolateRoot"], "InlineFormula"],
 " gives the solution as a rule of the form ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "->", 
   StyleBox["sol", "TI"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->25988],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"InterpolateRoot", "[", 
   RowBox[{
    StyleBox["expr", "TI"], 
    StyleBox[",", "TI"], 
    RowBox[{
     StyleBox["{", "TI"], 
     RowBox[{
      StyleBox["x", "TI"], ",", 
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["0", "TR"]], ",", 
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["1", "TR"]]}], "}"}]}], "]"}]], "InlineFormula"],
 " will search for a root of the equation ",
 Cell[BoxData[
  RowBox[{
   StyleBox["expr", "TI"], "==", "0"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->18170],

Cell[TextData[{
 Cell[BoxData["InterpolateRoot"], "InlineFormula"],
 " searches for a solution using inverse cubic interpolation of the last four \
data points. It does not use derivative information."
}], "Notes",
 CellID->28168],

Cell[TextData[{
 Cell[BoxData["InterpolateRoot"], "InlineFormula"],
 " works very slowly when the solution is a multiple root."
}], "Notes",
 CellID->22199],

Cell[TextData[{
 Cell[BoxData["InterpolateRoot"], "InlineFormula"],
 " is not as robust as ",
 Cell[BoxData[
  ButtonBox["FindRoot",
   BaseStyle->"FunctionLink",
   ButtonData->"paclet:ref/FindRoot"]], "InlineFormula"],
 ". However, it is useful when the location of the root is approximately \
known, each evaluation of the function is expensive, and high precision is \
desired."
}], "Notes",
 CellID->655],

Cell[TextData[{
 "If the equation and starting values are real, then ",
 Cell[BoxData["InterpolateRoot"], "InlineFormula"],
 " will search only for real roots, otherwise it will search for complex \
roots."
}], "Notes",
 CellID->3850],

Cell["The following options can be given: ", "Notes",
 CellID->13444],

Cell[BoxData[GridBox[{
   {
    ButtonBox["AccuracyGoal",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/AccuracyGoal"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the accuracy sought", "TableText"]},
   {
    ButtonBox["MaxIterations",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MaxIterations"], "15", Cell[
    "maximum number of iterations to use", "TableText"]},
   {"ShowProgress", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether progress is to be monitored", "TableText"]},
   {
    ButtonBox["WorkingPrecision",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/WorkingPrecision"], "40", Cell[
    "the precision to use in internal computations", "TableText"]}
  }]], "3ColumnTable",
 CellID->12936],

Cell[TextData[{
 "The setting for ",
 Cell[BoxData[
  ButtonBox["AccuracyGoal",
   BaseStyle->"FunctionLink",
   ButtonData->"paclet:ref/AccuracyGoal"]], "InlineFormula"],
 " refers to the accuracy of the root rather than the magnitude of the \
residual at the root."
}], "Notes",
 CellID->19406],

Cell[TextData[{
 "The precision used in internal computations typically varies from a little \
more than machine precision at the beginning to the setting for ",
 Cell[BoxData[
  ButtonBox["WorkingPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WorkingPrecision"]], "InlineFormula"],
 " at the end."
}], "Notes",
 CellID->29427],

Cell[TextData[{
 "The setting for ",
 Cell[BoxData[
  ButtonBox["WorkingPrecision",
   BaseStyle->"FunctionLink",
   ButtonData->"paclet:ref/WorkingPrecision"]], "InlineFormula"],
 " may be exceeded to achieve the desired ",
 Cell[BoxData[
  ButtonBox["AccuracyGoal",
   BaseStyle->"FunctionLink",
   ButtonData->"paclet:ref/AccuracyGoal"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->10313],

Cell[TextData[{
 "If ",
 Cell[BoxData["InterpolateRoot"], "InlineFormula"],
 " does not succeed in finding a solution to the desired accuracy within ",
 Cell[BoxData[
  ButtonBox["MaxIterations",
   BaseStyle->"FunctionLink",
   ButtonData->"paclet:ref/MaxIterations"]], "InlineFormula"],
 " steps, it returns the most recent approximation found. "
}], "Notes",
 CellID->7523],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"ShowProgress", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData["InterpolateRoot"], "InlineFormula"],
 " will print ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["accuracy", "TI"], ",", 
    StyleBox["x", "TI"]}], "}"}]], "InlineFormula"],
 " followed by ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["precision", "TI"], ",", 
    StyleBox["extraprecision", "TI"], ",", 
    StyleBox["delta", "TI"]}], "}"}]], "InlineFormula"],
 ", where:"
}], "Notes",
 CellID->32371],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    StyleBox["accuracy", "TI"], Cell["\<\
estimate of the accuracy of the current approximation to the solution\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["x", "TI"], Cell[
    "current approximation to the solution", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["precision", "TI"], Cell[
    "current working precision", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["extraprecision", "TI"], Cell[
    "number of extra digits of precision being used", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["delta", "TI"], Cell["\<\
predicted change in the approximation during the next iteration\
\>", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->23327]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->32156213],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->41558860],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<FunctionApproximations`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->987328680],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InterpolateRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Exp", "[", "x", "]"}], "==", "2"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->26126],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "x", "\[Rule]", 
   "0.69314718055994530941723212145786257157`23.84082546104514"}], 
  "}"}]], "Output",
 ImageSize->{223, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->20595]
}, Open  ]],

Cell["Check:", "ExampleText",
 CellID->1495],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"Log", "[", "2", "]"}], ",", "24"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->29213],

Cell[BoxData["0.69314718055994530941723212145817656807`24."], "Output",
 ImageSize->{186, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->2406]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->23859],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<FunctionApproximations`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->396458797],

Cell[TextData[{
 Cell[BoxData["InterpolateRoot"], "InlineFormula"],
 " can find complex roots:"
}], "ExampleText",
 CellID->23305],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InterpolateRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Exp", "[", "x", "]"}], "+", "2"}], "==", "0"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"1", "+", 
      RowBox[{"3", "I"}]}], ",", 
     RowBox[{"2", "+", 
      RowBox[{"4", "I"}]}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->22496],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x", "\[Rule]", 
   RowBox[{
   "0.6931471805599453094172321214581765680755001343602497568777`38.\
99134045887713", "+", 
    RowBox[{
    "3.1415926535897932384626433832795028841971693993751024251104`39.\
64766487052613", " ", "\[ImaginaryI]"}]}]}], "}"}]], "Output",
 ImageSize->{331, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->24833]
}, Open  ]],

Cell["Check:", "ExampleText",
 CellID->24223],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Exp", "[", "x", "]"}], "+", "2"}], "==", "0"}], "/.", 
  "%"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->4852],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->17879]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->30519],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<FunctionApproximations`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->888690700],

Cell[TextData[{
 "An expression ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " is interpreted as ",
 Cell[BoxData[
  RowBox[{
   StyleBox["expr", "TI"], "==", "0"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->6126],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InterpolateRoot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "3", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->7793],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "x", "\[Rule]", 
   "3.14159265358979323846264338327961822634`23.497149872694134"}], 
  "}"}]], "Output",
 ImageSize->{209, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->31585]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->28099],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<FunctionApproximations`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->725018582],

Cell[TextData[{
 "The Riemann hypothesis states that all zeros of the function ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Zeta",
    BaseStyle->"FunctionLink",
    ButtonData->"paclet:ref/Zeta"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 " lie on the line ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"Re", "[", "z", "]"}], "=", 
    FractionBox["1", "2"]}], TraditionalForm]], "InlineMath"],
 " of the complex plane. The first few zeros:"
}], "ExampleText",
 CellID->16519],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"InterpolateRoot", "[", 
    RowBox[{
     RowBox[{"Zeta", "[", "z", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", 
       RowBox[{".5", "+", 
        RowBox[{"#", " ", "I"}]}], ",", 
       RowBox[{".5", "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"#", "+", "1"}], ")"}], "I"}]}]}], "}"}]}], "]"}], "&"}], "/@",
   
  RowBox[{"{", 
   RowBox[{"14", ",", "21", ",", "25"}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->8596],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
     "0.500000000000000000000000000000000000000000000573`34.84948500216801", 
      "+", 
      RowBox[{
      "14.134725141734693790457251983562470270784257116562`36.3008023656212", 
       " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
     "0.50000000000000000000000000000401063472`22.84948500216801", "+", 
      RowBox[{
      "21.02203963877155499262847959388172113501`24.473189848481876", " ", 
       "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
     "0.4999999999999999999999999999999994977`25.84948500216801", "+", 
      RowBox[{
      "25.01085758014568876321379099256282499289`27.548643581043493", " ", 
       "\[ImaginaryI]"}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{478, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->5715]
}, Open  ]],

Cell[TextData[{
 "Define a function that evaluates the ",
 Cell[BoxData[
  ButtonBox["Zeta",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Zeta"]], "InlineFormula"],
 " function and increments a counter:"
}], "ExampleText",
 CellID->17552],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "[", 
   RowBox[{"z_", "?", "NumericQ"}], "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"n", "++"}], ";", 
    RowBox[{"Zeta", "[", "z", "]"}]}], ")"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->22492],

Cell[TextData[{
 "Check the real part of the root near ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", "2"], "+", 
   RowBox[{"14", 
    ButtonBox["I",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/I"]}]}]], "InlineFormula"],
 " to 400 digits:"
}], "ExampleText",
 CellID->14753],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"n", "=", "0"}], ";", 
  RowBox[{
   RowBox[{"InterpolateRoot", "[", 
    RowBox[{
     RowBox[{"g", "[", "z", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", 
       RowBox[{".5", "+", 
        RowBox[{"14", "I"}]}], ",", 
       RowBox[{".5", "+", 
        RowBox[{"15", "I"}]}]}], "}"}], ",", 
     RowBox[{"WorkingPrecision", "->", "400"}]}], "]"}], "//", 
   "Timing"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->8257],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"6.718999999999994`", " ", "Second"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", "\[Rule]", 
     RowBox[{
     "0.5000000000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000000000000000000000000000000000\
00000000000000000000000000000000000000000094928028`415.849485002168", "+", 
      RowBox[{
      "14.13472514173469379045725198356247027078425711569924317568556746014996\
342980925676494901039317156101277920297154879743676614269146988225458250536323\
944713778041338123720597054962195586586020055556672583601077370020541098266150\
754278051744259130625448197865107230493872562973832157742039521572567480933214\
003499046803434626731442092037738548714137831735639699536542811307968053149168\
85290678208229804926433866673462332007875876356926419`417.30080236562117", 
       " ", "\[ImaginaryI]"}]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{592, 220},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->27590]
}, Open  ]],

Cell["The number of function evaluations (and steps) needed:", "ExampleText",
 CellID->24959],

Cell[CellGroupData[{

Cell[BoxData["n"], "Input",
 CellLabel->"In[5]:=",
 CellID->13357],

Cell[BoxData["11"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->10886]
}, Open  ]],

Cell[TextData[{
 "Using ",
 Cell[BoxData[
  ButtonBox["FindRoot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindRoot"]], "InlineFormula"],
 " with the secant method:"
}], "ExampleText",
 CellID->7809],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"s", "=", "0"}], ",", 
      RowBox[{"n", "=", "0"}]}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"soln", "=", 
      RowBox[{"FindRoot", "[", 
       RowBox[{
        RowBox[{"Zeta", "[", "z", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"z", ",", 
          RowBox[{".5", "+", 
           RowBox[{"14", "I"}]}], ",", 
          RowBox[{".5", "+", 
           RowBox[{"15", "I"}]}]}], "}"}], ",", "\[IndentingNewLine]", 
        RowBox[{"WorkingPrecision", "->", "400"}], ",", "\[IndentingNewLine]",
         
        RowBox[{"StepMonitor", ":>", 
         RowBox[{"s", "++"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"EvaluationMonitor", ":>", 
         RowBox[{"n", "++"}]}]}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{
      "s", ",", "\"\< steps and \>\"", ",", "n", ",", 
       "\"\< function evaluations\>\""}], "]"}], ";", "\[IndentingNewLine]", 
     "soln"}]}], "]"}], "//", "Timing"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->5865],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "12", "\[InvisibleSpace]", "\<\" steps and \"\>", "\[InvisibleSpace]", "42",
    "\[InvisibleSpace]", "\<\" function evaluations\"\>"}],
  SequenceForm[12, " steps and ", 42, " function evaluations"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[16]:=",
 CellID->25686],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"20.734`", " ", "Second"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", "\[Rule]", 
     RowBox[{
     "0.4999999999999999999999999999999999999999999999999999999999999999999999\
999999999999999999999999999999999999999999999999999999999999999999999999999999\
999999999999999999999999999999999999999999999999999999999999999999999999999999\
999999999999999999999999999999999999999999999999999999999999999999999999999999\
999999999999999999999999999999999999999999999999999965121488851842113815436607\
03781931083455109442224366268329`400.", "+", 
      RowBox[{
      "14.13472514173469379045725198356247027078425711569924317568556746014996\
342980925676494901039317156101277920297154879743676614269146988225458250536323\
944713778041338123720597054962195586586020055556672583601077370020541098266150\
754278051744259130625448197865107230493872562973832157742039521572567480933214\
003499046803434626731442092037738548714137831735639699134266824045526958306083\
6651859330806440172172934523981334`400.", " ", "\[ImaginaryI]"}]}]}], "}"}]}],
   "}"}]], "Output",
 ImageSize->{592, 220},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->32019]
}, Open  ]],

Cell[TextData[{
 "Using ",
 Cell[BoxData[
  ButtonBox["FindRoot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindRoot"]], "InlineFormula"],
 " with Newton\[CloseCurlyQuote]s method:"
}], "ExampleText",
 CellID->259],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"s", "=", "0"}], ",", 
      RowBox[{"n", "=", "0"}]}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"soln", "=", 
      RowBox[{"FindRoot", "[", 
       RowBox[{
        RowBox[{"Zeta", "[", "z", "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"z", ",", 
          RowBox[{
           FractionBox["1", "2"], "+", 
           RowBox[{"14.", "I"}]}]}], "}"}], ",", "\[IndentingNewLine]", 
        RowBox[{"WorkingPrecision", "->", "400"}], ",", "\[IndentingNewLine]",
         
        RowBox[{"StepMonitor", ":>", 
         RowBox[{"s", "++"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"EvaluationMonitor", ":>", 
         RowBox[{"n", "++"}]}]}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{
      "s", ",", "\"\< steps and \>\"", ",", "n", ",", 
       "\"\< function evaluations\>\""}], "]"}], ";", "\[IndentingNewLine]", 
     "soln"}]}], "]"}], "//", "Timing"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->22313],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "10", "\[InvisibleSpace]", "\<\" steps and \"\>", "\[InvisibleSpace]", "32",
    "\[InvisibleSpace]", "\<\" function evaluations\"\>"}],
  SequenceForm[10, " steps and ", 32, " function evaluations"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->2435],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"20.672`", " ", "Second"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", "\[Rule]", 
     RowBox[{
     "0.4999999999999999999999999999999999999999999999999999999999999999999999\
999999999999999999999999999999999999999999999999999999999999999999999999999999\
999999999999999999999999999999999999999999999999999999999999999999999999999999\
999999999999999999999999999999999999999999999999999999999999999999999999999999\
999999999999999999999999999999999999999999999999999999999999999999999999999999\
99999999999999998881567710371527`400.", "+", 
      RowBox[{
      "14.13472514173469379045725198356247027078425711569924317568556746014996\
342980925676494901039317156101277920297154879743676614269146988225458250536323\
944713778041338123720597054962195586586020055556672583601077370020541098266150\
754278051744259130625448197865107230493872562973832157742039521572567480933214\
003499046803434626731442092037738548714137831735639699536542811307968053149168\
8529067820822980485616329462225447`400.", " ", "\[ImaginaryI]"}]}]}], "}"}]}],
   "}"}]], "Output",
 ImageSize->{592, 220},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->1028]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10468],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<FunctionApproximations`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->304168875],

Cell["Multiple roots converge slowly:", "ExampleText",
 CellID->22869],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "[", 
   RowBox[{"x_", "?", "NumericQ"}], "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"n", "++"}], ";", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Exp", "[", "x", "]"}], "-", "2"}], ")"}], "2"]}], 
   ")"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->456],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"n", "=", "0"}], ";", 
  RowBox[{"InterpolateRoot", "[", 
   RowBox[{
    RowBox[{"g", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
    RowBox[{"MaxIterations", "->", "100"}]}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->6731],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "x", "\[Rule]", 
   "0.69314718055989617815121706013605412438`20.840825461045107"}], 
  "}"}]], "Output",
 ImageSize->{202, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->7578]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["n"], "Input",
 CellLabel->"In[4]:=",
 CellID->26074],

Cell[BoxData["57"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->11395]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->31102],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["FindRoot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindRoot"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->169132743]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->17073],

Cell[TextData[ButtonBox["Function Approximations Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:FunctionApproximations/tutorial/FunctionApproximations"]], \
"Tutorials",
 CellID->23461]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->63732364],

Cell[TextData[ButtonBox["Function Approximations Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:FunctionApproximations/guide/FunctionApproximationsPackage"]], \
"MoreAbout",
 CellID->8159617]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"InterpolateRoot - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 58, 27.6155972}", "context" -> 
    "FunctionApproximations`", "keywords" -> {}, "index" -> True, "label" -> 
    "Function Approximations Package Symbol", "language" -> "en", "paclet" -> 
    "FunctionApproximations Package", "status" -> "None", "summary" -> 
    "InterpolateRoot[lhs == rhs, {x, x_0, x_1}] searches for a numerical \
solution to the equation lhs == rhs using x_0 and x_1 as the first two values \
of x.", "synonyms" -> {}, "title" -> "InterpolateRoot", "type" -> "Symbol", 
    "uri" -> "FunctionApproximations/ref/InterpolateRoot"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[10232, 346, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->32156213]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 30604, 1068}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1863, 49, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2486, 76, 52, 1, 70, "ObjectName",
 CellID->2514],
Cell[2541, 79, 1265, 42, 70, "Usage",
 CellID->10966]
}, Open  ]],
Cell[CellGroupData[{
Cell[3843, 126, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4321, 143, 252, 9, 70, "Notes",
 CellID->25988],
Cell[4576, 154, 582, 22, 70, "Notes",
 CellID->18170],
Cell[5161, 178, 230, 5, 70, "Notes",
 CellID->28168],
Cell[5394, 185, 156, 4, 70, "Notes",
 CellID->22199],
Cell[5553, 191, 409, 11, 70, "Notes",
 CellID->655],
Cell[5965, 204, 234, 6, 70, "Notes",
 CellID->3850],
Cell[6202, 212, 69, 1, 70, "Notes",
 CellID->13444],
Cell[6274, 215, 844, 25, 70, "3ColumnTable",
 CellID->12936],
Cell[7121, 242, 296, 9, 70, "Notes",
 CellID->19406],
Cell[7420, 253, 341, 9, 70, "Notes",
 CellID->29427],
Cell[7764, 264, 393, 13, 70, "Notes",
 CellID->10313],
Cell[8160, 279, 376, 10, 70, "Notes",
 CellID->7523],
Cell[8539, 291, 626, 24, 70, "Notes",
 CellID->32371],
Cell[9168, 317, 1027, 24, 70, "2ColumnTableMod",
 CellID->23327]
}, Closed]],
Cell[CellGroupData[{
Cell[10232, 346, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->32156213],
Cell[CellGroupData[{
Cell[10616, 360, 147, 5, 70, "ExampleSection",
 CellID->41558860],
Cell[10766, 367, 147, 4, 70, "Input",
 CellID->987328680],
Cell[CellGroupData[{
Cell[10938, 375, 246, 8, 28, "Input",
 CellID->26126],
Cell[11187, 385, 273, 10, 36, "Output",
 CellID->20595]
}, Open  ]],
Cell[11475, 398, 44, 1, 70, "ExampleText",
 CellID->1495],
Cell[CellGroupData[{
Cell[11544, 403, 148, 5, 28, "Input",
 CellID->29213],
Cell[11695, 410, 197, 5, 36, "Output",
 CellID->2406]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11941, 421, 216, 7, 70, "ExampleSection",
 CellID->23859],
Cell[12160, 430, 147, 4, 70, "Input",
 CellID->396458797],
Cell[12310, 436, 130, 4, 70, "ExampleText",
 CellID->23305],
Cell[CellGroupData[{
Cell[12465, 444, 368, 13, 70, "Input",
 CellID->22496],
Cell[12836, 459, 434, 13, 54, "Output",
 CellID->24833]
}, Open  ]],
Cell[13285, 475, 45, 1, 70, "ExampleText",
 CellID->24223],
Cell[CellGroupData[{
Cell[13355, 480, 171, 7, 70, "Input",
 CellID->4852],
Cell[13529, 489, 157, 5, 36, "Output",
 CellID->17879]
}, Open  ]],
Cell[13701, 497, 121, 3, 70, "ExampleDelimiter",
 CellID->30519],
Cell[13825, 502, 147, 4, 70, "Input",
 CellID->888690700],
Cell[13975, 508, 242, 10, 70, "ExampleText",
 CellID->6126],
Cell[CellGroupData[{
Cell[14242, 522, 219, 7, 70, "Input",
 CellID->7793],
Cell[14464, 531, 274, 10, 36, "Output",
 CellID->31585]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14787, 547, 223, 7, 70, "ExampleSection",
 CellID->28099],
Cell[15013, 556, 147, 4, 70, "Input",
 CellID->725018582],
Cell[15163, 562, 497, 16, 70, "ExampleText",
 CellID->16519],
Cell[CellGroupData[{
Cell[15685, 582, 506, 18, 70, "Input",
 CellID->8596],
Cell[16194, 602, 1004, 29, 88, "Output",
 CellID->5715]
}, Open  ]],
Cell[17213, 634, 242, 8, 70, "ExampleText",
 CellID->17552],
Cell[17458, 644, 250, 9, 70, "Input",
 CellID->22492],
Cell[17711, 655, 287, 11, 70, "ExampleText",
 CellID->14753],
Cell[CellGroupData[{
Cell[18023, 670, 467, 16, 70, "Input",
 CellID->8257],
Cell[18493, 688, 1312, 25, 241, "Output",
 CellID->27590]
}, Open  ]],
Cell[19820, 716, 93, 1, 70, "ExampleText",
 CellID->24959],
Cell[CellGroupData[{
Cell[19938, 721, 66, 2, 70, "Input",
 CellID->13357],
Cell[20007, 725, 155, 5, 36, "Output",
 CellID->10886]
}, Open  ]],
Cell[20177, 733, 207, 8, 70, "ExampleText",
 CellID->7809],
Cell[CellGroupData[{
Cell[20409, 745, 1125, 31, 70, "Input",
 CellID->5865],
Cell[21537, 778, 338, 8, 70, "Print",
 CellID->25686],
Cell[21878, 788, 1233, 25, 241, "Output",
 CellID->32019]
}, Open  ]],
Cell[23126, 816, 221, 8, 70, "ExampleText",
 CellID->259],
Cell[CellGroupData[{
Cell[23372, 828, 1086, 30, 70, "Input",
 CellID->22313],
Cell[24461, 860, 336, 8, 70, "Print",
 CellID->2435],
Cell[24800, 870, 1232, 25, 241, "Output",
 CellID->1028]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[26081, 901, 226, 7, 70, "ExampleSection",
 CellID->10468],
Cell[26310, 910, 147, 4, 70, "Input",
 CellID->304168875],
Cell[26460, 916, 70, 1, 70, "ExampleText",
 CellID->22869],
Cell[26533, 919, 333, 13, 70, "Input",
 CellID->456],
Cell[CellGroupData[{
Cell[26891, 936, 317, 10, 70, "Input",
 CellID->6731],
Cell[27211, 948, 273, 10, 36, "Output",
 CellID->7578]
}, Open  ]],
Cell[CellGroupData[{
Cell[27521, 963, 66, 2, 70, "Input",
 CellID->26074],
Cell[27590, 967, 155, 5, 36, "Output",
 CellID->11395]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[27806, 979, 311, 9, 70, "SeeAlsoSection",
 CellID->31102],
Cell[28120, 990, 200, 6, 70, "SeeAlso",
 CellID->169132743]
}, Open  ]],
Cell[CellGroupData[{
Cell[28357, 1001, 314, 9, 70, "TutorialsSection",
 CellID->17073],
Cell[28674, 1012, 192, 5, 70, "Tutorials",
 CellID->23461]
}, Open  ]],
Cell[CellGroupData[{
Cell[28903, 1022, 318, 9, 70, "MoreAboutSection",
 CellID->63732364],
Cell[29224, 1033, 198, 5, 70, "MoreAbout",
 CellID->8159617]
}, Open  ]],
Cell[29437, 1041, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

