(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8773,        298]
NotebookOptionsPosition[      6823,        239]
NotebookOutlinePosition[      8019,        269]
CellTagsIndexPosition[      7976,        266]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["FUNCTION APPROXIMATIONS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Function Approximations Package" :> 
          Documentation`HelpLookup[
           "paclet:FunctionApproximations/tutorial/FunctionApproximations"]}, \
#, 2]& , Evaluator -> Automatic], {
       1->"\<\"Function Approximations Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"OrderStarLegend" :> 
          Documentation`HelpLookup[
           "paclet:FunctionApproximations/ref/OrderStarLegend"], 
          "OrderStarPoles" :> 
          Documentation`HelpLookup[
           "paclet:FunctionApproximations/ref/OrderStarPoles"], 
          "OrderStarZeros" :> 
          Documentation`HelpLookup[
           "paclet:FunctionApproximations/ref/OrderStarZeros"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"OrderStarLegend\"\>", 
       2->"\<\"OrderStarPoles\"\>", 
       3->"\<\"OrderStarZeros\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["OrderStarInterpolation", "ObjectName",
 CellID->2073],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["OrderStarInterpolation"], "InlineFormula"],
     " \[LineSeparator]is an option to ",
     Cell[BoxData[
      ButtonBox["OrderStarPlot",
       BaseStyle->"Link",
       ButtonData->"paclet:FunctionApproximations/ref/OrderStarPlot"]], 
      "InlineFormula"],
     " that specifies whether interpolation points of an approximant to a \
function should be displayed. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->32353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Valid settings are ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " or a list of points. The default setting is ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->1281],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{"OrderStarInterpolation", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["OrderStarPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:FunctionApproximations/ref/OrderStarPlot"]], 
  "InlineFormula"],
 " will use ",
 Cell[BoxData[
  ButtonBox["NSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NSolve"]], "InlineFormula"],
 " to find points where the approximant agrees with the function."
}], "Notes",
 CellID->2662],

Cell[TextData[{
 "In some cases ",
 Cell[BoxData[
  ButtonBox["NSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NSolve"]], "InlineFormula"],
 " will be unable to find all of the interpolation points. By giving a list \
of points instead of ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", these points in addition to the interpolation points found by ",
 Cell[BoxData[
  ButtonBox["NSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NSolve"]], "InlineFormula"],
 " will be displayed."
}], "Notes",
 CellID->27996]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->19785],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["OrderStarLegend",
    BaseStyle->"Link",
    ButtonData->"paclet:FunctionApproximations/ref/OrderStarLegend"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["OrderStarPoles",
    BaseStyle->"Link",
    ButtonData->"paclet:FunctionApproximations/ref/OrderStarPoles"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["OrderStarZeros",
    BaseStyle->"Link",
    ButtonData->"paclet:FunctionApproximations/ref/OrderStarZeros"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->6442386]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->28213],

Cell[TextData[ButtonBox["Function Approximations Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:FunctionApproximations/tutorial/FunctionApproximations"]], \
"Tutorials",
 CellID->9451]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"OrderStarInterpolation - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 58, 35.3814210}", "context" -> 
    "FunctionApproximations`", "keywords" -> {}, "index" -> True, "label" -> 
    "Function Approximations Package Symbol", "language" -> "en", "paclet" -> 
    "FunctionApproximations Package", "status" -> "None", "summary" -> 
    "OrderStarInterpolation is an option to OrderStarPlot that specifies \
whether interpolation points of an approximant to a function should be \
displayed. ", "synonyms" -> {}, "title" -> "OrderStarInterpolation", "type" -> 
    "Symbol", "uri" -> "FunctionApproximations/ref/OrderStarInterpolation"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1615, 41, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2238, 68, 59, 1, 70, "ObjectName",
 CellID->2073],
Cell[2300, 71, 612, 17, 70, "Usage",
 CellID->32353]
}, Open  ]],
Cell[CellGroupData[{
Cell[2949, 93, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3427, 110, 466, 18, 70, "Notes",
 CellID->1281],
Cell[3896, 130, 583, 20, 70, "Notes",
 CellID->2662],
Cell[4482, 152, 598, 19, 70, "Notes",
 CellID->27996]
}, Closed]],
Cell[CellGroupData[{
Cell[5117, 176, 311, 9, 70, "SeeAlsoSection",
 CellID->19785],
Cell[5431, 187, 805, 26, 70, "SeeAlso",
 CellID->6442386]
}, Open  ]],
Cell[CellGroupData[{
Cell[6273, 218, 314, 9, 70, "TutorialsSection",
 CellID->28213],
Cell[6590, 229, 191, 5, 70, "Tutorials",
 CellID->9451]
}, Open  ]],
Cell[6796, 237, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

