(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8536,        295]
NotebookOptionsPosition[      6715,        238]
NotebookOutlinePosition[      7836,        268]
CellTagsIndexPosition[      7793,        265]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["FUNCTION APPROXIMATIONS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Function Approximations Package" :> 
          Documentation`HelpLookup[
           "paclet:FunctionApproximations/tutorial/FunctionApproximations"]}, \
#, 2]& , Evaluator -> Automatic], {
       1->"\<\"Function Approximations Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"OrderStarInterpolation" :> 
          Documentation`HelpLookup[
           "paclet:FunctionApproximations/ref/OrderStarInterpolation"], 
          "OrderStarPoles" :> 
          Documentation`HelpLookup[
           "paclet:FunctionApproximations/ref/OrderStarPoles"], 
          "OrderStarZeros" :> 
          Documentation`HelpLookup[
           "paclet:FunctionApproximations/ref/OrderStarZeros"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"OrderStarInterpolation\"\>", 
       2->"\<\"OrderStarPoles\"\>", 
       3->"\<\"OrderStarZeros\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["OrderStarKind", "ObjectName",
 CellID->9535],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["OrderStarKind"], "InlineFormula"],
     "\[LineSeparator]is an option to ",
     Cell[BoxData[
      ButtonBox["OrderStarPlot",
       BaseStyle->"Link",
       ButtonData->"paclet:FunctionApproximations/ref/OrderStarPlot"]], 
      "InlineFormula"],
     " that specifies the type of order star to be displayed. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->4562]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Valid settings are ",
 Cell[BoxData[
  ButtonBox["First",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/First"]], "InlineFormula"],
 " and ",
 Cell[BoxData["Second"], "InlineFormula"],
 ". The default setting is ",
 Cell[BoxData[
  ButtonBox["First",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/First"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->23365],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{"OrderStarKind", "->", " ", "First"}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["OrderStarPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:FunctionApproximations/ref/OrderStarPlot"]], 
  "InlineFormula"],
 " draws the level curve ",
 Cell[BoxData[
  RowBox[{"|", 
   RowBox[{
    StyleBox["r", "TI"], "/", 
    StyleBox["f", "TI"]}], "|", 
   RowBox[{"==", "1"}]}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  StyleBox["r", "TI"]], "InlineFormula"],
 " is the approximating function to ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 ". With the setting ",
 Cell[BoxData[
  RowBox[{"OrderStarKind", "->", "Second"}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["OrderStarPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:FunctionApproximations/ref/OrderStarPlot"]], 
  "InlineFormula"],
 " draws the level curve ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Re",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Re"], "[", 
    RowBox[{
     StyleBox["r", "TI"], "-", 
     StyleBox["f", "TI"]}], "]"}], "==", "0"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->25111]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->32606],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["OrderStarInterpolation",
    BaseStyle->"Link",
    ButtonData->"paclet:FunctionApproximations/ref/OrderStarInterpolation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["OrderStarPoles",
    BaseStyle->"Link",
    ButtonData->"paclet:FunctionApproximations/ref/OrderStarPoles"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["OrderStarZeros",
    BaseStyle->"Link",
    ButtonData->"paclet:FunctionApproximations/ref/OrderStarZeros"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->13345]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->12817],

Cell[TextData[ButtonBox["Function Approximations Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:FunctionApproximations/tutorial/FunctionApproximations"]], \
"Tutorials",
 CellID->11011]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"OrderStarKind - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 58, 35.5533004}", "context" -> 
    "FunctionApproximations`", "keywords" -> {}, "index" -> True, "label" -> 
    "Function Approximations Package Symbol", "language" -> "en", "paclet" -> 
    "FunctionApproximations Package", "status" -> "None", "summary" -> 
    "OrderStarKind is an option to OrderStarPlot that specifies the type of \
order star to be displayed. ", "synonyms" -> {}, "title" -> "OrderStarKind", 
    "type" -> "Symbol", "uri" -> 
    "FunctionApproximations/ref/OrderStarKind"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1636, 41, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2259, 68, 50, 1, 70, "ObjectName",
 CellID->9535],
Cell[2312, 71, 557, 16, 70, "Usage",
 CellID->4562]
}, Open  ]],
Cell[CellGroupData[{
Cell[2906, 92, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3384, 109, 382, 15, 70, "Notes",
 CellID->23365],
Cell[3769, 126, 1190, 44, 70, "Notes",
 CellID->25111]
}, Closed]],
Cell[CellGroupData[{
Cell[4996, 175, 311, 9, 70, "SeeAlsoSection",
 CellID->32606],
Cell[5310, 186, 817, 26, 70, "SeeAlso",
 CellID->13345]
}, Open  ]],
Cell[CellGroupData[{
Cell[6164, 217, 314, 9, 70, "TutorialsSection",
 CellID->12817],
Cell[6481, 228, 192, 5, 70, "Tutorials",
 CellID->11011]
}, Open  ]],
Cell[6688, 236, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

