(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8832,        305]
NotebookOptionsPosition[      6945,        247]
NotebookOutlinePosition[      8134,        278]
CellTagsIndexPosition[      8091,        275]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["FUNCTION APPROXIMATIONS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Function Approximations Package" :> 
          Documentation`HelpLookup[
           "paclet:FunctionApproximations/tutorial/FunctionApproximations"]}, \
#, 2]& , Evaluator -> Automatic], {
       1->"\<\"Function Approximations Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"OrderStarInterpolation" :> 
          Documentation`HelpLookup[
           "paclet:FunctionApproximations/ref/OrderStarInterpolation"], 
          "OrderStarPoles" :> 
          Documentation`HelpLookup[
           "paclet:FunctionApproximations/ref/OrderStarPoles"], 
          "OrderStarZeros" :> 
          Documentation`HelpLookup[
           "paclet:FunctionApproximations/ref/OrderStarZeros"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"OrderStarInterpolation\"\>", 
       2->"\<\"OrderStarPoles\"\>", 
       3->"\<\"OrderStarZeros\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["OrderStarLegend", "ObjectName",
 CellID->5446],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["OrderStarLegend"], "InlineFormula"],
     " \[LineSeparator]is an option to ",
     Cell[BoxData[
      ButtonBox["OrderStarPlot",
       BaseStyle->"Link",
       ButtonData->"paclet:FunctionApproximations/ref/OrderStarPlot"]], 
      "InlineFormula"],
     " that specifies whether to display the legend of symbols used to \
represent zeros, poles and interpolation points. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->19412]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Valid settings are ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["min", "TI"]], ",", 
      SubscriptBox[
       StyleBox["y", "TI"], 
       StyleBox["min", "TI"]]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["max", "TI"]], ",", 
      SubscriptBox[
       StyleBox["y", "TI"], 
       StyleBox["max", "TI"]]}], "}"}]}], "}"}]], "InlineFormula"],
 " where the ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], ",", 
   StyleBox["y", "TI"]}]], "InlineFormula"],
 " values are scaled coordinates ranging from 0 to 1. The default setting is \
",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->13004],

Cell[TextData[{
 "The setting ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["min", "TI"]], ",", 
      SubscriptBox[
       StyleBox["y", "TI"], 
       StyleBox["min", "TI"]]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["max", "TI"]], ",", 
      SubscriptBox[
       StyleBox["y", "TI"], 
       StyleBox["max", "TI"]]}], "}"}]}], "}"}]], "InlineFormula"],
 " specifies the bottom left and top right coordinates of the legend."
}], "Notes",
 CellID->8045]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->8529],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["OrderStarInterpolation",
    BaseStyle->"Link",
    ButtonData->"paclet:FunctionApproximations/ref/OrderStarInterpolation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["OrderStarPoles",
    BaseStyle->"Link",
    ButtonData->"paclet:FunctionApproximations/ref/OrderStarPoles"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["OrderStarZeros",
    BaseStyle->"Link",
    ButtonData->"paclet:FunctionApproximations/ref/OrderStarZeros"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->20132]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->28825],

Cell[TextData[ButtonBox["Function Approximations Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:FunctionApproximations/tutorial/FunctionApproximations"]], \
"Tutorials",
 CellID->1244]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"OrderStarLegend - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 58, 35.7095544}", "context" -> 
    "FunctionApproximations`", "keywords" -> {}, "index" -> True, "label" -> 
    "Function Approximations Package Symbol", "language" -> "en", "paclet" -> 
    "FunctionApproximations Package", "status" -> "None", "summary" -> 
    "OrderStarLegend is an option to OrderStarPlot that specifies whether to \
display the legend of symbols used to represent zeros, poles and \
interpolation points. ", "synonyms" -> {}, "title" -> "OrderStarLegend", 
    "type" -> "Symbol", "uri" -> 
    "FunctionApproximations/ref/OrderStarLegend"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1636, 41, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2259, 68, 52, 1, 70, "ObjectName",
 CellID->5446],
Cell[2314, 71, 621, 17, 70, "Usage",
 CellID->19412]
}, Open  ]],
Cell[CellGroupData[{
Cell[2972, 93, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3450, 110, 1116, 44, 70, "Notes",
 CellID->13004],
Cell[4569, 156, 622, 23, 70, "Notes",
 CellID->8045]
}, Closed]],
Cell[CellGroupData[{
Cell[5228, 184, 310, 9, 70, "SeeAlsoSection",
 CellID->8529],
Cell[5541, 195, 817, 26, 70, "SeeAlso",
 CellID->20132]
}, Open  ]],
Cell[CellGroupData[{
Cell[6395, 226, 314, 9, 70, "TutorialsSection",
 CellID->28825],
Cell[6712, 237, 191, 5, 70, "Tutorials",
 CellID->1244]
}, Open  ]],
Cell[6918, 245, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

