(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15321,        494]
NotebookOptionsPosition[     13171,        428]
NotebookOutlinePosition[     14379,        459]
CellTagsIndexPosition[     14336,        456]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["FUNCTION APPROXIMATIONS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Function Approximations Package" :> 
          Documentation`HelpLookup[
           "paclet:FunctionApproximations/tutorial/FunctionApproximations"]}, \
#, 2]& , Evaluator -> Automatic], {
       1->"\<\"Function Approximations Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ContourPlot" :> 
          Documentation`HelpLookup["paclet:ref/ContourPlot"], "RegionPlot" :> 
          Documentation`HelpLookup["paclet:ref/RegionPlot"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ContourPlot\"\>", 
       2->"\<\"RegionPlot\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Function Approximations Package" :> 
          Documentation`HelpLookup[
           "paclet:FunctionApproximations/guide/\
FunctionApproximationsPackage"]}, #, 2]& , Evaluator -> Automatic], {
       1->"\<\"Function Approximations Package\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["OrderStarPlot", "ObjectName", "OrderStar",
 CellID->24351],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"OrderStarPlot", "[", 
       RowBox[{
        StyleBox["r", "TI"], ",", 
        StyleBox["f", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]draws the order star depicting the region where ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        StyleBox["|", "TI"], 
        RowBox[{
         StyleBox["r", "TI"], "/", 
         StyleBox["f", "TI"]}], 
        StyleBox["|", "TI"], 
        RowBox[{"<", "1"}]}], TraditionalForm]], "InlineFormula"],
     " for the functions ",
     Cell[BoxData[
      StyleBox["r", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"OrderStarPlot", "[", 
       RowBox[{
        StyleBox["r", "TI"], ",", 
        StyleBox["f", "TI"], ",", 
        StyleBox["z", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]draws the order star where ",
     Cell[BoxData[
      StyleBox["r", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " are functions of ",
     Cell[BoxData[
      StyleBox["z", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->13290]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["OrderStarPlot"], "InlineFormula"],
 " by default draws the region in the complex plane where ",
 Cell[BoxData[
  RowBox[{"|", 
   RowBox[{
    StyleBox["r", "TI"], "/", 
    StyleBox["f", "TI"]}], "|", 
   RowBox[{"<", "1"}]}]], "InlineFormula"],
 ". With the setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["OrderStarKind",
    BaseStyle->"Link",
    ButtonData->"paclet:FunctionApproximations/ref/OrderStarKind"], "->", 
   "Second"}]], "InlineFormula"],
 ", ",
 Cell[BoxData["OrderStarPlot"], "InlineFormula"],
 " draws the region in the complex plane where ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Re",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Re"], "[", 
    RowBox[{
     StyleBox["r", "TI"], "-", 
     StyleBox["f", "TI"]}], "]"}], "<", "0"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->16052],

Cell[TextData[{
 Cell[BoxData["OrderStarPlot"], "InlineFormula"],
 " has the same options as ",
 Cell[BoxData[
  ButtonBox["ContourPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ContourPlot"]], "InlineFormula"],
 ", with the following additions and changes:"
}], "Notes",
 CellID->12295],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Axes",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Axes"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to draw axes", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["AxesOrigin",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/AxesOrigin"], 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], Cell[
    "where axes should cross", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ColorFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ColorFunction"], 
    RowBox[{
     RowBox[{
      ButtonBox["GrayLevel",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/GrayLevel"], "[", 
      RowBox[{"1", "-", 
       RowBox[{"#", "/", "2"}]}], "]"}], "&"}], Cell[
    "how to color stable and unstable regions", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["FrameTicks",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FrameTicks"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "where to place frame tick marks", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PlotPoints",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotPoints"], "80", Cell[
    "initial number of sample points", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PlotRange",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotRange"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "range of values to include", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Ticks",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Ticks"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "where to place tick marks", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["AspectRatio",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/AspectRatio"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "ratio of height to width", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["OrderStarInterpolation",
     BaseStyle->"Link",
     ButtonData->"paclet:FunctionApproximations/ref/OrderStarInterpolation"], 
    
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[TextData[{
     "whether to display points where ",
     Cell[BoxData[
      RowBox[{
       StyleBox["r", "TI"], "==", 
       StyleBox["f", "TI"]}]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["OrderStarKind",
     BaseStyle->"Link",
     ButtonData->"paclet:FunctionApproximations/ref/OrderStarKind"], 
    ButtonBox["First",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/First"], Cell[
    "which kind of order star to draw", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["OrderStarLegend",
     BaseStyle->"Link",
     ButtonData->"paclet:FunctionApproximations/ref/OrderStarLegend"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to include a plot legend", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["OrderStarPoles",
     BaseStyle->"Link",
     ButtonData->"paclet:FunctionApproximations/ref/OrderStarPoles"], 
    RowBox[{"{", 
     RowBox[{
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"], ",", 
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]}], "}"}], Cell[TextData[{
     "whether to indicate poles of ",
     Cell[BoxData[
      StyleBox["r", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["OrderStarZeros",
     BaseStyle->"Link",
     ButtonData->"paclet:FunctionApproximations/ref/OrderStarZeros"], 
    RowBox[{"{", 
     RowBox[{
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"], ",", 
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]}], "}"}], Cell[TextData[{
     "whether to indicate zeros of ",
     Cell[BoxData[
      StyleBox["r", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["OrderStarSymbolSize",
     BaseStyle->"Link",
     ButtonData->"paclet:FunctionApproximations/ref/OrderStarSymbolSize"], 
    "0.05", Cell["size of symbols", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["OrderStarSymbolThickness",
     BaseStyle->"Link",
     ButtonData->
      "paclet:FunctionApproximations/ref/OrderStarSymbolThickness"], "0.05", 
    Cell["line thickness of symbols", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    None, None, None, None, None, None, None, None, None, None, None, None, 
     None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, True, 
      True, True, True, True}}}},
 CellID->24420]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->8034],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ContourPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ContourPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RegionPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RegionPlot"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->393745391]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->24061],

Cell[TextData[ButtonBox["Function Approximations Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:FunctionApproximations/tutorial/FunctionApproximations"]], \
"Tutorials",
 CellID->14360]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->169982877],

Cell[TextData[ButtonBox["Function Approximations Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:FunctionApproximations/guide/FunctionApproximationsPackage"]], \
"MoreAbout",
 CellID->86284685]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"OrderStarPlot - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 58, 35.9126846}", "context" -> 
    "FunctionApproximations`", "keywords" -> {}, "index" -> True, "label" -> 
    "Function Approximations Package Symbol", "language" -> "en", "paclet" -> 
    "FunctionApproximations Package", "status" -> "None", "summary" -> 
    "OrderStarPlot[r, f] draws the order star depicting the region where | \
r/f | < 1 for the functions r and f. OrderStarPlot[r, f, z] draws the order \
star where r and f are functions of z.", "synonyms" -> {}, "title" -> 
    "OrderStarPlot", "type" -> "Symbol", "uri" -> 
    "FunctionApproximations/ref/OrderStarPlot"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1975, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2598, 77, 64, 1, 70, "ObjectName",
 CellID->24351],
Cell[2665, 80, 1441, 48, 70, "Usage",
 CellID->13290]
}, Open  ]],
Cell[CellGroupData[{
Cell[4143, 133, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4621, 150, 864, 30, 70, "Notes",
 CellID->16052],
Cell[5488, 182, 296, 9, 70, "Notes",
 CellID->12295],
Cell[5787, 193, 5423, 155, 70, "3ColumnTableMod",
 CellID->24420]
}, Closed]],
Cell[CellGroupData[{
Cell[11247, 353, 310, 9, 70, "SeeAlsoSection",
 CellID->8034],
Cell[11560, 364, 465, 17, 70, "SeeAlso",
 CellID->393745391]
}, Open  ]],
Cell[CellGroupData[{
Cell[12062, 386, 314, 9, 70, "TutorialsSection",
 CellID->24061],
Cell[12379, 397, 192, 5, 70, "Tutorials",
 CellID->14360]
}, Open  ]],
Cell[CellGroupData[{
Cell[12608, 407, 319, 9, 70, "MoreAboutSection",
 CellID->169982877],
Cell[12930, 418, 199, 5, 70, "MoreAbout",
 CellID->86284685]
}, Open  ]],
Cell[13144, 426, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

