(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8991,        304]
NotebookOptionsPosition[      7068,        245]
NotebookOutlinePosition[      8238,        275]
CellTagsIndexPosition[      8195,        272]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["FUNCTION APPROXIMATIONS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Function Approximations Package" :> 
          Documentation`HelpLookup[
           "paclet:FunctionApproximations/tutorial/FunctionApproximations"]}, \
#, 2]& , Evaluator -> Automatic], {
       1->"\<\"Function Approximations Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"OrderStarInterpolation" :> 
          Documentation`HelpLookup[
           "paclet:FunctionApproximations/ref/OrderStarInterpolation"], 
          "OrderStarLegend" :> 
          Documentation`HelpLookup[
           "paclet:FunctionApproximations/ref/OrderStarLegend"], 
          "OrderStarPoles" :> 
          Documentation`HelpLookup[
           "paclet:FunctionApproximations/ref/OrderStarPoles"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"OrderStarInterpolation\"\>", 
       2->"\<\"OrderStarLegend\"\>", 
       3->"\<\"OrderStarPoles\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["OrderStarZeros", "ObjectName",
 CellID->7701],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["OrderStarZeros"], "InlineFormula"],
     " \[LineSeparator]is an option to ",
     Cell[BoxData[
      ButtonBox["OrderStarPlot",
       BaseStyle->"Link",
       ButtonData->"paclet:FunctionApproximations/ref/OrderStarPlot"]], 
      "InlineFormula"],
     " that specifies whether zeros of an approximant and the function to be \
approximated should be displayed."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->28841]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "A valid setting is a list of two elements. Each element may be ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " or a list of points. The default setting is ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], ",", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"]}], "}"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->4404],

Cell["\<\
The first element specifies whether zeros of the approximant are displayed. \
The second element specifies whether zeros of the function to be approximated \
are displayed.\
\>", "Notes",
 CellID->15729],

Cell[TextData[{
 "With a setting of ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["OrderStarPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:FunctionApproximations/ref/OrderStarPlot"]], 
  "InlineFormula"],
 " will use ",
 Cell[BoxData[
  ButtonBox["NSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NSolve"]], "InlineFormula"],
 " to find zeros. In some cases, ",
 Cell[BoxData[
  ButtonBox["NSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NSolve"]], "InlineFormula"],
 " will be unable to find all of the zeros. By giving a list of points \
instead of ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", these points in addition to the zeros found by ",
 Cell[BoxData[
  ButtonBox["NSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NSolve"]], "InlineFormula"],
 " will be displayed."
}], "Notes",
 CellID->19215]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->29719],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["OrderStarInterpolation",
    BaseStyle->"Link",
    ButtonData->"paclet:FunctionApproximations/ref/OrderStarInterpolation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["OrderStarLegend",
    BaseStyle->"Link",
    ButtonData->"paclet:FunctionApproximations/ref/OrderStarLegend"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["OrderStarPoles",
    BaseStyle->"Link",
    ButtonData->"paclet:FunctionApproximations/ref/OrderStarPoles"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->18296]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->30565],

Cell[TextData[ButtonBox["Function Approximations Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:FunctionApproximations/tutorial/FunctionApproximations"]], \
"Tutorials",
 CellID->3650]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"OrderStarZeros - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 58, 42.5534796}", "context" -> 
    "FunctionApproximations`", "keywords" -> {}, "index" -> True, "label" -> 
    "Function Approximations Package Symbol", "language" -> "en", "paclet" -> 
    "FunctionApproximations Package", "status" -> "None", "summary" -> 
    "OrderStarZeros is an option to OrderStarPlot that specifies whether \
zeros of an approximant and the function to be approximated should be \
displayed.", "synonyms" -> {}, "title" -> "OrderStarZeros", "type" -> 
    "Symbol", "uri" -> "FunctionApproximations/ref/OrderStarZeros"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1639, 41, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2262, 68, 51, 1, 70, "ObjectName",
 CellID->7701],
Cell[2316, 71, 610, 17, 70, "Usage",
 CellID->28841]
}, Open  ]],
Cell[CellGroupData[{
Cell[2963, 93, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3441, 110, 640, 23, 70, "Notes",
 CellID->4404],
Cell[4084, 135, 213, 5, 70, "Notes",
 CellID->15729],
Cell[4300, 142, 1011, 35, 70, "Notes",
 CellID->19215]
}, Closed]],
Cell[CellGroupData[{
Cell[5348, 182, 311, 9, 70, "SeeAlsoSection",
 CellID->29719],
Cell[5662, 193, 819, 26, 70, "SeeAlso",
 CellID->18296]
}, Open  ]],
Cell[CellGroupData[{
Cell[6518, 224, 314, 9, 70, "TutorialsSection",
 CellID->30565],
Cell[6835, 235, 191, 5, 70, "Tutorials",
 CellID->3650]
}, Open  ]],
Cell[7041, 243, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

