(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7885,        272]
NotebookOptionsPosition[      5927,        212]
NotebookOutlinePosition[      7135,        243]
CellTagsIndexPosition[      7092,        240]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["FUNCTION APPROXIMATIONS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Function Approximations Package" :> 
          Documentation`HelpLookup[
           "paclet:FunctionApproximations/tutorial/FunctionApproximations"]}, \
#, 2]& , Evaluator -> Automatic], {
       1->"\<\"Function Approximations Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PrintFlag" :> 
          Documentation`HelpLookup[
           "paclet:FunctionApproximations/ref/PrintFlag"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"PrintFlag\"\>"}, "\<\"see also\"\>",
        
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["PlotFlag", "ObjectName",
 CellID->18114],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["PlotFlag"], "InlineFormula"],
     " \[LineSeparator]is an option to ",
     Cell[BoxData[
      ButtonBox["MiniMaxApproximation",
       BaseStyle->"Link",
       ButtonData->"paclet:FunctionApproximations/ref/MiniMaxApproximation"]],
       "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["GeneralMiniMaxApproximation",
       BaseStyle->"Link",
       ButtonData->
        "paclet:FunctionApproximations/ref/GeneralMiniMaxApproximation"]], 
      "InlineFormula"],
     " that specifies whether plots of the relative error of successive \
iterates in the approximation algorithm are to be drawn."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->11701]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Valid settings are ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ". The default setting is ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->31316],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["PlotFlag",
   BaseStyle->"Link",
   ButtonData->"paclet:FunctionApproximations/ref/PlotFlag"]], 
  "InlineFormula"],
 " option is useful when trying to determine what went wrong when the \
algorithm used by ",
 Cell[BoxData[
  ButtonBox["MiniMaxApproximation",
   BaseStyle->"Link",
   ButtonData->"paclet:FunctionApproximations/ref/MiniMaxApproximation"]], 
  "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["GeneralMiniMaxApproximation",
   BaseStyle->"Link",
   ButtonData->
    "paclet:FunctionApproximations/ref/GeneralMiniMaxApproximation"]], 
  "InlineFormula"],
 " fails."
}], "Notes",
 CellID->20671],

Cell[TextData[{
 "If the plots change dramatically from one iteration to the next, an \
increase in the amount of braking specified by the option ",
 Cell[BoxData[
  ButtonBox["Brake",
   BaseStyle->"Link",
   ButtonData->"paclet:FunctionApproximations/ref/Brake"]], "InlineFormula"],
 " is warranted."
}], "Notes",
 CellID->5786]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->20053],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["PrintFlag",
   BaseStyle->"Link",
   ButtonData->"paclet:FunctionApproximations/ref/PrintFlag"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->912]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->12263],

Cell[TextData[ButtonBox["Function Approximations Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:FunctionApproximations/tutorial/FunctionApproximations"]], \
"Tutorials",
 CellID->4313]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PlotFlag - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 58, 42.6941082}", "context" -> 
    "FunctionApproximations`", "keywords" -> {}, "index" -> True, "label" -> 
    "Function Approximations Package Symbol", "language" -> "en", "paclet" -> 
    "FunctionApproximations Package", "status" -> "None", "summary" -> 
    "PlotFlag is an option to MiniMaxApproximation and \
GeneralMiniMaxApproximation that specifies whether plots of the relative \
error of successive iterates in the approximation algorithm are to be drawn.",
     "synonyms" -> {}, "title" -> "PlotFlag", "type" -> "Symbol", "uri" -> 
    "FunctionApproximations/ref/PlotFlag"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1267, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1890, 61, 46, 1, 70, "ObjectName",
 CellID->18114],
Cell[1939, 64, 862, 24, 70, "Usage",
 CellID->11701]
}, Open  ]],
Cell[CellGroupData[{
Cell[2838, 93, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3316, 110, 450, 18, 70, "Notes",
 CellID->31316],
Cell[3769, 130, 668, 23, 70, "Notes",
 CellID->20671],
Cell[4440, 155, 330, 9, 70, "Notes",
 CellID->5786]
}, Closed]],
Cell[CellGroupData[{
Cell[4807, 169, 311, 9, 70, "SeeAlsoSection",
 CellID->20053],
Cell[5121, 180, 219, 6, 70, "SeeAlso",
 CellID->912]
}, Open  ]],
Cell[CellGroupData[{
Cell[5377, 191, 314, 9, 70, "TutorialsSection",
 CellID->12263],
Cell[5694, 202, 191, 5, 70, "Tutorials",
 CellID->4313]
}, Open  ]],
Cell[5900, 210, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

