(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6665,        228]
NotebookOptionsPosition[      4830,        172]
NotebookOutlinePosition[      6021,        203]
CellTagsIndexPosition[      5978,        200]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["GEODESY PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Geodesy Package" :> 
          Documentation`HelpLookup["paclet:Geodesy/tutorial/Geodesy"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Geodesy Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ToAuthalicRadius" :> 
          Documentation`HelpLookup["paclet:Geodesy/ref/ToAuthalicRadius"], 
          "CountryData" :> 
          Documentation`HelpLookup["paclet:ref/CountryData"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ToAuthalicRadius\"\>", 
       2->"\<\"CountryData\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["GeodeticToAuthalic", "ObjectName",
 CellID->29367],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"GeodeticToAuthalic", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          StyleBox["latitude", "TI"], ",", 
          StyleBox["longitude", "TI"]}], "}"}], ",", 
        StyleBox["eccentricity", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the coordinates of the corresponding point on an \
authalic sphere given the latitude and longitude of a point on a spheroid \
with ",
     "specified",
     " eccentricity."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->27912]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Coordinates ",
 Cell[BoxData[
  StyleBox["latitude", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["longitude", "TI"]], "InlineFormula"],
 " are the geodetic coordinates of the point on the spheroid."
}], "Notes",
 CellID->27065]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->7838],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToAuthalicRadius",
    BaseStyle->"Link",
    ButtonData->"paclet:Geodesy/ref/ToAuthalicRadius"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CountryData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CountryData"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->20984]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->21929],

Cell[TextData[ButtonBox["Geodesy Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Geodesy/tutorial/Geodesy"]], "Tutorials",
 CellID->15616]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GeodeticToAuthalic - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 58, 53.2100024}", "context" -> "Geodesy`", 
    "keywords" -> {}, "index" -> True, "label" -> "Geodesy Package Symbol", 
    "language" -> "en", "paclet" -> "Geodesy Package", "status" -> "None", 
    "summary" -> 
    "GeodeticToAuthalic[{latitude, longitude}, eccentricity] gives the \
coordinates of the corresponding point on an authalic sphere given the \
latitude and longitude of a point on a spheroid with specified eccentricity.",
     "synonyms" -> {}, "title" -> "GeodeticToAuthalic", "type" -> "Symbol", 
    "uri" -> "Geodesy/ref/GeodeticToAuthalic"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1291, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1914, 60, 56, 1, 70, "ObjectName",
 CellID->29367],
Cell[1973, 63, 711, 21, 70, "Usage",
 CellID->27912]
}, Open  ]],
Cell[CellGroupData[{
Cell[2721, 89, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3199, 106, 263, 9, 70, "Notes",
 CellID->27065]
}, Closed]],
Cell[CellGroupData[{
Cell[3499, 120, 310, 9, 70, "SeeAlsoSection",
 CellID->7838],
Cell[3812, 131, 481, 17, 70, "SeeAlso",
 CellID->20984]
}, Open  ]],
Cell[CellGroupData[{
Cell[4330, 153, 314, 9, 70, "TutorialsSection",
 CellID->21929],
Cell[4647, 164, 141, 3, 70, "Tutorials",
 CellID->15616]
}, Open  ]],
Cell[4803, 170, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

